/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: The UsbDeviceManager is a class that manages UsbDevice. 
 *
 *
 */
package jp.co.ricoh.dsdk.usb;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbServices;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;


/**
 * UsbDeviceManagerNX́AUsbDevice̊ǗsNXłB
 * The UsbDeviceManager is a class that manages UsbDevice. 
 */
public class UsbDeviceManager {

	private UsbServices services = null;
	
	private Vector devices = null;

	private List listeners = null;

	/**
	 * UsbDeviceManager̃CX^X𐶐܂
	 * Create the UsbDeviceManager instance.
	 */
	public UsbDeviceManager() throws UsbException{
		devices = new Vector();
		listeners = new ArrayList();

		services = UsbHostManager.getUsbServices();
		UsbHub rootHub = services.getRootUsbHub();					

		init(rootHub);
		
		/** foCXXVꂽꍇɌĂяo */
		/** When the device was attached or dettached, the UsbServicesListener class is called.*/
		services.addUsbServicesListener(new UsbServicesListener(){
			public void usbDeviceAttached(UsbServicesEvent use) {
				System.out.println("attached device");
				UsbDevice ud = use.getUsbDevice();
				if(!ud.isUsbHub()){
					devices.add(ud);

					for(int i = 0; i < listeners.size(); i++){
						UsbServicesListener lis = (UsbServicesListener)listeners.get(i);
						lis.usbDeviceAttached(use);
					}
				}
			}

			public void usbDeviceDetached(UsbServicesEvent use) {
				System.out.println("detached device");
				UsbDevice ud = use.getUsbDevice();
				for(int i = 0; i < devices.size(); i++){
					UsbDevice ud_moto = (UsbDevice)devices.get(i);
					if(ud == ud_moto){
						System.out.println("remove device");
						devices.remove(i);
						break;
					}
				}
				for(int i = 0; i < listeners.size(); i++){
					UsbServicesListener lis = (UsbServicesListener)listeners.get(i);
					lis.usbDeviceDetached(use);
				}
				
			}
		});
	}
	
	/**
	 * UsbDevicẽXg擾܂
	 * Get the UsbDevice list.
	 */
	private void init(UsbDevice device){
		/* UsbDevicẽXg쐬 */
		/* create the list of UsbDevice */
		if (device.isUsbHub()) {
			
			/* ʂTree\݂ꍇ */
			/* in the case of more device exists in a subordinate position */
			List attachedDevices = ((UsbHub) device).getAttachedUsbDevices();
			for (int i = 0; i < attachedDevices.size(); i++) {
				init((UsbDevice) attachedDevices.get(i));
			}
		} else {
			/* UsbDevicȅꍇ */
			/* in case of this is UsbDevice */
			devices.add(device);
		}
	}
	
	/**
	 * UsbServicesListenero^܂
	 * Register UsbServiceListener.
	 * 
	 */
	public void addUsbServicesListener(UsbServicesListener lis){
		listeners.add(lis);
	}
	
	/**
	 * UsbServicesListener폜܂
	 * Unregister UsbServiceListener.
	 */
	public void removeServicesListener(UsbServicesListener lis){
		for(int i = 0; i < listeners.size(); i++){
			if(lis == listeners.get(i)){
				listeners.remove(lis);
				break;
			}
		}
	}
	
	/**
	 * UsbDevicẽXg擾܂
	 * Get the list of UsbDevice.
	 */
	public List getDevices(){
		return devices;
	}
}