/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: This class show the device information to the panel.
 *
 *
 */
package jp.co.ricoh.dsdk.app.usb.test;

import javax.usb.UsbDevice;
import javax.usb.UsbException;

import jp.co.ricoh.dsdk.panel.AttributeType;
import jp.co.ricoh.dsdk.panel.Button;
import jp.co.ricoh.dsdk.panel.Container;
import jp.co.ricoh.dsdk.panel.Label;
import jp.co.ricoh.dsdk.panel.LabelArea;
import jp.co.ricoh.dsdk.panel.Pattern;
import jp.co.ricoh.dsdk.panel.Text;
import jp.co.ricoh.dsdk.panel.Window;
import jp.co.ricoh.dsdk.panel.event.ActionEvent;
import jp.co.ricoh.dsdk.panel.event.ActionListener;
import jp.co.ricoh.dsdk.usb.UsbDeviceInfo;
import jp.co.ricoh.dsdk.usb.prox.CardListener;
import jp.co.ricoh.dsdk.usb.prox.CardReaderManager;
import jp.co.ricoh.dsdk.usb.prox.CardReaderService;

/**
 * {@jp Device\ƂɎgpClass}{@en }.
 * {@jp {ContainerNXpĂ邽߁Athis.add()gpB}
 * {@jp AgpsƂȂĂBContainerWindowł邱Ƃz肳ĂȂB}
 * {@jp Container.java Line.136` Line.146B}
 * {@en This class show the device information to the panel.}
 */
public class DevicePanel extends Container {
	
	private static final long serialVersionUID = 1L;
	
	private Window window = null;
	
	private Button start_btn = null;

	private Label result_label = null;

	/**
	 * the base device information
	 */
	private UsbDevice device = null;
	
	private UsbDeviceInfo udi;
	
	private CardReaderService reader;

	private CardListener listener = null;
	
	/**
	 * Card data is input. 
	 */
	private String devicedata = "";

	
	/**
	 * {@jp DevicePanelNX𐶐}{@en Create DevicePanel}.
	 * @param device {@jp UsbDeice}{@en }.
	 */
	protected DevicePanel(Window window, final UsbDevice device){
		super();
		this.window = window;
		this.device = device;
		udi = new UsbDeviceInfo(device);
		System.out.println("device information =" + udi.toString());
		try {
			reader = CardReaderManager.getCardReaderService(device, UsbTest.INSTALL_PATH);
		} catch (UsbException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * close the DevicePanel.
	 */
	public void closeDevicePanel(){
		System.out.println("start closeDevicePanel");
		try {
			if(reader.isReading()){
				reader.stopReader();
				reader.releaseUsbInterface();
			}
		} catch (UsbException e) {
			e.printStackTrace();
		}
		reader.removeListener(listener);
		System.out.println("end closeDevicePanel");
	}
	
	/**
	 * {@jp DevicePanel̉ʒuAcʒuAA肷}{@en Set the position.}.
	 * @param x {@jp ʒu()}{@en }.
	 * @param y {@jp cʒu()}{@en }.
	 * @param width {@jp }{@en }.
	 * @param height {@jp }{@en }.
	 */
	public void setBounds(final int x,final int y, int width, int height){
//		super.setBounds(x-10, y-10, width+20, height+20);
//System.out.println("In setBounds");			
		
		/** Title\ */
		/** display the Title*/
		LabelArea title = new LabelArea();
		int bus = udi.getBus();
		int parentport = udi.getParentport();
		title.addText("bus : " + bus);
		title.addText("parent port : " + parentport);
		title.setBounds(x + 10, y + 10, 75, 16);
		window.add(title);
//		this.add((Component)title);
		
		
		/** ڍ׏\ */
		/** display the detail information*/
		final LabelArea area = new LabelArea();
		area.setBounds(x+10, y+40, 170, 24);
		area.addText(new Text("idVender : 0x" + udi.getIdVendor()));
		area.addText(new Text("idProduct : 0x" + udi.getIdProduct()));
		area.addText(new Text("bcdDevice : 0x" + udi.getBcdDevice()));
		window.add(area);
//		this.add(area);
		
		
		/** START{^\ */
		/** display the start button*/
		start_btn = new Button("START/STOP");
		createListener();
		start_btn.setBounds(x+120, y+30, 65, 24);
		window.add(start_btn);
//		this.add(start_btn);
		
		
		/** ʂ\ */
		/** display the result*/
		result_label = new Label("");
		result_label.setBounds(x+10, y+65, 570, 24);
		window.add(result_label);
		/** If the devicedata had already existed, the devicedata is displayed.*/
		if(!devicedata.equals("")){
			result_label.setText("RESULT : " + devicedata);
		}
//		this.add(result_label);
		
		
		/** g\ */
		/** display the Frame*/
		final Pattern up = new Pattern(x, y, width, 1, Pattern.Type.ALL1);
		final Pattern bottom = new Pattern(x, y + height, width, 1, Pattern.Type.ALL1);
		final Pattern left = new Pattern(x, y, 1, height, Pattern.Type.ALL1);
		final Pattern right = new Pattern(x + width, y, 1, height, Pattern.Type.ALL1);
		
		window.add(up);
		window.add(bottom);
		window.add(left);
		window.add(right);
//		this.add(up);
//		this.add(bottom);
//		this.add(left);
//		this.add(right);
//System.out.println("Out setBounds");			
	}
	
	
	/**
	 * {@jp ActionListenerǉ}{@en Add the ActionListener}.
	 * @param lis {@jp }{@en }.
	 */
	public void createListener() {
//System.out.println("In createListener : in DevicePanel");
		/** actionPerformedĂ΂ꂽƂɎListener̃\bhĂ΂悤ɂĂ */
		/** When the user pushes the start button, the ActionListener Class is called.  */
		start_btn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
//System.out.println("isReading = " + reader.isReading());
				if (!reader.isReading()){
					start_btn.setAttributeType(AttributeType.INVERSE);
					reader.startReader();
				} else {
					reader.stopReader();
					start_btn.setAttributeType(AttributeType.NONE);
				}
				start_btn.repaint();
			}
		});

		/** Set the reader status.*/
		if (reader.isReading()){
			start_btn.setAttributeType(AttributeType.INVERSE);
		} else {
			start_btn.setAttributeType(AttributeType.NONE);
		}
		start_btn.repaint();
		
		/** CardDeviceListenerɃCxgǉ */
		/** When the data is received from the usb device, the CardListner class is called.*/
		try {
			/** If the listener had already existed, listener isn't set.*/
			if(listener == null){
				listener = new CardListener(){
					public void readByte(byte[] data) {
	//					System.out.print("ThirdData = ");
//						for (int i = 0; i < data.length; i++) {
//							System.out.print(data[i] + " ");
//						}
//						System.out.println(" ");
						System.out.println("RESULT = " + new String(data));
						result_label.setText("RESULT : " + new String(data));
						result_label.repaint();
						devicedata = new String(data);
					}
	
					public void disconnect() {
						System.out.println("disconnect");
						reader.stopReader();
						reader.removeListener(listener);
					}
				};
				reader.addListener(listener);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
//System.out.println("Out createListener : in DevicePanel");
	}
	/**
	 * Return the usb device which set by the constructor.
	 * @return usb device
	 */
	public UsbDevice getDevice() {
		return device;
	}
}
