/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: ProximityCardReader is a class that extends AbstractCardReader for reading as for the data of the Proximity card.
 *
 */

package jp.co.ricoh.dsdk.usb.core.hid.prox;


import java.util.Vector;

import javax.usb.util.UsbUtil;

import jp.co.ricoh.dsdk.usb.prox.CardListener;

/**
 * ProximityCardReadeŕAAbstractCardReadergProximityJ[h̃f[^ǂݍ݂̂߂̃NXł
 * ProximityCardReader is a class that extends AbstractCardReader for reading as for the data of the Proximity card.
 */
public class ProximityCardIDCodeReader extends AbstractCardReader {

	private Vector listener = null;
	private StringBuffer str_data = null;

	/**
	 * ȈՃL[{[h}bv`܂
	 * The simple keyboard map is defined. 
	 */
	private static final String[] kbdTable_str = { "a", "a", "a", "a", "a",
			"b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n",
			"o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "1",
			"2", "3", "4", "5", "6", "7", "8", "9", "0" };

	/**
	 * ProximityCardReader̃CX^X쐬܂
	 * Create the ProximityCardReader instance.
	 */
	public ProximityCardIDCodeReader() {
		super();
		this.listener = new Vector();
		this.str_data = new StringBuffer();
		
		
		super.addListener(new CardListener(){
			public void readByte(byte[] data) {
				boolean endflag = false;
				boolean badflag = false;
				
				/** 
				 * parse the data. */
				for (int i=0; i<data.length; i++){
					/**
					 *  finish parsing if the data is "RETURN" code */
					if( UsbUtil.toHexString(data[i]).equals("28")){
						endflag = true;
					}
					/**             
					 *  check the return value. */
					if(((i-6)%8) == 0){
						if(!UsbUtil.toHexString(data[i]).equals("00")){
							endflag = true;
							badflag = true;
							System.out.println("System Error");
						}
					}

					if(endflag){
						break;
					}
					/** 
					 *  store the data if it is not "00"    */
					if(!UsbUtil.toHexString(data[i]).equals("00")){
						str_data.append(kbdTable_str[data[i]]);
					}

				}
				
				/** ?
				 *  no error and the end flag is enabled */
				if(!badflag && endflag){
					synchronized (listener) {
						for (int i = 0; i < listener.size(); i++) {
							if (listener.get(i) instanceof CardListener) {
								CardListener lis = (CardListener) listener.get(i);
								
								/**  
								 *  convert string data into byte array.*/
								byte[] b = str_data.toString().getBytes();
								
								/** get two last digits */
								String res_data = new String(b);
								long data_x = Long.parseLong(res_data) & 0xffff;
								lis.readByte(new String("" + data_x).getBytes());
								
								str_data = new StringBuffer();
//								lis.readByte(b);
								
							}
						}
					}
				}
			}
			
			public void disconnect() {
				synchronized (listener) {
					for (int i = 0; i < listener.size(); i++) {
						if (listener.get(i) instanceof CardListener) {
							CardListener lis = (CardListener) listener.get(i);
							lis.disconnect();
						}
					}
				}
			}
		});
		
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.core.cardreader.AbstractCardReader#addListener(jp.co.ricoh.dsdk.app.usb.cardreader.CardDataListener)
	 */
	public void addListener(CardListener lis){
		synchronized (listener) {
			listener.add(lis);
		}
	}
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#addListener(jp.co.ricoh.dsdk.app.usb.cardreader.CardDataListener)
	 */
	public void removeListener(CardListener lis) {
		synchronized (listener) {
			System.out.println("listener.size = " + listener.size());
			for(int i = 0; i < listener.size(); i++){
				CardListener cl = (CardListener)listener.get(i);
				if(cl == lis){
					listener.remove(i);
					break;
				}
			}
		}
	}
}