/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: MifareCardReader is a class that extends AbstractCardReader for reading as for the data of the Mifare card.
 *
 */

package jp.co.ricoh.dsdk.usb.core.hid.prox;

import java.util.Vector;

import javax.usb.util.UsbUtil;

import jp.co.ricoh.dsdk.usb.prox.CardListener;

/**
 * MifareCardReadeŕAAbstractCardReadergMifareJ[h̃f[^ǂݍ݂̂߂̃NXł
 * MifareCardReader is a class that extends AbstractCardReader for reading as for the data of the Mifare card.
 */
public class MifareCardReader extends AbstractCardReader {

	private Vector listener = null;
	private StringBuffer str_data = null;

	/**
	 * ȈՃL[{[h}bv`܂
	 * The simple keyboard map is defined. 
	 */
	private static final String[] kbdTable_str = { "a", "a", "a", "a", "a",
			"b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n",
			"o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "1",
			"2", "3", "4", "5", "6", "7", "8", "9", "0" };

	/**
	 * MifareCardReader̃CX^X쐬܂
	 * Create the MifareCardReader instance.
	 */
	public MifareCardReader() {
		super();
		this.listener = new Vector();
		this.str_data = new StringBuffer();
		
		
		super.addListener(new CardListener(){
			public void readByte(byte[] data) {
				boolean endflag = false;
				boolean badflag = false;
				
				/** f[^p[X
				 * parse the data. */
				for (int i=0; i<data.length; i++){
					/** f[^ "RETURN" R[h̏ꍇAp[XI
					 *  finish parsing if the data is "RETURN" code */
					if( UsbUtil.toHexString(data[i]).equals("28")){
						endflag = true;
					}
					/** Ԃl`FbN            
					 *  check the return value. */
					if(((i-6)%8) == 0){
						if(!UsbUtil.toHexString(data[i]).equals("00")){
							endflag = true;
							badflag = true;
							System.out.println("System Error");
						}
					}

					if(endflag){
						break;
					}
					/** 00łȂ̂kdbTableStringlɊi[
					 *  store the data if it is not "00"    */
					if(!UsbUtil.toHexString(data[i]).equals("00")){
						str_data.append(kbdTable_str[data[i]]);
					}

				}
				
				/** Error ȂAItOĂꍇ
				 *  no error and the end flag is enabled */
				if(!badflag && endflag){
					synchronized (listener) {
						for (int i = 0; i < listener.size(); i++) {
							if (listener.get(i) instanceof CardListener) {
								CardListener lis = (CardListener) listener.get(i);
								
								/** StringƂĎĂdataUIDɕϊ
								 *  convert string data into UID.     */
								
								String hS = Long.toHexString(new Long(str_data.toString()).longValue());
								System.out.println("hs : " + hS);
								
								StringBuffer hsbuf = new StringBuffer(20);
								hsbuf.append(hS);
								StringBuffer reversed = new StringBuffer(20);
								for(int t = 0; t < hsbuf.length(); t=t+2){
									String str = hsbuf.substring(t, t+2);
									reversed.insert(0, str);
								}
								byte[] b = reversed.toString().getBytes();
								
								str_data = new StringBuffer();
								lis.readByte(b);
								
							}
						}
					}
				}
			}
			
			public void disconnect() {
				synchronized (listener) {
					for (int i = 0; i < listener.size(); i++) {
						if (listener.get(i) instanceof CardListener) {
							CardListener lis = (CardListener) listener.get(i);
							lis.disconnect();
						}
					}
				}
			}
		});
		
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.core.cardreader.AbstractCardReader#addListener(jp.co.ricoh.dsdk.app.usb.cardreader.CardDataListener)
	 */
	public void addListener(CardListener lis){
		synchronized (listener) {
			listener.add(lis);
		}		
	}
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#addListener(jp.co.ricoh.dsdk.app.usb.cardreader.CardDataListener)
	 */
	public void removeListener(CardListener lis) {
		synchronized (listener) {
			for(int i = 0; i < listener.size(); i++){
				CardListener cl = (CardListener)listener.get(i);
				if(cl == lis){
					listener.remove(i);
					break;
				}
			}
		}
	}
}