/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: AbstractCardReader is the abstract class to get information from UsbCardReaderDevice. 
 *
 */

package jp.co.ricoh.dsdk.usb.core.hid.prox;

import java.util.List;
import java.util.Vector;

import javax.usb.UsbClaimException;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConst;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbPipe;
import javax.usb.util.UsbUtil;

import jp.co.ricoh.dsdk.usb.prox.CardListener;
import jp.co.ricoh.dsdk.usb.prox.CardReaderService;
import jp.co.ricoh.dsdk.util.usb.JavaxUsbUtil;

/**
 * AbstractCardReaderNX́AUsbCardReaderDevice擾邽߂̒ۃNXłB
 * AbstractCardReader is the abstract class to get information from UsbCardReaderDevice. 
 */
abstract class AbstractCardReader implements CardReaderService{

	private UsbDevice device = null;
	private UsbPipe pipe = null;
	private UsbInterface interf = null;

	private Vector lis = null;
	private boolean stop_flag = false;
	
	private int buffer_size = 1024;
	private final byte SCHOMAKER_ENDPOINT_ADDR = (byte) 0x81;

	
	/**
	 * AbstractCardReader̃CX^X쐬܂B
	 * Create AbstractCardReader instance.
	 */
	public AbstractCardReader() {
		this.lis = new Vector();
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#setDevice(javax.usb.UsbDevice)
	 */
	public void setDevice(UsbDevice device) throws UsbException{
		this.device = device;
		init();
	}
	
	/**
	 * CardReader܂B
	 * Initialize the CardReader.
	 */
	protected void init() throws UsbException {
		System.out.println("DEBUG AbstractCardReader: init() ");
		UsbConfiguration config = this.device.getActiveUsbConfiguration();
		System.out.println("DEBUG AbstractCardReader: got USB configuration ");
		
		UsbEndpoint endptIn = null;
		UsbEndpoint ep = null;
		
		if (config != null) {
			interf = config.getUsbInterface((byte) 0);
		}
		System.out.println("DEBUG AbstractCardReader: got USB interface ");
		
		/** UsbInterfacev */
		/** Claim the UsbInterface. */
		try {
			if(!interf.isClaimed())
			{
				interf.claim();
				System.out.println("DEBUG AbstractCardReader: interface is claimed ");
			}
		} catch (UsbClaimException e) {
			System.out.println("UsbClaimException was catched, but the processing go on.");
		} catch (UsbNotActiveException e) {
			System.out.println("UsbNotActiveException was catched, but the processing go on.");
		} catch (UsbDisconnectedException e) {
			System.out.println("UsbDisconnectedException was catched, but the processing go on.");
		}		
		
		/** Gh|Cg擾 */
		/** Get the endpoint. */
		List eps = interf.getUsbEndpoints();
		boolean foundEp = false;
		System.out.println("DEBUG AbstractCardReader: got endpoints ");
		for (int j = 0; j < eps.size(); j++) {
			ep = (UsbEndpoint) eps.get(j);
			int t = ep.getType();
			System.out.println("DEBUG AbstractCardReader endpointaddress: " +ep.getUsbEndpointDescriptor().bEndpointAddress());
			if (t == UsbConst.ENDPOINT_TYPE_INTERRUPT
					&& ep.getDirection() == UsbConst.ENDPOINT_DIRECTION_IN
					&& ep.getUsbEndpointDescriptor().bEndpointAddress() == SCHOMAKER_ENDPOINT_ADDR ) {
				endptIn = ep;
				System.out.println("DEBUG AbstractCardReader endpoint is selected " );
				foundEp = true;
				break;
			}
		}
		if( !foundEp )
		{
			System.out.println("DEBUG AbstractCardReader Have NOT found endpoint with address 0x81 try next best " );
			for (int j = 0; j < eps.size(); j++) {
				ep = (UsbEndpoint) eps.get(j);
				int t = ep.getType();
				System.out.println("DEBUG AbstractCardReader endpointaddress: " +ep.getUsbEndpointDescriptor().bEndpointAddress());
				if (t == UsbConst.ENDPOINT_TYPE_INTERRUPT
						&& ep.getDirection() == UsbConst.ENDPOINT_DIRECTION_IN) {
					endptIn = ep;
					System.out.println("DEBUG AbstractCardReader endpoint is selected " );
					foundEp = true;
					break;
				}
			}
		}
		System.out.println("endpoint information = " + endptIn.getUsbEndpointDescriptor());
		/** UsbPipe擾EJ */
		/** Get and open the UsbPipe. */
		pipe = endptIn.getUsbPipe();
		System.out.println("DEBUG AbstractCardReader: got pipe ");
		if(!pipe.isOpen()){
			pipe.open();
			System.out.println("DEBUG AbstractCardReader: open pipe ");
		}
	}

	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#addListener(jp.co.ricoh.dsdk.app.usb.cardreader.CardDataListener)
	 */
	public void addListener(CardListener listener) {
		synchronized (lis) {
			lis.add(listener);
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#getDevice()
	 */
	public UsbDevice getDevice() {
		return this.device;
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#stopReader()
	 */
	public void stopReader() {
		this.stop_flag = false;
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#isReading()
	 */
	public boolean isReading(){
		return this.stop_flag;
	}
	
	/*
	 * (non-Javadoc)
	 * @see jp.co.ricoh.dsdk.app.usb.cardreader.CardDeviceListener#releaseUsbInterface()
	 */
	public void releaseUsbInterface() throws UsbException{
		if(interf != null){
			JavaxUsbUtil.reset(interf);
			pipe.close();
			interf.release();
		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see java.lang.Thread#run()
	 */
	public void startReader() {
		/** Thread new  start() xsȂ߃AvThread쐬Kv */
		/** We need to create the Thread-class in this method. */
		new Thread() {
			public void run() {
				stop_flag = true;
				while (stop_flag) {
					try {
//						byte[] buffer = new byte[UsbUtil.unsignedInt(pipe
//								.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize())];
						
						byte[] temp = new byte[buffer_size];
//						int buffer_length = pipe.syncSubmit(temp);
						byte[] buffer = new byte[pipe.syncSubmit(temp)];
						
						
						/** 擾oCg */
						/** Substitution the byte array*/
						for(int i = 0; i < buffer.length; i++){
							buffer[i] = temp[i];
						}
						for(int i = 0; i < buffer.length ; i++){
							//00łȂ̂Sďo					
							if(!UsbUtil.toHexString(buffer[i]).equals("00")){
								System.out.print(i + ": 0x" + UsbUtil.toHexString(buffer[i]));
								System.out.println("");
							}
						}
						
						/** buffer̒lׂ0̏ꍇ́AEventグȂ */
						/** We don't have to notify the Event in case of all value is 0. */
						for (int i = 0; i < buffer.length; i++) {
							if (buffer[i] == 0)
								/** bufferׂ0̏ꍇ */
								/** In case of all value is 0. */
								;
							else {
								/** buffer0ȊOꂽƂɁAEventグ */
								/** exists the value of excluding 0. */
								synchronized (lis) {
									for (int j = 0; j < lis.size(); j++) {
										CardListener local_lis = (CardListener) lis.get(j);
										local_lis.readByte(buffer);
									}
								}
								break;// for break;
							}
						}
						Thread.sleep(50);
					} catch (Exception e) {
						//disconect̏Lq
						//in case of disconnect error occurs.
						System.out.println("exception of send command " + e);
						try{releaseUsbInterface();}catch(UsbException ex){ex.printStackTrace();}
						stop_flag = false;
						synchronized (lis) {
							for (int j = 0; j < lis.size(); j++) {
								CardListener local_lis = (CardListener) lis.get(j);
								local_lis.disconnect();
							}
						}
					}//end try catch
				}//end while
			}//end run()
		}.start();
	}
}