/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: Provides a singleton registry for the card id & user info mappings.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.auth;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

import jp.co.ricoh.dsdk.ap.sample.localauth.app.Activator;
import jp.co.ricoh.dsdk.ap.sample.localauth.util.FileUtil;
import jp.co.ricoh.dsdk.ap.sample.localauth.util.HexUtil;

/**
 * ̃NX́AOC[UXgǗVOgNXłB
 * Xgɂ́AIDƁAɑΉ郍OC[UAOCpX[hL^Ă܂B
 * This is a singleton class that manages the user information list.
 * The list consists of card IDs and corresponding login user names and login passwords.
 */
public class LoginUserRegistry {
	
	private static LoginUserRegistry reg = null;
	private static final String USERFILE = "localauth.dat";
	private ArrayList users;
	
	/**
	 * LoginUserResigtry擾܂B
	 * Returns the LoginUsetRegistry.
	 */
	synchronized public static LoginUserRegistry getInstance() throws IOException {
		if (reg == null) {
			reg = new LoginUserRegistry();
			return reg;
		}
		else return reg;
	}

	/**
	 * LoginUserRegistrỹCX^X𐶐܂B
	 * Creates the LoginUserRegistroy instance.
	 */
	private LoginUserRegistry() throws IOException {
		users = new ArrayList();
		loadUsers();
	}
	
	/**
	 * CfNXw肵āALoginUser擾܂B
	 * Returns the LoginUser with the given index.
	 */
	public LoginUser getUser(int index) {
		if (index < 0) return null;
		if (index > (users.size() - 1)) return null;
		return (LoginUser) ((LoginUser) users.get(index)).clone();
	}

	/**
	 * WXg̑SOC[U擾܂B
	 * Returns the number of login users in the registry. 
	 */
	public int getUserCounts() {
		return users.size();
	}
	
	/**
	 * w肵IDOC[Uindex擾܂B
	 * Returns the index of the login user who has the given ID. 
	 */
	public int searchUser(byte[] id) {
		for (int i = 0; i < users.size(); i++) {
			LoginUser user = (LoginUser) users.get(i);
			if (Arrays.equals(user.getId(), id)) return i;
		}
		return -1;
	}
	
	/**
	 * LoginUserw肵āAOC[U܂B
	 * OC[UꍇALoginUserCX^XԂ܂B
	 * Look up a login user who is equal to the given LoginUser.
	 * If the login user exists, returns the LoginUser instance.
	 */
	public LoginUser searchUser(LoginUser user) {
		for (int i = 0; i < users.size(); i++) {
			LoginUser _user = (LoginUser) users.get(i);
			if (_user.equals(user)) return _user;
		}
		return null;
	}

	/**
	 * WXgɃOC[Uǉ܂B
	 * Add a LoginUser to the registry. 
	 */
	public synchronized void addUser(LoginUser user) {
		if (searchUser(user.getId()) == -1) {
			users.add(user);
		} else {
		}
	}
	
	/**
	 * w肵CfNX̃OC[UAw肵LoginUserCX^XōXV܂B
	 * Updates the login user with the given index to the given LoginUser.
	 */
	public synchronized void updateUser(LoginUser user, int index) {
		if (index < 0) ;
		if (index > (users.size() - 1)) ;
		else {
			LoginUser _user = (LoginUser) users.get(index);
			_user.setId(user.getId());
			_user.setLoginName(user.getLoginName());
			_user.setLoginPassword(user.getLoginPassword());
		}
	}

	/**
	 * LoginUserw肵āAOC[U폜܂B
	 * Removes the login user who is equal to the given LoginUser.
	 */
	public synchronized void removeUser(LoginUser user) {
		LoginUser _user = searchUser(user);
		if (_user != null) {
			users.remove(_user);
		}
	}
	
	/**
	 * IDw肵āAOC[U폜܂B
	 * Removes the login user who is equal to the given LoginUser.
	 */
	public synchronized void removeUser(int index) {
		if (index < 0) ;
		if (index > (users.size() - 1)) ;
		users.remove(index);
	}
	
	/**
	 * OC[U[J̃t@C烍[hāAOC[UXg𐶐܂B
	 * t@C̖ÓA"localauth.dat"łB
	 * t@ĆACXg[pXɂ܂B
	 * 
	 * Loads login users from the local file and creates a login user list.
	 * The file name is "localauth.dat".
	 * The file is located in the INSTALL PATH.
	 */
	private void loadUsers() throws IOException {
		String authFilePath = Activator.filePath;
		File out = new File(authFilePath + File.separator + USERFILE);
		
		if (!out.exists()) {
			try {
				FileUtil.copyFile(getClass().getResourceAsStream(USERFILE), out);
				
			} catch (IOException e) {
				//e.printStackTrace();
				throw e;
			}
		}
		
		BufferedReader br = null;
		try {
			br = new BufferedReader(new FileReader(out));
			
			String line = null;
			while ((line = br.readLine())!= null) {				
				StringTokenizer st = new StringTokenizer(line, ",");
				
				byte[] id = st.nextToken().getBytes();
				
				String loginName = st.nextToken();
				
				String loginPassword = null;
				try {
					loginPassword = st.nextToken();
				} catch (NoSuchElementException e) {
					loginPassword = "";
				}
				
				users.add(new LoginUser(id, loginName, loginPassword));
			}
		
		} catch (FileNotFoundException e) {
			//e.printStackTrace();
			throw e;
			
		} catch (IOException e) {
			//e.printStackTrace();
			throw e;
				
		} finally {
			if (br != null) try {br.close();} catch (Exception e) {}
		}
	}
	
	/**
	 * _̃OC[UXgŁA[J̃t@CXV܂B
	 * Updates the local file with the current login user list in the registry.
	 */
	public synchronized void saveUsers() throws IOException {
		String authFilePath = Activator.filePath;
		File out = new File(authFilePath + File.separator + USERFILE);
		
		BufferedOutputStream os = null;
		try {
			os = new BufferedOutputStream(new FileOutputStream(out));
			for (int i = 0; i < users.size(); i++) {
				LoginUser user = (LoginUser) users.get(i);
				String data = 
					new String(user.getId()) + "," + 
					user.getLoginName() + "," + 
					user.getLoginPassword() + '\n';
				os.write(data.getBytes());
			}
			os.flush();
		} catch (FileNotFoundException e) {
			//e.printStackTrace();
			throw e;
		} catch (IOException e) {
			//e.printStackTrace();
			throw e;
		} finally {
			if (os != null) try {os.close();} catch (Exception e) {}
		}
	}
}