/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: Performs user authentication using PanelService API.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.auth;

import java.io.IOException;

import jp.co.ricoh.dsdk.ap.sample.localauth.app.CurrentInfo;
//import jp.co.ricoh.dsdk.ap.sample.localauth.cs.IDService;
import jp.co.ricoh.dsdk.opt.auth.ccm.AlreadySetException;
import jp.co.ricoh.dsdk.opt.auth.ccm.Ccm;
import jp.co.ricoh.dsdk.opt.auth.ccm.CcmRequest;
import jp.co.ricoh.dsdk.opt.auth.ccm.CcmRequestHandler;
import jp.co.ricoh.dsdk.opt.auth.ccm.CcmService;
import jp.co.ricoh.dsdk.opt.auth.ccm.InvalidPINException;
import jp.co.ricoh.dsdk.opt.auth.ccm.Name;
import jp.co.ricoh.dsdk.opt.auth.ccm.Password;
import jp.co.ricoh.dsdk.opt.auth.ccm.UnsupportedRequestException;

/**
 * ̃NX́APanelServicegpă[UF؂sNXłB
 * This class performs user authentication using PanelService. 
 */
public class LoginService {

	private LocalAuth localAuth= null;
	private CcmService ccms = null;
	private CcmRequestHandler handler = null;
	private byte[] data = null;
	private LoginUser currentUser = null;
	
	/**
	 * LoginServicẽCX^X쐬܂B
	 * Creates a LoginService instance.
	 */
	public LoginService() throws IOException {
		localAuth = new LocalAuth();
		currentUser = new LoginUser(new byte[0], "", "");
		
		ccms = new Ccm().getService();
		handler = new CcmRequestHandler() {
			public void handle(CcmRequest[] req) 
			throws UnsupportedRequestException, InvalidPINException, IOException {
				handleCcmRequest(req);
			}
		};
	}

	/**
	 * FؗṽnhJn܂B
	 * Starts handling authentication requests. 
	 */
	public void start() throws AlreadySetException {
		ccms.setRequestHandler(handler);
	}
	
	/**
	 * Fؗṽnh~܂B
	 * Stops handling the authentication requests.
	 */
	public void stop() {
		ccms.removeRequestHandler(handler);
	}

	/**
	 * [UF؃OCvo܂B
	 * Requests the user authentication login.
	 */
	public void requestLogin(byte[] data) {
		this.data = data;
		ccms.requestLogin();
	}

	/**
	 * [UF؃OAEgvo܂B
	 * Requests the user authentication logout.
	 */
	public void requestLogout() {
		ccms.requestLogout();
		CurrentInfo.clear();
	}
	
	/**
	 * ݂̃[U擾܂B
	 * Returns the current LoginUser.
	 */
	public LoginUser getCurrentUser() {
		return currentUser;
	}
	
	/**
	 * Fؗv̏s܂B
	 * Processes the authentication requests. 
	 */
	private void handleCcmRequest(CcmRequest[] req) 
	throws UnsupportedRequestException {
		currentUser = new LoginUser(new byte[0], "", "");
		
		Name name = null;
		Password password = null;
		
		/* v̐U蕪 */
		/* Categorizes each request */
		for (int i = 0; i < req.length; i++) {
			
			if (req[i] instanceof Name) {               
				name = (Name) req[i];
				
			} else if (req[i] instanceof Password) {  
				password = (Password) req[i];
				
			} else {
				throw new UnsupportedRequestException("Unsupported " + req[i]);
			}
		}
		
		byte[] tokenID = data;
		
		currentUser.setId(tokenID);
		
		/* IDɑΉ郆[U擾 */
		/* Obtains the corresponding user to the ID */
		if (localAuth.authenticate(tokenID)) {
			currentUser.setLoginName(localAuth.getAuthenticatedUser().getLoginName());
			currentUser.setLoginPassword(localAuth.getAuthenticatedUser().getLoginPassword());
		}
		
		/* OC[ŨZbg */
		/* Sets the login user name */
		if (name != null) {
			name.setName(currentUser.getLoginName().getBytes());
		}
		
		/* OCpX[h̃Zbg */
		/* Sets the login password */
		if (password != null) {
			password.setPassword(currentUser.getLoginPassword().getBytes());
		}
		
		/* ݂IDA[UZbg */
		/* Sets the current ID and current user */
		CurrentInfo.set(currentUser);
	}
	
}
