/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: Performs a local authentication using LocalUserRegistry.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.auth;

import java.io.IOException;

/**
 * ̃NX́ALoginUserRegistryJ[hIDɑΉ郆[UA
 * [JF؂sNXłB
 * This class performs a local authetication by looking up the user 
 * who corresponds to the inserted card ID in LoginUserRegistry.
 */
public class LocalAuth {
	
	private boolean authenticated;
	private int index;
	
	private LoginUserRegistry userRegistry = null;

	/**
	 * LocalAuth̃CX^X쐬܂B
	 * Create a LocalAuth instance.
	 */
	public LocalAuth() throws IOException {
		userRegistry = LoginUserRegistry.getInstance();
	}
	
	/**
	 * LoginUserRegistryJ[hIDɑΉ郆[U܂B
	 * [U񂪌ꍇAFؐƂ܂B
	 * Looking up the user who corresponds to the inserted card ID in LoginUserRegistry.
	 * If the corresponding user exists, the authentication will succeed.
	 */
	public boolean authenticate(byte[] id) {
		authenticated = false;
		index = userRegistry.searchUser(id);
		if (index == -1) return false;
		else {
			System.out.println("[LocalAuth] Local user for the inserted card found!!");
			authenticated = true;
			return true;
		}
	}
	
	/**
	 * F؂ĂꍇALoginUserԂ܂B
	 * Returns the LoginUser if the prior authentication succeeded. 
	 */
	public LoginUser getAuthenticatedUser() {
		if (authenticated) return userRegistry.getUser(index);
		else return new LoginUser(new byte[0], "", "");
	}
	
}
