/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: javax.usb LocalAuth sample bundle activator.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.app;

import jp.co.ricoh.dsdk.service.util.ServerContext;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

/**
 * Activator class
 */
public class Activator implements BundleActivator {
	
	/**
	 * HomepXi[
	 * Stores the home path of the application
	 */
	public static String filePath = "";
	public static String installedPath = "";
	
	private CardWaiter waiter = null;
	private HttpService http = null;
	private ServiceReference ref = null;
   
	private BundleContext contxt = null;
	String path = "";
	public static String INSTALL_PATH;
	
	/* (non Javadoc)
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    public void start(BundleContext bc) throws Exception {
    	System.out.println("ProxCard-LocalAuth : START");
		this.contxt = bc;
    	//get ServiceReference HTTP service
		this.ref = bc.getServiceReference("org.osgi.service.http.HttpService");
		if (this.ref==null){
			throw new Exception("not found HTTP service");
		}
		//get Service
		this.http = (HttpService)bc.getService(ref);
		if (this.http==null){
			throw new Exception("not found service object");
		}

    	filePath = (String) ServerContext.getProperty(bc, ServerContext.Prop_Key.HOME);
    	installedPath = (String)ServerContext.getProperty(bc, ServerContext.Prop_Key.INSTALLPATH);
		
		path = (String)ServerContext.getProperty(this.contxt, ServerContext.Prop_Key.INSTALLPATH);;
		if(path.indexOf("file:")==0){
			path = path.substring("file:".length());
		}
		System.out.println("path = " + path);
		INSTALL_PATH = path;
    	
    	try{
			waiter =  CardWaiter.getInstance();
			waiter.startReaders();
		}catch(Throwable th){
			th.printStackTrace();
		}
		//servlet has the alias
		http.registerServlet("/proximity/localauth/main",new main(),null,null);
		http.registerServlet("/proximity/localauth/useredit",new useredit(),null,null);
		http.registerResources("/proximity/localauth/images", "/images", null);
    }
    
    
    /* (non Javadoc)
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext arg0) throws Exception {
    	System.out.println("ProxCard-LocalAuth : STOP");
    	waiter.stopReaders();
    	
    	//unregister servlet,resources
		if (this.http!=null){
			this.http.unregister("/proximity/localauth/main");
			this.http.unregister("/proximity/localauth/useredit");
			this.http.unregister("/proximity/localauth/images");
		}
    }
	
}
