/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: An utility class for a data conversion between byte array and hexstring.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.util;

public class HexUtil {
	
	public static byte[] hexStringToBytes(String hexString) {
		if(hexString.length() % 2 != 0) {
			hexString = "0" + hexString;
		}
		byte[] b = new byte[hexString.length()/2];
		for (int offset = 0; offset <= hexString.length() - 2; offset += 2){
			String hexByte = hexString.substring(offset, offset+2);
			b[offset/2] = (byte)Integer.parseInt(hexByte, 0x10);
		}
		return b;
	}
	
	public static String bytesToHexString(byte[] bytes) {
		String hexString = "";
		for (int i = 0; i < bytes.length; i++) {
			if ((bytes[i] & 0xFF) < 0x10) hexString += '0';
			hexString += Integer.toHexString(bytes[i]&0xFF).toUpperCase();
		}
		return hexString;
	}
}
