/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: An utility class to copy/delete files.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
	
	synchronized public static void copyDirectory(File srcDir, File dstDir) throws IOException {
		if (!(srcDir != null && dstDir != null && srcDir.exists() && srcDir.isDirectory())) return;
		if (srcDir.getAbsolutePath().equals(dstDir.getAbsolutePath())) return;
		System.out.println("##### Copy dir " + srcDir.getAbsolutePath() + " to dir " + dstDir.getAbsolutePath());
		
		dstDir.mkdirs();
		
		File[] children = srcDir.listFiles();
		for (int i = 0; i < children.length; i++) {
			String dstPath = dstDir + File.separator + children[i].getName();
			if (children[i].isFile()) copyFile(children[i], new File(dstPath));
			if (children[i].isDirectory()) {
				File childDirOfDstDir = new File(dstPath);
				childDirOfDstDir.mkdirs();
				copyDirectory(children[i], childDirOfDstDir);
			}
		}
	}
	
	synchronized public static void copyFile(File srcFile, File dstFile) throws IOException {
		if (!(srcFile != null && dstFile != null && srcFile.exists() && srcFile.isFile())) return;
		if (srcFile.getAbsolutePath().equals(dstFile.getAbsolutePath())) return;
		System.out.println("########## Copy file " + srcFile.getAbsolutePath() + " to file " + dstFile.getAbsolutePath());
		
		copyFile(new FileInputStream(srcFile), dstFile);
	}
	
	synchronized public static void copyFile(InputStream srcFile, File dstFile) throws IOException {
		if (srcFile == null || dstFile == null) return;
		System.out.println("########## Copy file from stream to file " + dstFile.getAbsolutePath());
		
		String dstPath = dstFile.getAbsolutePath();
		String dstDir = dstPath.substring(0, dstPath.lastIndexOf(File.separator));
		new File(dstDir).mkdirs(); 
		
		BufferedInputStream is = null;
		BufferedOutputStream os = null;
		try {
			is = new BufferedInputStream(srcFile);
			os = new BufferedOutputStream(new FileOutputStream(dstFile));
			byte buf[] = new byte[256];
	        int len;
	        while ((len = is.read(buf)) != -1) {
	            os.write(buf, 0, len);
	        }
	        os.flush();
		} catch (FileNotFoundException e) {
			//e.printStackTrace();
			throw e;
		} catch (IOException e) {
			//e.printStackTrace();
			throw e;
		} finally {
			if (os != null) try {os.close();} catch (Exception e) {}
			if (is != null) try {is.close();} catch (Exception e) {}
		}
	}
	
	synchronized public static void deleteDirectory(File dir) {
		if (!(dir != null && dir.exists() && dir.isDirectory())) return;
		System.out.println("##### Delete dir " + dir.getAbsolutePath());
		
		File[] children = dir.listFiles();
		for (int i = 0; i < children.length; i++) {
			if (children[i].isFile()) deleteFile(children[i]);
			if (children[i].isDirectory()) {
				deleteDirectory(children[i]);
			}
		}
		dir.delete();
	}
	
	synchronized public static void deleteFile(File file) {
		if (!(file != null && file.exists() && file.isFile())) return;
		System.out.println("########## Delete file " + file.getAbsolutePath());
		
		file.delete();
	}
}
