/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: SCF CardService to read JavaCard id.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.cs;

import jp.co.ricoh.dsdk.scard.framework.card.Card;
import jp.co.ricoh.dsdk.scard.framework.card.CardAccessException;
import jp.co.ricoh.dsdk.scard.framework.service.CardServiceException;
import jp.co.ricoh.dsdk.scard.framework.service.UnsupportedCardException;
import jp.co.ricoh.dsdk.scard.framework.util.APDUException;
import jp.co.ricoh.dsdk.scard.framework.util.RequestAPDU;
import jp.co.ricoh.dsdk.scard.framework.util.ResponseAPDU;
import jp.co.ricoh.dsdk.scard.option.applet.AppletServiceImpl;

public class JavaCardIDService extends AppletServiceImpl implements IDService {
	
	protected static final byte[] GETDATA_CPLC = new byte[] {
		(byte)0x80,(byte)0xCA,(byte)0x9F,(byte)0x7F,(byte)0x2D
	};
	
	protected static final byte SW1_OK = (byte)0x90;
	
	public synchronized void initialize(Card card) 
	throws UnsupportedCardException, CardServiceException {
		super.initialize(card);
		
		boolean supported = false;
		
		RequestAPDU request = new RequestAPDU(GETDATA_CPLC);
		ResponseAPDU response = null;
		try {
			response = card.getIO().transmit(request);
			
			if (response.sw1() == SW1_OK) supported = true;
		
		} catch (CardAccessException e) {
			throw new CardServiceException(e);
		} catch (APDUException e) {
		}
		
		if (!supported) {
			throw new UnsupportedCardException();
		}
	}
	
	public byte[] getID() throws CardServiceException {
		RequestAPDU request = new RequestAPDU(GETDATA_CPLC);
		ResponseAPDU response = null;
		try {
			response = this.sendRequestAPDU(request);
			
			if (response.sw1() != SW1_OK) {
				throw new CardServiceException("Unsuccessful SW : " +
						Integer.toHexString(response.statusWords()));
			}
			
			byte[] data = response.data();
			
			byte[] tokenID = new byte[10];
			System.arraycopy(data, 0x03, tokenID, 0, 2);
			System.arraycopy(data, 0x05, tokenID, 2, 2);
			System.arraycopy(data, 0x13, tokenID, 4, 2);
			System.arraycopy(data, 0x0F, tokenID, 6, 4);
			
			return tokenID;
		
		} catch (APDUException e) {
			throw new CardServiceException(e);
		}
	}

}
