/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: SCF CardService to read Cryptoflex card id.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.cs;

import java.util.Iterator;

import jp.co.ricoh.dsdk.scard.framework.card.Card;
import jp.co.ricoh.dsdk.scard.framework.card.CardAccessException;
import jp.co.ricoh.dsdk.scard.framework.service.CardService;
import jp.co.ricoh.dsdk.scard.framework.service.CardServiceException;
import jp.co.ricoh.dsdk.scard.framework.service.UnsupportedCardException;
import jp.co.ricoh.dsdk.scard.framework.util.APDUException;
import jp.co.ricoh.dsdk.scard.framework.util.RequestAPDU;
import jp.co.ricoh.dsdk.scard.framework.util.ResponseAPDU;
import jp.co.ricoh.dsdk.scard.option.file.FileAccessService;
import jp.co.ricoh.dsdk.scard.option.file.FileID;
import jp.co.ricoh.dsdk.scard.option.file.FileInfo;
import jp.co.ricoh.dsdk.scard.option.file.FilePath;
import jp.co.ricoh.dsdk.scard.option.security.CHVCallback;
import jp.co.ricoh.dsdk.scard.option.security.CredentialSet;
import jp.co.ricoh.dsdk.scard.option.security.SecurityDomain;
import jp.co.ricoh.dsdk.scard.option.security.VerificationException;

public class CryptoflexIDService extends CardService
implements IDService, FileAccessService {
	
	private static final byte[][] atr = {
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x63,(byte)0x01,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x64,(byte)0x02,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x62,(byte)0x04,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0xE2,(byte)0x00,(byte)0x00,(byte)0x40,(byte)0x20,(byte)0x49,(byte)0x00},
		{(byte)0x3B,(byte)0x85,(byte)0x40,(byte)0x20,(byte)0x68,(byte)0x01,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x15,(byte)0x40,(byte)0x00,(byte)0x68,(byte)0x01,(byte)0x02,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x62,(byte)0x01,(byte)0x01,(byte)0x00,(byte)0x00},
		{(byte)0x3B,(byte)0x95,(byte)0x00,(byte)0x40,(byte)0xFF,(byte)0x62,(byte)0x01,(byte)0x02,(byte)0x00,(byte)0x00}
	};
	
	private static final byte[][] mask = {
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00},
		{(byte)0xff,(byte)0xff,(byte)0x00,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0xff,(byte)0x00,(byte)0x00}
	};
	
	private static AtrFilter atrFilter;
	
	static {
		atrFilter = new AtrFilter();
		for (int i = 0; i < atr.length; i++) {
			atrFilter.put(mask[i], atr[i]);	
		}
	}
	
	protected final static byte CLA_CRYPTO     = (byte)0xC0;
    protected final static byte INS_SELECTFILE = (byte)0xA4;
    protected final static byte INS_READBINARY = (byte)0xB0;
    protected final static byte BZ             = (byte)0x00;
    
    protected final static byte SW1_OK         = (byte)0x90;
	
	private static final FilePath filePath = new FilePath(":3F00:0002", ':');
	
	private static final int fileLen = 8;
	
	public synchronized void initialize(Card card) throws UnsupportedCardException, CardServiceException {
		super.initialize(card);
		
		if(!atrFilter.isCandidate(card.getInfo())){
			throw new UnsupportedCardException();
		}
	}
	
	public byte[] getID() throws CardServiceException {
		return this.read(filePath, 0, fileLen);
	}

	public void appendRecord(FilePath arg0, byte[] arg1) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		
	}

	public boolean exists(FilePath arg0) throws CardServiceException {
		// TODO Auto-generated method stub
		return false;
	}

	public FileInfo getFileInfo(FilePath arg0) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	public FilePath getRoot() {
		// TODO Auto-generated method stub
		return null;
	}

	public byte[] read(FilePath path, int offset, int length) throws VerificationException, CardServiceException {
		RequestAPDU req = null;
		ResponseAPDU res = null;
		
		Iterator ite = path.iterator();
    	while(ite.hasNext()){
    		FileID id = (FileID)ite.next();
    		
    		try{
    			req = new RequestAPDU(new byte[]{
    					CLA_CRYPTO, 
    					INS_SELECTFILE, 
    					BZ, 
    					BZ
    					});
    			req.append((byte)id.toBytes().length);
    			req.append(id.toBytes());
	    		res = card.getIO().transmit(req);
	    		
	    		if (res.sw1() != SW1_OK) {
	    			throw new CardServiceException("Status word bytes is not successful : " + 
	    					Integer.toHexString(res.statusWords()));
	    		}
	    		
    		} catch(APDUException e){	
                throw new CardServiceException(e);
                
            } catch (CardAccessException e) {
            	throw new CardServiceException(e);
			}
    	}
		
		try {
			req = new RequestAPDU(new byte[]{
					CLA_CRYPTO, 
					INS_READBINARY
					});
	        byte p1 = (byte)(offset/0x100);
	        byte p2 = (byte)(offset%0x100);
	        req.append(p1);
	        req.append(p2);
	        req.append((byte)length);
	        res = card.getIO().transmit(req);
	        
			if (res.sw1() != SW1_OK) {
    			throw new CardServiceException("Status word bytes is not successful : " + 
    					Integer.toHexString(res.statusWords()));
    		}
			
			return res.data();
			
		} catch (APDUException e) {
			throw new CardServiceException(e);
			
		} catch (CardAccessException e) {
			throw new CardServiceException(e);
		}
	}

	public byte[] readRecord(FilePath arg0) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	public byte[][] readRecords(FilePath arg0, int arg1) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	public byte[] readRecord(FilePath arg0, int arg1) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	public byte[][] readRecords(FilePath arg0, int arg1, int arg2) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	public void write(FilePath arg0, int arg1, byte[] arg2) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		
	}

	public void writeRecord(FilePath arg0, byte[] arg1) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		
	}

	public void writeRecord(FilePath arg0, int arg1, byte[] arg2) throws VerificationException, CardServiceException {
		// TODO Auto-generated method stub
		
	}

	public void setCallback(CHVCallback arg0) {
		// TODO Auto-generated method stub
		
	}

	public void provideCredentials(SecurityDomain arg0, CredentialSet arg1) {
		// TODO Auto-generated method stub
		
	}

}
