/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: SCF CardFilter sample using ATR.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.cs;

import java.util.Enumeration;
import java.util.Hashtable;

import jp.co.ricoh.dsdk.scard.framework.card.CardFilter;
import jp.co.ricoh.dsdk.scard.framework.card.Card.Info;

class AtrFilter implements CardFilter{
	
	private Hashtable hashTable = new Hashtable();
	
	public AtrFilter(){}
	
	public void put(byte[] mask, byte[] atr){
		hashTable.put(mask, atr);
	}
	
	public boolean isCandidate(Info info) {
		boolean ret = false;
		
		if (info == null) return ret;
		
		try {
			byte[] card = info.getAtr();
			
			byte masked = 0; 
			
			Enumeration em = hashTable.keys();
			while (em.hasMoreElements() && !ret) {
				byte[] mask = (byte[]) em.nextElement();
				byte[] atr = (byte[]) hashTable.get(mask);
				
				if (atr.length == card.length) {
					int i = 0;
					for (; i < atr.length; i++) {
						masked = (byte)(card[i] & mask[i]);
						if(masked!=atr[i]){
							break;
						}
					}
					if(!(i < card.length)){
						ret = true;
					}
				}
			}
			
		} catch (Throwable e) {
			e.printStackTrace();
		}
		return ret;
	}
}