/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: Encapsulates current card & user information.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.app;

import jp.co.ricoh.dsdk.ap.sample.localauth.auth.LoginUser;

/**
 * 現在ささっているカード情報および現在のログインユーザ情報を格納するクラスです。
 * This class stores current card and login user information.
 */
public class CurrentInfo {
	
	private static LoginUser user = new LoginUser(new byte[0], "", "");
	
	/**
	 * LoginUserを設定します。
	 * Set the LoginUser.
	 */
	public static void set(LoginUser _user) {
		user = _user;
	}
	
	/**
	 * 格納しているカード情報を削除します。
	 * Delete the card information stored this class.
	 */
	public static void clear() {
		user = new LoginUser(new byte[0], "", "");
	}
	
	/**
	 * 現在ささっているカードのIDを取得します。
	 * Get the user-id.
	 */
	public static byte[] getCurrentId() {
		return user.getId();
	}
	
	/**
	 * 現在ささっているカードのLoginUserクラスを取得します。
	 * Get the LoginUser instance.
	 */
	public static LoginUser getCurrentUser() {
		return user;
	}
}
