/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: Waits for a card using SCF.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.app;

import java.io.IOException;

import jp.co.ricoh.dsdk.ap.sample.localauth.auth.LoginService;
import jp.co.ricoh.dsdk.ap.sample.localauth.auth.LoginUserRegistry;
import jp.co.ricoh.dsdk.ap.sample.localauth.cs.CryptoflexIDService;
import jp.co.ricoh.dsdk.ap.sample.localauth.cs.JavaCardIDService;
import jp.co.ricoh.dsdk.opt.auth.ccm.AlreadySetException;
import jp.co.ricoh.dsdk.scard.framework.card.Card;
import jp.co.ricoh.dsdk.scard.framework.card.CardManager;
import jp.co.ricoh.dsdk.scard.framework.event.CardEvent;
import jp.co.ricoh.dsdk.scard.framework.event.CardEventListener;
import jp.co.ricoh.dsdk.scard.framework.service.CardServiceRegister;
import jp.co.ricoh.dsdk.scard.framework.service.CardServiceRegistryException;

/**
 * このクラスは、SmartCard Frameworkを使用してCardの読込みを開始・停止するためのクラスです。
 * CardWaiter is a class to start/stop reading Card using SmartCard Framework. 
 */
public class CardWaiter {
	
	private CardManager cm;
	private CardEventListener listener;
	
	private LoginService ls;
	
	/**
	 * デフォルトコンストラクタです。
	 * Default constructor.
	 */
	public CardWaiter() throws IOException {
		try {
			ls = new LoginService();
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		}
		cm = new CardManager();
	}
	
	/**
	 * LoginServiceの開始、カードのID読み込みの開始をします。
	 * Starts the LoginService and reading card ID. 
	 */
	public void start() throws Exception {
		try {
			/* ログインサービス開始 */
			/* Starts the LoginService */
			ls.start();
			
		} catch (AlreadySetException e) {
			e.printStackTrace();
			throw e;
		}
        
        try {
        	/* カードサービス登録 */
        	/* Registers card services */
        	CardServiceRegister register = new CardServiceRegister();
        	register.add(JavaCardIDService.class);
        	register.add(CryptoflexIDService.class);
        	
        	/* CardEventListener の実装と登録 */
        	/* Implemements a CardEventListener and adds it to the CardManager. */
			listener = new CardEventListener() {

				public void inserted(CardEvent event) {
					Card card = event.getSlot().getCard();
					ls.requestLogin(card);
				}

				public void removed(CardEvent event) {
					ls.requestLogout();
				}
				
			};
			cm.addCardListener(listener);
			
		} catch (CardServiceRegistryException e) {
			e.printStackTrace();
			throw e;

		}
	}
	
	/**
	 * カードのID読込みを停止して、LoginServiceを停止します
	 * Stop reading card ID and the LoginService.
	 */
	public void stop() {
		/* LoginServiceの停止 */
		/* Stops the LoginService */
		ls.stop();
		
		try {
			/* 登録したCardEventListenerの削除 */
			/* Removes the registered CardEventListener */
			if (cm != null) cm.removeCardListener(listener);
			
			/* 登録したカードサービスの削除 */
			/* Removes the registered card services */
			CardServiceRegister register = new CardServiceRegister();
			register.remove(JavaCardIDService.class);
			register.remove(CryptoflexIDService.class);
			
		} catch (CardServiceRegistryException e) {
			e.printStackTrace();
		}
		
		try {
			/* ログインユーザのリストを更新 */
			/* Updates the login user list */
			LoginUserRegistry.getInstance().saveUsers();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
}
