/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: SCF LocalAuth sample bundle activator.
 *
 */

package jp.co.ricoh.dsdk.ap.sample.localauth.app;

import jp.co.ricoh.dsdk.service.util.ServerContext;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

/**
 * Activator クラスです
 * Activator class
 */
public class Activator implements BundleActivator {
	
	private CardWaiter waiter = null;
	
	/**
	 * Homeパスを格納
	 * Stores the home path of the application
	 */
	public static String filePath = null;
	
	private HttpService http;
	private ServiceReference ref;
	
	/* (non Javadoc)
     * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
     */
    public void start(BundleContext bc) throws Exception {
    	try {
    	System.out.println("SCF-LocalAuth : START");
    	
    	filePath = (String) ServerContext.getProperty(bc, ServerContext.Prop_Key.HOME);
    	
    	waiter = new CardWaiter();
   		waiter.start();
    	
    	//get ServiceReference HTTP service
		this.ref = bc.getServiceReference("org.osgi.service.http.HttpService");
		if (this.ref==null){
			throw new Exception("not found HTTP service");
		}
		//get Service
		this.http = (HttpService)bc.getService(ref);
		if (this.http==null){
			throw new Exception("not found service object");
		}
		//servlet has the alias
		http.registerServlet("/smart/localauth/main",new main(),null,null);
		http.registerServlet("/smart/localauth/useredit",new useredit(),null,null);
		http.registerResources("/smart/localauth/images", "/images", null);
    	} catch (Exception e) {
    		e.printStackTrace();
    		throw e;
    	}
    }
    /* (non Javadoc)
     * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
     */
    public void stop(BundleContext arg0) throws Exception {
    	System.out.println("SCF-LocalAuth : STOP");
    	waiter.stop();
    	
    	//unregister servlet,resources
		if (this.http!=null){
			this.http.unregister("/smart/localauth/main");
			this.http.unregister("/smart/localauth/useredit");
			this.http.unregister("/smart/localauth/images");
		}
    }
	
}
