#!/bin/bash
#============================================================================
# xend-relocation
#
# Version = 1.0.3
# Date = 2007-09-14
#
# Maintainer(s) = Ron Terry - ron (at) pronetworkconsulting (dot) com
#
# The latest version can be found at:
#
#    http://pronetworkconsulting.com/linux/scripts/xend-relocation.html
#
# Description:
#
# This script is used to enable or disable the VM relocation (migration)
#  feature of xend.  It can be used to manage the local instance of xend
#  or both the local instance and instances of xend on the other machines
#  to/from which VMs can be relocated.
# To manage the instances of xend on other machines this script communicates
#  using ssh so it is recomended that if you use this feature you 
#  pre-distribute ssh keys between the servers.
#
# Depends on:
#
# Can use:           /etc/sysconfig/xend
#
# Usage:             xend-relocation (start|stop|status)
#                 or
#                    xend-relocation (on|off|status)
#
# Vars:
#
#  XEN_CONFIG_FILE
#
#  RELOCATION_NODELIST
#
#  MANAGE_ALL_RELOCATION_NODES
#
#  XEN_RELOCATION_PORT
#
#============================================================================

####  Read config files and set variables  ##################################

# If you source the /etc/sysconfig/xend file comment out the variables
#  being set in this script.

. /etc/sysconfig/xend

XEN_CONFIG_FILE="/etc/xen/xend-config.sxp"

####  Script Functions  #####################################################

usage(){
  echo ""
  echo "Usage:      xend-relocation {start|stop|status}" 
  echo "         or"
  echo "            xend-relocation {on|off|status}"
  echo ""
}

relocate_on() {
  for NODE in $RELOCATION_NODELIST
  do
    case $NODE in
      any)
        SSHCMD=""
        RELOCATION_NODELIST=""
      ;;
      *)
        if [ "$MANAGE_ALL_RELOCATION_NODES" = "true" ]
        then
          SSHCMD="ssh root@$NODE "
        else
          SSHCMD=""
        fi
      ;;
    esac

    $SSHCMD sed -i "s/^#(xend-relocation-server yes)/(xend-relocation-server yes)/g" $XEN_CONFIG_FILE
    $SSHCMD sed -i "s/^#(xend-relocation-server no)/(xend-relocation-server yes)/g" $XEN_CONFIG_FILE
    $SSHCMD sed -i "s/^#(xend-relocation-port [^)]*)/(xend-relocation-port $XEN_RELOCATION_PORT)/g" $XEN_CONFIG_FILE
    $SSHCMD sed -i "s/^(xend-relocation-hosts-allow \(.*\)/###(xend-relocation-hosts-allow \1/g" $XEN_CONFIG_FILE
    $SSHCMD sed -i "s/^#(xend-relocation-hosts-allow .*/(xend-relocation-hosts-allow \'$RELOCATION_NODELIST')/g" $XEN_CONFIG_FILE
    $SSHCMD rcxend restart

    if [ "$NODE" = "any" ] || [ "$MANAGE_ALL_RELOCATION_NODES" = "false" ]
    then
      exit 0
    fi
  done
}

relocate_off() {
  for NODE in $RELOCATION_NODELIST
  do
    case $NODE in
      any)
        SSHCMD=""
        RELOCATION_NODELIST=""
      ;;
      *)
        SSHCMD="ssh root@$NODE "
      ;;
    esac

    $SSHCMD sed -i "s/^(xend-relocation-server yes)/#(xend-relocation-server yes)/g" $XEN_CONFIG_FILE
    $SSHCMD sed -i "s/^(xend-relocation-port [^)]*)/#(xend-relocation-port $XEN_RELOCATION_PORT)/g" $XEN_CONFIG_FILE
    $SSHCMD sed -i "s/^(xend-relocation-hosts-allow .*/#(xend-relocation-hosts-allow \'$RELOCATION_NODELIST')/g" $XEN_CONFIG_FILE
    $SSHCMD rcxend restart

    if [ "$NODE" = "any" ] || [ "$MANAGE_ALL_RELOCATION_NODES" = "false" ]
    then
      exit 0
    fi
  done
}

relocate_status() {
  if grep -q "^(xend-relocation-server .*yes)" $XEN_CONFIG_FILE
  then
     ENABLED="yes"
  elif egrep -q "(^\(xend-relocation-server .*no\)|^#\(xend-relocation-server .*no\)|^#\(xend-relocation-server .*yes\))" $XEN_CONFIG_FILE
  then
    ENABLED="no"
  fi

  echo ""
  echo "Xend Relocation Server Enabled:                $ENABLED"
  echo ""
}

####  Script Body  ##########################################################

case $1 in
  on|ON|On|start)
    case $ENABLE_RELOCATION in
      true)
        relocate_on
      ;;
      false)
      ;;
    esac
    exit 0
  ;;
  off|OFF|Off|stop)
    relocate_off
    exit 0
  ;;
  status|STATUS|Status)
    relocate_status
    exit 0
  ;;
  *)
    usage
    exit 1
  ;;
esac
