#
# spec file for package xen
#
# Copyright (c) 2013 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

Name:           xen
ExclusiveArch:  %ix86 x86_64
%define xvers 4.2
%define xvermaj 4
%define changeset 26280
%define xen_build_dir xen-4.2.4-testing
%define with_kmp 1
%define with_stubdom 0
# EFI requires gcc46 or newer
# its available in 12.1 or >= sles11sp2
%if %suse_version == 1210 || %suse_version == 1110
%define with_gcc46 1
%else
%define with_gcc46 0
%endif
%ifarch x86_64
%define with_dom0_support 1
%else
%define with_dom0_support 0
%endif
%define _fwdefdir /etc/sysconfig/SuSEfirewall2.d/services
%if %suse_version > 1140
%define with_xend 1
%else
%define with_xend 1
%endif
BuildRequires:  LibVNCServer-devel
BuildRequires:  SDL-devel
BuildRequires:  automake
BuildRequires:  bin86
BuildRequires:  curl-devel
BuildRequires:  dev86
BuildRequires:  fdupes
BuildRequires:  glib2-devel
BuildRequires:  graphviz
BuildRequires:  latex2html
BuildRequires:  libbz2-devel
BuildRequires:  libjpeg-devel
BuildRequires:  libuuid-devel
BuildRequires:  libxml2-devel
BuildRequires:  libyajl-devel
BuildRequires:  ncurses-devel
BuildRequires:  openssl
BuildRequires:  openssl-devel
BuildRequires:  pciutils-devel
BuildRequires:  python-devel
BuildRequires:  texinfo
BuildRequires:  transfig
%if %suse_version >= 1120
BuildRequires:  xz-devel
%endif
%if %suse_version <= 1110
BuildRequires:  pmtools
%else
BuildRequires:  acpica
%endif
%if %suse_version >= 1030
BuildRequires:  texlive
BuildRequires:  texlive-latex
%if %suse_version > 1220
BuildRequires:  texlive-courier
BuildRequires:  texlive-dvips
BuildRequires:  texlive-helvetic
BuildRequires:  texlive-psnfss
BuildRequires:  texlive-times
BuildRequires:  tex(a4.sty)
BuildRequires:  tex(a4wide.sty)
BuildRequires:  tex(fancyhdr.sty)
BuildRequires:  tex(parskip.sty)
BuildRequires:  tex(setspace.sty)
%endif
%else
BuildRequires:  te_ams
BuildRequires:  te_latex
BuildRequires:  tetex
%endif
%ifarch x86_64
%if %{?with_gcc46}0
BuildRequires:  gcc46
BuildRequires:  libgcc46
BuildRequires:  libgcc46-32bit
%endif
BuildRequires:  gcc-32bit
BuildRequires:  gcc43-32bit
BuildRequires:  glibc-32bit
BuildRequires:  glibc-devel-32bit
%define max_cpus 256
%define pae_enabled n
%else
%define max_cpus 32
%define pae_enabled y
%endif
BuildRequires:  glibc-devel
%if %{?with_kmp}0
BuildRequires:  kernel-source
BuildRequires:  kernel-syms
BuildRequires:  module-init-tools
%if %suse_version < 1220
BuildRequires:  xorg-x11
%else
BuildRequires:  lndir
%endif
%endif
Version:        4.2.4_02
Release:        1.26.2
PreReq:         %insserv_prereq %fillup_prereq
Summary:        Xen Virtualization: Hypervisor (aka VMM aka Microkernel)
License:        GPL-2.0+
Group:          System/Kernel
Source0:        xen-4.2.4-testing-src.tar.bz2
Source1:        stubdom.tar.bz2
Source2:        qemu-xen-traditional-dir-remote.tar.bz2
Source3:        qemu-xen-dir-remote.tar.bz2
Source4:        seabios-dir-remote.tar.bz2
Source5:        ipxe.tar.bz2
Source6:        xen-utils-0.1.tar.bz2
Source10:       README.SuSE
Source11:       boot.xen
Source12:       boot.local.xenU
Source13:       init.xend
Source14:       init.xendomains
Source15:       logrotate.conf
Source16:       domUloader.py
Source17:       xmexample.domUloader
Source18:       xmexample.disks
Source19:       block-nbd
Source20:       block-iscsi
Source21:       block-npiv-common.sh
Source22:       block-npiv
Source23:       block-npiv-vport
Source24:       xmclone.sh
Source25:       xend-relocation.sh
Source26:       init.xen_loop
%if %{?with_kmp}0
Source27:       xen_pvdrivers.conf
Source28:       kmp_filelist
%endif
# Xen API remote authentication sources
Source29:       block-dmmd
Source30:       etc_pam.d_xen-api
Source31:       xenapiusers
# sysconfig hook script for Xen
Source32:       xen-updown.sh
# Firewall service file for xend relocation server
Source33:       xend-relocation-server.fw
# init script and sysconf file for pciback
Source34:       init.pciback
Source35:       sysconfig.pciback
Source36:       xnloader.py
Source99:       baselibs.conf
# http://xenbits.xensource.com/ext/xenalyze
Source20000:    xenalyze.hg.tar.bz2
# Upstream patches
Patch25861:     25861-x86-early-fixmap.patch
Patch25862:     25862-sercon-non-com.patch
Patch25863:     25863-sercon-ehci-dbgp.patch
Patch25864:     25864-sercon-unused.patch
Patch25866:     25866-sercon-ns16550-pci-irq.patch
Patch25867:     25867-sercon-ns16550-parse.patch
Patch25874:     25874-x86-EFI-chain-cfg.patch
Patch25909:     25909-xenpm-consistent.patch
Patch25920:     25920-x86-APICV-enable.patch
Patch25921:     25921-x86-APICV-delivery.patch
Patch25922:     25922-x86-APICV-x2APIC.patch
Patch25957:     25957-x86-TSC-adjust-HVM.patch
Patch25958:     25958-x86-TSC-adjust-sr.patch
Patch25959:     25959-x86-TSC-adjust-expose.patch
Patch26077:     26077-stubdom_fix_compile_errors_in_grub.patch
Patch26078:     26078-hotplug-Linux_remove_hotplug_support_rely_on_udev_instead.patch
Patch26079:     26079-hotplug-Linux_close_lockfd_after_lock_attempt.patch
Patch26081:     26081-stubdom_fix_rpmlint_warning_spurious-executable-perm.patch
Patch26082:     26082-blktap2-libvhd_fix_rpmlint_warning_spurious-executable-perm.patch
Patch26083:     26083-blktap_fix_rpmlint_warning_spurious-executable-perm.patch
Patch26084:     26084-hotplug_install_hotplugpath.sh_as_data_file.patch
Patch26085:     26085-stubdom_install_stubdompath.sh_as_data_file.patch
Patch26086:     26086-hotplug-Linux_correct_sysconfig_tag_in_xendomains.patch
Patch26087:     26087-hotplug-Linux_install_sysconfig_files_as_data_files.patch
Patch26114:     26114-pygrub-list-entries.patch
Patch26129:     26129-ACPI-BGRT-invalidate.patch
Patch26133:     26133-IOMMU-defer-BM-disable.patch
Patch26189:     26189-xenstore-chmod.patch
Patch26262:     26262-x86-EFI-secure-shim.patch
Patch26324:     26324-IOMMU-assign-params.patch
Patch26325:     26325-IOMMU-add-remove-params.patch
Patch26326:     26326-VT-d-context-map-params.patch
Patch26327:     26327-AMD-IOMMU-flush-params.patch
Patch26328:     26328-IOMMU-pdev-type.patch
Patch26329:     26329-IOMMU-phantom-dev.patch
Patch26330:     26330-VT-d-phantom-MSI.patch
Patch26331:     26331-IOMMU-phantom-dev-quirk.patch
Patch26341:     26341-hvm-firmware-passthrough.patch
Patch26342:     26342-hvm-firmware-passthrough.patch
Patch26343:     26343-hvm-firmware-passthrough.patch
Patch26344:     26344-hvm-firmware-passthrough.patch
Patch26369:     26369-libxl-devid.patch
Patch26370:     26370-libxc-x86-initial-mapping-fit.patch
Patch26372:     26372-tools-paths.patch
Patch26404:     26404-x86-forward-both-NMI-kinds.patch
Patch26418:     26418-x86-trampoline-consider-multiboot.patch
Patch26532:     26532-AMD-IOMMU-phantom-MSI.patch
Patch26547:     26547-tools-xc_fix_logic_error_in_stdiostream_progress.patch
Patch26548:     26548-tools-xc_handle_tty_output_differently_in_stdiostream_progress.patch
Patch26549:     26549-tools-xc_turn_XCFLAGS__into_shifts.patch
Patch26550:     26550-tools-xc_restore_logging_in_xc_save.patch
Patch26551:     26551-tools-xc_log_pid_in_xc_save-xc_restore_output.patch
Patch26554:     26554-hvm-firmware-passthrough.patch
Patch26555:     26555-hvm-firmware-passthrough.patch
Patch26556:     26556-hvm-firmware-passthrough.patch
Patch26576:     26576-x86-APICV-migration.patch
Patch26577:     26577-x86-APICV-x2APIC.patch
Patch26675:     26675-tools-xentoollog_update_tty_detection_in_stdiostream_progress.patch
Patch26754:     26754-hvm-Improve-APIC-INIT-SIPI-emulation.patch
Patch26878:     26878-VMX-Detect-posted-interrupt-capability.patch
Patch26879:     26879-VMX-Turn-on-posted-interrupt-bit-in-vmcs.patch
Patch26880:     26880-VMX-Add-posted-interrupt-supporting.patch
Patch26881:     26881-x86-HVM-Call-vlapic_set_irq-to-delivery-virtual-interrupt.patch
Patch26882:     26882-VMX-Use-posted-interrupt-to-deliver-virtual-interrupt.patch
Patch26902:     26902-x86-EFI-pass-boot-services-variable-info-to-runtime-code.patch
Patch26953:     26953-x86-allow-Dom0-read-only-access-to-IO-APICs.patch
Patch27179:     27179-VMX-Viridian-suppress-MSR-based-APIC-suggestion-when-having-APIC-V.patch
Patch27184:     27184-libxl-devid-fix.patch
Patch27249:     27249-VMX-fix-interaction-of-APIC-V-and-Viridian-emulation.patch
Patch27353:     27353-VMX-add-boot-parameter-to-enable-disable-APIC-v-dynamically.patch
Patch27405:     27405-Nested-VMX-Check-whether-interrupt-is-blocked-by-TPR.patch
Patch27406:     27406-Nested-VMX-Force-check-ISR-when-L2-is-running.patch
Patch27407:     27407-Nested-VMX-Clear-APIC-v-control-bit-in-vmcs02.patch
Patch27408:     27408-Nested-VMX-Update-APIC-v-RVI-SVI-when-vmexit-to-L1.patch
Patch27431:     27431-x86-don-t-allow-Dom0-access-to-the-HT-address-range.patch
Patch27511:     27511-x86-fix-memory-cut-off-when-using-PFN-compression.patch
Patch27512:     27512-libxc-x86-fix-page-table-creation-for-huge-guests.patch
Patch27515:     27515-cpufreq-missing-check-of-copy_from_guest.patch
Patch27519:     27519-x86-machine_restart-must-not-call-acpi_dmar_reinstate-twice.patch
Patch27549:     27549-set-mtu-from-bridge-for-tap-interface.patch
Patch27582:     27582-x86-HVM-fix-failure-path-in-hvm_vcpu_initialise.patch
Patch27583:     27583-VMX-fix-failure-path-in-construct_vmcs.patch
Patch27586:     27586-x86-HVM-properly-handle-wide-MMIO.patch
Patch27611:     27611-x86-HVM-linear-address-must-be-canonical-for-the-whole-accessed-range.patch
Patch27612:     27612-x86-HVM-refuse-doing-string-operations-in-certain-situations.patch
Patch27691:     27691-x86-percpu-Force-INVALID_PERCPU_AREA-into-the-non-canonical-address-region.patch
Patch27692:     27692-Nested-VMX-check-VMX-capability-before-read-VMX-related-MSRs.patch
Patch27694:     27694-Nested-VMX-fix-IA32_VMX_CR4_FIXED1-msr-emulation.patch
Patch27756:     27756-pygrub-xvda-style-disk.patch
Patch27764:     27764-x86-print-relevant-tail-part-of-filename-for-warnings-and-crashes.patch
Patch27870:     27870-x86-idle-reduce-contention-on-ACPI-register-accesses.patch
Patch27925:     27925-nested-SVM-adjust-guest-handling-of-structure-mappings.patch
Patch27963:     27963-nested-VMX-don-t-ignore-mapping-errors.patch
Patch28103:     28103-nested-vmx-fix-I-O-port-bitmap-indexing-arithmetic.patch
Patch28112:     28112-nested-VMX-fix-I-O-port-exit-emulation.patch
Patch28131:     28131-Nested-VMX-CR-emulation-fix-up.patch
Patch28229:     28229-Nested-VMX-Setup-the-virtual-NMI-exiting-info.patch
Patch28235:     28235-VMX-apicv-Set-NMI-window-exiting-for-NMI.patch
Patch28297:     28297-nested-EPT-fixing-wrong-handling-for-L2-guest-s-direct-mmio-access.patch
Patch28302:     28302-Nested-VMX-prohibit-virtual-vmentry-vmexit-during-IO-emulation.patch
Patch28304:     28304-x86-don-t-drop-guest-visible-state-updates-when-64-bit-PV-guest-is-in-user-mode.patch
Patch188:       xen.migrate.tools-xc_print_messages_from_xc_save_with_xc_report.patch
Patch189:       xen.migrate.tools-xc_document_printf_calls_in_xc_restore.patch
Patch190:       xen.migrate.tools-xc_rework_xc_save.cswitch_qemu_logdirty.patch
Patch191:       xen.migrate.tools_set_migration_constraints_from_cmdline.patch
Patch192:       xen.migrate.tools_add_xm_migrate_--log_progress_option.patch
Patch193:       xen.migrate.tools-xend_move_assert_to_exception_block.patch
Patch194:       xen.migrate.tools-libxc_print_stats_if_migration_is_aborted.patch
Patch195:       xen.migrate.tools_set_number_of_dirty_pages_during_migration.patch
# Upstream qemu patches
Patch200:       VNC-Support-for-ExtendedKeyEvent-client-message.patch
Patch201:       0001-net-move-the-tap-buffer-into-TAPState.patch
Patch202:       0002-net-increase-tap-buffer-size.patch
Patch203:       0003-e1000-fix-access-4-bytes-beyond-buffer-end.patch
Patch204:       0004-e1000-secrc-support.patch
Patch205:       0005-e1000-multi-buffer-packet-support.patch
Patch206:       0006-e1000-clear-EOP-for-multi-buffer-descriptors.patch
Patch207:       0007-e1000-verify-we-have-buffers-upfront.patch
Patch208:       0008-e1000-check-buffer-availability.patch
# Our patches
Patch301:       xend-config.diff
Patch302:       xen-destdir.diff
Patch304:       xen-changeset.diff
Patch305:       xen-paths.diff
Patch306:       xen-xmexample.diff
Patch307:       xen-xmexample-vti.diff
Patch310:       xen-fixme-doc.diff
Patch311:       xen-domUloader.diff
Patch312:       xen-no-dummy-nfs-ip.diff
Patch313:       serial-split.patch
Patch314:       xen-xm-top-needs-root.diff
Patch315:       xen-max-free-mem.diff
Patch322:       bridge-opensuse.patch
Patch323:       bridge-vlan.diff
Patch324:       bridge-bonding.diff
Patch325:       bridge-record-creation.patch
Patch327:       udev-rules.patch
Patch328:       vif-route-ifup.patch
Patch329:       network-nat-open-SuSEfirewall2-FORWARD.patch
Patch340:       xen-hvm-default-bridge.diff
Patch341:       xen-hvm-default-pae.diff
Patch342:       libxen_permissive.patch
Patch343:       xenapi-console-protocol.patch
Patch344:       xen-disable-qemu-monitor.diff
Patch345:       qemu-security-etch1.diff
Patch350:       cdrom-removable.patch
Patch351:       xend-core-dump-loc.diff
Patch352:       blktap.patch
Patch353:       xen-api-auth.patch
Patch354:       xen-qemu-iscsi-fix.patch
Patch355:       ioemu-vnc-resize.patch
Patch356:       ioemu-debuginfo.patch
Patch357:       vif-bridge-no-iptables.patch
Patch358:       xenconsole-no-multiple-connections.patch
Patch359:       qemu-ifup-set-mtu.patch
# Needs to go upstream
Patch370:       checkpoint-rename.patch
Patch371:       xm-save-check-file.patch
Patch372:       xm-create-xflag.patch
Patch373:       xend-sysconfig.patch
Patch374:       domu-usb-controller.patch
Patch375:       usb-list.patch
Patch376:       xend-devid-or-name.patch
Patch377:       suspend_evtchn_lock.patch
Patch378:       log-guest-console.patch
Patch379:       xend-migration-domname-fix.patch
Patch380:       xm-create-maxmem.patch
Patch381:       vif-bridge-tap-fix.patch
Patch382:       xend-cpuid.patch
# ioemu part of blktap patch series
Patch410:       ioemu-blktap-fv-init.patch
Patch411:       ioemu-blktap-image-format.patch
Patch412:       build-tapdisk-ioemu.patch
Patch413:       tapdisk-ioemu-logfile.patch
Patch414:       ioemu-blktap-zero-size.patch
Patch415:       tapdisk-ioemu-shutdown-fix.patch
Patch420:       blktapctrl-default-to-ioemu.patch
Patch421:       ioemu-blktap-barriers.patch
# Other bug fixes or features
Patch423:       bdrv_open2_fix_flags.patch
Patch424:       bdrv_open2_flags_2.patch
Patch425:       ioemu-bdrv-open-CACHE_WB.patch
Patch426:       ioemu-7615-qcow2-fix-alloc_cluster_link_l2.patch
Patch427:       xen-ioemu-hvm-pv-support.diff
Patch428:       qemu-dm-segfault.patch
Patch429:       hibernate.patch
Patch430:       del_usb_xend_entry.patch
Patch431:       capslock_enable.patch
Patch433:       multi-xvdp.patch
Patch434:       check_device_status.patch
Patch435:       change_home_server.patch
Patch436:       altgr_2.patch
Patch438:       stdvga-cache.patch
Patch439:       minios-fixups.patch
Patch440:       bdrv_default_rwflag.patch
Patch442:       xen-minimum-restart-time.patch
Patch446:       xend-disable-internal-logrotate.patch
Patch447:       xend-config-enable-dump-comment.patch
Patch448:       change-vnc-passwd.patch
Patch449:       kernel-boot-hvm.patch
Patch450:       ioemu-watchdog-support.patch
Patch451:       ioemu-watchdog-linkage.patch
Patch452:       ioemu-watchdog-ib700-timer.patch
Patch453:       tools-watchdog-support.patch
Patch454:       xend-console-port-restore.patch
Patch456:       xend-vcpu-affinity-fix.patch
Patch457:       xen-cpupool-xl-config-format.patch
Patch458:       ipxe-enable-nics.patch
Patch459:       blktap-close-fifos.patch
Patch460:       blktap-disable-debug-printf.patch
Patch461:       xen-migration-bridge-check.patch
Patch462:       pygrub-netware-xnloader.patch
Patch463:       xen-managed-pci-device.patch
Patch464:       xend-hvm-firmware-passthrough.patch
Patch465:       xend-xm-reboot-fix.patch
Patch466:       disable-xl-when-using-xend-fix.patch
Patch467:       xend-pvscsi-recognize-also-SCSI-CDROM-devices.patch
# Jim's domain lock patch
Patch480:       xend-domain-lock.patch
Patch481:       xend-domain-lock-sfex.patch
# Hypervisor and PV driver Patches
Patch500:       32on64-extra-mem.patch
Patch502:       x86-ioapic-ack-default.patch
Patch503:       x86-cpufreq-report.patch
Patch504:       x86-dom-print.patch
Patch505:       pvdrv-import-shared-info.patch
Patch506:       x86-extra-trap-info.patch
Patch507:       pvdrv_emulation_control.patch
Patch508:       blktap-pv-cdrom.patch
Patch511:       supported_module.diff
Patch512:       magic_ioport_compat.patch
Patch513:       xen.sles11sp1.fate311487.xen_platform_pci.dmistring.patch
Patch650:       disable_emulated_device.diff
Patch651:       ioemu-disable-scsi.patch
Patch652:       ioemu-disable-emulated-ide-if-pv.patch
Patch700:       hv_extid_compatibility.patch
Patch800:       xenpaging.autostart.patch
Patch801:       xenpaging.doc.patch
Patch802:       xenpaging.qemu.flush-cache.patch

# Kurofune ATI passthrough patch
Patch900:       xen-4.2.4.ati-passthrough.patch

# Build patch
Patch99998:     tmp-initscript-modprobe.patch
Patch99999:     tmp_build.patch
Url:            http://www.cl.cam.ac.uk/Research/SRG/netos/xen/
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
%define pyver %(python -c "import sys; print sys.version[:3]")
%if %{?with_kmp}0
%suse_kernel_module_package -n xen um xen -f kmp_filelist
%endif

%description
Xen is a virtual machine monitor for x86 that supports execution of
multiple guest operating systems with unprecedented levels of
performance and resource isolation.

This package contains the Xen Hypervisor. (tm)

Modern computers are sufficiently powerful to use virtualization to
present the illusion of many smaller virtual machines (VMs), each
running a separate operating system instance. Successful partitioning
of a machine to support the concurrent execution of multiple operating
systems poses several challenges. Firstly, virtual machines must be
isolated from one another: It is not acceptable for the execution of
one to adversely affect the performance of another. This is
particularly true when virtual machines are owned by mutually
untrusting users. Secondly, it is necessary to support a variety of
different operating systems to accommodate the heterogeneity of popular
applications. Thirdly, the performance overhead introduced by
virtualization should be small.

Xen uses a technique called paravirtualization: The guest OS is
modified, mainly to enhance performance.

The Xen hypervisor (microkernel) does not provide device drivers for
your hardware (except for CPU and memory). This job is left to the
kernel that's running in domain 0. Thus the domain 0 kernel is
privileged; it has full hardware access. It's started immediately after
Xen starts up. Other domains have no access to the hardware; instead
they use virtual interfaces that are provided by Xen (with the help of
the domain 0 kernel).

Xen does support booting other Operating Systems; ports of NetBSD
(Christian Limpach), FreeBSD (Kip Macy), and Plan 9 (Ron Minnich)
exist. A port of Windows XP was developed for an earlier version of
Xen, but is not available for release due to license restrictions.

In addition to this package you need to install the kernel-xen and
xen-tools to use Xen. Xen 3 also supports running unmodified guests
using full virtualization, if appropriate hardware is present. Install
xen-tools-ioemu if you want to use this.

[Hypervisor is a trademark of IBM]



Authors:
--------
    Ian Pratt <ian.pratt@cl.cam.ac.uk>
    Keir Fraser <Keir.Fraser@cl.cam.ac.uk>
    Christian Limpach <Christian.Limpach@cl.cam.ac.uk>
    Mark Williamson <mark.williamson@cl.cam.ac.uk>
    Ewan Mellor <ewan@xensource.com>
    ...

%package libs
Summary:        Xen Virtualization: Libraries
Group:          System/Kernel
#Requires:       xen = %{version}

%description libs
Xen is a virtual machine monitor for x86 that supports execution of
multiple guest operating systems with unprecedented levels of
performance and resource isolation.

This package contains the libraries used to interact with the Xen
virtual machine monitor.

Modern computers are sufficiently powerful to use virtualization to
present the illusion of many smaller virtual machines (VMs), each
running a separate operating system instance. Successful partitioning
of a machine to support the concurrent execution of multiple operating
systems poses several challenges. Firstly, virtual machines must be
isolated from one another: It is not acceptable for the execution of
one to adversely affect the performance of another. This is
particularly true when virtual machines are owned by mutually
untrusting users. Secondly, it is necessary to support a variety of
different operating systems to accommodate the heterogeneity of popular
applications. Thirdly, the performance overhead introduced by
virtualization should be small.

Xen uses a technique called paravirtualization: The guest OS is
modified, mainly to enhance performance.

The Xen hypervisor (microkernel) does not provide device drivers for
your hardware (except for CPU and memory). This job is left to the
kernel that's running in domain 0. Thus the domain 0 kernel is
privileged; it has full hardware access. It's started immediately after
Xen starts up. Other domains have no access to the hardware; instead
they use virtual interfaces that are provided by Xen (with the help of
the domain 0 kernel).

Xen does support booting other Operating Systems; ports of NetBSD
(Christian Limpach), FreeBSD (Kip Macy), and Plan 9 (Ron Minnich)
exist. A port of Windows XP was developed for an earlier version of
Xen, but is not available for release due to license restrictions.



Authors:
--------
    Ian Pratt <ian.pratt@cl.cam.ac.uk>

%if %{?with_dom0_support}0

%package tools
Summary:        Xen Virtualization: Control tools for domain 0
Group:          System/Kernel
Requires:       bridge-utils
Requires:       multipath-tools
Requires:       python
Requires:       python-curses
Requires:       python-lxml
Requires:       python-openssl
Requires:       python-pam
Requires:       python-xml
Requires:       xen-libs = %{version}
# subpackage existed in 10.3
Provides:       xen-tools-ioemu = %{version}
Obsoletes:      xen-tools-ioemu < %{version}

%description tools
Xen is a virtual machine monitor for x86 that supports execution of
multiple guest operating systems with unprecedented levels of
performance and resource isolation.

This package contains the control tools that allow you to start, stop,
migrate, and manage virtual machines.

Modern computers are sufficiently powerful to use virtualization to
present the illusion of many smaller virtual machines (VMs), each
running a separate operating system instance. Successful partitioning
of a machine to support the concurrent execution of multiple operating
systems poses several challenges. Firstly, virtual machines must be
isolated from one another: It is not acceptable for the execution of
one to adversely affect the performance of another. This is
particularly true when virtual machines are owned by mutually
untrusting users. Secondly, it is necessary to support a variety of
different operating systems to accommodate the heterogeneity of popular
applications. Thirdly, the performance overhead introduced by
virtualization should be small.

Xen uses a technique called paravirtualization: The guest OS is
modified, mainly to enhance performance.

The Xen hypervisor (microkernel) does not provide device drivers for
your hardware (except for CPU and memory). This job is left to the
kernel that's running in domain 0. Thus the domain 0 kernel is
privileged; it has full hardware access. It's started immediately after
Xen starts up. Other domains have no access to the hardware; instead
they use virtual interfaces that are provided by Xen (with the help of
the domain 0 kernel).

Xen does support booting other Operating Systems; ports of NetBSD
(Christian Limpach), FreeBSD (Kip Macy), and Plan 9 (Ron Minnich)
exist. A port of Windows XP was developed for an earlier version of
Xen, but is not available for release due to license restrictions.

In addition to this package you need to install kernel-xen and xen to
use Xen.



Authors:
--------
    Ian Pratt <ian.pratt@cl.cam.ac.uk>
%endif

%package tools-domU
Summary:        Xen Virtualization: Control tools for domain U
Group:          System/Kernel
Conflicts:      xen-tools

%description tools-domU
Xen is a virtual machine monitor for x86 that supports execution of
multiple guest operating systems with unprecedented levels of
performance and resource isolation.

This package contains tools that allow unprivileged domains to query
the virtualized environment.



Authors:
--------
    Ian Pratt <ian.pratt@cl.cam.ac.uk>

%package devel
Summary:        Xen Virtualization: Headers and libraries for development
Group:          System/Kernel
Requires:       xen-libs = %{version}

%description devel
Xen is a virtual machine monitor for x86 that supports execution of
multiple guest operating systems with unprecedented levels of
performance and resource isolation.

This package contains the libraries and header files needed to create
tools to control virtual machines.

Modern computers are sufficiently powerful to use virtualization to
present the illusion of many smaller virtual machines (VMs), each
running a separate operating system instance. Successful partitioning
of a machine to support the concurrent execution of multiple operating
systems poses several challenges. Firstly, virtual machines must be
isolated from one another: It is not acceptable for the execution of
one to adversely affect the performance of another. This is
particularly true when virtual machines are owned by mutually
untrusting users. Secondly, it is necessary to support a variety of
different operating systems to accommodate the heterogeneity of popular
applications. Thirdly, the performance overhead introduced by
virtualization should be small.

Xen uses a technique called paravirtualization: The guest OS is
modified, mainly to enhance performance.

The Xen hypervisor (microkernel) does not provide device drivers for
your hardware (except for CPU and memory). This job is left to the
kernel that's running in domain 0. Thus the domain 0 kernel is
privileged; it has full hardware access. It's started immediately after
Xen starts up. Other domains have no access to the hardware; instead
they use virtual interfaces that are provided by Xen (with the help of
the domain 0 kernel).

Xen does support booting other Operating Systems; ports of NetBSD
(Christian Limpach), FreeBSD (Kip Macy), and Plan 9 (Ron Minnich)
exist. A port of Windows XP was developed for an earlier version of
Xen, but is not available for release due to license restrictions.



Authors:
--------
    Ian Pratt <ian.pratt@cl.cam.ac.uk>

%if %{?with_kmp}0

%package KMP
Summary:        Xen para-virtual device drivers for fully virtualized guests
Group:          System/Kernel
Conflicts:      xen

%description KMP
Xen para-virtual device drivers for fully virtualized guests

Xen is a virtual machine monitor for x86 that supports execution of
multiple guest operating systems with unprecedented levels of
performance and resource isolation.

This package contains the libraries and header files needed to create
tools to control virtual machines.

Modern computers are sufficiently powerful to use virtualization to
present the illusion of many smaller virtual machines (VMs), each
running a separate operating system instance. Successful partitioning
of a machine to support the concurrent execution of multiple operating
systems poses several challenges. Firstly, virtual machines must be
isolated from one another: It is not acceptable for the execution of
one to adversely affect the performance of another. This is
particularly true when virtual machines are owned by mutually
untrusting users. Secondly, it is necessary to support a variety of
different operating systems to accommodate the heterogeneity of popular
applications. Thirdly, the performance overhead introduced by
virtualization should be small.

Xen uses a technique called paravirtualization: The guest OS is
modified, mainly to enhance performance.

The Xen hypervisor (microkernel) does not provide device drivers for
your hardware (except for CPU and memory). This job is left to the
kernel that's running in domain 0. Thus the domain 0 kernel is
privileged; it has full hardware access. It's started immediately after
Xen starts up. Other domains have no access to the hardware; instead
they use virtual interfaces that are provided by Xen (with the help of
the domain 0 kernel).

Xen does support booting other Operating Systems; ports of NetBSD
(Christian Limpach), FreeBSD (Kip Macy), and Plan 9 (Ron Minnich)
exist. A port of Windows XP was developed for an earlier version of
Xen, but is not available for release due to license restrictions.



%endif

%if %{?with_dom0_support}0

%package doc-html
Summary:        Xen Virtualization: HTML documentation
Group:          Documentation/HTML

%description doc-html
Xen is a virtual machine monitor for x86 that supports execution of
multiple guest operating systems with unprecedented levels of
performance and resource isolation.

xen-doc-html contains the online documentation in HTML format. Point
your browser at file:/usr/share/doc/packages/xen/html/



Authors:
--------
    Ian Pratt <ian.pratt@cl.cam.ac.uk>

%package doc-pdf
Summary:        Xen Virtualization: PDF documentation
Group:          Documentation/Other

%description doc-pdf
Xen is a virtual machine monitor for x86 that supports execution of
multiple guest operating systems with unprecedented levels of
performance and resource isolation.

xen-doc-pdf contains the online documentation in PDF format. Use
xpdf/kpdf/gpdf/gv/... to read the files in
/usr/share/doc/packages/xen/pdf/



Authors
--------
    Ian Pratt <ian.pratt@cl.cam.ac.uk>
%endif

%prep
%setup -q -n %xen_build_dir -a 1 -a 2 -a 3 -a 4 -a 5 -a 20000
tar xfj %{SOURCE6} -C $RPM_BUILD_DIR/%{xen_build_dir}/tools
# Upstream patches
%patch25861 -p1
%patch25862 -p1
%patch25863 -p1
%patch25864 -p1
%patch25866 -p1
%patch25867 -p1
%patch25874 -p1
%patch25909 -p1
%patch25920 -p1
%patch25921 -p1
%patch25922 -p1
%patch25957 -p1
%patch25958 -p1
%patch25959 -p1
%patch26077 -p1
%patch26078 -p1
%patch26079 -p1
%patch26081 -p1
%patch26082 -p1
%patch26083 -p1
%patch26084 -p1
%patch26085 -p1
%patch26086 -p1
%patch26087 -p1
%patch26114 -p1
%patch26129 -p1
%patch26133 -p1
%patch26189 -p1
%patch26262 -p1
%patch26324 -p1
%patch26325 -p1
%patch26326 -p1
%patch26327 -p1
%patch26328 -p1
%patch26329 -p1
%patch26330 -p1
%patch26331 -p1
%patch26341 -p1
%patch26342 -p1
%patch26343 -p1
%patch26344 -p1
%patch26369 -p1
%patch26370 -p1
%patch26372 -p1
%patch26404 -p1
%patch26418 -p1
%patch26532 -p1
%patch26547 -p1
%patch26548 -p1
%patch26549 -p1
%patch26550 -p1
%patch26551 -p1
%patch26554 -p1
%patch26555 -p1
%patch26556 -p1
%patch26576 -p1
%patch26577 -p1
%patch26675 -p1
%patch26754 -p1
%patch26878 -p1
%patch26879 -p1
%patch26880 -p1
%patch26881 -p1
%patch26882 -p1
%patch26902 -p1
%patch26953 -p1
%patch27179 -p1
%patch27184 -p1
%patch27249 -p1
%patch27353 -p1
%patch27405 -p1
%patch27406 -p1
%patch27407 -p1
%patch27408 -p1
%patch27431 -p1
%patch27511 -p1
%patch27512 -p1
%patch27515 -p1
%patch27519 -p1
%patch27549 -p1
%patch27582 -p1
%patch27583 -p1
%patch27586 -p1
%patch27611 -p1
%patch27612 -p1
%patch27691 -p1
%patch27692 -p1
%patch27694 -p1
%patch27756 -p1
%patch27764 -p1
%patch27870 -p1
%patch27925 -p1
%patch27963 -p1
%patch28103 -p1
%patch28112 -p1
%patch28131 -p1
%patch28229 -p1
%patch28235 -p1
%patch28297 -p1
%patch28302 -p1
%patch28304 -p1
%patch188 -p1
%patch189 -p1
%patch190 -p1
%patch191 -p1
%patch192 -p1
%patch193 -p1
%patch194 -p1
%patch195 -p1
# Qemu
%patch200 -p1
%patch201 -p1
%patch202 -p1
%patch203 -p1
%patch204 -p1
%patch205 -p1
%patch206 -p1
%patch207 -p1
%patch208 -p1
# Our patches
%patch301 -p1
%patch302 -p1
%patch304 -p1
%patch305 -p1
%patch306 -p1
%patch307 -p1
%patch310 -p1
%patch311 -p1
%patch312 -p1
%patch313 -p1
%patch314 -p1
%patch315 -p1
%patch322 -p1
%patch323 -p1
%patch324 -p1
%patch325 -p1
%patch327 -p1
%patch328 -p1
%patch329 -p1
%patch340 -p1
%patch341 -p1
%patch342 -p1
%patch343 -p1
%patch344 -p1
%patch345 -p1
%patch350 -p1
%patch351 -p1
%patch352 -p1
%patch353 -p1
%patch354 -p1
%patch355 -p1
%patch356 -p1
%patch357 -p1
%patch358 -p1
%patch359 -p1
%patch370 -p1
%patch371 -p1
%patch372 -p1
%patch373 -p1
%patch374 -p1
%patch375 -p1
%patch376 -p1
%patch377 -p1
%patch378 -p1
%patch379 -p1
%patch380 -p1
%patch381 -p1
%patch382 -p1
%patch410 -p1
%patch411 -p1
%patch412 -p1
%patch413 -p1
%patch414 -p1
%patch415 -p1
%patch420 -p1
%patch421 -p1
%patch423 -p1
%patch424 -p1
%patch425 -p1
%patch426 -p1
%patch427 -p1
%patch428 -p1
%patch429 -p1
%patch430 -p1
%patch431 -p1
%patch433 -p1
%patch434 -p1
%patch435 -p1
%patch436 -p1
%patch438 -p1
%patch439 -p1
%patch440 -p1
%patch442 -p1
%patch446 -p1
%patch447 -p1
%patch448 -p1
%patch449 -p1
%patch450 -p1
%patch451 -p1
%patch452 -p1
%patch453 -p1
%patch454 -p1
%patch456 -p1
%patch457 -p1
%patch458 -p1
%patch459 -p1
%patch460 -p1
%patch461 -p1
%patch462 -p1
%patch463 -p1
%patch464 -p1
%patch465 -p1
%patch466 -p1
%patch467 -p1
%patch480 -p1
%patch481 -p1
%patch500 -p1
%patch502 -p1
%patch503 -p1
%patch504 -p1
%patch505 -p1
%patch506 -p1
%patch507 -p1
%patch508 -p1
%patch511 -p1
%patch512 -p1
%patch513 -p1
%patch650 -p1
%patch651 -p1
%patch652 -p1
%patch700 -p1
%patch800 -p1
%patch801 -p1
%patch802 -p1
%patch900 -p1
%patch99998 -p1
%patch99999 -p1
# tools/qemu-xen-traditional-dir-remote/configure ./tools/qemu-xen-dir-remote/configure use
# clock_gettime to check whether -lrt is needed - and don't check other functions
# with glibc 2.17 clock_gettime is part of libc, so use timer_settime
sed -i -e 's/int main(void) { clockid_t id; return clock_gettime(id, NULL); }/int main(void) { struct itimerspec  v;timer_t t; return timer_gettime (t, \&v);}/' \
tools/qemu-xen-traditional-dir-remote/configure ./tools/qemu-xen-dir-remote/configure

%build
XEN_EXTRAVERSION=%version-%release
XEN_EXTRAVERSION=${XEN_EXTRAVERSION#%{xvers}}
sed -i "s/XEN_EXTRAVERSION[\t ]*.=.*\$/XEN_EXTRAVERSION  = $XEN_EXTRAVERSION/" xen/Makefile
sed -i "s/XEN_CHANGESET[\t ]*=.*\$/XEN_CHANGESET     = %{changeset}/" xen/Makefile
export EXTRA_CFLAGS_XEN_TOOLS="$RPM_OPT_FLAGS"
export EXTRA_CFLAGS_QEMU_TRADITIONAL="$RPM_OPT_FLAGS"
export EXTRA_CFLAGS_QEMU_XEN="$RPM_OPT_FLAGS"
./configure \
        --enable-xenapi \
        --prefix=/usr \
        --exec_prefix=/usr \
        --bindir=%{_bindir} \
        --sbindir=%{_sbindir} \
        --libdir=%{_libdir} \
        --datadir=%{_datadir}
%if %{?with_dom0_support}0
CFLAGS_SAVE=$CFLAGS
make -C xenalyze.hg CC="gcc -I../xen/include -DMAX_CPUS=%{max_cpus} ${RPM_OPT_FLAGS}" %{?_smp_mflags} -k
make -C tools/include/xen-foreign %{?_smp_mflags}
make tools docs %{?_smp_mflags}
make -C tools/debugger/gdbsx
make -C tools/xen-utils-0.1 XEN_INTREE_BUILD=yes XEN_ROOT=$PWD
%else
make -C tools/include/xen-foreign %{?_smp_mflags}
make tools docs %{?_smp_mflags}
%endif
%if %{?with_kmp}0
# pv driver modules
export XL=/usr/src/linux
export XEN=/usr/src/linux/include/xen
mkdir -p obj
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r unmodified_drivers/linux-2.6 obj/$flavor
    cd obj/$flavor
    ./mkbuildtree
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules \
	%{?_smp_mflags} \
        M=$PWD
    cd ../..
done
%endif

%install
export EXTRA_CFLAGS_XEN_TOOLS="$RPM_OPT_FLAGS"
export EXTRA_CFLAGS_QEMU_TRADITIONAL="$RPM_OPT_FLAGS"
export EXTRA_CFLAGS_QEMU_XEN="$RPM_OPT_FLAGS"
%if %{?with_dom0_support}0
# EFI
%ifarch x86_64
make -C xen install \
%if %{?with_gcc46}0
	CC=gcc-4.6 \
%endif
	max_phys_cpus=%{max_cpus} debug=n crash_debug=n DESTDIR=$RPM_BUILD_ROOT %{?_smp_mflags}
make -C xen clean
%endif
install_xen()
{
    local ext=""
    if [ -n "$1" ]; then
        ext="-$1"
        mv $RPM_BUILD_ROOT/boot/xen-%{version}-%{release}.gz \
           $RPM_BUILD_ROOT/boot/xen${ext}-%{version}-%{release}.gz
        mv $RPM_BUILD_ROOT/boot/xen-syms-%{version}-%{release} \
           $RPM_BUILD_ROOT/boot/xen-syms${ext}-%{version}-%{release}
    fi
    rm $RPM_BUILD_ROOT/boot/xen-%{xvers}.gz
    rm $RPM_BUILD_ROOT/boot/xen-%{xvermaj}.gz
    rm $RPM_BUILD_ROOT/boot/xen.gz
    # Do not link to links; grub cannot follow.
    ln -s xen${ext}-%{version}-%{release}.gz $RPM_BUILD_ROOT/boot/xen${ext}-%{xvers}.gz
    ln -s xen${ext}-%{version}-%{release}.gz $RPM_BUILD_ROOT/boot/xen${ext}-%{xvermaj}.gz
    ln -s xen${ext}-%{version}-%{release}.gz $RPM_BUILD_ROOT/boot/xen${ext}.gz
    ln -sf xen-syms${ext}-%{version}-%{release} $RPM_BUILD_ROOT/boot/xen-syms${ext}
}
make -C xen install max_phys_cpus=%{max_cpus} pae=%{pae_enabled} debug=y crash_debug=y DESTDIR=$RPM_BUILD_ROOT %{?_smp_mflags}
install_xen dbg
make -C xen clean
make -C xen install max_phys_cpus=%{max_cpus} pae=%{pae_enabled} debug=n crash_debug=n DESTDIR=$RPM_BUILD_ROOT %{?_smp_mflags}
install_xen
make -C xen clean
make -C tools/include/xen-foreign %{?_smp_mflags}
# tools
export XEN_PYTHON_NATIVE_INSTALL=1
make -C tools install \
    DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir} %{?_smp_mflags}
rm -f $RPM_BUILD_ROOT/usr/sbin/{qcow-create,img2qcow,qcow2raw}
make -C tools/misc/serial-split install \
    DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir} %{?_smp_mflags}
%ifarch x86_64
mkdir -p $RPM_BUILD_ROOT/${_libdir}/xen/bin/
ln -s /usr/lib/xen/bin/qemu-dm $RPM_BUILD_ROOT/%{_libdir}/xen/bin/qemu-dm
ln -s /usr/lib/xen/bin/qemu-system-i386 $RPM_BUILD_ROOT/%{_libdir}/xen/bin/qemu-system-i386
%endif
# efi depends on gcc46
echo > xen.files.txt
if test -d $RPM_BUILD_ROOT%{_libdir}/efi
then
	echo %{_libdir}/efi >> xen.files.txt
fi
cp -avL xenalyze.hg/dump-raw $RPM_BUILD_ROOT/%{_bindir}/xenalyze.dump-raw
cp -avL xenalyze.hg/xenalyze $RPM_BUILD_ROOT/%{_bindir}
%else
make -C tools install DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir} %{?_smp_mflags}
make -C tools/misc/serial-split install \
    DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir} %{?_smp_mflags}
%endif
# PV driver modules
%if %{?with_kmp}0
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
mkdir -p $RPM_BUILD_ROOT/etc/modprobe.d
for flavor in %flavors_to_build; do
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules_install \
        M=$PWD/obj/$flavor
    install -m644 %SOURCE27 $RPM_BUILD_ROOT/etc/modprobe.d/xen_pvdrivers-$flavor.conf
done
%endif
%if %{?with_dom0_support}0
# Stubdom
%if %{?with_stubdom}0
#remove -fstack-protector flag for stubdom build section
export EXTRA_CFLAGS_XEN_TOOLS=$(echo $RPM_OPT_FLAGS |sed -e 's/-fstack-protector//g')
export EXTRA_CFLAGS_QEMU_TRADITIONAL=$(echo $RPM_OPT_FLAGS |sed -e 's/-fstack-protector//g')
export EXTRA_CFLAGS_QEMU_XEN=$(echo $RPM_OPT_FLAGS |sed -e 's/-fstack-protector//g')
make stubdom %{?_smp_mflags}
make -C stubdom install \
    DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir} \
    DOCDIR=%{_defaultdocdir}/xen INCDIR=%{_includedir}
mkdir -p $RPM_BUILD_ROOT/%{_defaultdocdir}/xen
%ifarch x86_64
ln -s /usr/lib/xen/bin/stubdom-dm $RPM_BUILD_ROOT/usr/lib64/xen/bin/stubdom-dm
ln -s /usr/lib/xen/bin/stubdompath.sh $RPM_BUILD_ROOT/usr/lib64/xen/bin/stubdompath.sh
%endif
#restore -fstack-protector flag
export EXTRA_CFLAGS_XEN_TOOLS="$RPM_OPT_FLAGS"
export EXTRA_CFLAGS_QEMU_TRADITIONAL="$RPM_OPT_FLAGS"
export EXTRA_CFLAGS_QEMU_XEN="$RPM_OPT_FLAGS"
%endif
# Qemu
#make -C tools/qemu-xen-dir-remote install
# Docs
make -C docs install \
    DESTDIR=$RPM_BUILD_ROOT MANDIR=%{_mandir} \
    DOCDIR=%{_defaultdocdir}/xen
for name in COPYING %SOURCE10 %SOURCE11 %SOURCE12; do
    install -m 644 $name $RPM_BUILD_ROOT/%{_defaultdocdir}/xen/
done
mkdir -p $RPM_BUILD_ROOT/%{_defaultdocdir}/xen/misc
for name in vtpm.txt crashdb.txt sedf_scheduler_mini-HOWTO.txt xenpaging.txt; do
    install -m 644 docs/misc/$name $RPM_BUILD_ROOT/%{_defaultdocdir}/xen/misc/
done
%endif
# init scripts
%if %{?with_dom0_support}0
mkdir -p $RPM_BUILD_ROOT/etc/init.d
install %SOURCE13 $RPM_BUILD_ROOT/etc/init.d/xend
ln -s /etc/init.d/xend $RPM_BUILD_ROOT/usr/sbin/rcxend
install %SOURCE14 $RPM_BUILD_ROOT/etc/init.d/xendomains
ln -s /etc/init.d/xendomains $RPM_BUILD_ROOT/usr/sbin/rcxendomains
install %SOURCE34 $RPM_BUILD_ROOT/etc/init.d/pciback
ln -s /etc/init.d/pciback $RPM_BUILD_ROOT/usr/sbin/rcpciback
install %SOURCE35 $RPM_BUILD_ROOT/var/adm/fillup-templates/sysconfig.pciback
mkdir -p $RPM_BUILD_ROOT/etc/modprobe.d
install -m644 %SOURCE26 $RPM_BUILD_ROOT/etc/modprobe.d/xen_loop.conf
# example config
mkdir -p $RPM_BUILD_ROOT/etc/xen/{vm,examples,scripts}
mv $RPM_BUILD_ROOT/etc/xen/xmexample* $RPM_BUILD_ROOT/etc/xen/examples
mv $RPM_BUILD_ROOT/etc/xen/xlexample* $RPM_BUILD_ROOT/etc/xen/examples
rm -f $RPM_BUILD_ROOT/etc/xen/examples/*nbd
install -m644 %SOURCE17 %SOURCE18 $RPM_BUILD_ROOT/etc/xen/examples/
install -m644 tools/xentrace/formats $RPM_BUILD_ROOT/etc/xen/examples/xentrace_formats.txt
# scripts
rm -f $RPM_BUILD_ROOT/etc/xen/scripts/block-*nbd
install -m755 %SOURCE19 %SOURCE20 %SOURCE21 %SOURCE22 %SOURCE23 %SOURCE24 %SOURCE25 %SOURCE29 $RPM_BUILD_ROOT/etc/xen/scripts/
ln -s /etc/xen/scripts/vm-monitor $RPM_BUILD_ROOT/etc/xen/scripts/set-lock
# Xen API remote authentication files
install -d $RPM_BUILD_ROOT/etc/pam.d
install -m644 %SOURCE30 $RPM_BUILD_ROOT/etc/pam.d/xen-api
install -m644 %SOURCE31 $RPM_BUILD_ROOT/etc/xen/
# sysconfig hook for Xen
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig/network/scripts
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig/network/if-up.d
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig/network/if-down.d
install -m755 %SOURCE32 $RPM_BUILD_ROOT/etc/sysconfig/network/scripts
ln -s /etc/sysconfig/network/scripts/xen-updown.sh $RPM_BUILD_ROOT/etc/sysconfig/network/if-up.d/xen
ln -s /etc/sysconfig/network/scripts/xen-updown.sh $RPM_BUILD_ROOT/etc/sysconfig/network/if-down.d/xen
# logrotate
install -m644 -D %SOURCE15 $RPM_BUILD_ROOT/etc/logrotate.d/xen
# directories
mkdir -p $RPM_BUILD_ROOT/var/lib/xenstored
mkdir -p $RPM_BUILD_ROOT/var/lib/xen/images
mkdir -p $RPM_BUILD_ROOT/var/lib/xen/jobs
mkdir -p $RPM_BUILD_ROOT/var/lib/xen/save
mkdir -p $RPM_BUILD_ROOT/var/lib/xen/dump
mkdir -p $RPM_BUILD_ROOT/var/lib/xen/xend-db/domain
mkdir -p $RPM_BUILD_ROOT/var/lib/xen/xend-db/migrate
mkdir -p $RPM_BUILD_ROOT/var/lib/xen/xend-db/vnet
mkdir -p $RPM_BUILD_ROOT/var/log/xen
mkdir -p $RPM_BUILD_ROOT/var/log/xen/console
ln -s /var/lib/xen/images $RPM_BUILD_ROOT/etc/xen/images
# Bootloader
install -m755 %SOURCE16 $RPM_BUILD_ROOT/usr/lib/xen/boot/
install -m755 %SOURCE36 $RPM_BUILD_ROOT/%{_libdir}/python%{pyver}/site-packages
# udev support
mkdir -p $RPM_BUILD_ROOT/etc/udev/rules.d
mv $RPM_BUILD_ROOT/etc/udev/rules.d/xen-backend.rules $RPM_BUILD_ROOT/etc/udev/rules.d/40-xen.rules
mv $RPM_BUILD_ROOT/etc/udev/rules.d/xend.rules $RPM_BUILD_ROOT/etc/udev/rules.d/40-xend.rules
# xen utils
make -C tools/xen-utils-0.1 install DESTDIR=$RPM_BUILD_ROOT XEN_INTREE_BUILD=yes XEN_ROOT=$PWD
# Clean up unpackaged files
rm -rf $RPM_BUILD_ROOT/%{_datadir}/doc/xen/qemu/
rm -f  $RPM_BUILD_ROOT/%{_datadir}/doc/qemu/qemu-*
rm -f  $RPM_BUILD_ROOT/%{_datadir}/doc/packages/xen/html/hypercall/.deps
rm -rf $RPM_BUILD_ROOT/%{_defaultdocdir}/xen/ps
rm -rf $RPM_BUILD_ROOT/usr/share/xen/man/man1/qemu/qemu*
rm -f  $RPM_BUILD_ROOT/usr/share/xen/qemu/openbios-ppc
rm -f  $RPM_BUILD_ROOT/usr/share/xen/qemu/openbios-sparc32
rm -f  $RPM_BUILD_ROOT/usr/share/xen/qemu/openbios-sparc64
rm -f  $RPM_BUILD_ROOT/usr/share/qemu-xen/openbios-ppc
rm -f  $RPM_BUILD_ROOT/usr/share/qemu-xen/openbios-sparc32
rm -f  $RPM_BUILD_ROOT/usr/share/qemu-xen/openbios-sparc64
rm -f  $RPM_BUILD_ROOT/usr/share/qemu-xen/palcode-clipper
rm -f  $RPM_BUILD_ROOT/usr/sbin/netfix
rm -f  $RPM_BUILD_ROOT/%{_libdir}/python%{pyver}/site-packages/*.egg-info
rm -rf $RPM_BUILD_ROOT/html
rm -rf $RPM_BUILD_ROOT/usr/share/doc/xen/README.*
rm -f  $RPM_BUILD_ROOT/%{_libdir}/xen/bin/qemu-dm.debug
rm -f  $RPM_BUILD_ROOT/%{_bindir}/qemu-img-xen
rm -f  $RPM_BUILD_ROOT/%{_bindir}/qemu-nbd-xen
rm -rf $RPM_BUILD_ROOT/%{_libdir}/debug
rm -rf $RPM_BUILD_ROOT/usr/lib/debug
# Upstream Qemu
rm -rf  $RPM_BUILD_ROOT/usr/local/share/qemu
rm -rf  $RPM_BUILD_ROOT/usr/local/share/doc/qemu
rm -f  $RPM_BUILD_ROOT/usr/local/etc/qemu/target-x86_64.conf
rm -f  $RPM_BUILD_ROOT/usr/local/share/man/man1/qemu.1
rm -f  $RPM_BUILD_ROOT/usr/local/share/man/man1/qemu-img.1
rm -f  $RPM_BUILD_ROOT/usr/local/share/man/man8/qemu-nbd.8
rm -f  $RPM_BUILD_ROOT/usr/local/share/doc/qemu/qemu-doc.html
rm -f  $RPM_BUILD_ROOT/usr/local/share/doc/qemu/qemu-tech.html
#install firewall definitions format is described here:
#/usr/share/SuSEfirewall2/services/TEMPLATE
mkdir -p $RPM_BUILD_ROOT/%{_fwdefdir}
install -m 644 %{S:26} $RPM_BUILD_ROOT/%{_fwdefdir}/xend-relocation-server
# create symlinks for keymaps
%fdupes -s $RPM_BUILD_ROOT/%{_datadir}
%else
# 32 bit hypervisor no longer supported.  Remove dom0 tools.
rm -rf $RPM_BUILD_ROOT/%{_datadir}/doc
rm -rf $RPM_BUILD_ROOT/usr/local/share/doc
rm -rf $RPM_BUILD_ROOT/%{_datadir}/man
rm -rf $RPM_BUILD_ROOT/usr/local/share/man
rm -rf $RPM_BUILD_ROOT/%{_datadir}/qemu-xen
rm -rf $RPM_BUILD_ROOT/%{_datadir}/xen
rm -rf $RPM_BUILD_ROOT/%{_datadir}/locale
rm -rf $RPM_BUILD_ROOT/%{_libdir}/xen
rm -rf $RPM_BUILD_ROOT/%{_libdir}/python*
rm -rf $RPM_BUILD_ROOT/usr/sbin
rm -rf $RPM_BUILD_ROOT/etc/bash_completion.d
rm -rf $RPM_BUILD_ROOT/etc/init.d
rm -rf $RPM_BUILD_ROOT/etc/logrotate.d
rm -rf $RPM_BUILD_ROOT/etc/pam.d
rm -rf $RPM_BUILD_ROOT/etc/sysconfig
rm -rf $RPM_BUILD_ROOT/etc/udev
rm -rf $RPM_BUILD_ROOT/etc/qemu
rm -rf $RPM_BUILD_ROOT/etc/xen
rm -rf $RPM_BUILD_ROOT/usr/local/etc
rm -rf $RPM_BUILD_ROOT/var
rm -f $RPM_BUILD_ROOT/%{_bindir}/*store*
rm -f $RPM_BUILD_ROOT/%{_bindir}/*trace*
rm -f $RPM_BUILD_ROOT/%{_bindir}/xenalyze*
rm -f $RPM_BUILD_ROOT/%{_bindir}/qemu*
rm -f $RPM_BUILD_ROOT/%{_bindir}/pygrub
rm -f $RPM_BUILD_ROOT/%{_bindir}/remus
rm -f $RPM_BUILD_ROOT/%{_bindir}/tapdisk-ioemu
rm -f $RPM_BUILD_ROOT/%{_bindir}/xencons
%endif

%if %{?with_dom0_support}0

%files -f xen.files.txt
%defattr(-,root,root)
/boot/xen-%{version}-%{release}.gz
/boot/xen-%{xvermaj}.gz
/boot/xen-%{xvers}.gz
/boot/xen-dbg-%{version}-%{release}.gz
/boot/xen-dbg-%{xvermaj}.gz
/boot/xen-dbg-%{xvers}.gz
/boot/xen-dbg.gz
/boot/xen-syms
/boot/xen-syms-%{version}-%{release}
/boot/xen-syms-dbg
/boot/xen-syms-dbg-%{version}-%{release}
/boot/xen.gz
%endif

%files libs
%defattr(-,root,root)
%{_libdir}/fs/
%{_libdir}/*.so.*

%if %{?with_dom0_support}0

%files tools
%defattr(-,root,root)
/usr/bin/xenalyze
/usr/bin/xenalyze.dump-raw
/usr/bin/xencons
/usr/bin/xenstore*
/usr/bin/xentrace*
/usr/bin/pygrub
/usr/bin/tapdisk-ioemu
/usr/bin/remus
/usr/sbin/blktapctrl
/usr/sbin/flask-loadpolicy
/usr/sbin/flask-getenforce
/usr/sbin/flask-setenforce
/usr/sbin/flask-get-bool
/usr/sbin/flask-label-pci
/usr/sbin/flask-set-bool
/usr/sbin/rcxend
/usr/sbin/rcxendomains
/usr/sbin/rcpciback
/usr/sbin/tapdisk
/usr/sbin/xen*
/usr/sbin/xm
/usr/sbin/xsview
/usr/sbin/gtracestat
/usr/sbin/gtraceview
/usr/sbin/lock-util
/usr/sbin/tapdisk-client
/usr/sbin/tapdisk-diff
/usr/sbin/tapdisk-stream
/usr/sbin/tapdisk2
/usr/sbin/td-util
/usr/sbin/vhd-update
/usr/sbin/vhd-util
/usr/sbin/gdbsx
/usr/sbin/xl
/usr/sbin/kdd
/usr/sbin/tap-ctl
%{_libdir}/xen
%ifarch x86_64
/usr/lib/xen
%endif
%{_mandir}/man1/*.1.gz
%{_mandir}/man5/*.5.gz
%{_mandir}/man8/*.8.gz
/var/adm/fillup-templates/*
%dir /var/lib/xen
%dir %attr(700,root,root) /var/lib/xen/images
%dir %attr(700,root,root) /var/lib/xen/save
%dir %attr(700,root,root) /var/lib/xen/dump
%dir %attr(700,root,root) /var/lib/xen/xenpaging
%dir /var/lib/xen/xend-db
%dir /var/lib/xen/xend-db/domain
%dir /var/lib/xen/xend-db/migrate
%dir /var/lib/xen/xend-db/vnet
%dir /var/lib/xenstored
%dir /var/log/xen
%dir /var/log/xen/console
%config /etc/init.d/*
%config /etc/logrotate.d/xen
%dir %attr(700,root,root) /etc/xen
/etc/xen/auto
%config /etc/xen/examples
/etc/xen/images
/etc/xen/scripts
%config /etc/xen/cpupool
/etc/xen/README*
%config /etc/xen/vm
%config(noreplace) /etc/xen/*.sxp
%config(noreplace) /etc/xen/*.xml
%config(noreplace) /etc/xen/xenapiusers
%config(noreplace) /etc/xen/xl.conf
%config /etc/pam.d/xen-api
%config /etc/modprobe.d/xen_loop.conf
%dir /etc/modprobe.d
%dir /etc/udev
%dir /etc/udev/rules.d
/etc/udev/rules.d/40-xen.rules
/etc/udev/rules.d/40-xend.rules
/etc/sysconfig/network/scripts/xen-updown.sh
/etc/sysconfig/network/if-up.d/xen
/etc/sysconfig/network/if-down.d/xen
/etc/bash_completion.d/xl.sh
%dir %{_defaultdocdir}/xen
%{_defaultdocdir}/xen/COPYING
%{_defaultdocdir}/xen/README.SuSE
%{_defaultdocdir}/xen/boot.local.xenU
%{_defaultdocdir}/xen/boot.xen
%{_defaultdocdir}/xen/misc
%dir %{_libdir}/python%{pyver}/site-packages/xen
%dir %{_libdir}/python%{pyver}/site-packages/grub
%dir %{_datadir}/qemu-xen
%dir %{_datadir}/xen
%dir %{_datadir}/xen/man
%dir %{_datadir}/xen/man/man1
%dir %{_datadir}/xen/man/man8
%dir %{_datadir}/xen/qemu
%{_datadir}/qemu-xen/*
%{_datadir}/xen/*.dtd
%{_datadir}/xen/qemu/*
%{_datadir}/xen/man/man1/*
%{_datadir}/xen/man/man8/*
%{_libdir}/python%{pyver}/site-packages/xen/*
%{_libdir}/python%{pyver}/site-packages/grub/*
%{_libdir}/python%{pyver}/site-packages/fsimage.so
%{_libdir}/python%{pyver}/site-packages/xnloader.py
%config %{_fwdefdir}/xend-relocation-server
%endif

%files tools-domU
%defattr(-,root,root)
/usr/bin/xen-detect
/bin/domu-xenstore
/bin/xenstore-*

%files devel
%defattr(-,root,root)
%{_bindir}/serial-split
%{_libdir}/*.a
%{_libdir}/*.so
/usr/include/*

%if %{?with_dom0_support}0

%files doc-html
%defattr(-,root,root)
%{_defaultdocdir}/xen/html
#%{_datadir}/doc/qemu

%files doc-pdf
%defattr(-,root,root)
%{_defaultdocdir}/xen/pdf
%endif

%if %{?with_dom0_support}0

%post
if [ -x /sbin/update-bootloader ]; then
    /sbin/update-bootloader --refresh; exit 0
fi

%post tools
%if %{?with_xend}0
# with_xend
# enable both xm (xend based) and xl (libxl based)
if /bin/ls /etc/init.d/rc3.d/S??xend > /dev/null 2>&1 ; then
    if ! /bin/ls /etc/init.d/rc3.d/S??xencommons > /dev/null 2>&1 ; then
        echo "postin %{name}-tools: Forcing insserv xencommons during package upgrade because xend was enabled."
        echo "postin %{name}-tools: with xend"
    fi
    %{fillup_and_insserv -Y -n xencommons xencommons}
else
    %{fillup_and_insserv -y -n xencommons xencommons}
fi
%{fillup_and_insserv -y -n xend xend}
%else
# without_xend
# disable xm (xend based) and enable only xl (libxl based)
if /bin/ls /etc/init.d/rc3.d/S??xend > /dev/null 2>&1 ; then
    if ! /bin/ls /etc/init.d/rc3.d/S??xencommons > /dev/null 2>&1 ; then
        echo "postin %{name}-tools: Forcing insserv xencommons during package upgrade because xend was enabled."
    fi
    echo "postin %{name}-tools: disabling xend in favor of xencommons. xm command replaced by xl."
    %{stop_on_removal xend}
    rm -fv /etc/init.d/rc?.d/???xend || :
    %{fillup_and_insserv -Y -n xencommons xencommons}
else
    %{fillup_and_insserv -y -n xencommons xencommons}
fi
%endif
#
%{fillup_and_insserv -y -n xendomains xendomains}
%{fillup_only -n pciback}
if [ -f /usr/bin/qemu-img ]; then
    if [ -f /usr/bin/qemu-img-xen ]; then
        rm /usr/bin/qemu-img-xen
    fi
    ln -s /usr/bin/qemu-img /usr/bin/qemu-img-xen
fi
if [ -f /usr/bin/qemu-nbd ]; then
    if [ -f /usr/bin/qemu-nbd-xen ]; then
        rm /usr/bin/qemu-nbd-xen
    fi
    ln -s /usr/bin/qemu-nbd /usr/bin/qemu-nbd-xen
fi

%preun tools
%{stop_on_removal xendomains xend xencommons}

%postun tools
%if %{?with_xend}0
# with_xend
%{restart_on_update xend}
%endif
%{insserv_cleanup}
if [ -f /usr/bin/qemu-img-xen ]; then
    rm /usr/bin/qemu-img-xen
fi
if [ -f /usr/bin/qemu-nbd-xen ]; then
    rm /usr/bin/qemu-nbd-xen
fi
%endif

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%changelog
* Wed Feb 19 2014 carnold@suse.com
- Upstream patch from Jan
  27691-x86-percpu-Force-INVALID_PERCPU_AREA-into-the-non-canonical-address-region.patch
  28304-x86-don-t-drop-guest-visible-state-updates-when-64-bit-PV-guest-is-in-user-mode.patch
* Tue Feb 18 2014 carnold@suse.com
- Update to Xen version 4.2.4 c/s 26280
  xen-4.2.4-testing-src.tar.bz2
  qemu-xen-traditional-dir-remote.tar.bz2
  qemu-xen-dir-remote.tar.bz2
- bnc#861256 - VUL-0: xen: XSA-88: use-after-free in xc_cpupool_getinfo()
  under memory pressure. (fix included with update)
- Dropped 45 patches now found in the tarballs.
* Tue Feb 11 2014 ohering@suse.de
- bnc#863297: xend/pvscsi: recognize also SCSI CDROM devices
  xend-pvscsi-recognize-also-SCSI-CDROM-devices.patch
* Wed Jan 29 2014 carnold@suse.com
- bnc#858496 - Xen: XSA-83: Out-of-memory condition yielding memory
  corruption during IRQ setup
  28305-x86-irq-avoid-use-after-free-on-error-path-in-pirq_guest_bind.patch (Replaces xsa83.patch)
- bnc#860163 - VUL-0: xen: XSA-84: integer overflow in several
  XSM/Flask hypercalls
  xsa84.patch
- bnc#860165 - VUL-0: xen: XSA-85: Off-by-one error in
  FLASK_AVC_CACHESTAT hypercall
  xsa85.patch
- bnc#860300 - VUL-1: xen: XSA-86: libvchan failure handling
  malicious ring indexes
  xsa86.patch
- bnc#860302 - VUL-0: CVE-2014-1666: xen: XSA-87:
  PHYSDEVOP_{prepare,release}_msix exposed to unprivileged guests
  28307-x86-PHYSDEVOP-prepare-release-msix-are-privileged.patch
- Upstream patches from Jan
  28296-mce-fix-race-condition-in-mctelem_xchg_head.patch
  28297-nested-EPT-fixing-wrong-handling-for-L2-guest-s-direct-mmio-access.patch
  28299-common-sysctl-Don-t-leak-status-in-SYSCTL_page_offline_op.patch
  28302-Nested-VMX-prohibit-virtual-vmentry-vmexit-during-IO-emulation.patch
* Fri Jan 10 2014 carnold@suse.com
- bnc#858311 - L3: Server is not booting in kernel XEN after latest
  updates - (XEN) setup 0000:00:18.0 for d0 failed (-19)
  28068-x86-properly-handle-MSI-X-unmask-operation-from-guests.patch
* Fri Jan 10 2014 carnold@suse.com
- bnc#858496 - Xen: XSA-83: Out-of-memory condition yielding memory
  corruption during IRQ setup
  xsa83.patch
- Upstream patches from Jan
  28201-x86-mm-Prevent-leaking-domain-mappings-in-paging_log_dirty_op.patch
  28229-Nested-VMX-Setup-the-virtual-NMI-exiting-info.patch
  28235-VMX-apicv-Set-NMI-window-exiting-for-NMI.patch
  28248-VTD-DMAR-free-correct-pointer-on-error-from-acpi_parse_one_atsr.patch
  28249-AMD-IOMMU-fix-infinite-loop-due-to-ivrs_bdf_entries-larger-than-16-bit-value.patch
  28272-hvm_save_one-return-correct-data.patch
* Mon Dec 16 2013 carnold@suse.com
- bnc#853049 - VUL-0: CVE-2013-6885: xen: XSA-82: Guest triggerable
  AMD CPU erratum may cause host hang
  28102-x86-AMD-work-around-erratum-793.patch
- bnc#853048 - VUL-0: CVE-2013-6400: xen: XSA-80: IOMMU TLB
  flushing may be inadvertently suppressed
  28164-IOMMU-clear-don-t-flush-override-on-error-paths.patch
- bnc#831120 - VUL-0: CVE-2013-2212: xen: XSA-60: Excessive time to
  disable caching with HVM guests with PCI passthrough
  27852-VMX-disable-EPT-when-cpu_has_vmx_pat.patch
  27853-VMX-remove-the-problematic-set_uc_mode-logic.patch
  27854-VMX-fix-cr0.cd-handling.patch
- bnc#848014 - [HP HPS] Xen hypervisor panics on 8-blades nPar with
  46-bit memory addressing
  27829-x86-ACPI-x2APIC-guard-against-out-of-range-ACPI-or-APIC-IDs.patch
  27965-x86-consider-modules-when-cutting-off-memory.patch
- bnc#833251 - [HP BCS SLES11 Bug]: In HP’s UEFI x86_64 platform
  and with xen environment, in booting stage ,xen hypervisor will
  panic.
  28167-x86-cpuidle-publish-new-states-only-after-fully-initializing-them.patch
- Upstream patches from Jan
  27961-credit-Update-other-parameters-when-setting-tslice_ms.patch
  27962-fix-leaking-of-v-cpu_affinity_saved-on-domain-destruction.patch
  27963-nested-VMX-don-t-ignore-mapping-errors.patch
  28022-x86-hvm-reset-TSC-to-0-after-domain-resume-from-S3.patch
  28023-x86-crash-disable-the-watchdog-NMIs-on-the-crashing-cpu.patch
  28041-x86-xsave-fix-nonlazy-state-handling.patch
  28057-x86-hvm-fix-segment-validation.patch
  28065-x86-restrict-XEN_DOMCTL_getmemlist.patch (Replaces CVE-2013-4553-xsa74.patch)
  28066-x86-HVM-only-allow-ring-0-guest-code-to-make-hypercalls.patch (Replaces CVE-2013-4554-xsa76.patch)
  28068-x86-properly-handle-MSI-X-unmask-operation-from-guests.patch
  28092-Fix-ptr-calculation-when-converting-from-a-VA.patch
  28103-nested-vmx-fix-I-O-port-bitmap-indexing-arithmetic.patch
  28108-fix-locking-in-offline_page.patch
  28112-nested-VMX-fix-I-O-port-exit-emulation.patch
  28113-x86-fix-early-boot-command-line-parsing.patch
  28131-Nested-VMX-CR-emulation-fix-up.patch
  28133-x86-boot-fix-BIOS-memory-corruption-on-certain-IBM-systems.patch
  28144-defer-the-domain-mapping-in-scrub_one_page.patch
  28168-x86-PV-don-t-commit-debug-register-values-early-in-arch_set_info_guest.patch
  28169-kexec-x86-do-not-map-crash-kernel-area.patch
  28183-x86-p2m-restrict-auditing-to-debug-builds.patch
* Tue Dec 10 2013 carnold@suse.com
- pygrub: Support (/dev/xvda) style disk specifications
  27756-pygrub-xvda-style-disk.patch
* Tue Nov 19 2013 carnold@suse.com
- bnc#849667 - VUL-0: xen: XSA-74: Lock order reversal between
  page_alloc_lock and mm_rwlock
  CVE-2013-4553-xsa74.patch
- bnc#849668 - VUL-0: xen: XSA-76: Hypercalls exposed to privilege
  rings 1 and 2 of HVM guests
  CVE-2013-4554-xsa76.patch
- Fix for XSA-78
  27964-TLB-flushing-in-dma_pte_clear_one.patch
* Wed Nov 13 2013 carnold@suse.com
- bnc#842417 - In HP’s UEFI x86_64 platform and sles11sp3 with xen
  environment, dom0 will soft lockup on multiple blades nPar.
  27870-x86-idle-reduce-contention-on-ACPI-register-accesses.patch
- bnc#848014 - [HP HPS] Xen hypervisor panics on 8-blades nPar with
  46-bit memory addressing
  27926-VMX-don-t-crash-processing-d-debug-key.patch
- bnc#846849 - L3: Soft lockup with PCI passthrough and many VCPUs
  27926-VMX-don-t-crash-processing-d-debug-key.patch
- bnc#833483 - Boot Failure with xen kernel in UEFI mode with error
  "No memory for trampoline"
  27864-x86-EFI-make-trampoline-allocation-more-flexible.patch
  (Replaces x86-EFI-trampoline-fallback.patch)
- Upstream patches from Jan
  27736-scheduler-adjust-internal-locking-interface.patch
  27737-sched-fix-race-between-sched_move_domain-and-vcpu_wake.patch
  27759-credit-unpause-parked-vcpu-before-destroying-it.patch
  27764-x86-print-relevant-tail-part-of-filename-for-warnings-and-crashes.patch
  27766-x86-xsave-also-save-restore-XCR0-across-suspend-ACPI-S3.patch
  27785-x86-refine-address-validity-checks-before-accessing-page-tables.patch
  27792-fix-locking-in-cpu_disable_scheduler.patch
  27848-x86-HVM-32-bit-IN-result-must-be-zero-extended-to-64-bits.patch
  27925-nested-SVM-adjust-guest-handling-of-structure-mappings.patch
  27928-x86-eliminate-has_arch_mmios.patch
* Mon Nov 11 2013 carnold@suse.com
- bnc#849665 - VUL-0: CVE-2013-4551: xen: XSA-75: Host crash due to
  guest VMX instruction execution
  27868-nested-VMX-VMLANUCH-VMRESUME-emulation-must-check-permission-1st.patch
* Fri Nov  8 2013 carnold@suse.com
- The upstream version of checking for xend when using the 'xl'
  command is used is not working.
  disable-xl-when-using-xend-fix.patch
* Wed Nov  6 2013 carnold@suse.com
- bnc#840997 - It is possible to start a VM twice on the same node.
  xend-xm-reboot-fix.patch
* Mon Nov  4 2013 carnold@suse.com
- bnc#848657 - VUL-0: xen: CVE-2013-4494: XSA-73: Lock order
  reversal between page allocation and grant table locks
  27828-gnttab-correct-locking-order-reversal.patch
* Mon Oct 14 2013 carnold@suse.com
- bnc#845520 - VUL-0: CVE-2013-4416: xen: ocaml xenstored
  mishandles oversized message replies
  CVE-2013-4416-xsa72.patch
- bnc#833483 - Boot Failure with xen kernel in UEFI mode with error
  "No memory for trampoline"
  x86-EFI-trampoline-fallback.patch
- Upstream patches from Jan
  27678-x86-properly-handle-hvm_copy_from_guest_-phys-virt-errors.patch (Replaces CVE-2013-4355-xsa63.patch)
  27680-x86-properly-set-up-fbld-emulation-operand-address.patch (Replaces CVE-2013-4361-xsa66.patch)
  27690-x86-idle-Fix-get_cpu_idle_time-s-interaction-with-offline-pcpus.patch
  27691-x86-percpu-Force-INVALID_PERCPU_AREA-to-non-canonical.patch
  27692-Nested-VMX-check-VMX-capability-before-read-VMX-related-MSRs.patch
  27694-Nested-VMX-fix-IA32_VMX_CR4_FIXED1-msr-emulation.patch
  27696-xsm-forbid-PV-guest-console-reads.patch
  27724-x86-check-segment-descriptor-read-result-in-64-bit-OUTS-emulation.patch (Replaces CVE-2013-4368-xsa67.patch)
  27725-libxl-fix-vif-rate-parsing.patch (Replaces CVE-2013-4369-xsa68.patch)
  27726-tools-ocaml-fix-erroneous-free-of-cpumap-in-stub_xc_vcpu_getaffinity.patch (Replaces CVE-2013-4370-xsa69.patch)
  27727-libxl-fix-out-of-memory-error-handling-in-libxl_list_cpupool.patch (Replaces CVE-2013-4371-xsa70.patch)
  27728-x86-correct-LDT-checks.patch
  27729-x86-add-address-validity-check-to-guest_map_l1e.patch
  27731-x86-check-for-canonical-address-before-doing-page-walks.patch
* Wed Oct  2 2013 jfehlig@suse.com
- Improvements to block-dmmd script
  bnc#828623
* Wed Oct  2 2013 carnold@suse.com
- bnc#840196 - L3: MTU size on Dom0 gets reset when booting DomU
  with e1000 device
  0001-net-move-the-tap-buffer-into-TAPState.patch
  0002-net-increase-tap-buffer-size.patch
  0003-e1000-fix-access-4-bytes-beyond-buffer-end.patch
  0004-e1000-secrc-support.patch
  0005-e1000-multi-buffer-packet-support.patch
  0006-e1000-clear-EOP-for-multi-buffer-descriptors.patch
  0007-e1000-verify-we-have-buffers-upfront.patch
  0008-e1000-check-buffer-availability.patch
* Tue Oct  1 2013 carnold@suse.com
- bnc#840196 - L3: MTU size on Dom0 gets reset when booting DomU
  with e1000 device
  27549-set-mtu-from-bridge-for-tap-interface.patch
  qemu-ifup-set-mtu.patch
* Mon Sep 30 2013 carnold@suse.com
- bnc#840592 - VUL-0: CVE-2013-4355: XSA-63: xen: Information leaks
  through I/O instruction emulation
  CVE-2013-4355-xsa63.patch
- bnc#841766 - VUL-1: CVE-2013-4361: XSA-66: xen: Information leak
  through fbld instruction emulation
  CVE-2013-4361-xsa66.patch
- bnc#842511 - VUL-0: CVE-2013-4368: XSA-67: xen: Information leak
  through outs instruction emulation
  CVE-2013-4368-xsa67.patch
- bnc#842512 - VUL-1: CVE-2013-4369: XSA-68: xen: possible null
  dereference when parsing vif ratelimiting info
  CVE-2013-4369-xsa68.patch
- bnc#842513 - VUL-0: CVE-2013-4370: XSA-69: xen: misplaced free in
  ocaml xc_vcpu_getaffinity stub
  CVE-2013-4370-xsa69.patch
- bnc#842514 - VUL-0: CVE-2013-4371: XSA-70: xen: use-after-free in
  libxl_list_cpupool under memory pressure
  CVE-2013-4371-xsa70.patch
- bnc#842515 - VUL-0: CVE-2013-4375: XSA-71: xen: qemu disk backend
  (qdisk) resource leak
  CVE-2013-4375-xsa71.patch
- Upstream patches from Jan
  27511-x86-fix-memory-cut-off-when-using-PFN-compression.patch (Replaces x86-memory-cut-off.patch)
  27512-libxc-x86-fix-page-table-creation-for-huge-guests.patch
  27515-cpufreq-missing-check-of-copy_from_guest.patch
  27519-x86-machine_restart-must-not-call-acpi_dmar_reinstate-twice.patch
  27582-x86-HVM-fix-failure-path-in-hvm_vcpu_initialise.patch
  27583-VMX-fix-failure-path-in-construct_vmcs.patch
  27586-x86-HVM-properly-handle-wide-MMIO.patch
  27611-x86-HVM-linear-address-must-be-canonical-for-the-whole-accessed-range.patch
  27612-x86-HVM-refuse-doing-string-operations-in-certain-situations.patch
  27615-x86-xsave-initialize-extended-register-state-when-guests-enable-it.patch (Replaces CVE-2013-1442-xsa62.patch)
* Wed Sep 11 2013 carnold@suse.com
- bnc#839596 - VUL-0: CVE-2013-1442: XSA-62: xen: Information leak
  on AVX and/or LWP capable CPUs
  CVE-2013-1442-xsa62.patch
- bnc#833251 - [HP BCS SLES11 Bug]: In HP’s UEFI x86_64 platform
  and with xen environment, in booting stage ,xen hypervisor will
  panic.
  27479-x86-EFI-properly-handle-run-time-memory-regions-outside-the-1-1-map.patch
- bnc#833796 - L3: Xen: migration broken from xsave-capable to
  xsave-incapable host
  27461-x86-xsave-initialization-improvements.patch
  27483-x86-xsave-fix-migration-from-xsave-capable-to-xsave-incapable-host.patch
- bnc#834751 - [HP BCS SLES11 Bug]: In xen, “shutdown –y 0 –h”
  cannot power off system
  27479-x86-EFI-properly-handle-run-time-memory-regions-outside-the-1-1-map.patch
- bnc#839600 - [HP BCS SLES11 Bug]: In HP’s UEFI x86_64 platform and
  sles11sp3 with xen environment, xen hypervisor will panic on
  multiple blades nPar.
  x86-memory-cut-off.patch
- Upstream patches from Jan
  27430-x86-don-t-allow-Dom0-access-to-the-MSI-address-range.patch
  27431-x86-don-t-allow-Dom0-access-to-the-HT-address-range.patch
  27452-x86-AVX-instruction-emulation-fixes.patch
  27467-xend-handle-extended-PCI-configuration-space-when-saving-state.patch
  27468-xend-fix-file-descriptor-leak-in-pci-utilities.patch
  27480-x86-allow-guest-to-set-clear-MSI-X-mask-bit-try-2.patch
* Tue Sep 10 2013 carnold@suse.com
- Update to Xen 4.2.3 c/s 26170
  Dropped 78 patches now contained in the tarball
* Wed Aug 28 2013 carnold@suse.com
- bnc#833251 - [HP BCS SLES11 Bug]: In HP’s UEFI x86_64 platform
  and with xen environment, in booting stage ,xen hypervisor will
  panic.
  27397-ACPI-fix-acpi_os_map_memory.patch
- bnc#835896 - vcpus not started after upgrading Dom0 from 11SP2 to
  SP3
  27127-x86-HVM-fix-x2APIC-APIC_ID-read-emulation.patch (upstream c/s 27409)
- Upstream patches from Jan
  26534-x86-explicit-suffix-in-inline-assembler-for-clang.patch
  27249-VMX-fix-interaction-of-APIC-V-and-Viridian-emulation.patch
  27322-Nested-VMX-Flush-TLBs-and-Caches-if-paging-mode-changed.patch
  27348-x86-AMD-Fix-nested-svm-crash-due-to-assertion-in-__virt_to_maddr.patch
  27349-x86-AMD-Inject-GP-instead-of-UD-when-unable-to-map-vmcb.patch
  27353-VMX-add-boot-parameter-to-enable-disable-APIC-v-dynamically.patch
  27354-VT-d-protect-against-bogus-information-coming-from-BIOS.patch
  27356-x86-MTRR-fix-range-check-in-mtrr_add_page.patch
  27357-x86-time-fix-check-for-negative-time-in-__update_vcpu_system_time.patch
  27404-VT-d-warn-about-CFI-being-enabled-by-firmware.patch
  27405-Nested-VMX-Check-whether-interrupt-is-blocked-by-TPR.patch
  27406-Nested-VMX-Force-check-ISR-when-L2-is-running.patch
  27407-Nested-VMX-Clear-APIC-v-control-bit-in-vmcs02.patch
  27408-Nested-VMX-Update-APIC-v-RVI-SVI-when-vmexit-to-L1.patch
* Mon Aug 26 2013 carnold@suse.com
- bnc#836239 - SLES 11 SP3 Xen security patch does not
  automatically update UEFI boot binary
  xen.spec
* Thu Aug  8 2013 carnold@suse.com
- bnc#824676 - L3: Failed to setup devices for vm instance when
  start multiple vms simultaneously
  blktap-close-fifos.patch
* Wed Aug  7 2013 carnold@suse.com
- bnc#817799 - sles9sp4 guest fails to start after upgrading to
  sles11 sp3
  27230-Revert-hvmloader-always-include-HPET-table.patch
- Upstream patches from Jan
  27197-AMD-intremap-Prevent-use-of-per-device-vector-maps.patch
  27204-libxl-suppress-device-assignment-to-HVM-guest-without-IOMMU.patch
  27212-x86-don-t-pass-negative-time-to-gtime_to_gtsc-try-2.patch
  27213-iommu-amd-Fix-logic-for-clearing-the-IOMMU-interrupt-bits.patch
  27214-iommu-amd-Workaround-for-erratum-787.patch
  27221-x86-mm-Ensure-useful-progress-in-alloc_l2_table.patch
  27231-adjust-x86-EFI-build.patch
  27248-x86-cpuidle-Change-logging-for-unknown-APIC-IDs.patch
  27263-x86-time-Update-wallclock-in-shared-info-when-altering-domain-time-offset.patch
  27321-x86-refine-FPU-selector-handling-code-for-XSAVEOPT.patch
* Thu Jun 27 2013 carnold@suse.com
- bnc#826882 - VUL-0: xen: CVE-2013-1432: XSA-58: Page reference
  counting error due to XSA-45/CVE-2013-1918 fixes
  27181-x86-fix-page-refcount-handling-in-page-table-pin-error-path.patch
* Wed Jun 26 2013 jfehlig@suse.com
- Add upstream patch to fix devid assignment in libxl
  27184-libxl-devid-fix.patch
* Thu Jun  6 2013 carnold@suse.com
- bnc#823608 - VUL-0: xen: XSA-57: libxl allows guest write access to
  sensitive console related xenstore keys
  27178-libxl-Restrict-permissions-on-PV-console-device-xenstore-nodes.patch
- bnc#823011 - VUL-0: xen: XSA-55: Multiple vulnerabilities in
  libelf PV kernel handling
  27141-libelf-abolish-libelf-relocate.c.patch
  27142-libxc-introduce-xc_dom_seg_to_ptr_pages.patch
  27143-libxc-Fix-range-checking-in-xc_dom_pfn_to_ptr-etc.patch
  27144-libelf-add-struct-elf_binary-parameter-to-elf_load_i.patch
  27145-libelf-abolish-elf_sval-and-elf_access_signed.patch
  27146-libelf-move-include-of-asm-guest_access.h-to-top-of-.patch
  27147-libelf-xc_dom_load_elf_symtab-Do-not-use-syms-uninit.patch
  27148-libelf-introduce-macros-for-memory-access-and-pointe.patch
  27149-tools-xcutils-readnotes-adjust-print_l1_mfn_valid_no.patch
  27150-libelf-check-nul-terminated-strings-properly.patch
  27151-libelf-check-all-pointer-accesses.patch
  27152-libelf-Check-pointer-references-in-elf_is_elfbinary.patch
  27153-libelf-Make-all-callers-call-elf_check_broken.patch
  27154-libelf-use-C99-bool-for-booleans.patch
  27155-libelf-use-only-unsigned-integers.patch
  27156-libelf-check-loops-for-running-away.patch
  27157-libelf-abolish-obsolete-macros.patch
  27158-libxc-Add-range-checking-to-xc_dom_binloader.patch
  27159-libxc-check-failure-of-xc_dom_-_to_ptr-xc_map_foreig.patch
  27160-libxc-check-return-values-from-malloc.patch
  27161-libxc-range-checks-in-xc_dom_p2m_host-and-_guest.patch
  27162-libxc-check-blob-size-before-proceeding-in-xc_dom_ch.patch
  27163-libxc-Better-range-check-in-xc_dom_alloc_segment.patch
- bnc#808269 - Fully Virtualized Windows VM install is failed on
  Ivy Bridge platforms with Xen kernel
  26878-VMX-Detect-posted-interrupt-capability.patch
  26879-VMX-Turn-on-posted-interrupt-bit-in-vmcs.patch
  26880-VMX-Add-posted-interrupt-supporting.patch
  26881-x86-HVM-Call-vlapic_set_irq-to-delivery-virtual-interrupt.patch
  26882-VMX-Use-posted-interrupt-to-deliver-virtual-interrupt.patch
  x86-VMX-Viridian-vINTR.patch
- Upstream patches from Jan
  27093-libxc-limit-cpu-values-when-setting-vcpu-affinity.patch (Replaces CVE-2013-2072-xsa56.patch)
  27112-x86-fix-ordering-of-operations-in-destroy_irq.patch
  27117-x86-MCE-disable-if-MCE-banks-are-not-present.patch
  27118-x86-xsave-fix-information-leak-on-AMD-CPUs.patch (Replaces CVE-2013-2076-xsa52.patch)
  27119-x86-xsave-recover-from-faults-on-XRSTOR.patch (Replaces CVE-2013-2077-xsa53.patch)
  27120-x86-xsave-properly-check-guest-input-to-XSETBV.patch (Replaces CVE-2013-2078-xsa54.patch)
  27121-x86-preserve-FPU-selectors-for-32-bit-guest-code.patch
  27122-x86-fix-XCR0-handling.patch
  27123-x86-vtsc-update-vcpu_time-in-hvm_set_guest_time.patch
- Dropped 27083-AMD-iommu-SR56x0-Erratum-64-Reset-all-head-tail-pointers.patch
* Fri May 31 2013 carnold@suse.com
- bnc#801663 - performance of mirror lvm unsuitable for production
  block-dmmd
* Fri May 24 2013 carnold@suse.com
- bnc#817904 - [SLES11SP3 BCS Bug] Crashkernel fails to boot after
  panic on XEN kernel SP3 Beta 4 and RC1
  27085-x86-fix-boot-time-APIC-mode-detection.patch
- Upstream AMD Erratum patch from Jan
  27083-AMD-iommu-SR56x0-Erratum-64-Reset-all-head-tail-pointers.patch
* Tue May 21 2013 carnold@suse.com
- bnc#813675 - - VUL-0: xen: CVE-2013-1919: XSA-46: Several access
  permission issues with IRQs for unprivileged guests
  27079-fix-XSA-46-regression-with-xend-xm.patch
* Fri May 17 2013 carnold@suse.com
- bnc#820917 - VUL-1: CVE-2013-2076: xen: Information leak on
  XSAVE/XRSTOR capable AMD CPUs (XSA-52)
  CVE-2013-2076-xsa52.patch
- bnc#820919 - VUL-0: CVE-2013-2077: xen: Hypervisor crash due to
  missing exception recovery on XRSTOR (XSA-53)
  CVE-2013-2077-xsa53.patch
- bnc#820920 - VUL-1: CVE-2013-2078: xen: Hypervisor crash due to
  missing exception recovery on XSETBV (XSA-54)
  CVE-2013-2078-xsa54.patch
- bnc#808085 - aacraid driver panics mapping INT A when booting
  kernel-xen
  26953-x86-allow-Dom0-read-only-access-to-IO-APICs.patch
- bnc#817210 - openSUSE 12.3 Domain 0 doesn't boot with i915
  graphics controller under Xen with VT-d enabled
  27071-x86-IO-APIC-fix-guest-RTE-write-corner-cases.patch
- Upstream patches from Jan
  26860-x86-allow-VCPUOP_register_vcpu_info-to-work-again-on-PVHVM-guests.patch
  26910-ns16550-delay-resume-until-dom0-ACPI-has-a-chance-to-run.patch
  26946-x86-make-vcpu_destroy_pagetables-preemptible.patch (Replaces CVE-2013-1918-xsa45*.patch)
  26947-x86-make-new_guest_cr3-preemptible.patch (Replaces CVE-2013-1918-xsa45*.patch)
  26948-x86-make-MMUEXT_NEW_USER_BASEPTR-preemptible.patch (Replaces CVE-2013-1918-xsa45*.patch)
  26949-x86-make-vcpu_reset-preemptible.patch (Replaces CVE-2013-1918-xsa45*.patch)
  26950-x86-make-arch_set_info_guest-preemptible.patch (Replaces CVE-2013-1918-xsa45*.patch)
  26951-x86-make-page-table-unpinning-preemptible.patch (Replaces CVE-2013-1918-xsa45*.patch)
  26952-x86-make-page-table-handling-error-paths-preemptible.patch (Replaces CVE-2013-1918-xsa45*.patch)
  26956-x86-mm-preemptible-cleanup.patch (Replaces CVE-2013-1918-xsa45*.patch)
  26958-VT-d-don-t-permit-SVT_NO_VERIFY-entries-for-known-device-types.patch (Replaces CVE-2013-1952-xsa49.patch)
  26966-x86-handle-paged-gfn-in-wrmsr_hypervisor_regs.patch
  27072-x86-shadow-fix-off-by-one-in-MMIO-permission-check.patch
  27074-x86-hvm-avoid-p2m-lookups-for-vlapic-accesses.patch
* Tue May 14 2013 carnold@suse.com
- bnc#819416 - VUL-0: xen: CVE-2013-2072: XSA-56: Buffer overflow
  in xencontrol Python bindings affecting xend
  CVE-2013-2072-xsa56.patch
* Tue May  7 2013 carnold@suse.com
- bnc#818183 - VUL-0: xen: CVE-2013-2007: XSA-51: qga set umask
  0077 when daemonizing
  CVE-2013-2007-xsa51-1.patch
  CVE-2013-2007-xsa51-2.patch
* Mon May  6 2013 ohering@suse.de
- add lndir to BuildRequires
* Mon May  6 2013 ohering@suse.de
- remove xen.migrate.tools_notify_restore_to_hangup_during_migration_--abort_if_busy.patch
  It changed migration protocol and upstream wants a different solution
* Sun May  5 2013 ohering@suse.de
- bnc#802221 - fix xenpaging
  readd xenpaging.qemu.flush-cache.patch
* Thu May  2 2013 carnold@suse.com
- bnc#808269 - Fully Virtualized Windows VM install is failed on
  Ivy Bridge platforms with Xen kernel
  26754-hvm-Improve-APIC-INIT-SIPI-emulation.patch
* Tue Apr 30 2013 carnold@suse.com
- Upstream patches from Jan
  26891-x86-S3-Fix-cpu-pool-scheduling-after-suspend-resume.patch
  26930-x86-EFI-fix-runtime-call-status-for-compat-mode-Dom0.patch
- Additional fix for bnc#816159
  CVE-2013-1918-xsa45-followup.patch
* Mon Apr 29 2013 cyliu@suse.com
- bnc#817068 - Xen guest with >1 sr-iov vf won't start
  xen-managed-pci-device.patch
* Mon Apr 29 2013 carnold@suse.com
- Update to Xen 4.2.2 c/s 26064
  The following recent security patches are included in the tarball
  CVE-2013-0151-xsa34.patch (bnc#797285)
  CVE-2012-6075-xsa41.patch (bnc#797523)
  CVE-2013-1917-xsa44.patch (bnc#813673)
  CVE-2013-1919-xsa46.patch (bnc#813675)
* Wed Apr 24 2013 carnold@suse.com
- Upstream patch from Jan
  26902-x86-EFI-pass-boot-services-variable-info-to-runtime-code.patch
* Fri Apr 19 2013 carnold@suse.com
- bnc#816159 - VUL-0: xen: CVE-2013-1918: XSA-45: Several long
  latency operations are not preemptible
  CVE-2013-1918-xsa45-1-vcpu-destroy-pagetables-preemptible.patch
  CVE-2013-1918-xsa45-2-new-guest-cr3-preemptible.patch
  CVE-2013-1918-xsa45-3-new-user-base-preemptible.patch
  CVE-2013-1918-xsa45-4-vcpu-reset-preemptible.patch
  CVE-2013-1918-xsa45-5-set-info-guest-preemptible.patch
  CVE-2013-1918-xsa45-6-unpin-preemptible.patch
  CVE-2013-1918-xsa45-7-mm-error-paths-preemptible.patch
- bnc#816163 - VUL-0: xen: CVE-2013-1952: XSA-49: VT-d interrupt
  remapping source validation flaw for bridges
  CVE-2013-1952-xsa49.patch
* Thu Apr 18 2013 cyliu@suse.com
- bnc#809662 - can't use pv-grub to start domU (pygrub does work)
  xen.spec
* Mon Apr 15 2013 carnold@suse.com
- bnc#814709 - Unable to create XEN virtual machines in SLED 11 SP2
  on Kyoto
  xend-cpuinfo-model-name.patch
* Mon Apr 15 2013 carnold@suse.com
- bnc#813673 - VUL-0: CVE-2013-1917: xen: Xen PV DoS vulnerability with
  SYSENTER
  CVE-2013-1917-xsa44.patch
- bnc#813675 - VUL-0: CVE-2013-1919: xen: Several access permission
  issues with IRQs for unprivileged guests
  CVE-2013-1919-xsa46.patch
- bnc#814059 - VUL-1: xen: qemu-nbd format-guessing due to missing
  format specification
  CVE-2013-1922-xsa48.patch
- Upstream patches from Jan
  26749-x86-reserve-pages-when-SandyBridge-integrated-graphics.patch
  26751-x86-EFI-permit-setting-variable-with-non-zero-attributes.patch
  26765-hvm-Clean-up-vlapic_reg_write-error-propagation.patch
  26770-x86-irq_move_cleanup_interrupt-must-ignore-legacy-vectors.patch
  26771-x86-S3-Restore-broken-vcpu-affinity-on-resume.patch
  26772-VMX-Always-disable-SMEP-when-guest-is-in-non-paging-mode.patch
  26773-x86-mm-shadow-spurious-warning-when-unmapping-xenheap-pages.patch
  26774-defer-event-channel-bucket-pointer-store-until-after-XSM-checks.patch
  26799-x86-don-t-pass-negative-time-to-gtime_to_gtsc.patch
* Thu Apr  4 2013 carnold@suse.com
- bnc#813156 - IndentationError in XendCheckpoint.py
  xend-domain-lock.patch
* Tue Apr  2 2013 ohering@suse.de
- bnc#797014 - no way to control live migrations
- bnc#803712 - after live migration rcu_sched_state detected stalls
  xen.migrate.tools-xend_move_assert_to_exception_block.patch
  xen.migrate.tools-libxc_print_stats_if_migration_is_aborted.patch
  xen.migrate.tools_set_number_of_dirty_pages_during_migration.patch
  xen.migrate.tools_notify_restore_to_hangup_during_migration_--abort_if_busy.patch
* Tue Mar 26 2013 carnold@suse.com
- bnc#811764 - XEN (hypervisor or kernel) has a problem with EFI
  variable services
  x86-EFI-set-variable-permit-attrs.patch
- Upstream patches from Jan
  26060-ACPI-ERST-table-size-checks.patch
  26692-x86-fully-protect-MSI-X-table-from-PV-guest-accesses.patch
  26702-powernow-add-fixups-for-AMD-P-state-figures.patch
  26704-x86-MCA-suppress-bank-clearing-for-certain-injected-events.patch (bnc#805579)
  26731-AMD-IOMMU-Process-softirqs-while-building-dom0-iommu-mappings.patch
  26733-VT-d-Enumerate-IOMMUs-when-listing-capabilities.patch
  26734-ACPI-ERST-Name-table-in-otherwise-opaque-error-messages.patch
  26736-ACPI-APEI-Unlock-apei_iomaps_lock-on-error-path.patch
  26737-ACPI-APEI-Add-apei_exec_run_optional.patch
  26742-IOMMU-properly-check-whether-interrupt-remapping-is-enabled.patch
  26743-VT-d-deal-with-5500-5520-X58-errata.patch (bnc#801910)
  26744-AMD-IOMMU-allow-disabling-only-interrupt-remapping.patch
* Thu Mar 14 2013 jfehlig@suse.com
- Load blktap module in xencommons init script.  blktap2 doesn't
  support qcow2, so blktap is needed to support domains with
  'tap:qcow2' disk configurations.
  modified tmp-initscript-modprobe.patch
* Thu Mar 14 2013 carnold@suse.com
- bnc#809203 - xen.efi isn't signed with SUSE Secure Boot key
  xen.spec
* Mon Mar 11 2013 jfehlig@suse.com
- Fix adding managed PCI device to an inactive domain
  modified xen-managed-pci-device.patch
* Mon Mar 11 2013 jfehlig@suse.com
- bnc#805094 - xen hot plug attach/detach fails
  modified blktap-pv-cdrom.patch
* Mon Mar 11 2013 jfehlig@suse.com
- bnc# 802690 - domain locking can prevent a live migration from
  completing
  modified xend-domain-lock.patch
* Fri Mar  8 2013 ohering@suse.de
- bnc#797014 - no way to control live migrations
  26675-tools-xentoollog_update_tty_detection_in_stdiostream_progress.patch
  xen.migrate.tools-xc_print_messages_from_xc_save_with_xc_report.patch
  xen.migrate.tools-xc_document_printf_calls_in_xc_restore.patch
  xen.migrate.tools-xc_rework_xc_save.cswitch_qemu_logdirty.patch
  xen.migrate.tools_set_migration_constraints_from_cmdline.patch
  xen.migrate.tools_add_xm_migrate_--log_progress_option.patch
* Thu Mar  7 2013 carnold@suse.com
- Upstream patches from Jan
  26585-x86-mm-Take-the-p2m-lock-even-in-shadow-mode.patch
  26595-x86-nhvm-properly-clean-up-after-failure-to-set-up-all-vCPU-s.patch
  26601-honor-ACPI-v4-FADT-flags.patch
  26656-x86-fix-null-pointer-dereference-in-intel_get_extended_msrs.patch
  26659-AMD-IOMMU-erratum-746-workaround.patch
  26660-x86-fix-CMCI-injection.patch
  26672-vmx-fix-handling-of-NMI-VMEXIT.patch
  26673-Avoid-stale-pointer-when-moving-domain-to-another-cpupool.patch
  26676-fix-compat-memory-exchange-op-splitting.patch
  26677-x86-make-certain-memory-sub-ops-return-valid-values.patch
  26678-SEDF-avoid-gathering-vCPU-s-on-pCPU0.patch
  26679-x86-defer-processing-events-on-the-NMI-exit-path.patch
  26683-credit1-Use-atomic-bit-operations-for-the-flags-structure.patch
  26689-fix-domain-unlocking-in-some-xsm-error-paths.patch
* Tue Mar  5 2013 carnold@suse.com
- fate#313584: pass bios information to XEN HVM guest
  xend-hvm-firmware-passthrough.patch
* Mon Mar  4 2013 ohering@suse.de
- bnc#806736: enabling xentrace crashes hypervisor
  26686-xentrace_fix_off-by-one_in_calculate_tbuf_size.patch
* Thu Feb 28 2013 ohering@suse.de
- update xenalyze to revision 149
  Make eip_list output more useful
  Use correct length when copying record into buffer
  decode PV_HYPERCALL_SUBCALL events
  decode PV_HYPERCALL_V2 records
  Analyze populate-on-demand reclamation patterns
  Handle 64-bit MMIO
  Also strip write bit when processing a generic event
  Make the warnigns in hvm_generic_postprocess more informative
  Don't warn about switching paging levels unless verbosity>=6
  Process NPFs as generic for summary purposes
  Add HVM_EVENT_VLAPIC
* Wed Feb 20 2013 jfehlig@suse.com
- Add upstream patch to fix vfb/vkb initialization in libxl
  26369-libxl-devid.patch
* Tue Feb 19 2013 carnold@suse.com
- fate##313584: pass bios information to XEN HVM guest
  26554-hvm-firmware-passthrough.patch
  26555-hvm-firmware-passthrough.patch
  26556-hvm-firmware-passthrough.patch
* Tue Feb 19 2013 carnold@suse.com
- Upstream patches from Jan
  26516-ACPI-parse-table-retval.patch (Replaces CVE-2013-0153-xsa36.patch)
  26517-AMD-IOMMU-clear-irtes.patch (Replaces CVE-2013-0153-xsa36.patch)
  26518-AMD-IOMMU-disable-if-SATA-combined-mode.patch (Replaces CVE-2013-0153-xsa36.patch)
  26519-AMD-IOMMU-perdev-intremap-default.patch (Replaces CVE-2013-0153-xsa36.patch)
  26526-pvdrv-no-devinit.patch
  26529-gcc48-build-fix.patch
  26531-AMD-IOMMU-IVHD-special-missing.patch (Replaces CVE-2013-0153-xsa36.patch)
  26532-AMD-IOMMU-phantom-MSI.patch
  26536-xenoprof-div-by-0.patch
  26576-x86-APICV-migration.patch
  26577-x86-APICV-x2APIC.patch
  26578-AMD-IOMMU-replace-BUG_ON.patch
* Mon Feb 18 2013 ohering@suse.de
- bnc#797014 - no way to control live migrations
  26547-tools-xc_fix_logic_error_in_stdiostream_progress.patch
  26548-tools-xc_handle_tty_output_differently_in_stdiostream_progress.patch
  26549-tools-xc_turn_XCFLAGS_*_into_shifts.patch
  26550-tools-xc_restore_logging_in_xc_save.patch
  26551-tools-xc_log_pid_in_xc_save-xc_restore_output.patch
* Mon Feb 11 2013 mmarek@suse.cz
- Set $BRP_PESIGN_FILES in the %%install section so that modules
  are signed in the buildservice (fate#314552).
* Mon Feb 11 2013 ohering@suse.de
- PVonHVM: __devinit was removed in linux-3.8
* Wed Feb  6 2013 jfehlig@suse.com
- Add 'managed' PCI passthrough support to xend, allowing support
  for the same through libvirt
  xen-managed-pci-device.patch
  FATE#313570
* Tue Feb  5 2013 carnold@suse.com
- Upstream patches from Jan
  26287-sched-credit-pick-idle.patch
  26340-VT-d-intremap-verify-legacy-bridge.patch (Replaces CVE-2012-5634-xsa33.patch)
  26370-libxc-x86-initial-mapping-fit.patch
  26395-x86-FPU-context-conditional.patch
  26404-x86-forward-both-NMI-kinds.patch
  26418-x86-trampoline-consider-multiboot.patch
  26427-x86-AMD-enable-WC+.patch
  26428-x86-HVM-RTC-update.patch
  26440-x86-forward-SERR.patch
  26443-ACPI-zap-DMAR.patch
  26444-x86-nHVM-no-self-enable.patch (Replaces CVE-2013-0152-xsa35.patch)
  26501-VMX-simplify-CR0-update.patch
  26502-VMX-disable-SMEP-when-not-paging.patch
* Fri Feb  1 2013 carnold@suse.com
- bnc#800275 - VUL-0: XSA-36: CVE-2013-0153: xen: interrupt remap
  entries shared and old ones not cleared on AMD IOMMUs
  CVE-2013-0153-xsa36.patch
* Wed Jan 30 2013 mmarek@suse.cz
- Add # needssslcertforbuild to the specfile, to make the UEFI
  signing certificate available during build (fate#314511, fate#314552).
* Fri Jan 25 2013 jfehlig@suse.com
- bnc#798188 - Add $network to xend initscript dependencies
* Thu Jan 24 2013 jfehlig@suse.com
- Add upstream patches to fix libxl bugs.  These patches have
  already been posted for inclusion in xen-4.2-testing.
  25912-partial-libxl.patch
  26372-tools-paths.patch
  26468-libxl-race.patch
  26469-libxl-race.patch
* Tue Jan 22 2013 carnold@novell.com
- bnc#797285 - VUL-0: Xen: XSA-34 (CVE-2013-0151) - nested
  virtualization on 32-bit exposes host crash
  CVE-2013-0151-xsa34.patch
- bnc#797287 - VUL-0: Xen: XSA-35 (CVE-2013-0152) - Nested HVM
  exposes host to being driven out of memory by guest
  CVE-2013-0152-xsa35.patch
* Thu Jan 17 2013 carnold@novell.com
- bnc#793717 - NetWare will not boot on Xen 4.2
  xnloader.py
  domUloader.py
  pygrub-netware-xnloader.patch
  Removed reverse-24757-use-grant-references.patch
* Wed Jan 16 2013 carnold@novell.com
- bnc#797523 - VUL-1: CVE-2012-6075: qemu / kvm-qemu: e1000
  overflows under some conditions
  CVE-2012-6075-xsa41.patch
* Tue Jan 15 2013 carnold@novell.com
- Mask the floating point exceptions for guests like NetWare on
  machines that support XSAVE.
  x86-fpu-context-conditional.patch
* Mon Jan 14 2013 carnold@novell.com
- fate##313584: pass bios information to XEN HVM guest
  26341-hvm-firmware-passthrough.patch
  26342-hvm-firmware-passthrough.patch
  26343-hvm-firmware-passthrough.patch
  26344-hvm-firmware-passthrough.patch
* Tue Jan  8 2013 carnold@novell.com
- bnc#787169 - L3: Marvell 88SE9125 disk controller not detecting
  disk in Xen kernel
  26133-IOMMU-defer-BM-disable.patch
  26324-IOMMU-assign-params.patch
  26325-IOMMU-add-remove-params.patch
  26326-VT-d-context-map-params.patch
  26327-AMD-IOMMU-flush-params.patch
  26328-IOMMU-pdev-type.patch
  26329-IOMMU-phantom-dev.patch
  26330-VT-d-phantom-MSI.patch
  26331-IOMMU-phantom-dev-quirk.patch
- Upstream patches from Jan
  26294-x86-AMD-Fam15-way-access-filter.patch
  26320-IOMMU-domctl-assign-seg.patch
  26332-x86-compat-show-guest-stack-mfn.patch
  26333-x86-get_page_type-assert.patch
* Mon Dec 17 2012 carnold@novell.com
- bnc#794316 - VUL-0: CVE-2012-5634: xen: VT-d interrupt remapping
  source validation flaw (XSA-33)
  CVE-2012-5634-xsa33.patch
* Mon Dec 17 2012 carnold@novell.com
- Update to Xen 4.2.1 c/s 25952
* Tue Dec 11 2012 carnold@novell.com
- Upstream patches from Jan
  26195-x86-compat-atp-gmfn-range-cont.patch
  26196-ACPI-set-PDC-bits-rc.patch
  26200-IOMMU-debug-verbose.patch
  26203-x86-HAP-dirty-vram-leak.patch
  26229-gnttab-version-switch.patch (Replaces CVE-2012-5510-xsa26.patch)
  26230-x86-HVM-limit-batches.patch (Replaces CVE-2012-5511-xsa27.patch)
  26231-memory-exchange-checks.patch (Replaces CVE-2012-5513-xsa29.patch)
  26232-x86-mark-PoD-error-path.patch (Replaces CVE-2012-5514-xsa30.patch)
  26233-memop-order-checks.patch (Replaces CVE-2012-5515-xsa31.patch)
  26234-x86-page-from-gfn-pv.patch (Replaces CVE-2012-5525-xsa32.patch)
  26235-IOMMU-ATS-max-queue-depth.patch
  26252-VMX-nested-rflags.patch
  26253-VMX-nested-rdtsc.patch
  26254-VMX-nested-dr.patch
  26255-VMX-nested-ia32e-mode.patch
  26258-VMX-nested-intr-delivery.patch
  26260-x86-mmuext-errors.patch
  26262-x86-EFI-secure-shim.patch
  26266-sched-ratelimit-check.patch
  26272-x86-EFI-makefile-cflags-filter.patch
* Mon Dec 10 2012 carnold@novell.com
- bnc#757525 - domain destroyed on live migration with missing vif
  on target machine
  xen-migration-bridge-check.patch
* Thu Dec  6 2012 carnold@novell.com
- NetWare will not boot or install on Xen 4.2
  reverse-24757-use-grant-references.patch
* Fri Nov 30 2012 cyliu@suse.com
- fate#313222 - xenstore-chmod should support 256 permissions
  26189-xenstore-chmod.patch
* Tue Nov 27 2012 carnold@novell.com
- bnc#789945 - VUL-0: CVE-2012-5510: xen: Grant table version
  switch list corruption vulnerability (XSA-26)
  CVE-2012-5510-xsa26.patch
- bnc#789944 - VUL-0: CVE-2012-5511: xen: Several HVM operations do
  not validate the range of their inputs (XSA-27)
  CVE-2012-5511-xsa27.patch
- bnc#789951 - VUL-0: CVE-2012-5513: xen: XENMEM_exchange may
  overwrite hypervisor memory (XSA-29)
  CVE-2012-5513-xsa29.patch
- bnc#789948 - VUL-0: CVE-2012-5514: xen: Missing unlock in
  guest_physmap_mark_populate_on_demand() (XSA-30)
  CVE-2012-5514-xsa30.patch
- bnc#789950 - VUL-0: CVE-2012-5515: xen: Several memory hypercall
  operations allow invalid extent order values (XSA-31)
  CVE-2012-5515-xsa31.patch
- bnc#789952 - VUL-0: CVE-2012-5525: xen: Several hypercalls do not
  validate input GFNs (XSA-32)
  CVE-2012-5525-xsa32.patch
- Upstream patches from Jan
  26129-ACPI-BGRT-invalidate.patch
  26132-tmem-save-NULL-check.patch
  26134-x86-shadow-invlpg-check.patch
  26139-cpumap-masking.patch
  26148-vcpu-timer-overflow.patch (Replaces CVE-2012-4535-xsa20.patch)
  26149-x86-p2m-physmap-error-path.patch (Replaces CVE-2012-4537-xsa22.patch)
  26150-x86-shadow-unhook-toplevel-check.patch (Replaces CVE-2012-4538-xsa23.patch)
  26151-gnttab-compat-get-status-frames.patch (Replaces CVE-2012-4539-xsa24.patch)
  26179-PCI-find-next-cap.patch
  26183-x86-HPET-masking.patch
  26188-x86-time-scale-asm.patch
* Wed Nov 21 2012 ohering@suse.de
- remove obsolete pv-driver-build.patch to fix build
* Sat Nov 17 2012 aj@suse.de
- Fix build with glibc 2.17: add patch xen-glibc217.patch, fix
  configure for librt.
* Tue Nov 13 2012 jfehlig@suse.com
- bnc#777628 - guest "disappears" after live migration
  Updated block-dmmd script
* Fri Nov  9 2012 carnold@novell.com
- Fix exception in balloon.py and osdep.py
  xen-max-free-mem.diff
* Tue Nov  6 2012 carnold@novell.com
- fate#311966: Fix XEN VNC implementation to correctly map keyboard
  layouts
  VNC-Support-for-ExtendedKeyEvent-client-message.patch
* Tue Oct 30 2012 ohering@suse.de
- fate#310510 - fix xenpaging
  restore changes to integrate paging into xm/xend
  xenpaging.autostart.patch
  xenpaging.doc.patch
* Mon Oct 29 2012 carnold@novell.com
- bnc#787163 - VUL-0: CVE-2012-4544: xen: Domain builder Out-of-
  memory due to malicious kernel/ramdisk (XSA 25)
  CVE-2012-4544-xsa25.patch
- bnc#779212 - VUL-0: CVE-2012-4411: XEN / qemu: guest
  administrator can access qemu monitor console (XSA-19)
  CVE-2012-4411-xsa19.patch
* Thu Oct 25 2012 carnold@novell.com
- bnc#786516 - VUL-0: CVE-2012-4535: xen: Timer overflow DoS
  vulnerability
  CVE-2012-4535-xsa20.patch
- bnc#786518 - VUL-0: CVE-2012-4536: xen: pirq range check DoS
  vulnerability
  CVE-2012-4536-xsa21.patch
- bnc#786517 - VUL-0: CVE-2012-4537: xen: Memory mapping failure
  DoS vulnerability
  CVE-2012-4537-xsa22.patch
- bnc#786519 - VUL-0: CVE-2012-4538: xen: Unhooking empty PAE
  entries DoS vulnerability
  CVE-2012-4538-xsa23.patch
- bnc#786520 - VUL-0: CVE-2012-4539: xen: Grant table hypercall
  infinite loop DoS vulnerability
  CVE-2012-4539-xsa24.patch
- bnc#784087 - L3: Xen BUG at io_apic.c:129
  26102-x86-IOAPIC-legacy-not-first.patch
* Wed Oct 24 2012 carnold@novell.com
- Upstream patches from Jan
  25920-x86-APICV-enable.patch
  25921-x86-APICV-delivery.patch
  25922-x86-APICV-x2APIC.patch
  25957-x86-TSC-adjust-HVM.patch
  25958-x86-TSC-adjust-sr.patch
  25959-x86-TSC-adjust-expose.patch
  25975-x86-IvyBridge.patch
  25984-SVM-nested-paging-mode.patch
  26054-x86-AMD-perf-ctr-init.patch
  26055-x86-oprof-hvm-mode.patch
  26056-page-alloc-flush-filter.patch
  26061-x86-oprof-counter-range.patch
  26062-ACPI-ERST-move-data.patch
  26063-x86-HPET-affinity-lock.patch
  26095-SVM-nested-leak.patch
  26096-SVM-nested-vmexit-emul.patch
  26098-perfc-build.patch
* Mon Oct 22 2012 ohering@suse.de
- handle possible asprintf failures in log-guest-console.patch
* Mon Oct 22 2012 ohering@suse.de
- bnc#694863 - kexec fails in xen
  26093-hvm_handle_PoD_and_grant_pages_in_HVMOP_get_mem_type.patch
* Thu Oct 18 2012 carnold@novell.com
- fate#312709: Pygrub needs to know which entry to select
  26114-pygrub-list-entries.patch
* Thu Oct 18 2012 ohering@suse.de
- merge changes fron xen-unstable, obsolete our changes
  26077-stubdom_fix_compile_errors_in_grub.patch
  26078-hotplug-Linux_remove_hotplug_support_rely_on_udev_instead.patch
  26079-hotplug-Linux_close_lockfd_after_lock_attempt.patch
  26081-stubdom_fix_rpmlint_warning_spurious-executable-perm.patch
  26082-blktap2-libvhd_fix_rpmlint_warning_spurious-executable-perm.patch
  26083-blktap_fix_rpmlint_warning_spurious-executable-perm.patch
  26084-hotplug_install_hotplugpath.sh_as_data_file.patch
  26085-stubdom_install_stubdompath.sh_as_data_file.patch
  26086-hotplug-Linux_correct_sysconfig_tag_in_xendomains.patch
  26087-hotplug-Linux_install_sysconfig_files_as_data_files.patch
  26088-tools_xend_fix_wrong_condition_check_for_xml_file.patch
* Tue Oct 16 2012 carnold@novell.com
- fate#311966: Fix XEN VNC implementation to correctly map keyboard
  layouts
  VNC-Support-for-ExtendedKeyEvent-client-message.patch
* Mon Oct 15 2012 ohering@suse.de
- workaround bash bug in locking.sh:claim_lock, close fd
* Sat Oct 13 2012 ohering@suse.de
- fix incorrect self-provides/obsoletes of xen-tools-ioemu
* Tue Oct  9 2012 carnold@novell.com
- bnc#783847 - Virtualization/xen: Bug Xen 4.2 'xendomins' init
  script incorrectly Requires 'xend' service when using 'xl'
  toolstack
  init.xendomains
* Mon Oct  8 2012 carnold@novell.com
- bnc#782835 - Xen HVM Guest fails (errors) to launch on Opensuse
  12.2 + Xen 4.2 + 'xl' toolstack
  xen-pygrub-grub-args.patch
* Mon Oct  8 2012 ohering@suse.de
- backport parallel build support for stubdom
- rename 5 patches which were merged upstream
* Fri Oct  5 2012 ohering@suse.de
- remove more obsolete changes:
  CFLAGS passing to qemu-traditional, PYTHON_PREFIX_ARG handling
  and pygrub installation
* Fri Oct  5 2012 ohering@suse.de
- update blktap-pv-cdrom.patch
  handle allocation errors in asprintf to fix compile errors
  handle value returned from xs_read properly
  remove casts from void pointers
* Fri Oct  5 2012 ohering@suse.de
- update xenalyze to revision 138
  Fix dump time calculation overflow
  move struct record_info into a header
  correctly display of count of HW events
  update trace.h to match xen-unstable
  Remove vestigal HW_IRQ trace records
  Remove decode of PV_UPDATE_VA_MAPPING
  automatically generate dependencies
  Get rid of redundant hvm dump_header
  Introduce more efficient read mechanism
  Eliminate unnecessary cycles_to_time calculation
  Rework math to remove two 64-bit divisions
  Enable -O2 optimization level
  Remove --dump-cooked
  Remove spurious dump_header construction
  Improve record-sorting algorithm
  Use long to cast into and out of pointers
  Make max_active_pcpu calculation smarter
  Optimize pcpu_string
  Enable more cr3 output
  Sort cr3 enumerated values by start time
  Add option to skip vga range in MMIO enumeration
  Handle MMIO records from different vmexits
  Relocate pio and mmio enumaration structs to their own sub-struct
  Handle new hvm_event traces
  Introduce generic summary functionality
  Function-ize setting of h->post_process
  Reorganize cr trace handling
  Allow several summary handlers to register on a single vmexit
  Get rid of all tabs in xenalyze.c
  Handle new IRQ tracing
  Decrease verbosity
  Print exit reason number if no string is available
  Fix minor summary issue
  Add string for TPR_BELOW_THRESHOLD
  Raise MAX_CPUS to 256 cpus.
  Add --report-pcpu option to report physical cpu utilization.
  increase MAX_CPUS
  Handle RUNSTATE_INIT in domain_runstate calculation
* Fri Oct  5 2012 ohering@suse.de
- update RPM_OPT_FLAGS handling in spec file
  pass EXTRA_CFLAGS via environment
* Fri Oct  5 2012 ohering@suse.de
- remove obsolete xencommons-proc-xen.patch
* Mon Oct  1 2012 carnold@novell.com
- Upstream patches from Jan
  25927-x86-domctl-ioport-mapping-range.patch
  25929-tmem-restore-pool-version.patch
  25931-x86-domctl-iomem-mapping-checks.patch
  25940-x86-S3-flush-cache.patch
  25952-x86-MMIO-remap-permissions.patch
  25961-x86-HPET-interrupts.patch
  25962-x86-assign-irq-vector-old.patch
  25965-x86-ucode-Intel-resume.patch
* Tue Sep 25 2012 ohering@suse.de
- pygrub: always append --args
  25941-pygrub_always_append_--args.patch
* Mon Sep 24 2012 ohering@suse.de
- use BuildRequires: gcc46 only in sles11sp2 or 12.1 to fix build
  in 11.4
* Wed Sep 19 2012 carnold@novell.com
- Upstream patches from Jan
  25833-32on64-bogus-pt_base-adjust.patch
  25835-adjust-rcu-lock-domain.patch
  25836-VT-d-S3-MSI-resume.patch
  25850-tmem-xsa-15-1.patch
  25851-tmem-xsa-15-2.patch
  25852-tmem-xsa-15-3.patch
  25853-tmem-xsa-15-4.patch
  25854-tmem-xsa-15-5.patch
  25855-tmem-xsa-15-6.patch
  25856-tmem-xsa-15-7.patch
  25857-tmem-xsa-15-8.patch
  25858-tmem-xsa-15-9.patch
  25859-tmem-missing-break.patch
  25860-tmem-cleanup.patch
  25861-x86-early-fixmap.patch
  25862-sercon-non-com.patch
  25863-sercon-ehci-dbgp.patch
  25864-sercon-unused.patch
  25866-sercon-ns16550-pci-irq.patch
  25867-sercon-ns16550-parse.patch
  25874-x86-EFI-chain-cfg.patch
  25909-xenpm-consistent.patch
* Tue Sep 18 2012 carnold@novell.com
- Fixed the 32bit build.
* Mon Sep 17 2012 carnold@novell.com
- Update to Xen 4.2.0 FCS c/s 25844
* Fri Sep  7 2012 ohering@suse.de
- unmodified_drivers: handle IRQF_SAMPLE_RANDOM, it was removed
  in 3.6-rc1
* Wed Sep  5 2012 jfehlig@suse.com
- bnc#778105 - first XEN-PV VM fails to spawn
  xend: Increase wait time for disk to appear in host bootloader
  Modified existing xen-domUloader.diff
* Thu Aug 30 2012 carnold@novell.com
- Disable the snapshot patches. Snapshot only supported the qcow2
  image format which was poorly implemented qemu 0.10.2. Snapshot
  support may be restored in the future when the newer upstream
  qemu is used by Xen.
* Tue Aug 28 2012 ohering@suse.de
- bnc#776995 - attaching scsi control luns with pvscsi
  - xend/pvscsi: fix passing of SCSI control LUNs
  xen-bug776995-pvscsi-no-devname.patch
  - xend/pvscsi: fix usage of persistant device names for SCSI devices
  xen-bug776995-pvscsi-persistent-names.patch
  - xend/pvscsi: update sysfs parser for Linux 3.0
  xen-bug776995-pvscsi-sysfs-parser.patch
* Thu Aug 23 2012 carnold@novell.com
- Update to Xen 4.2.0 RC3+ c/s 25779
* Tue Aug 21 2012 carnold@novell.com
- Update to Xen 4.2.0 RC2+ c/s 25765
* Mon Aug 20 2012 ohering@suse.de
-bnc#766284 - compiled-in ata_piix driver issues with PVonHVM guests
  Update xen_pvdrivers.conf to match not only libata but also ata_piix
  This avoids IO errors in the piix driver caused by unplugged hardware
* Fri Aug 10 2012 carnold@novell.com
- Update to Xen 4.1.3 c/s 23336
* Mon Jul 30 2012 carnold@novell.com
- Upstream or pending upstream patches from Jan
  25587-fix-off-by-one-parsing-error.patch
  25616-x86-MCi_CTL-default.patch
  25617-vtd-qinval-addr.patch
  25688-x86-nr_irqs_gsi.patch
* Sun Jul 29 2012 aj@suse.de
- Build all files with optimization (fortify source does not work
  with -O0).
* Fri Jul 27 2012 carnold@novell.com
- bnc#773393 - VUL-0: CVE-2012-3433: xen: HVM guest destroy p2m
  teardown host DoS vulnerability
  CVE-2012-3433-xsa11.patch
- bnc#773401 - VUL-1: CVE-2012-3432: xen: HVM guest user mode MMIO
  emulation DoS
  25682-x86-inconsistent-io-state.patch
* Wed Jul 18 2012 carnold@novell.com
- bnc#762484 - VUL-1: CVE-2012-2625: xen: pv bootloader doesn't
  check the size of the bzip2 or lzma compressed kernel, leading to
  denial of service
  25589-pygrub-size-limits.patch
* Tue Jul 10 2012 werner@suse.de
- Make it build with latest TeXLive 2012 with new package layout
* Fri Jun 15 2012 carnold@novell.com
- bnc#767273 - unsupported /var/lock/subsys is still used by xendomains
  init.xendomains
* Tue Jun 12 2012 carnold@novell.com
- bnc#766283 - opensuse 12.2 pv guests can not start after
  installation due to lack of grub2 support in the host
  24000-pygrub-grub2.patch
  24001-pygrub-grub2.patch
  24002-pygrub-grub2.patch
* Mon Jun 11 2012 carnold@novell.com
- Upstream pygrub patches for grub2 support and fixes
  23686-pygrub-solaris.patch
  23697-pygrub-grub2.patch
  23944-pygrub-debug.patch
  23998-pygrub-GPT.patch
  23999-pygrub-grub2.patch
  24064-pygrub-HybridISO.patch
  24401-pygrub-scrolling.patch
  24402-pygrub-edit-fix.patch
  24460-pygrub-extlinux.patch
  24706-pygrub-extlinux.patch
* Wed Jun  6 2012 carnold@novell.com
- Revised version of security patch and an additional patch for
  bnc#764077
  x86_64-AMD-erratum-121.patch
  x86_64-allow-unsafe-adjust.patch
* Wed Jun  6 2012 ohering@suse.de
- remove dummy asm/smp-processor-id.h
* Tue May 29 2012 jsmeix@suse.de
- removed dummy xenapi.tex which was added because of bnc#750679
  (see the below entry dated "Mon Apr  2 13:07:20 CEST 2012")
  because "ps2pdf xenapi.ps xenapi.pdf" failed only for
  Ghostscript version 9.04 (now we have Ghostscript 9.05).
* Fri May 25 2012 carnold@novell.com
- bnc#764077 - VUL-0: EMBARGOED: xen: XSA-9: denial of service on
  older AMD systems
  x86_64-AMD-erratum-121.patch
- Revised version of security patch for bnc#757537
  x86_64-sysret-canonical.patch
* Tue May 15 2012 carnold@novell.com
- Upstream patches from Jan
  25242-x86_64-hotplug-compat-m2p.patch
  25247-SVM-no-rdtsc-intercept.patch
  25267-x86-text-unlikely.patch
  25269-x86-vMCE-addr-misc-write.patch
  25271-x86_64-IST-index.patch
  25327-pvdrv-no-asm-system-h.patch
* Sun May 13 2012 ohering@suse.de
- add dummy asm/smp-processor-id.h for kernel-source 3.4-rcX
* Sun May 13 2012 ohering@suse.de
- remove inclusion of asm/system.h from platform-pci.c
* Tue Apr 24 2012 carnold@novell.com
- Upstream patches from Jan
  25168-x86-memset-size.patch
  25191-x86-tdt-delta-calculation.patch
  25195-x86-cpuidle-C2-no-flush-or-bm-check.patch
  25196-x86-HAP-PAT-sr.patch
  25200-x86_64-trap-bounce-flags.patch
* Thu Apr 19 2012 carnold@novell.com
- bnc#757537 - VUL-0: xen: CVE-2012-0217 PV guest escalation
  x86_64-sysret-canonical.patch
- bnc#757970 - VUL-1: xen: guest denial of service on syscall GPF
  generation
  x86_64-trap-bounce-flags.patch
* Tue Apr  3 2012 carnold@novell.com
- Upstream patches from Jan
  25098-x86-emul-lock-UD.patch
  25101-x86-hpet-disable.patch
  ioemu-9877-MSI-X-device-cleanup.patch
* Mon Apr  2 2012 ohering@suse.de
- bnc#750679 - "ps2pdf xenapi.ps xenapi.pdf" fails for user abuild in Factory
  add dummy xenapi.tex until ghostscript is fixed
* Wed Mar 28 2012 ohering@suse.de
- remove vcd.o rule from PVonHVM Makefile, not needed anymore
* Tue Mar 20 2012 carnold@novell.com
- bnc#753165 - xen/scripts/network-bridge wont create bridge
  bridge-bonding.diff
* Mon Mar 19 2012 carnold@novell.com
- Upstream patches from Jan
  24950-gnttab-copy-mapped.patch
  24970-x86-cpuidle-deny-port-access.patch
  24996-x86-cpuidle-array-overrun.patch
  25041-tapdisk2-create-init-name.patch
* Wed Mar 14 2012 ohering@suse.de
- use BuildRequires: gcc46 only in sles11sp2 to avoid issues
  when gcc47 and newer is the distro default
* Mon Feb 27 2012 jfehlig@suse.com
- bnc#745880 - cpuid setting is not preserved across xend restarts
  xend-cpuid.patch
* Mon Feb 27 2012 jfehlig@suse.com
- Rename 2XXXX-vif-bridge.patch -> vif-bridge-tap-fix.patch
* Mon Feb 27 2012 carnold@novell.com
- bnc#747331 - XEN: standard "newburn" kernel QA stress test on guest
  (+ smartd on Dom0?) freezes the guest
  24883-x86-guest-walk-not-present.patch
- bnc#745367 - MCE bank handling during migration
  24781-x86-vmce-mcg_ctl.patch
  24886-x86-vmce-mcg_ctl-default.patch
  24887-x86-vmce-sr.patch
- bnc#744771 - L3: VM with passed through PCI card fails to reboot
  under dom0 load
  24888-pci-release-devices.patch
- Upstream patches from Jan
  24517-VT-d-fault-softirq.patch
  24527-AMD-Vi-fault-softirq.patch
  24535-x86-vMSI-misc.patch
  24615-VESA-lfb-flush.patch
  24690-x86-PCI-SERR-no-deadlock.patch
  24701-gnttab-map-grant-ref-recovery.patch
  24742-gnttab-misc.patch
  24780-x86-paging-use-clear_guest.patch
  24805-x86-MSI-X-dom0-ro.patch
  ioemu-9869-MSI-X-init.patch
  ioemu-9873-MSI-X-fix-unregister_iomem.patch
* Sat Feb 25 2012 ohering@suse.de
- add BuildRequires: libuuid-devel
* Tue Feb 14 2012 carnold@novell.com
- bnc#746702 - Xen HVM DomU crash during Windows Server 2008 R2
  install, when maxmem > memory
  README.SuSE
* Wed Feb  8 2012 jfehlig@suse.com
- bnc#745005 - Update vif configuration examples in xmexample*
  Updated xen-xmexample.diff
* Thu Feb  2 2012 jfehlig@suse.com
- bnc#743414 - using vifname is ignored when defining a xen virtual
  interface with xl/libxl
  24459-libxl-vifname.patch
* Thu Feb  2 2012 carnold@novell.com
- bnc#740165 - VUL-0: kvm: qemu heap overflow in e1000 device
  emulation (applicable to Xen qemu - CVE-2012-0029)
  cve-2012-0029-qemu-xen-unstable.patch
* Wed Feb  1 2012 carnold@novell.com
- bnc#744014 - blank screen in SLES11 SP2 guest with a VF statically
  assigned
  ioemu-MSI-X-fix-unregister_iomem.patch
- Upstream patches from Jan
  24453-x86-vIRQ-IRR-TMR-race.patch
  24456-x86-emul-lea.patch
* Thu Jan 26 2012 ohering@suse.de
- fate#310510 - fix xenpaging
  24586-x86-mm_Properly_account_for_paged_out_pages.patch
  24609-tools-libxc_handle_fallback_in_linux_privcmd_map_foreign_bulk_properly.patch
  24610-xenpaging_make_file_op_largefile_aware.patch
  xen-unstable.misc.linux_privcmd_map_foreign_bulk.retry_paged.patch
  xenpaging.speedup-page-out.resume_pages.find_next_bit_set.patch
  xenpaging.speedup-page-out.evict_pages.free_slot_stack.patch
  xenpaging.speedup-page-out.policy_choose_victim.patch
  update xenpaging.error-handling.patch, flush qemu cache not so often
* Thu Jan 26 2012 ohering@suse.de
- fate#310510 - fix xenpaging
  24566-tools-libxc_fix_error_handling_in_xc_mem_paging_load.patch
* Tue Jan 24 2012 ohering@suse.de
- fate#310510 - fix xenpaging
  24466-libxc_Only_retry_mapping_pages_when_ENOENT_is_returned.patch
* Mon Jan 23 2012 carnold@novell.com
- The xen kmp packages fail on the 09-check-packaged-twice script.
  Rename xen_pvdrivers.conf to xen_pvdrivers-<kernel flavor>.conf
* Fri Jan 20 2012 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.speedup-page-in.gfn_to_slot.patch
* Wed Jan 18 2012 carnold@novell.com
- bnc#739585 - L3: Xen block-attach fails after repeated attach/detach
  blktap-close-fifos.patch
  blktap-disable-debug-printf.patch
* Fri Jan 13 2012 jfehlig@suse.com
- bnc#741159 - Fix default setting of XENSTORED_ROOTDIR in
  xencommons init script
  xencommons-xenstored-root.patch
* Thu Jan 12 2012 carnold@novell.com
- bnc#740625 - xen: cannot interact with xend after upgrade (SLES)
- bnc#738694 - xen: cannot interact with xend after upgrade (os12.1)
- Other README changes included.
  README.SuSE
* Tue Jan 10 2012 ohering@suse.de
- bnc#694863 - kexec fails in xen
  24478-libxl_add_feature_flag_to_xenstore_for_XS_RESET_WATCHES.patch
* Mon Jan  9 2012 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.speedup-page-out.patch
* Tue Jan  3 2012 carnold@novell.com
- bnc#735806 - VF doesn't work after hot-plug for many times
  24448-x86-pt-irq-leak.patch
- Upstream patches from Jan
  24261-x86-cpuidle-Westmere-EX.patch
  24417-amd-erratum-573.patch
  24429-mceinj-tool.patch
  24447-x86-TXT-INIT-SIPI-delay.patch
  ioemu-9868-MSI-X.patch
* Mon Jan  2 2012 ohering@suse.de
- bnc#732884 - remove private runlevel 4 from init scripts
  xen.no-default-runlevel-4.patch
* Mon Dec 19 2011 carnold@novell.com
- bnc#727515 - Fragmented packets hang network boot of HVM guest
  ipxe-gcc45-warnings.patch
  ipxe-ipv4-fragment.patch
  ipxe-enable-nics.patch
* Mon Dec 19 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  update xenpaging.autostart.patch, make changes with mem-swap-target
  permanent
  update xenpaging.doc.patch, mention issues with live migration
* Thu Dec 15 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  add xenpaging.evict_mmap_readonly.patch
  update xenpaging.error-handling.patch, reduce debug output
* Thu Dec 15 2011 carnold@novell.com
- bnc#736824 - Microcode patches for AMD's 15h processors panic the
  system
  24189-x86-p2m-pod-locking.patch
  24412-x86-AMD-errata-model-shift.patch
  24411-x86-ucode-AMD-Fam15.patch
* Wed Dec 14 2011 carnold@novell.com
- bnc#711219 - SR-IOV VF doesn't work in SLES11 sp2 guest
  24357-firmware-no-_PS0-_PS3.patch
- Upstream patches from Jan
  24153-x86-emul-feature-checks.patch
  24275-x86-emul-lzcnt.patch
  24277-x86-dom0-features.patch
  24278-x86-dom0-no-PCID.patch
  24282-x86-log-dirty-bitmap-leak.patch
  24359-x86-domU-features.patch
  24360-x86-pv-domU-no-PCID.patch
  24389-amd-fam10-gart-tlb-walk-err.patch
  24391-x86-pcpu-version.patch
* Thu Dec  8 2011 ohering@suse.de
- bnc#729208 - xenpaging=-1 doesn't work
  xenpaging.doc.patch
* Thu Dec  8 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  readd xenpaging.qemu.flush-cache.patch
* Wed Dec  7 2011 jfehlig@suse.com
- bnc#732782 - L3: xm create hangs when maxmen value is enclosed
  in "quotes"
  xm-create-maxmem.patch
* Wed Dec  7 2011 carnold@novell.com
- Upstream patches / changes from Jan
  Added 24358-kexec-compat-overflow.patch
  Removed 24341-x86-64-mmcfg_remove___initdata_annotation_overlooked_in_23749e8d1c8f074ba.patch
  Removed 24345-tools-libxc_Fix_x86_32_build_breakage_in_previous_changeset..patch
* Wed Dec  7 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  24178-debug_Add_domain-vcpu_pause_count_info_to_d_key..patch
  Use wait queues for paging, improve foreign mappings.
  xenpaging.versioned-interface.patch
  xenpaging.mmap-before-nominate.patch
  xenpaging.p2m_is_paged.patch
  xenpaging.evict_fail_fast_forward.patch
  xenpaging.error-handling.patch
  xenpaging.mem_event-use-wait_queue.patch
  xenpaging.waitqueue-paging.patch
  Remove obsolete patch, not needed with wait queue usage
  xenpaging.HVMCOPY_gfn_paged_out.patch
* Wed Dec  7 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  Fix incorrect backport, remove double memset, use xzalloc
  24171-x86waitqueue_Allocate_whole_page_for_shadow_stack..patch
* Wed Dec  7 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  fix typo in nominate, use lock instead of double unlock
  23905-xenpaging_fix_locking_in_p2m_mem_paging_functions.patch
* Wed Dec  7 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  24327-After_preparing_a_page_for_page-in_allow_immediate_fill-in_of_the_page_contents.patch
  24328-Tools_Libxc_wrappers_to_automatically_fill_in_page_oud_page_contents_on_prepare.patch
  24329-Teach_xenpaging_to_use_the_new_and_non-racy_xc_mem_paging_load_interface.patch
* Tue Dec  6 2011 jfehlig@suse.com
- bnc#734826 - xm rename doesn't work anymore
  Updated xend-migration-domname-fix.patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  24269-mem_event_move_mem_event_domain_out_of_struct_domain.patch
  24270-Free_d-mem_event_on_domain_destruction..patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  24318-x86-mm_Fix_checks_during_foreign_mapping_of_paged_pages.patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  23949-constify_vcpu_set_affinitys_second_parameter.patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  24105-xenpaging_compare_domain_pointer_in_p2m_mem_paging_populate.patch
  24106-mem_event_check_capabilities_only_once.patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  24272-xenpaging_Fix_c-s_235070a29c8c3ddf7_update_machine_to_phys_mapping_during_page_deallocation.patch
* Fri Dec  2 2011 ohering@suse.de
- bnc#727081 - xend domains don't work anymore since update from 12.1 beta to 12.1 RC 1
  24344-tools-x86_64_Fix_cpuid_inline_asm_to_not_clobber_stacks_red_zone.patch
  24345-tools-libxc_Fix_x86_32_build_breakage_in_previous_changeset..patch
* Fri Dec  2 2011 ohering@suse.de
- bnc#733449 - Panic in mcfg_ioremap when booting xen-dbg.gz on Xeon E3-1230
  24341-x86-64-mmcfg_remove___initdata_annotation_overlooked_in_23749e8d1c8f074ba.patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  backport waitqueue changes from xen-unstable
  24104-waitqueue_Double_size_of_x86_shadow_stack..patch
  24171-x86waitqueue_Allocate_whole_page_for_shadow_stack..patch
  24195-waitqueue_Detect_saved-stack_overflow_and_crash_the_guest..patch
  24196-waitqueue_Reorder_prepare_to_wait_so_that_vcpu_is_definitely_on_the.patch
  24197-x86-waitqueue_Because_we_have_per-cpu_stacks_we_must_wake_up_on_teh.patch
  24231-waitqueue_Implement_wake_up_nroneall..patch
  24232-waitqueue_Hold_a_reference_to_a_domain_on_a_waitqueue..patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  24227-xenpaging_restrict_pagefile_permissions.patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  merge upstream version of our existing patches:
  24218-libxc_add_bitmap_clear_function.patch
  remove old versions:
  xenpaging.bitmap_clear.patch
* Fri Dec  2 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  merge upstream version of our existing patches:
  24138-xenpaging_munmap_all_pages_after_page-in.patch
  24208-xenpaging_remove_filename_from_comment.patch
  24209-xenpaging_remove_obsolete_comment_in_resume_path.patch
  24210-xenpaging_use_PERROR_to_print_errno.patch
  24211-xenpaging_simplify_file_op.patch
  24212-xenpaging_print_gfn_in_failure_case.patch
  24213-xenpaging_update_xenpaging_init.patch
  24214-xenpaging_remove_xc_dominfo_t_from_paging_t.patch
  24215-xenpaging_track_the_number_of_paged-out_pages.patch
  24216-xenpaging_move_page_add-resume_loops_into_its_own_function..patch
  24217-xenpaging_improve_mainloop_exit_handling.patch
  24219-xenpaging_retry_unpageable_gfns.patch
  24220-xenpaging_install_into_LIBEXEC_dir.patch
  24221-xenpaging_add_XEN_PAGING_DIR_-_libxl_xenpaging_dir_path.patch
  24222-xenpaging_use_guests_tot_pages_as_working_target.patch
  24223-xenpaging_watch_the_guests_memory-target-tot_pages_xenstore_value.patch
  24224-xenpaging_add_cmdline_interface_for_pager.patch
  24225-xenpaging_improve_policy_mru_list_handling.patch
  24226-xenpaging_add_debug_to_show_received_watch_event..patch
  remove old versions:
  xenpaging.XEN_PAGING_DIR.patch
  xenpaging.add_evict_pages.patch
  xenpaging.cmdline-interface.patch
  xenpaging.encapsulate_domain_info.patch
  xenpaging.file_op-return-code.patch
  xenpaging.install-to-libexec.patch
  xenpaging.low_target_policy_nomru.patch
  xenpaging.main-loop-exit-handling.patch
  xenpaging.misleading-comment.patch
  xenpaging.page_in-munmap-size.patch
  xenpaging.print-gfn.patch
  xenpaging.record-numer-paged-out-pages.patch
  xenpaging.reset-uncomsumed.patch
  xenpaging.stale-comments.patch
  xenpaging.target-tot_pages.patch
  xenpaging.use-PERROR.patch
  xenpaging.watch-target-tot_pages.patch
  xenpaging.watch_event-DPRINTF.patch
  xenpaging.xc_interface_open-comment.patch
* Wed Nov 30 2011 jfehlig@suse.com
- bnc#733348 - Use 'xm' in various scripts if xend is running.
  Modified xmclone.sh and xen-updown.sh
- Only emit xl warning when xend is running and -f (force) flag
  is not specified.
  Modified disable-xl-when-using-xend.patch
* Wed Nov 30 2011 carnold@novell.com
- Upstream patches from Jan
  24190-hap-log-dirty-disable-rc.patch
  24193-hap-track-dirty-vram-rc.patch
  24201-x86-pcpu-platform-op.patch
* Tue Nov 22 2011 carnold@novell.com
- Upstream patches from Jan
  23900-xzalloc.patch
  24144-cpufreq-turbo-crash.patch
  24148-shadow-pgt-dying-op-performance.patch
  24155-x86-ioapic-EOI-after-migration.patch
  24156-x86-ioapic-shared-vectors.patch
  24157-x86-xstate-init.patch
  24168-x86-vioapic-clear-remote_irr.patch
* Tue Nov 22 2011 cyliu@suse.com
- submit fixes for bnc#649209 and bnc#711892
  xl-create-pv-with-qcow2-img.patch
  update suspend_evtchn_lock.patch
* Sun Nov 20 2011 ohering@suse.de
- Update trace.c, merge patches from upstream
  23050-xentrace_dynamic_tracebuffer_allocation.patch
  23091-xentrace_fix_t_info_pages_calculation..patch
  23092-xentrace_print_calculated_numbers_in_calculate_tbuf_size.patch
  23093-xentrace_remove_gdprintk_usage_since_they_are_not_in_guest_context.patch
  23094-xentrace_update_comments.patch
  23095-xentrace_use_consistent_printk_prefix.patch
  23128-xentrace_correct_formula_to_calculate_t_info_pages.patch
  23129-xentrace_remove_unneeded_debug_printk.patch
  23173-xentrace_Move_register_cpu_notifier_call_into_boot-time_init..patch
  23239-xentrace_correct_overflow_check_for_number_of_per-cpu_trace_pages.patch
  23308-xentrace_Move_the_global_variable_t_info_first_offset_into_calculate_tbuf_size.patch
  23309-xentrace_Mark_data_size___read_mostly_because_its_only_written_once.patch
  23310-xentrace_Remove_unneeded_cast_when_assigning_pointer_value_to_dst.patch
  23404-xentrace_reduce_trace_buffer_size_to_something_mfn_offset_can_reach.patch
  23405-xentrace_fix_type_of_offset_to_avoid_ouf-of-bounds_access.patch
  23406-xentrace_update___insert_record_to_copy_the_trace_record_to_individual_mfns.patch
  23407-xentrace_allocate_non-contiguous_per-cpu_trace_buffers.patch
  23643-xentrace_Allow_tracing_to_be_enabled_at_boot.patch
  23719-xentrace_update___trace_var_comment.patch
  Remove old patches:
  xen-unstable.xentrace.dynamic_tbuf.patch
  xen-unstable.xentrace.empty_t_info_pages.patch
  xen-unstable.xentrace.verbose.patch
  xen-unstable.xentrace.no_gdprintk.patch
  xen-unstable.xentrace.comments.patch
  xen-unstable.xentrace.printk_prefix.patch
  xen-unstable.xentrace.remove_debug_printk.patch
  xen-unstable.xentrace.t_info_pages-formula.patch
  xen-unstable.xentrace.register_cpu_notifier-boot_time.patch
  xen-unstable.xentrace.t_info_page-overflow.patch
  xen-unstable.xentrace.t_info_first_offset.patch
  xen-unstable.xentrace.data_size__read_mostly.patch
  xen-unstable.xentrace.__insert_record-dst-type.patch
* Mon Nov 14 2011 carnold@novell.com
- Upstream patches from Jan
  24116-x86-continuation-cancel.patch
  24123-x86-cpuidle-quiesce.patch
  24124-x86-microcode-amd-quiesce.patch
  24137-revert-23666.patch
  24xxx-shadow-pgt-dying-op-performance.patch
* Thu Nov 10 2011 carnold@novell.com
- bnc#722738 - xm cpupool-create errors out
  xen-cpupool-xl-config-format.patch
* Fri Nov  4 2011 carnold@novell.com
- Fix broken build when building docs
  23819-make-docs.patch
* Fri Nov  4 2011 jfehlig@suse.com
- bnc#720054 - Prevent vif-bridge from adding user-created tap
  interfaces to a bridge
  2XXXX-vif-bridge.patch
* Fri Nov  4 2011 carnold@novell.com
- bnc#713503 - DOM0 filesystem commit
  23752-x86-shared-IRQ-vector-maps.patch
  23754-AMD-perdev-vector-map.patch
* Thu Nov  3 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  This change reverses the task of xenpaging. Before this change a
  fixed number of pages was paged out. With this change the guest
  will not have access to more than the given number of pages at
  the same time.
  The xenpaging= config option is replaced by actmem=
  A new xm mem-swap-target is added.
  The xenpaging binary is moved to /usr/lib/xen/bin/
  xenpaging.HVMCOPY_gfn_paged_out.patch
  xenpaging.XEN_PAGING_DIR.patch
  xenpaging.add_evict_pages.patch
  xenpaging.bitmap_clear.patch
  xenpaging.cmdline-interface.patch
  xenpaging.encapsulate_domain_info.patch
  xenpaging.file_op-return-code.patch
  xenpaging.guest-memusage.patch
  xenpaging.install-to-libexec.patch
  xenpaging.low_target_policy_nomru.patch
  xenpaging.main-loop-exit-handling.patch
  xenpaging.misleading-comment.patch
  xenpaging.page_in-munmap-size.patch
  xenpaging.print-gfn.patch
  xenpaging.record-numer-paged-out-pages.patch
  xenpaging.reset-uncomsumed.patch
  xenpaging.stale-comments.patch
  xenpaging.target-tot_pages.patch
  xenpaging.use-PERROR.patch
  xenpaging.watch-target-tot_pages.patch
  xenpaging.watch_event-DPRINTF.patch
  xenpaging.xc_interface_open-comment.patch
* Thu Nov  3 2011 ohering@suse.de
- xen.spec: update filelist
  package /usr/lib*/xen with wildcard to pickup new files
  remove duplicate /usr/sbin/xen-list from filelist
* Wed Oct 26 2011 carnold@novell.com
- bnc#725169 - xen-4.0.2_21511_03-0.5.3: bootup hangs
  23993-x86-microcode-amd-fix-23871.patch
* Wed Oct 26 2011 carnold@novell.com
- Update to Xen 4.1.2 FCS c/s 23174
* Mon Oct 24 2011 jfehlig@suse.com
- bnc#720054 - Fix syntax error introduced during recent adjustment
  of Xen's tap udev rule.
  Updated udev-rules.patch
* Thu Oct 20 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  Merge paging related fixes from xen-unstable:
  23506-x86_Disable_set_gpfn_from_mfn_until_m2p_table_is_allocated..patch
  23507-xenpaging_update_machine_to_phys_mapping_during_page_deallocation.patch
  23509-x86_32_Fix_build_Define_machine_to_phys_mapping_valid.patch
  23562-xenpaging_remove_unused_spinlock_in_pager.patch
  23576-x86_show_page_walk_also_for_early_page_faults.patch
  23577-tools_merge_several_bitop_functions_into_xc_bitops.h.patch
  23578-xenpaging_add_xs_handle_to_struct_xenpaging.patch
  23579-xenpaging_drop_xc.c_remove_ASSERT.patch
  23580-xenpaging_drop_xc.c_remove_xc_platform_info_t.patch
  23581-xenpaging_drop_xc.c_remove_xc_wait_for_event.patch
  23582-xenpaging_drop_xc.c_move_xc_mem_paging_flush_ioemu_cache.patch
  23583-xenpaging_drop_xc.c_move_xc_wait_for_event_or_timeout.patch
  23584-xenpaging_drop_xc.c_remove_xc_files.patch
  23585-xenpaging_correct_dropping_of_pages_to_avoid_full_ring_buffer.patch
  23586-xenpaging_do_not_bounce_p2mt_back_to_the_hypervisor.patch
  23587-xenpaging_remove_srand_call.patch
  23588-xenpaging_remove_return_values_from_functions_that_can_not_fail.patch
  23589-xenpaging_catch_xc_mem_paging_resume_errors.patch
  23590-xenpaging_remove_local_domain_id_variable.patch
  23591-xenpaging_move_num_pages_into_xenpaging_struct.patch
  23592-xenpaging_start_paging_in_the_middle_of_gfn_range.patch
  23593-xenpaging_pass_integer_to_xenpaging_populate_page.patch
  23594-xenpaging_add_helper_function_for_unlinking_pagefile.patch
  23595-xenpaging_add_watch_thread_to_catch_guest_shutdown.patch
  23596-xenpaging_implement_stopping_of_pager_by_sending_SIGTERM-SIGINT.patch
  23597-xenpaging_remove_private_mem_event.h.patch
  23599-tools_fix_build_after_recent_xenpaging_changes.patch
  23817-mem_event_add_ref_counting_for_free_requestslots.patch
  23818-mem_event_use_mem_event_mark_and_pause_in_mem_event_check_ring.patch
  23827-xenpaging_use_batch_of_pages_during_final_page-in.patch
  23841-mem_event_pass_mem_event_domain_pointer_to_mem_event_functions.patch
  23842-mem_event_use_different_ringbuffers_for_share_paging_and_access.patch
  23874-xenpaging_track_number_of_paged_pages_in_struct_domain.patch
  23904-xenpaging_use_p2m-get_entry_in_p2m_mem_paging_functions.patch
  23905-xenpaging_fix_locking_in_p2m_mem_paging_functions.patch
  23906-xenpaging_remove_confusing_comment_from_p2m_mem_paging_populate.patch
  23908-p2m_query-modify_p2mt_with_p2m_lock_held.patch
  23943-xenpaging_clear_page_content_after_evict.patch
  23953-xenpaging_handle_evict_failures.patch
  23978-xenpaging_check_p2mt_in_p2m_mem_paging_functions.patch
  23979-xenpaging_document_p2m_mem_paging_functions.patch
  23980-xenpaging_disallow_paging_in_a_PoD_guest.patch
  Remove obsolete patches:
  x86-show-page-walk-early.patch
  xenpaging.23817-mem_event_check_ring.patch
  xenpaging.catch-xc_mem_paging_resume-error.patch
  xenpaging.guest_remove_page.slow_path.patch
  xenpaging.mem_event-no-p2mt.patch
  xenpaging.no-srand.patch
  xenpaging.return-void.patch
  xenpaging.xenpaging_populate_page-gfn.patch
* Thu Oct 20 2011 ohering@suse.de
- xen.spec: use changeset number as patch number for upstream patches
* Wed Oct 19 2011 adrian@suse.de
- do not use runlevel 4 in init scripts, it makes it impossible
  to "insserv xend" on 12.1
* Mon Oct 17 2011 carnold@novell.com
- Upstream patches from Jan
  23955-x86-pv-cpuid-xsave.patch
  23957-cpufreq-error-paths.patch
* Tue Oct 11 2011 carnold@novell.com
- Upstream patches from Jan
  23933-pt-bus2bridge-update.patch
  23726-x86-intel-flexmigration-v2.patch
  23925-x86-AMD-ARAT-Fam12.patch
  23246-x86-xsave-enable.patch
  23897-x86-mce-offline-again.patch
* Mon Oct 10 2011 carnold@novell.com
- Update to Xen 4.1.2_rc3 c/s 23171
* Thu Oct  6 2011 jfehlig@suse.com
- bnc#720054 - Changed /etc/udev/rules.d/40-xen.rules to not run
  Xen's vif-bridge script when not running Xen.  This is not a
  solution to the bug but an improvement in the rules regardless.
  Updated udev-rules.patch
* Tue Oct  4 2011 carnold@novell.com
- Upstream patches from Jan
  23868-vtd-RMRR-validation.patch
  23871-x86-microcode-amd-silent.patch
  23898-cc-option-grep.patch
* Fri Sep 30 2011 jfehlig@suse.com
- Add pciback init script and sysconf file, giving users a simple
  mechanism to configure pciback.
  init.pciback sysconfig.pciback
* Fri Sep 23 2011 ohering@suse.de
- update scripts to use xl -f, or xm if xend is running:
  xen-updown.sh, init.xendomains, xmclone.sh
* Fri Sep 23 2011 ohering@suse.de
- bnc#694863 - kexec fails in xen
  xenstored: allow guest to shutdown all its watches/transactions
  xenstored.XS_RESET_WATCHES.patch
* Thu Sep 22 2011 carnold@novell.com
- Upstream patches from Jan
  23843-scheduler-switch.patch
  23846-x86-TSC-check.patch
  23848-vmx-conditional-off.patch
  23853-x86-pv-cpuid-xsave.patch
* Fri Sep 16 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  mem_event: add ref counting for free requestslots
  xenpaging.23817-mem_event_check_ring.patch
* Wed Sep 14 2011 carnold@novell.com
- bnc#717650 - Unable to start VM
- Update to Xen 4.1.2_rc2 c/s 23152
* Fri Sep  9 2011 jfehlig@suse.com
- bnc#716695 - domUs using tap devices will not start
  updated multi-xvdp.patch
* Tue Sep  6 2011 carnold@novell.com
- Upstream patches from Jan
  23803-intel-pmu-models.patch
  23800-x86_64-guest-addr-range.patch
  23795-intel-ich10-quirk.patch
  23804-x86-IPI-counts.patch
* Wed Aug 31 2011 jfehlig@suse.com
- bnc#706106 - Inconsistent reporting of VM names during migration
  xend-migration-domname-fix.patch
* Tue Aug 30 2011 carnold@novell.com
- bnc#712823 - L3:Xen guest does not start reliable when rebooted
  xend-vcpu-affinity-fix.patch
* Tue Aug 23 2011 carnold@novell.com
- Upstream patches from Jan
  23725-pci-add-device.patch
  23762-iommu-fault-bm-off.patch
  23763-pci-multi-seg-x2apic-vtd-no-crash.patch
  23765-x86-irq-vector-leak.patch
  23766-x86-msi-vf-bars.patch
  23771-x86-ioapic-clear-pin.patch
  23772-x86-trampoline.patch
  23774-x86_64-EFI-EDD.patch
  23776-x86-kexec-hpet-legacy-bcast-disable.patch
  23781-pm-wide-ACPI-ids.patch
  23782-x86-ioapic-clear-irr.patch
  23783-ACPI-set-_PDC-bits.patch
* Mon Aug 15 2011 ohering@suse.de
- Include gcc46 only when its available (>11.4 && >sles11sp1)
* Fri Aug 12 2011 carnold@novell.com
- bnc#711943 - [xl] Fail to create multi-guests with NIC assigned
  23685-libxl-segfault-fix.patch
* Wed Aug 10 2011 jfehlig@suse.com
- libxenlight and legacy xend toolstack should not be used
  together.  If xend is running, print a warning and exit
  xl.  Add a '-f' (force) option to xl to override this
  behavior.
  disable-xl-when-using-xend.patch
  bnc#707664
* Wed Aug 10 2011 carnold@novell.com
- Upstream patches from Jan
  23732-sedf.patch
  23735-guest-dom0-cap.patch
  23746-vtd-cleanup-timers.patch
  23747-mmcfg-base-address.patch
  23749-mmcfg-reservation.patch
* Tue Aug  9 2011 cyliu@novell.com
- bnc#704160 - crm resource migrate fails with xen machines
  update snapshot-xend.patch
- bnc#706574 - xm console DomUName hang after "xm save/restore" of
  PVM on the latest Xen
  xend-console-port-restore.patch
* Tue Aug  9 2011 ohering@suse.de
- update xencommons script to run only when needed
  xencommons-proc-xen.patch
* Fri Jul 22 2011 carnold@novell.com
- Upstream patches from Jan
  23726-x86-intel-flexmigration.patch
  23706-fix-20892.patch
  23723-x86-CMOS-lock.patch
  23676-x86_64-image-map-bounds.patch
  23724-x86-smpboot-x2apic.patch
* Mon Jul 11 2011 ohering@suse.de
- hotplug.losetup.patch
  correct dev:inode detection, stat returns major:minor without
  leading zeros, while losetup -a includes trailing zeros
* Fri Jul  8 2011 cyliu@novell.com
- fate#310635: xen npiv multipath support
  update block-npiv* scripts for testing
* Thu Jul  7 2011 carnold@novell.com
- Fixes for EFI support
  x86-EFI-discard-comment.patch
* Wed Jun 29 2011 carnold@novell.com
- fate#309894: Xen needs to correctly understand family 15h CPU
  topology
- fate#311376: EFI support in SP2
- fate#311529: Native UEFI booting under Xen (installation)
  23074-pfn.h.patch
  23571-vtd-fault-verbosity.patch
  23574-x86-dom0-compressed-ELF.patch
  23575-x86-DMI.patch
  23610-x86-topology-info.patch
  23611-amd-fam15-topology.patch
  23613-EFI-headers.patch
  23614-x86_64-EFI-boot.patch
  23615-x86_64-EFI-runtime.patch
  23616-x86_64-EFI-MPS.patch
* Wed Jun 29 2011 jbeulich@novell.com
- Mark xen-scsi.ko supported (bnc#582265, fate#309459).
* Tue Jun 28 2011 carnold@novell.com
- fate#310308: Hypervisor assisted watchdog driver
  ioemu-watchdog-support.patch
  ioemu-watchdog-linkage.patch
  ioemu-watchdog-ib700-timer.patch
  tools-watchdog-support.patch
* Mon Jun 27 2011 carnold@novell.com
- bnc#702025 - VUL-0: xen: VT-d (PCI passthrough) MSI trap
  injection  (CVE-2011-1898)
  Fixed in Xen version 4.1.1
* Wed Jun 22 2011 cyliu@novell.com
- fate#310956: Support Direct Kernel Boot for FV guests
  kernel-boot-hvm.patch
* Wed Jun 22 2011 cyliu@novell.com
- fate#310316: Support change vnc password while vm is running
  change-vnc-passwd.patch
- fate#310325: Support get domU console log from Dom0
  log-guest-console.patch
* Wed Jun 22 2011 ohering@suse.de
- fate#311487: remove modprobe.conf files for autoloading of Xen
  and Hyper-V drivers
  xen.sles11sp1.fate311487.xen_platform_pci.dmistring.patch
  add dmi modalias to xen-platform-pci.ko
* Tue Jun 21 2011 carnold@novell.com
- fate#308532: [NONCODE] Remove XEN 32-bit Hypervisor
  Modify ExclusiveArch in xen.spec to build only x86_64
* Tue Jun 21 2011 carnold@novell.com
- fate#309900 - Add Xen support for SVM Decode Assist in AMD family
  15h
- fate#309902 - Add Xen support for AMD family 12h processors
- fate#309903 - Add Xen support for AMD family 14h processors
- fate#309906 - Add Xen support for performance event counters in
  AMD family 15h
* Fri Jun 17 2011 carnold@novell.com
- fate#309893: Add Xen support for AMD family 15h processors
- fate#309901: Add Xen support for SVM TSC scaling in AMD family
  15h
- fate#311951: Ivy Bridge: XEN support for Supervisor Mode
  Execution Protection (SMEP)
  23437-amd-fam15-TSC-scaling.patch
  23462-libxc-cpu-feature.patch
  23481-x86-SMEP.patch
  23504-x86-SMEP-hvm.patch
  23505-x86-cpu-add-arg-check.patch
  23508-vmx-proc-based-ctls-probe.patch
  23510-hvm-cpuid-DRNG.patch
  23511-amd-fam15-no-flush-for-C3.patch
  23516-cpuid-ERMS.patch
  23538-hvm-pio-emul-no-host-crash.patch
  23539-hvm-cpuid-FSGSBASE.patch
  23543-x86_64-maddr_to_virt-assertion.patch
  23546-fucomip.patch
* Wed Jun 15 2011 jfehlig@novell.com
- Fix libxc reentrancy issues
  23383-libxc-rm-static-vars.patch
* Wed Jun 15 2011 carnold@novell.com
- fate#310957 - Update to Xen 4.1.1 FCS c/s 23079
* Tue Jun 14 2011 lidongyang@novell.com
- fate#311000 - Extend Xen domain lock framework to support
  more alternative
  xend-domain-lock-sfex.patch
* Mon Jun 13 2011 lidongyang@novell.com
- fate#311371 - Enhance yast to configure live migration for
  Xen and KVM
  add firewall service file for xen-tools
* Fri Jun 10 2011 jfehlig@novell.com
- Add man page for xen-list utility
  updated xen-utils-0.1.tar.bz2
* Thu May 26 2011 carnold@novell.com
- Upstream patches from Jan
  23233-hvm-cr-access.patch
  23234-svm-decode-assist-base.patch
  23235-svm-decode-assist-crs.patch
  23236-svm-decode-assist-invlpg.patch
  23238-svm-decode-assist-insn-fetch.patch
  23303-cpufreq-misc.patch
  23304-amd-oprofile-strings.patch
  23305-amd-fam15-xenoprof.patch
  23306-amd-fam15-vpmu.patch
  23334-amd-fam12+14-vpmu.patch
  23338-vtd-force-intremap.patch
* Thu May 26 2011 carnold@novell.com
- fate#310957 - Update to Xen 4.1.1-rc1 c/s 23064
* Tue May 24 2011 ohering@suse.de
- xentrace: dynamic tracebuffer allocation
  xen-unstable.xentrace.dynamic_tbuf.patch
  xen-unstable.xentrace.empty_t_info_pages.patch
  xen-unstable.xentrace.verbose.patch
  xen-unstable.xentrace.no_gdprintk.patch
  xen-unstable.xentrace.comments.patch
  xen-unstable.xentrace.printk_prefix.patch
  xen-unstable.xentrace.remove_debug_printk.patch
  xen-unstable.xentrace.t_info_pages-formula.patch
  xen-unstable.xentrace.register_cpu_notifier-boot_time.patch
  xen-unstable.xentrace.t_info_page-overflow.patch
  xen-unstable.xentrace.t_info_first_offset.patch
  xen-unstable.xentrace.data_size__read_mostly.patch
  xen-unstable.xentrace.__insert_record-dst-type.patch
* Tue May 24 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  update xenpaging patches for xen 4.1
  xenpaging.guest_remove_page.slow_path.patch
  xenpaging.mem_event-no-p2mt.patch
  xenpaging.no-srand.patch
  xenpaging.return-void.patch
  xenpaging.catch-xc_mem_paging_resume-error.patch
  xenpaging.xenpaging_populate_page-gfn.patch
  xenpaging.autostart.patch
* Fri May 20 2011 carnold@novell.com
- bnc#670465 - When connecting to Xen guest through vncviewer mouse
  tracking is off.
- Upstream patch 23298-hvmop-get-mem-type.patch replaces
  xen.sles11sp1.bug684297.HVMOP_get_mem_type.patch
- Upstream patches from Jan
  23333-hvm-32bit-compat-hypercalls.patch
  23337-vtd-malicious-msi-filter.patch
  23338-vtd-force-intremap.patch (CVE-2011-1898)
  23341-x86-ioapic-write-entry.patch
  23343-vtd-error-path-leaks.patch
* Thu May 19 2011 ohering@suse.de
- bnc#684305 - on_crash is being ignored with kdump now working in HVM
  xend-config-enable-dump-comment.patch
* Thu May 19 2011 ohering@suse.de
- disable xend's logrotation for xend.log, use included logrotate.conf
* Wed May 18 2011 ohering@suse.de
- bnc#684297 - HVM taking too long to dump vmcore
  xen.sles11sp1.bug684297.HVMOP_get_mem_type.patch
  new hvm_op hyper call option
  xen.sles11sp1.bug684297.xen_oldmem_pfn_is_ram.patch
  Use new Xen HVMOP_get_mem_type hvmop hypercall option and new Linux
  kernel register_oldmem_pfn_is_ram interface.
  (depends on two kernel-source changes)
* Tue May 17 2011 carnold@novell.com
- Update to Xen 4.1.1-rc1-pre c/s 23051
* Thu May 12 2011 carnold@novell.com
- Numerous cleanups when compiling with the unused-but-set-variable
  flag enabled and warnings equal to errors.
  xen-warnings-unused.diff
* Thu May 12 2011 jfehlig@novell.com
- Add a 'long' option to xen-list utility
  Updated xen-utils-0.1.tar.bz2
* Tue May 10 2011 jfehlig@novell.com
- bnc#691256 - move modprobe of xen backend modules from xend to
  xencommons initscript
  tmp-initscript-modprobe.patch
* Mon May  9 2011 jfehlig@novell.com
- bnc#691738 - Xen does not find device create with npiv block
  xen-qemu-iscsi-fix.patch
* Tue May  3 2011 carnold@novell.com
- Upstream patches from Jan
  22998-x86-get_page_from_l1e-retcode.patch
  22999-x86-mod_l1_entry-retcode.patch
  23000-x86-mod_l2_entry-retcode.patch
  23096-x86-hpet-no-cpumask_lock.patch
  23099-x86-rwlock-scalability.patch
  23103-x86-pirq-guest-eoi-check.patch
  23127-vtd-bios-settings.patch
  23153-x86-amd-clear-DramModEn.patch
  23154-x86-amd-iorr-no-rdwr.patch
  23199-amd-iommu-unmapped-intr-fault.patch
  23200-amd-iommu-intremap-sync.patch
  23228-x86-conditional-write_tsc.patch
* Tue May  3 2011 carnold@novell.com
- bnc#691238 - L3: question on behaviour change xm list
  snapshot-xend.patch
* Mon May  2 2011 ohering@suse.de
- update xenalyze to revision 98
  * Unify setting of vcpu data type
  * Unify record size checks
  * Fix cr3_switch not to access hvm struct before it's initialized
- add xenalyze.gcc46.patch to fix unused-but-set-variable errors
* Thu Apr 28 2011 jfehlig@novell.com
- bnc#688473 - VUL-0: potential buffer overflow in tools
  cve-2011-1583-4.0.patch
* Thu Apr 28 2011 ohering@suse.de
- hotplug.losetup.patch
  correct dev:inode detection and use variable expansion
* Tue Apr 26 2011 carnold@novell.com
- bnc#623680 - xen kernel freezes during boot when processor module
  is loaded
  23228-x86-conditional-write_tsc.patch
- bnc#680824 - dom0 can't recognize boot disk when IOMMU is enabled
  23200-amd-iommu-intremap-sync.patch
- Upstream patches from Jan
  23127-vtd-bios-settings.patch
  23153-x86-amd-clear-DramModEn.patch
  23154-x86-amd-iorr-no-rdwr.patch
  23199-amd-iommu-unmapped-intr-fault.patch
* Thu Apr 21 2011 ohering@suse.de
- bnc#685189: update vif-route-ifup.patch to use correct variable
  after upstream commit 22910:d4bc41a8cecb
* Wed Apr 20 2011 ohering@suse.de
- bnc#688519: correct indention in xend-domain-lock.patch
* Tue Apr 19 2011 jfehlig@novell.com
- bnc#687981 - L3: mistyping model type when defining VIF crashes
  VM
  xend-validate-nic-model.patch
* Mon Apr 11 2011 jfehlig@suse.de
- bnc#685338: Fix porting of xend-domain-lock.patch
* Mon Apr 11 2011 ohering@suse.de
- update scripts to use xl instead of xm:
  xen-updown.sh, init.xendomains, xmclone.sh
* Mon Apr 11 2011 ohering@suse.de
- disable xend in openSuSE > 11.4
  the xl command is the replacement for the xm command
* Thu Apr  7 2011 ohering@suse.de
- mark runlevel scripts as config to preserve local changes by
  admin or dev during package update
* Thu Apr  7 2011 ohering@suse.de
- enable xencommons runlevel script during upgrade if xend was
  already enabled
* Thu Apr  7 2011 ohering@suse.de
- call /sbin/ldconfig directly in xen-libs post install scripts
* Tue Apr  5 2011 carnold@novell.com
- Upstream patches from Jan
  23103-x86-pirq-guest-eoi-check.patch
  23030-x86-hpet-init.patch
  23061-amd-iommu-resume.patch
  23127-vtd-bios-settings.patch
* Thu Mar 31 2011 coolo@novell.com
- add baselibs.conf as libvirt uses 32bit libraries
* Tue Mar 29 2011 carnold@novell.com
- Remus support is enabled for now.
* Mon Mar 28 2011 carnold@novell.com
- Enable support for kernel decompression for gzip, bzip2, and LZMA
  so that kernels compressed with any of these methods can be
  launched
* Fri Mar 25 2011 carnold@novell.com
- Update to Xen 4.1 FCS
* Thu Mar 24 2011 ohering@suse.de
- fix xentrace.dynamic_sized_tbuf.patch
  the default case did not work, correct size calculation
* Tue Mar 22 2011 carnold@novell.com
- Update to c/s 23010 Xen 4.1 rc8
* Tue Mar 22 2011 ohering@suse.de
- use _smp_mflags instead of jobs, jobs is not expanded everywhere
* Mon Mar 21 2011 carnold@novell.com
- bnc#681302 - xm create -x <guest> returns "ImportError: No module
  named ext"
  xm-create-xflag.patch
* Thu Mar 17 2011 carnold@novell.com
- bnc#675817 - Kernel panic when creating HVM guests on AMD
  platforms with XSAVE
  22462-x86-xsave-init-common.patch
* Tue Mar 15 2011 carnold@novell.com
- bnc#679344 - Xen: multi-vCPU pv guest may crash host
  23034-x86-arch_set_info_guest-DoS.patch
- bnc#678871 - dom0 hangs long time when starting hvm guests with
  memory >= 64GB
  22780-pod-preempt.patch
- bnc#675363 - Random lockups with kernel-xen. Possibly graphics
  related
  22997-x86-map_pages_to_xen-check.patch
- Upstream patches from Jan
  22949-x86-nmi-pci-serr.patch
  22992-x86-fiop-m32i.patch
  22996-x86-alloc_xen_pagetable-no-BUG.patch
  23020-x86-cpuidle-ordering.patch
  23039-csched-constrain-cpu.patch
* Mon Mar 14 2011 jfehlig@novell.com
- Fix xen-utils to cope with xen-unstable c/s 21483
* Mon Mar 14 2011 carnold@novell.com
- bnc#678229 - restore of sles HVM fails
  22873-svm-sr-32bit-sysenter-msrs.patch
* Fri Mar 11 2011 ohering@suse.de
- xz-devel is available since 11.2, make it optional for SLES11SP1
* Mon Feb 28 2011 cyliu@novell.com
- Fix /vm/uuid xenstore leak on tapdisk2 device cleanup
  22499-xen-hotplug-cleanup.patch
* Fri Feb 25 2011 carnold@novell.com
- Upstream patches from Jan
  22872-amd-iommu-pci-reattach.patch
  22879-hvm-no-self-set-mem-type.patch
  22899-x86-tighten-msr-permissions.patch
  22915-x86-hpet-msi-s3.patch
  22947-amd-k8-mce-init-all-msrs.patch
* Thu Feb 17 2011 jfehlig@novell.com
- bnc#672833 - xen-tools bug causing problems with Ubuntu 10.10
  under Xen 4.
  22238-pygrub-grub2-fix.patch
* Thu Feb 17 2011 lidongyang@novell.com
- bnc#665610 - xm console > 1 to same VM messes up both consoles
  Upstream rejected due to portability concern, see
  http://lists.xensource.com/archives/html/xen-devel/2011-02/msg00942.html
  xenconsole-no-multiple-connections.patch
* Fri Feb 11 2011 carnold@novell.com
- Enable support for kernel decompression for gzip, bzip2, and LZMA
  so that kernels compressed with any of these methods can be
  launched.
* Thu Feb 10 2011 lidongyang@novell.com
- bnc#651822 - xm snapshot-xxx scripts lead to an XP SP3 HVM domU
  to chkdsk
  Make sure we only apply the snapshot once, and the changes made
  after snapshot-apply hit the disk.
* Wed Feb  9 2011 carnold@novell.com
- Update to Xen 4.1.0 c/s 22861
* Tue Feb  8 2011 jfehlig@novell.com
- bnc#658569 - SLES 11 SP1 dom0 iptables gives lots of physdev
  messages
  22385-vif-common.patch
* Mon Feb  7 2011 ohering@suse.de
- update xenalyze, more 64bit fixes
* Mon Feb  7 2011 ohering@suse.de
- allocate xentrace buffer metadata based on requested tbuf_size
  xentrace.dynamic_sized_tbuf.patch
* Mon Feb  7 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.runtime_mru_size.patch
  - specify policy mru size at runtime
  xenpaging.no_domain_id.patch
  - reduce memory usage in pager
* Mon Feb  7 2011 ohering@suse.de
- bnc#625394 - set vif mtu from bridge mtu if kernel supports it
  vif-bridge.mtu.patch
* Sun Feb  6 2011 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.autostart_delay.patch
  - decouple create/destroycreateXenPaging from _create/_removeDevices
  - change xenpaging variable from int to str
  - init xenpaging variable to 0 if xenpaging is not in config file
    to avoid string None coming from sxp file
* Tue Feb  1 2011 carnold@novell.com
- Update to Xen 4.0.2 rc2-pre, changeset 21443
* Mon Jan 31 2011 carnold@novell.com
- bnc#633573 - System fail to boot after running several warm
  reboot tests
  22749-vtd-workarounds.patch
- Upstream patches from Jan
  22744-ept-pod-locking.patch
  22777-vtd-ats-fixes.patch
  22781-pod-hap-logdirty.patch
  22782-x86-emul-smsw.patch
  22789-i386-no-x2apic.patch
  22790-svm-resume-migrate-pirqs.patch
  22816-x86-pirq-drop-priv-check.patch
* Thu Jan 27 2011 carnold@novell.com
- Don't pass the deprecataed extid parameter to xc.hvm_build
* Fri Jan 14 2011 carnold@novell.com
- bnc#658704 - SLES11 SP1 Xen boot panic in x2apic mode
  22707-x2apic-preenabled-check.patch
- bnc#641419 - L3: Xen: qemu-dm reports "xc_map_foreign_batch: mmap failed:
  Cannot allocate memory"
  7434-qemu-rlimit-as.patch
- Additional or upstream patches from Jan
  22693-fam10-mmio-conf-base-protect.patch
  22694-x86_64-no-weak.patch
  22708-xenctx-misc.patch
  21432-4.0-cpu-boot-failure.patch
  22645-amd-flush-filter.patch
  qemu-fix-7433.patch
* Wed Jan 12 2011 carnold@novell.com
- Maintain compatibility with the extid flag even though it is
  deprecated for both legacy and sxp config files.
  hv_extid_compatibility.patch
* Wed Jan 12 2011 cyliu@novell.com
- bnc#649209-improve suspend eventchn lock
  suspend_evtchn_lock.patch
* Tue Jan 11 2011 carnold@novell.com
- Removed the hyper-v shim patches in favor of using the upstream
  version.
* Mon Jan 10 2011 carnold@novell.com
- bnc#641419 - L3: Xen: qemu-dm reports "xc_map_foreign_batch: mmap
  failed: Cannot allocate memory"
  qemu-rlimit-as.patch
* Mon Jan 10 2011 cyliu@novell.com
- Upstream c/s 7433 to replace qemu_altgr_more.patch
  7433-qemu-altgr.patch
* Fri Jan  7 2011 jfehlig@novell.com
- bnc#661931 - Fix fd leak in xenstore library
  21344-4.0-testing-xenstore-fd-leak.patch
* Tue Jan  4 2011 carnold@novell.com
- bnc#656369 - g5plus: sles11sp1 xen crash with 8 socket x2apic
  preenabled
  21989-x2apic-resume.patch
  22475-x2apic-cleanup.patch
  22535-x2apic-preenabled.patch
- bnc#658163 - maintenance release - Nehalem system cannot boot
  into xen with maintenance release installed
  22504-iommu-dom0-holes.patch
  22506-x86-iommu-dom0-estimate.patch
- bnc#658704 - SLES11 SP1 Xen boot panic in x2apic mode
  21810-x2apic-acpi.patch
- Upstream patches from Jan
  22470-vlapic-tick-loss.patch
  22484-vlapic-tmcct-periodic.patch
  22526-ept-access-once.patch
  22533-x86-32bit-apicid.patch
  22534-x86-max-local-apic.patch
  22538-keyhandler-relax.patch
  22540-32on64-hypercall-debug.patch
  22549-vtd-map-page-leak.patch
  22574-ept-skip-validation.patch
  22632-vtd-print-entries.patch
* Tue Jan  4 2011 carnold@novell.com
- bnc#661298 - maintenance release candidate - Windows VMs reboot
  too fast, triggering failsafe
  xen-minimum-restart-time.patch
* Tue Jan  4 2011 cyliu@novell.com
- bnc#659070 - Fail to input '|' in en-us keyboard
  qemu_altgr_more.patch
* Tue Dec 28 2010 jfehlig@novell.com
- bnc#659466 - XEN drbd block device type not working on SLES 11 SP1
  20158-revert.patch
* Mon Dec 27 2010 jfehlig@novell.com
- Revert changes made to snapshot-xend.patch and
  snapshot-ioemu-restore.patch made on 2010-11-19.  The changes
  were intended to fix bnc#651822, but testing revealed additional
  changes were needed to completely resolve the bug.  bnc#651822
  will be fixed in a subsequent maintenance release.
* Mon Dec 27 2010 lidongyang@novell.com
- bnc#654543 - PV guest won't unplug the IDE disk created by
  qemu-dm
  a dirty hack, only add the device to drives_table[] if we are FV
  domU, that will be unplugged anyway if a PV driver is loaded
  later.
  ioemu-disable-emulated-ide-if-pv.patch
* Wed Dec 22 2010 cyliu@novell.com 
- Upstream patch to replace xenfb_32bpp.patch
  7426-xenfb-depth.patch
* Tue Dec 21 2010 lidongyang@novell.com
- bnc#651822 make sure we only apply the snapshot once, and the
  changes made after snapshot-apply hit the disk.
  snapshot-xend.patch
  snapshot-without-pv-fix.patch
* Fri Dec 17 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.HVMCOPY_gfn_paged_out.patch
  - remove incorrect and unneeded cleanup from do_memory_op
    subfunctions
  add mainline tag to merged patches
* Thu Dec 16 2010 jfehlig@novell.com
- bnc#613584 - If available, use kpartx '-f' option in domUloader
* Thu Dec 16 2010 jfehlig@novell.com
- bnc#659872 - xend: Do no release domain lock on checkpoint
  operation.
* Tue Dec 14 2010 carnold@novell.com
- Upstream patches from Jan
  22431-p2m-remove-bug-check.patch
  22448-x86_64-gdt-ldt-fault-filter.patch
  22466-x86-sis-apic-bug.patch
  22451-hvm-cap-clobber.patch
  22388-x2apic-panic.patch
  22452-x86-irq-migrate-directed-eoi.patch
* Tue Dec 14 2010 carnold@novell.com
- bnc#658163 - maintenance release - Nehalem system cannot boot
  into xen with maintenance release installed
  iommu-dom0-holes.patch
  x86-iommu-dom0-estimate.patch
* Tue Dec 14 2010 carnold@novell.com
- bnc#659085 - physical host is rebooted with unknown reason
  Regression: Remove the patch 22071-ept-get-entry-lock.patch
* Mon Dec 13 2010 carnold@novell.com
- Removed 7410-qemu-alt-gr.patch and altgr_2.patch.  It causes a
  regression (see bnc#659070)
* Tue Dec  7 2010 ohering@suse.de
- make stubdom build optional
* Tue Dec  7 2010 ohering@suse.de
- pass -j N to stubdom build
* Tue Dec  7 2010 ohering@suse.de
- add xenalzye from http://xenbits.xensource.com/ext/xenalyze.hg
* Tue Dec  7 2010 ohering@suse.de
- hotplug-block-losetup-a.patch
  allow hardlinked blockdevices
- fate#310510 - fix xenpaging
  xenpaging.paging_prep_enomem.patch
  - retry page-in if guest is temporary out-of-memory
  xenpaging.print-arguments.patch
  - print arguments passed to xenpaging
  xenpaging.machine_to_phys_mapping.patch
  - invalidate array during page deallocation
  xenpaging.autostart_delay.patch
  - fold xenpaging.enabled.patch into this patch
  - set xenpaging_delay to 0.0 to start xenpaging right away
* Fri Dec  3 2010 carnold@novell.com
- bnc#654591 - SLES11 SP0->Sp1 regression? (Xen, HVMs, NPIV)
  Fixed xen-qemu-iscsi-fix.patch
* Fri Dec  3 2010 cyliu@novell.com
- blktap2 patch - fix problem that blktap2 device info not cleared
  when block-attach fail.
  blktap2.patch
* Tue Nov 30 2010 carnold@novell.com
- bnc#655438 - Using performance counter in domU on Nehalem cpus
  22417-vpmu-nehalem.patch
- Upstream patches from Jan
  22389-amd-iommu-decls.patch
  22416-acpi-check-mwait.patch
  22431-p2m-remove-bug-check.patch
* Tue Nov 30 2010 carnold@novell.com
- bnc#656245 - VUL-1: hypervisor: application or kernel in any pv
  Xen domain can crash Xen
  x86_64-gdt-ldt-fault-filter.patch
* Mon Nov 29 2010 carnold@novell.com
- bnc#654050 - Python: a crasher bug in pyexpat - upstream patch
  needs backporting
  22235-lxml-validator.patch
* Tue Nov 23 2010 jfehlig@novell.com
- bnc#628729 - Add a small, fast alternative to 'xm list' for
  enumerating active domains.  xen-list is a C program that uses
  libxenstore and libxenctl directly, bypassing the python
  toolstack.
  xen-utils-0.1.tar.bz2
* Mon Nov 22 2010 jfehlig@novell.com
- bnc#628729 - Add a small, fast alternative to 'xm list' for
  enumerating active domains.  xen-list is a C program that uses
  libxenstore and libxenctl directly, bypassing the python
  toolstack.
  xen-utils-0.1.tar.bz2
* Fri Nov 19 2010 lidongyang@novell.com
- bnc#651822 - xm snapshot-xxx scripts lead to an XP SP3 HVM domU
  to chkdsk
  snapshot-xend.patch
  snapshot-ioemu-restore.patch
* Wed Nov 17 2010 carnold@novell.com
- bnc#651957 - Xen: vm-install failed to start
  xenpaging.enabled.patch
* Wed Nov 17 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.signal_handling.patch
  - unlink pagefile in signal handler
* Fri Nov 12 2010 carnold@novell.com
- Upstream patch for python 2.7 compatibility
  22045-python27-compat.patch
* Thu Nov 11 2010 cyliu@novell.com
- bnc#641144 - FV Xen VM running windows or linux cannot write to
  virtual floppy drive
  bdrv_default_rwflag.patch
* Thu Nov 11 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.optimize_p2m_mem_paging_populate.patch
  xenpaging.HVMCOPY_gfn_paged_out.patch
* Thu Nov 11 2010 carnold@novell.com
- bnc#649864 - automatic numa cpu placement of xen conflicts with
  cpupools
  22326-cpu-pools-numa-placement.patch
* Wed Nov 10 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.populate_only_if_paged.patch
  - revert logic, populate needs to happen unconditionally
  xenpaging.p2m_mem_paging_populate_if_p2m_ram_paged.patch
  - invalidate current mfn only if gfn is not in flight or done
  xenpaging.mem_event_check_ring-free_requests.patch
  - print info only if 1 instead of 2 slots are free
  xenpaging.guest_remove_page.patch
  - check mfn before usage in resume function
  xenpaging.machine_to_phys_mapping.patch
  - check mfn before usage in resume function
* Tue Nov  9 2010 jfehlig@novell.com
- bnc#552115 - Remove target discovery in block-iscsi
  modified block-iscsi script
* Mon Nov  8 2010 jfehlig@novell.com
- bnc#649277 - Fix pci passthru in xend interface used by libvirt
  22369-xend-pci-passthru-fix.patch
* Sun Nov  7 2010 lidongyang@novell.com
- bnc#642078 - xm snapshot-create causes qemu-dm to SEGV
  snapshot-without-pv-fix.patch
* Fri Nov  5 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.num_pages_equal_max_pages.patch
* Fri Nov  5 2010 carnold@novell.com
- bnc#647681 - L3: Passthrough of certain PCI device broken after
  SLES 11 to SP1 upgrade
- bnc#650871 - Regression in Xen PCI Passthrough
  22348-vtd-check-secbus-devfn.patch
- Upstream patches from Jan
  22223-vtd-workarounds.patch (bnc#652935)
  22231-x86-pv-ucode-msr-intel.patch
  22232-x86-64-lahf-lm-bios-workaround.patch
  22280-kexec.patch
  22337-vtd-scan-single-func.patch
* Wed Nov  3 2010 carnold@novell.com
- bnc#497149 - SLES11 64bit Xen - SLES11 64bit HVM guest has
  corrupt text console
  stdvga-cache.patch
* Wed Nov  3 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.page_already_populated.patch
  xenpaging.notify_policy_only_once.patch
  xenpaging.guest_remove_page.patch
  xenpaging.machine_to_phys_mapping.patch
  remove xenpaging.memory_op.patch, retry loops are not needed
* Tue Nov  2 2010 carnold@novell.com
- bnc#474789 - xen-tools 3.3 rpm misses pv-grub
- PV-GRUB replaces PyGrub to boot domU images safely: it runs the
  regular grub inside the created domain itself and uses regular
  domU facilities to read the disk / fetch files from network etc.;
  it eventually loads the PV kernel and chain-boots it.
* Wed Oct 27 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.doc.patch
- add /var/lib/xen/xenpaging directory
* Wed Oct 27 2010 ksrinivasan@novell.com
- Some cleanup in the APIC handling code in the HyperV shim.
  hv_apic.patch
* Wed Oct 27 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.memory_op.patch, correct delay handling in retry loop
* Wed Oct 27 2010 cyliu@novell.com
- bnc#640370 - VM graphic console in VNC is corrupted
  xenfb_32bpp.patch
* Fri Oct 22 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.autostart_delay.patch
  delay start of xenpaging 7 seconds for smooth BIOS startup
* Wed Oct 20 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.tools_xenpaging_cleanup.patch
* Wed Oct 20 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.mem_event_check_ring-free_requests.patch
* Wed Oct 20 2010 ohering@suse.de
- install /etc/xen/examples/xentrace_formats.txt to get human readable
  tracedata if xenalyze is not used
* Sun Oct 17 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.autostart_delay.patch
  xenpaging.blacklist.patch
  xenpaging.MRU_SIZE.patch
  remove xenpaging.hacks.patch, realmode works
* Mon Oct 11 2010 carnold@novell.com
- Upstream patches from Jan including fixes for the following bugs
  bnc#583568 - Xen kernel is not booting
  bnc#615206 - Xen kernel fails to boot with IO-APIC problem
  bnc#640773 - Xen kernel crashing right after grub
  bnc#643477 - issues with PCI hotplug/hotunplug to Xen driver domain
  22222-x86-timer-extint.patch
  22214-x86-msr-misc-enable.patch
  22213-x86-xsave-cpuid-check.patch
  22194-tmem-check-pv-mfn.patch
  22177-i386-irq-safe-map_domain_page.patch
  22175-x86-irq-enter-exit.patch
  22174-x86-pmtimer-accuracy.patch
  22160-Intel-C6-EOI.patch
  22159-notify-evtchn-dying.patch
  22157-x86-debug-key-i.patch
* Mon Oct 11 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.signal_handling.patch
  xenpaging.autostart.patch
  xenpaging.hacks.patch
* Mon Oct 11 2010 ohering@suse.de
- rename xenpaging.XENMEM_decrease_reservation.patch
  to xenpaging.memory_op.patch
* Fri Oct  8 2010 cyliu@novell.com
- bnc#632956 - fix VNC altgr-insert behavior
  7410-qemu-alt-gr.patch
  altgr_2.patch
* Thu Oct  7 2010 jfehlig@novell.com
- bnc#618087 - VNC view won't stay connected to fully virtualized
  Linux Xen VMs
  modified ioemu-vnc-resize.patch
* Tue Oct  5 2010 carnold@novell.com
- bnc#639546 - Dom-U deleted after introduction of the parameter
  "change_home_server False" in the VM configuration
  change_home_server.patch
* Mon Oct  4 2010 jfehlig@novell.com
- bnc#641859 - block-dmmd script does not handle the configuration
  when only MD is used
  modified block-dmmd script
* Thu Sep 30 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.populate_only_if_paged.patch
* Mon Sep 27 2010 carnold@novell.com
- bnc#640773 - Xen kernel crashing right after grub
  21894-intel-unmask-cpuid.patch
- Upstream patch from Jan
  22148-serial-irq-dest.patch
* Thu Sep 23 2010 cyliu@novell.com
- bnc#628719 - improve check_device_status to handle HA cases
  check_device_status.patch
* Thu Sep 23 2010 cyliu@novell.com
- bnc#628719 - multi-xvdp
  mutli-xvdp.patch
* Wed Sep 22 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.XENMEM_decrease_reservation.patch
  xenpaging.xenpaging_init.patch
  xenpaging.policy_linear.patch
* Mon Sep 20 2010 cyliu@novell.com
- bnc#632956 - fix VNC altgr-insert behavior
  7410-qemu-alt-gr.patch
  altgr_2.patch
* Fri Sep 17 2010 ohering@suse.de
- fate#310510 - fix xenpaging
  xenpaging.pageout_policy.patch
  xenpaging.xs_daemon_close.patch
  xenpaging.pagefile.patch
  xenpaging.mem_paging_tool_qemu_flush_cache.patch
  xenpaging.get_paged_frame.patch
  xenpaging.notify_via_xen_event_channel.patch
* Mon Sep 13 2010 carnold@novell.com
- bnc#636231 - XEN: Unable to disconnect/remove CDROM drive from VM
  xend-devid-or-name.patch
* Mon Sep 13 2010 carnold@novell.com
- Upstream patches from Jan
  22019-x86-cpuidle-online-check.patch
  22051-x86-forced-EOI.patch
  22067-x86-irq-domain.patch
  22068-vtd-irte-RH-bit.patch
  22071-ept-get-entry-lock.patch
  22084-x86-xsave-off.patch
* Mon Sep 13 2010 carnold@novell.com
- bnc#638465 - hypervisor panic in memory handling
  22135-heap-lock.patch
* Fri Sep 10 2010 carnold@novell.com
- Update to Xen 4.0.1.  This is a bug fix release.
* Thu Sep  9 2010 jfehlig@novell.com
- bnc#635380 - Fix pygrub Grub2 support
  See update to Xen 4.0.1 for fixes
* Fri Aug 27 2010 cyliu@novell.com
- bnc#628701 - Improve performance when activate/deactivate dmmd
  devices
  modified block-dmmd script
* Wed Aug 25 2010 jfehlig@novell.com
- bnc#628701 - Fix qemu-dm handling of dmmd devices
  modified xen-qemu-iscsi-fix.patch
* Mon Aug 16 2010 carnold@novell.com
- bnc#626262 - Populate-on-demand memory problem on xen with hvm
  guest
  21971-pod-accounting.patch
* Mon Aug 16 2010 cyliu@novell.com
- bnc#584204 - xm usb-list broken
  usb-list.patch
* Thu Aug 12 2010 carnold@novell.com
- bnc#625520 - TP-L3: NMI cannot be triggered for xen kernel
  21926-x86-pv-NMI-inject.patch
* Mon Aug  9 2010 carnold@novell.com
- bnc#613529 - TP-L3: kdump kernel hangs when crash was initiated
  from xen kernel
  21886-kexec-shutdown.patch
* Mon Aug  2 2010 carnold@novell.com
- Upstream Intel patches to improve X2APIC handling.
  21716-iommu-alloc.patch
  21717-ir-qi.patch
  21718-x2apic-logic.patch
* Tue Jul 27 2010 jfehlig@novell.com
- bnc#623833 - Error in Xend-API method VM_set_actions_after_crash
  21866-xenapi.patch
* Tue Jul 27 2010 jfehlig@novell.com
- bnc#625003 - Fix vm config options coredump-{restart,destroy}
  Added hunk to xm-create-xflag.patch
* Mon Jul 26 2010 jfehlig@novell.com
- bnc#605186 - Squelch harmless error messages in block-iscsi
* Mon Jul 26 2010 jfehlig@novell.com
- bnc#623438 - Add ability to control SCSI device path scanning
  in xend
  21847-pscsi.patch
* Mon Jul 26 2010 carnold@novell.com
- Enable the packaging of create.dtd.  This is needed for when xm
  is configured to use xenapi.
* Wed Jul 21 2010 carnold@novell.com
- bnc#624285 - TP-L3: xen rdtsc emulation reports wrong frequency
  21445-x86-tsc-handling-cleanups-v2.patch
* Tue Jul 20 2010 carnold@novell.com
- bnc#623201 - drbd xvd will fail in new xen4 packages due to wrong
  popen2 arguments in blkif.py
  popen2-argument-fix.patch
* Thu Jul  8 2010 carnold@novell.com
- bnc#620694 - Xen yast vm-install for existing paravirtualized
  disk fails with UnboundLocalError: local variable 'dev_type'
  referenced before assignment
  21678-xend-mac-fix.patch
* Wed Jul  7 2010 carnold@novell.com
- bnc#586221 - cannot add DomU with USB host controller defined
  domu-usb-controller.patch (Chun Yan Liu)
* Tue Jul  6 2010 carnold@novell.com
- Upstream patches from Jan
  21151-trace-bounds-check.patch
  21627-cpuidle-wrap.patch
  21643-vmx-vpmu-pmc-offset.patch
  21682-trace-buffer-range.patch
  21683-vtd-kill-timer-conditional.patch
  21693-memevent-64bit-only.patch
  21695-trace-t_info-readonly.patch
  21698-x86-pirq-range-check.patch
  21699-p2m-query-for-type-change.patch
  21700-32on64-vm86-gpf.patch
  21705-trace-printk.patch
  21706-trace-security.patch
  21712-amd-osvw.patch
  21744-x86-cpufreq-range-check.patch
  21933-vtd-ioapic-write.patch
  21953-msi-enable.patch
* Fri Jun 25 2010 jsong@novell.com
- bnc#599550 - Xen cannot distinguish the status of 'pause'
  21723-get-domu-state.patch
* Tue Jun 22 2010 jfehlig@novell.com
- bnc#604611 - Do not store vif device details when vif config
  contains invalid mac address.
  21653-xend-mac-addr.patch
* Wed Jun 16 2010 carnold@novell.com
- linux pvdrv: generalize location of autoconf.h
  Fixes error because of missing autoconf.h when building os11.2
  Factory.
* Mon Jun 14 2010 carnold@novell.com
- bnc#609153 - xm migrate <domain_name> localhost -l fails on
  Windows VMs
  21615-dont-save-xen-heap-pages.patch
- Upstream fixes from Jan
  21446-iommu-graceful-generic-fail.patch
  21453-shadow-avoid-remove-all-after-teardown.patch
  21456-compat-hvm-addr-check.patch
  21492-x86-pirq-unbind.patch
  21526-x86-nehalem-cpuid-mask.patch
  21620-x86-signed-domain-irq.patch
* Mon Jun  7 2010 carnold@novell.com
- bnc#612189 - Clear APIC Timer Initial Count Register when masking
  timer interrupt
  21542-amd-erratum-411.patch
* Fri Jun  4 2010 carnold@novell.com
- bnc#610658 - XEN: PXE boot fails for fully virtualized guests -
  e1000 virtual nic. (see also bnc#484778)
  enable_more_nic_pxe.patch
* Tue May 25 2010 carnold@novell.com
- bnc#608191 - /var/adm/fillup-templates/sysconfig.xend from
  package xen-tools is no valid sysconfig file
  xend-sysconfig.patch
* Tue May 25 2010 carnold@novell.com
- bnc#608194 - /etc/xen/* config files are not packaged with
  noreplace
* Tue May 25 2010 carnold@novell.com
- bnc#569744 - SLE HVM guest clock/timezone is incorrect after
  reboot
  21460-xend-timeoffset.patch
* Tue May 25 2010 jfehlig@novell.com
- bnc#606882 - Allow spaces in vbd path names
  21459-block-script.patch
* Mon May 24 2010 jsong@novell.com
- bnc#591799 - The status of Caps Lock is incorrect in domU
  capslock_enable.patch
* Thu May 20 2010 carnold@novell.com
-  Upstream fixes from Jan including a fix for Intel's ATS issue
  21435-vmx-retain-global-controls.patch
  21406-x86-microcode-quiet.patch
  21421-vts-ats-enabling.patch
* Wed May 19 2010 carnold@novell.com
- bnc#607219 - AMD Erratum 383 workaround for Xen
  21408-amd-erratum-383.patch
* Wed May 19 2010 carnold@novell.com
- Added modprobe of evtchn to init.xend.  The kernel will also need
  to build evtchn as a module for this to be meaningful.
* Mon May 17 2010 carnold@novell.com
- bnc#603008 - On an 8 Socket Nehalem-EX system, the fix for 593536
  causes a hang during network setup.
- Upstream patches from Jan.
  21360-x86-mce-polling-disabled-init.patch
  21372-x86-cross-cpu-wait.patch
  21331-svm-vintr-during-nmi.patch
  21333-xentrace-t_info-size.patch
  21340-vtd-dom0-mapping-latency.patch
  21346-x86-platform-timer-wrap.patch
  21373-dummy-domain-io-caps.patch
* Wed May 12 2010 carnold@novell.com
- bnc#605182 - /etc/xen/scripts/xen-hotplug-cleanup: line 24: [:
  !=: unary operator expected
  21129-xen-hotplug-cleanup.patch
* Mon May 10 2010 carnold@novell.com
- bnc#599929 - Hot add/remove Kawela NIC device over 500 times will
  cause guest domain crash
  passthrough-hotplug-segfault.patch
* Fri May  7 2010 jfehlig@novell.com
- bnc#603583 - Fix migration of domUs using tapdisk devices
  21317-xend-blkif-util-tap2.patch
  suse-disable-tap2-default.patch
* Thu May  6 2010 carnold@novell.com
- Match upstreams cpu pools switch from domctl to sysctl
- Upstream replacements for two of our custom patches (to ease
  applying further backports)
- Fixed dump-exec-state.patch (could previously hang the system, as
  could - with lower probability - the un-patched implementation)
* Wed May  5 2010 carnold@novell.com
- bnc#593536 - xen hypervisor takes very long to initialize Dom0 on
  128 CPUs and 256Gb
  21272-x86-dom0-alloc-performance.patch
  21266-vmx-disabled-check.patch
  21271-x86-cache-flush-global.patch
* Tue May  4 2010 carnold@novell.com
- bnc#558815 - using multiple npiv luns with same wwpn/wwnn broken
- bnc#601104 - Xen /etc/xen/scripts/block-npiv script fails when
  accessing multiple disks using NPIV
  block-npiv
* Fri Apr 30 2010 carnold@novell.com
- bnc#595124 - VT-d can not be enabled on 32PAE Xen on Nehalem-EX
  platform
  21234-x86-bad-srat-clear-pxm2node.patch
  bnc#585371 - kdump fails to load with xen: locate_hole failed
  21235-crashkernel-advanced.patch
* Thu Apr 29 2010 carnold@novell.com
- bnc#588918 - Attaching a U-disk to domain's failed by
  "xm usb-attach"
  init.xend
* Wed Apr 21 2010 jfehlig@novell.com
- bnc#596442 - Preserve device config on domain start failure
  xend-preserve-devs.patch
* Tue Apr 20 2010 jfehlig@novell.com
- bnc#597770 - insserv reports a loop between xendomains and
  openais.  Remove openais from Should-Start in xendomains script.
* Fri Apr 16 2010 jfehlig@novell.com
- bnc#569194 - Tools-side fixes for tapdisk protocol specification
  blktap-script.patch
  ioemu-subtype.patch
  Modified xen-domUloader.diff
* Wed Apr 14 2010 carnold@novell.com
- Upstream bug fixes from Jan
  21089-x86-startup-irq-from-setup-gsi.patch
  21109-x86-cpu-hotplug.patch
  21150-shadow-race.patch
  21160-sysctl-debug-keys.patch
* Fri Apr  9 2010 jfehlig@novell.com
- Updated to Xen 4.0.0 FCS, changeset 21091
* Tue Apr  6 2010 jfehlig@novell.com
- Change default lock dir (when domain locking is enabled) to
  /var/lib/xen/images/vm_locks
- Support SXP config files in xendomains script
* Wed Mar 31 2010 carnold@novell.com
- Update to changeset 21087 Xen 4.0.0 RC9.
* Fri Mar 26 2010 carnold@novell.com
- Update to changeset 21075 Xen 4.0.0 RC8.
* Thu Mar 25 2010 jsong@novell.com
- bnc#584210 - xm usb-hc-destroy does not remove entry from xend
  del_usb_xend_entry.patch
* Tue Mar 23 2010 carnold@novell.com
- Update to changeset 21057 Xen 4.0.0 RC7.
* Wed Mar 17 2010 jsong@novell.com
-Fix bnc#466899 - numa enabled xen fails to start/create vms
  adjust_vcpuaffinity_more_cpu.patch
* Tue Mar  9 2010 carnold@novell.com
- Update to changeset 21022 Xen 4.0.0 RC6.
* Tue Mar  9 2010 carnold@novell.com
- bnc#586510 - cpupool fixes
  cpu-pools-update.patch
* Fri Mar  5 2010 carnold@novell.com
- bnc#582645 - Xen stuck, mptbase driver attempting to reset config
  request
* Mon Mar  1 2010 carnold@novell.com
- Update to changeset 20990 Xen 4.0.0 RC5.
* Mon Feb 22 2010 jfehlig@novell.com
- bnc#556939 - Improve device map cleanup code in domUloader
* Sun Feb 21 2010 jfehlig@novell.com
- bnc# 578910 - xm block-detach does not cleanup xenstore
  hotplug-cleanup-fix.patch
* Fri Feb 19 2010 carnold@novell.com
- bnc#579361 - Windows Server 2003 cannot wake up from stand by in
  sp1
  hibernate.patch
* Fri Feb 19 2010 carnold@novell.com
- fate#308852: XEN CPU Pools
  cpupools-core.patch
  cpupools-core-fixup.patch
  keyhandler-alternative.patch
  cpu-pools-libxc.patch
  cpu-pools-python.patch
  cpu-pools-libxen.patch
  cpu-pools-xmtest.patch
  cpu-pools-docs.patch
* Thu Feb 18 2010 ksrinivasan@novell.com
- bnc#558760: Disable scsi devices when PV drivers are loaded.
* Tue Feb 16 2010 carnold@novell.com
- Update to changeset 20951 Xen 4.0.0 RC4 for sle11-sp1 beta5.
* Mon Feb  8 2010 carnold@novell.com
- bnc#572146 - SLES11 SP1 beta 2 Xen - BUG: soft lockup - CPU#31
  stuck for 61s! [kstop/31:4512]
  cpuidle-hint-v3.patch
* Fri Feb  5 2010 carnold@novell.com
- Update to changeset 20900 RC2+ for sle11-sp1 beta4.
* Fri Jan 29 2010 carnold@novell.com
- bnc#573376 - OS reboot while create DomU with Windows CD
* Wed Jan 27 2010 carnold@novell.com
- bnc#573881 - /usr/lib64/xen/bin/qemu-dm is a broken link
* Thu Jan 21 2010 carnold@novell.com
- Update to changeset 20840 RC1+ for sle11-sp1 beta3.
* Thu Jan 21 2010 jfehlig@novell.com
- bnc#569581 - SuSEfirewall2 should handle rules.  Disable
  handle_iptable in vif-bridge script
  vif-bridge-no-iptables.patch
* Wed Jan 20 2010 carnold@novell.com
- bnc#569577 - /etc/modprove.d/xen_pvdrivers, installed by
  xen-kmp-default, to ../xen_pvdrivers.conf
* Wed Jan  6 2010 ksrinivasan@novell.com
- bnc#564406 - Make the new PV drivers work with older hosts that
  do not understand the new PV driver protocol.
* Fri Dec 11 2009 carnold@novell.com
- Upstream Xen version renamed to 4.0.0 in changeset 20624 & 20625.
* Wed Dec  9 2009 carnold@novell.com
- fate#307594: HP-MCBS: XEN: support NR_CPUS=256
  This is a spec file change (xen.spec)
* Thu Dec  3 2009 carnold@novell.com
- bnc#555152 - "NAME" column in xentop (SLES11) output limited to
  10 characters unlike SLES10
  The update to c/s 20572 includes this fix (at c/s 20567).
* Tue Dec  1 2009 wkong@novell.com
- Modify xen-paths.diff
* Tue Dec  1 2009 wkong@novell.com
- Merge xend-tap-fix.patch to xen-domUloader.diff
  remove part of it which accepted by upstream
* Tue Dec  1 2009 jfehlig@novell.com
- Load gntdev module in xend init script similar to blkbk,
  netbk, etc.
* Thu Nov 26 2009 wkong@novell.com
- Backport dmmd from sles11/xen
  block-dmmd
  xen-qemu-iscsi-fix.patch
  xen.spec
* Thu Nov 26 2009 wkong@novell.com
- Fix regression when create_vbd for tap
  xend-tap-fix.patch
* Tue Nov 24 2009 carnold@novell.com
- Temporarily disable libxl because of libconfig dependency.
* Thu Nov 19 2009 wkong@novell.com
- fate#302864 domUloader support lvm in disk
  domUloader.py
  Note: for test in Beta1, if not good, remove it
* Thu Nov 19 2009 wkong@novell.com
- fate#302864 domUloader support fs on whole disk
  domUloader.py
* Fri Nov  6 2009 carnold@suse.de
- Turn KMPs back on now that kernel side fix is checked in.
* Tue Oct 20 2009 jfehlig@novell.com
- fate#304415 VMM: ability to switch networking mode
  Add vif-route-ifup to handle routed configurations using
  sysconfig scripts.
  vif-route-ifup.patch
* Mon Oct 19 2009 jsong@novell.com
- fate#307540 USB for Xen VMs
  usb-add.patch
* Mon Oct 19 2009 jsong@novell.com
- fate#305545 XEN extra descriptive field within xenstore
  add_des.patch
* Mon Oct 12 2009 carnold@novell.com
- Update to Xen version 3.5.0 for the following features.
  fate#304226 XEN: FlexMigration feature of VT-x2 support
  fate#305004 Add SR-IOV PF and VF drivers to Vt-d enabled Xen
  fate#306830 T states in Xen controlling by MSR
  fate#306832 Fix for xen panic on new processors
  fate#306833 Westmere and Nehalem-EX: Add support for Pause Loop exiting feature for Xen
  fate#306835 Xen: server virtual power management enhacement
  fate#306837 VT-d2 - PCI SIG ATS support
  fate#306872 Xen: Node manager support P/T-states change when Vt-d enable
  fate#306873 Xen: SMP guest live migration may fail with hap=1 on NHM
  fate#306875 Westmere: LT-SX (Xen)
  fate#306891 RAS features for Xen: Add support for Machine Check and CPU/Memory online/offline features
  fate#307322 1GB page support in Xen
  fate#307324 Xen IOMMU support
* Fri Oct  9 2009 carnold@novell.com
- bnc#541945 - xm create -x command does not work in SLES 10 SP2 or
  SLES 11
  xm-create-xflag.patch
* Thu Oct  8 2009 jfehlig@novell.com
- Minor enhancement to xen-updown.sh sysconfig hook
* Mon Sep 28 2009 wkong@novell.com
- Add patch ioemu-bdrv-open-CACHE_WB.patch
  for install guest on tapdisk very very slow.
* Fri Sep 25 2009 jfehlig@novell.com
- Add temporary workaround for race between xend writing and
  qemu-dm reading from xenstore.  The issue is preventing PV
  domUs from booting as they have no backend console.
  qemu-retry-be-status.patch
- bnc#520234 - npiv does not work with XEN
  Update block-npiv
- bnc#496033 - Support for creating NPIV ports without starting vm
  block-npiv-common.sh
  block-npiv-vport
  Update block-npiv
- bnc#500043 - Fix access to NPIV disk from HVM vm
  Update xen-qemu-iscsi-fix.patch
* Tue Sep 15 2009 jfehlig@novell.com
- bnc#513921 - Xen doesn't work get an eror when starting the
  install processes or starting a pervious installed DomU
  20125-xc-parse-tuple-fix.patch
* Wed Sep  2 2009 carnold@novell.com
- bnc#536176 - Xen panic when using iommu after updating hypervisor
  19380-vtd-feature-check.patch
* Fri Aug 28 2009 jfehlig@novell.com
- bnc#530959 - virsh autostart doesn't work
  Fixing this libvirt bug also required fixing xend's op_pincpu
  method with upstream c/s 19580
  19580-xend-pincpu.patch
* Fri Aug 28 2009 jbeulich@novell.com
- bnc#534146 - Xen: Fix SRAT check for discontig memory
  20120-x86-srat-check-discontig.patch
* Mon Aug 24 2009 carnold@novell.com
- bnc#491081 - Xen time goes backwards x3950M2
  20112-x86-dom0-boot-run-timers.patch
* Mon Aug 10 2009 ro@suse.de
- disable module build for ec2 correctly to fix build
  (at the suse_kernel_module_package macro)
* Mon Aug 10 2009 ksrinivasan@novell.com
- bnc#524071 - implemented workaround for a windows7 bug.
  hv_win7_eoi_bug.patch
* Mon Aug  3 2009 jfehlig@novell.com
- bnc#524180 - xend memory leak resulting in long garbage collector
    runs
  20013-xend-memleak.patch
* Fri Jul 31 2009 carnold@novell.com
- Upstream bugfixes from Jan.
  19896-32on64-arg-xlat.patch
  19960-show-page-walk.patch
  19945-pae-xen-l2-entries.patch
  19953-x86-fsgs-base.patch
  19931-gnttblop-preempt.patch
  19885-kexec-gdt-switch.patch
  19894-shadow-resync-fastpath-race.patch
- hvperv shim patches no longer require being applied conditionally
* Wed Jul 29 2009 jfehlig@novell.com
- bnc#520234 - npiv does not work with XEN in SLE11
  Update block-npiv
- bnc#496033 - Support for creating NPIV ports without starting vm
  block-npiv-common.sh
  block-npiv-vport
  Update block-npiv
- bnc#500043 - Fix access to NPIV disk from HVM vm
  Update xen-qemu-iscsi-fix.patch
* Wed Jul 15 2009 carnold@novell.com
- Don't build the KMPs for the ec2 kernel.
* Thu Jul  2 2009 jfehlig@novell.com
- Upstream fixes from Jan Beulich
  19606-hvm-x2apic-cpuid.patch
  19734-vtd-gcmd-submit.patch
  19752-vtd-srtp-sirtp-flush.patch
  19753-vtd-reg-write-lock.patch
  19764-hvm-domain-lock-leak.patch
  19765-hvm-post-restore-vcpu-state.patch
  19767-hvm-port80-inhibit.patch
  19768-x86-dom0-stack-dump.patch
  19770-x86-amd-s3-resume.patch
  19801-x86-p2m-2mb-hap-only.patch
  19815-vtd-kill-correct-timer.patch
- Patch from Jan Beulich to aid in debugging bnc#509911
  gnttblop-preempt.patch
* Tue Jun 23 2009 wkong@novell.com
- bnc#515220 - qemu-img-xen snapshot Segmentation fault
  qemu-img-snapshot.patch update
* Tue Jun  9 2009 wkong@novell.com
- bnc#504491 - drop write data when set read only disk in xen config
  bdrv_open2_fix_flags.patch
  bdrv_open2_flags_2.patch
* Fri Jun  5 2009 carnold@novell.com
- Upstream fixes from Jan Beulich.
  19474-32on64-S3.patch
  19490-log-dirty.patch
  19492-sched-timer-non-idle.patch
  19493-hvm-io-intercept-count.patch
  19505-x86_64-clear-cr1.patch
  19519-domctl-deadlock.patch
  19523-32on64-restore-p2m.patch
  19555-ept-live-migration.patch
  19557-amd-iommu-ioapic-remap.patch
  19560-x86-flush-tlb-empty-mask.patch
  19571-x86-numa-shift.patch
  19578-hvm-load-ldt-first.patch
  19592-vmx-exit-reason-perfc-size.patch
  19595-hvm-set-callback-irq-level.patch
  19597-x86-ioport-quirks-BL2xx.patch
  19602-vtd-multi-ioapic-remap.patch
  19631-x86-frametable-map.patch
  19653-hvm-vcpuid-range-checks.patch
* Fri Jun  5 2009 jsong@novell.com
- bnc#382112 - Caps lock not being passed to vm correctly.
  capslock_enable.patch
* Wed May 27 2009 jfehlig@novell.com
- bnc#506833 - Use pidof in xend and xendomains init scripts
* Wed May 27 2009 jsong@novell.com
- bnc#484778 - XEN: PXE boot of FV domU using non-Realtek NIC fails
  enable_more_nic_pxe.patch
* Wed May 27 2009 jsong@novell.com
  cross-migrate.patch
- bnc#390961 - cross-migration of a VM causes it to become
  unresponsive (remains paused after migration)
* Tue May 19 2009 carnold@novell.com
- Patches taken to fix the xenctx tool. The fixed version of this
  tool is needed to debug bnc#502735.
  18962-xc_translate_foreign_address.patch
  18963-xenctx.patch
  19168-hvm-domctl.patch
  19169-remove-declare-bitmap.patch
  19170-libxc.patch
  19171-xenctx.patch
  19450-xc_translate_foreign_address.patch
* Mon May 18 2009 wkong@novell.com
-bnc#485770 - check exsit file for save and snapshot-create
  xm-save-check-file.patch
  snapshot-xend.patch
* Mon May 18 2009 wkong@novell.com
-bnc#503782 - Using converted vmdk image does not work
  ioemu-tapdisk-compat-QEMU_IMG.patch
* Thu May 14 2009 jfehlig@novell.com
- bnc#503332 - Remove useless qcow tools
  /usr/sbin/{qcow-create,img2qcow,qcow2raw} from xen-tools package.
* Wed May 13 2009 jsong@novell.com
- bnc#474738 - adding CD drive to VM guest makes it unbootable.
  parse_boot_disk.patch
* Mon May 11 2009 wkong@novell.com
- bnc#477892 - snapshot windows can't accomplish.
  snapshot-xend.patch
* Tue Apr 28 2009 carnold@novell.com
- bnc#495300 - L3: Xen unable to PXE boot Windows based DomU's
  18545-hvm-gpxe-rom.patch, 18548-hvm-gpxe-rom.patch
* Mon Apr 27 2009 jfehlig@novell.com
- bnc#459836 - Fix rtc_timeoffset when localtime=0
  xend-timeoffset.patch
* Wed Apr 22 2009 carnold@novell.com
- bnc#497440 - xmclone.sh script incorrectly handles networking for
  SLE11.
* Fri Apr 17 2009 wkong@novell.com
- bnc#477890 - VM becomes unresponsive after applying snapshot
* Wed Apr 15 2009 jfehlig@novell.com
- bnc#494892 - Update xend-domain-lock.patch to flock the lock
    file.
* Wed Apr  8 2009 ksrinivasan@novell.com
- bnc#439639 - SVVP Test 273 System - Sleep Stress With IO" fails
  Turned off s3/s4 sleep states for HVM guests.
* Tue Apr  7 2009 jsong@novell.com
- bnc#468169 - fix domUloader to umount the mounted device mapper target in dom0
    when install a sles10 guest with disk = /dev/disk/by_path
* Thu Apr  2 2009 jfehlig@novell.com
- bnc#488490 - domUloader can't handle block device names with ':'
- bnc#486244 - vms fail to start after reboot when using qcow2
* Tue Mar 31 2009 carnold@novell.com
- bnc#490835 - VTd errata on Cantiga chipset
  19230-vtd-mobile-series4-chipset.patch
* Mon Mar 30 2009 carnold@novell.com
- bnc#482515 - Missing dependency in xen.spec
* Thu Mar 26 2009 carnold@novell.com
- Additional upstream bug fix patches from Jan Beulich.
  19132-page-list-mfn-links.patch
  19134-fold-shadow-page-info.patch
  19135-next-shadow-mfn.patch
  19136-page-info-rearrange.patch
  19156-page-list-simplify.patch
  19161-pv-ldt-handling.patch
  19162-page-info-no-cpumask.patch
  19216-msix-fixmap.patch
  19268-page-get-owner.patch
  19293-vcpu-migration-delay.patch
  19391-vpmu-double-free.patch
  19415-vtd-dom0-s3.patch
* Wed Mar 25 2009 carnold@novell.com
- Imported numerous upstream bug fix patches.
  19083-memory-is-conventional-fix.patch
  19097-M2P-table-1G-page-mappings.patch
  19137-lock-domain-page-list.patch
  19140-init-heap-pages-max-order.patch
  19167-recover-pat-value-s3-resume.patch
  19172-irq-to-vector.patch
  19173-pci-passthrough-fix.patch
  19176-free-irq-shutdown-fix.patch
  19190-pciif-typo-fix.patch
  19204-allow-old-images-restore.patch
  19232-xend-exception-fix.patch
  19239-ioapic-s3-suspend-fix.patch
  19240-ioapic-s3-suspend-fix.patch
  19242-xenstored-use-after-free-fix.patch
  19259-ignore-shutdown-deferrals.patch
  19266-19365-event-channel-access-fix.patch
  19275-19296-schedular-deadlock-fixes.patch
  19276-cpu-selection-allocation-fix.patch
  19302-passthrough-pt-irq-time-out.patch
  19313-hvmemul-read-msr-fix.patch
  19317-vram-tracking-fix.patch
  19335-apic-s3-resume-error-fix.patch
  19353-amd-migration-fix.patch
  19354-amd-migration-fix.patch
  19371-in-sync-L1s-writable.patch
  19372-2-on-3-shadow-mode-fix.patch
  19377-xend-vnclisten.patch
  19400-ensure-ltr-execute.patch
  19410-virt-to-maddr-fix.patch
* Mon Mar  9 2009 jfehlig@novell.com
- bnc#483565 - Fix block-iscsi script.
  Updated block-iscsi and xen-domUloader.diff
* Mon Mar  9 2009 carnold@novell.com
- bnc#465814 - Mouse stops responding when wheel is used in Windows
  VM.
  mouse-wheel-roll.patch (James Song)
- bnc#470704 - save/restore of windows VM throws off the mouse
  tracking.
  usb-save-restore.patch (James Song)
* Thu Mar  5 2009 jfehlig@novell.com
- bnc#436629 - Use global vnc-listen setting specified in xend
  configuration file.
  xend-vnclisten.patch
- bnc#482623 - Fix pygrub to append user-supplied 'extra' args
  to kernel args.
  19234_pygrub.patch
* Thu Mar  5 2009 carnold@novell.com
- bnc#481161 upgrade - sles10sp2 to sles11 upgrade keeps
  xen-tools-ioemu
* Tue Mar  3 2009 kukuk@suse.de
- Don't load 8139* driver if xen-vnif works [bnc#480164]
* Fri Feb 27 2009 carnold@novell.com
- bnc#480164 - Default network proposal in fully virtualized
  SLES 11 VM is invalid.
  xen_pvdrivers
* Thu Feb 26 2009 carnold@novell.com
- bnc#474822 - L3: Win2003 i386 XEN VM can see only 2 TB with a
  4TB LUN.
  int13_hardisk-64bit-lba.patch
* Wed Feb 25 2009 jfehlig@novell.com
- bnc#477890 - Destroy domain if snapshot restore fails.
  Updated snapshot-xend.patch
* Tue Feb 24 2009 ksrinivasan@novell.com
- bnc#470238 - SLE11 32FV guest is hanging during certification
  tests.
  bnc#468265 - Xen guest shows duplicate drives
  bnc#469598 - SLES11 RC2 64bit Xen - SLES11 full virt guests
  hanging under load.
  disable_emulated_device.diff
* Tue Feb 24 2009 kwolf@suse.de
- bnc#477892 - Disable xend timeout for snapshots
  Updated snapshot-xend.patch
* Tue Feb 24 2009 kwolf@suse.de
- bnc#477895 - Fix detaching blktap disks from domains without
  device model
  Updated blktap-ioemu-close-fix.patch
* Fri Feb 20 2009 kwolf@suse.de
- bnc#472390 - Enable debuginfo for ioemu
  ioemu-debuginfo.patch
* Thu Feb 19 2009 carnold@novell.com
- bnc#473883 - Xen: 64 bit guest crashes with qemu-dm segfault
  qemu-dm-segfault.patch
* Wed Feb 18 2009 jfehlig@novell.com
- bnc#437776 - Remove tracing (bash -x) from network-nat script
  network-nat.patch
* Wed Feb 18 2009 jfehlig@novell.com
- bnc#473815 - Handle NULL return when reading a xenstore path.
  Updated blktap-error-handling.patch
* Wed Feb 18 2009 kwolf@suse.de
- Fix VHD image support for > 4 GB (offsets truncated to 32 bits)
  ioemu-vpc-4gb-fix.patch
* Thu Feb 12 2009 ksrinivasan@novell.com
- bnc#468660 - Fix migration from sles10 to sles11 on Intel.
  old-arbytes.patch
* Thu Feb 12 2009 carnold@novell.com
- bnc#473800 - If VT-d is enabled, Dom0 fails to boot up on
  Nehalem-HEDT platform.
  19198-fix-snoop.patch
  19154-snoop-control.patch
* Thu Feb  5 2009 jfehlig@novell.com
- bnc#470133 - Better error handling in xm when not booted Xen
  19153-xm-noxen-error.patch
* Wed Feb  4 2009 kwolf@suse.de
- bnc#472075 - Fix ioemu to initialize its blktap backend also for
  fully virtualized guests
  ioemu-blktap-fv-init.patch
* Tue Feb  3 2009 jfehlig@novell.com
- bnc#470855 - Add note to xm man page on how to detach domain
  console
  19152-xm-man-page.patch
* Mon Feb  2 2009 jfehlig@novell.com
- bnc#471090 - XendAPIStore: Do not remove non-existent item
  class list
  19151-xend-class-dereg.patch
* Mon Feb  2 2009 carnold@novell.com
- bnc#470949 - user mode application may crash kernel
  19088-x86-page-non-atomic-owner.patch (Jan Beulich)
  19089-x86_64-widen-page-refcounts.patch
  19103-x86_64-fold-page-lock.patch
  x86_64-page-info-pack.patch
  x86_64-sh-next-shadow.patch
* Fri Jan 23 2009 carnold@novell.com
- Intel - Remove improper operating condition that results in a
  machine check.
  19072-vmx-pat.patch
  19079-snp_ctl-1.patch
* Fri Jan 23 2009 kwolf@suse.de
- bnc#465379 - Fix blktap error handling
  blktap-error-handling.patch
* Thu Jan 22 2009 carnold@novell.com
- bnc#435219 - XEN pv-driver doesn't work
* Thu Jan 22 2009 jbeulich@novell.com
- Fix unmaskable MSI handling.
  18778-msi-irq-fix.patch
* Wed Jan 21 2009 jfehlig@novell.com
- bnc#467883 - Squelch output of xen-updown.sh sysconfig hook
  script and don't save state of tap devices not belonging to Xen.
* Wed Jan 21 2009 carnold@novell.com
- bnc#467807 - Xen: IRQs stop working
  xen-ioapic-ack-default.diff
* Fri Jan 16 2009 carnold@novell.com
- bnc#447178 - xm dump-core does not work for cross-bitness guest.
  19046-cross-bit-coredumping.patch
  19048-cross-bit-coredumping.patch
  19051-cross-bit-coredumping.patch
* Thu Jan 15 2009 brieske@novell.com
- bnc#429637 - SSVP SMBIOS HCT Test failing
  19027-hvmloader-SMBIOS-dev-mem-boundary.patch
* Wed Jan 14 2009 carnold@novell.com
- bnc#460805 - Unable to boot with Xen kernel with IBM T42p / T41p
  19039-x86-propagate-nolapic.patch
  19038-x86-no-apic.patch
* Mon Jan  5 2009 carnold@novell.com
- bnc#435596 - dom0 S3 resume fails if disk drive is set as AHCI
  mode.
  18937-S3-MSI.patch
- Final Xen 3.3.1 FCS changeset 18546
* Mon Dec 29 2008 carnold@novell.com
- bnc#436021 - On PAE host with EPT enabled, booting a HVM guest
  with 4G memory will cause Xen hang.
  18943-amd-32bit-paging-limit.patch
* Mon Dec 22 2008 carnold@novell.com
- bnc#461596 - Failue to load 64-bit HVM Solaris 10U6 DomU with 2
  vcpus.  Update to RC4 contains fix in c/s 18538.
* Mon Dec 22 2008 jfehlig@novell.com
- bnc#379032 and bnc#404014 - Fix loop device leak in domUloader
* Wed Dec 17 2008 kwolf@suse.de
- bnc#456758 - Allow all block device types for which a script
  exists in /etc/xen/scripts besides file, tap and phy.
  reenable-block-protocols.patch
* Mon Dec 15 2008 carnold@novell.com
- Patch cleanup. Updated tarball with several of our stand-alone
  but now upstream patches (c/s 18536).
* Fri Dec  5 2008 kwolf@suse.de
- bnc#404014 - Fix memory leak in libxenguest during domain
  creation
  libxc-zlib-memleak.patch
* Thu Dec  4 2008 jfehlig@novell.com
- bnc#456511 - Fix domain name change after checkpoint/shutdown
  events.
* Tue Dec  2 2008 carnold@novell.com
- Fixed xmclone.sh. It calls lomount which no longer exists in the
  distro.
* Tue Nov 25 2008 kwolf@suse.de
- Fix the build. Build system seems to be unhappy about having two
  copies of the xenstore binary (this is not a proper fix in fact
  as the build error says the two files are not identical - they
  are hardlinks, so this seems unlikely to be the real cause).
  tmp_build.patch
* Mon Nov 24 2008 jfehlig@novell.com
- bnc#448364 - Fix cpu affinity on save/restore/migrate
* Thu Nov 20 2008 kwolf@suse.de
- bnc#444731 - Fix data corruption bug (caused by broken x86
  emulation for movnti instruction)
  xen-x86-emulate-movnti.patch
* Wed Nov 19 2008 kwolf@suse.de
- Report device model errors during the creation of snapshots
  to xend instead of failing silently
* Wed Nov 19 2008 kwolf@suse.de
- bnc#445659 - ioemu: Workaround for VNC client initialization
  race with xenfb changing the resolution (caused VNC connection
  to be closed, vm-install recognized this as failed installation)
  ioemu-vnc-resize.patch
* Tue Nov 18 2008 carnold@novell.com
- bnc#444203 - With EPT mode4, HVM S3 causes Xen HV crash.
  18783-hvm-vcpu-reset-state-fix.patch
* Mon Nov 17 2008 carnold@novell.com
- bnc#444731 - Blackscreen instead of second stage during
  installation
  18766-realmode-stack-size-fix.patch
* Thu Nov 13 2008 carnold@novell.com
- bnc#429739 - Network failure with bnx2 when booted to XEN
  18778-msi-irq-fix.patch
* Wed Nov 12 2008 kwolf@suse.de
- bnc#444197 - Add udev rule to fix domUloader race with
  automounter (udev-rules.patch)
* Sun Nov  9 2008 ro@suse.de
- disable kmp to fix build again
* Fri Nov  7 2008 kwolf@suse.de
- Fix merge damage which prevented disks to be snapshotted when
  not in disk-only snapshot mode
* Wed Nov  5 2008 kwolf@suse.de
- bnc#435195 - Fix error handling for blktap devices and ioemu;
  check for images smaller than a sector and abort (causes hangs
  of the complete blktap stack otherwise)
  ioemu-blktap-zero-size.patch
* Mon Nov  3 2008 plc@novell.com
- bnc#436572 - L3: vm serial port configuration and access is not
  persistent across dom0 reboot
* Wed Oct 29 2008 carnold@novell.com
- bnc#436926 - Xen hypervisor crash
* Tue Oct 28 2008 jfehlig@novell.com
- bnc#438927 - Fix migration bug in xend
* Tue Oct 28 2008 carnold@suse.de
- disable KMP, does not build with current kernel
* Fri Oct 24 2008 jfehlig@novell.com
- bnc#437756 - Fix default netdev device in network-route
* Wed Oct 22 2008 jfehlig@novell.com
- bnc#434560 - Remove local patch that prevents creating PV vif
  when "type=ioemu" is specified in guest vif config.  This patch
  is causing several problems with recent changes to xenstore
  layout.
* Wed Oct 22 2008 jfehlig@novell.com
- bnc#431758 - Added upstream changeset 18654 to prevent setting
  vcpus > VCPUs_max on running domain.
* Tue Oct 21 2008 carnold@novell.com
- Update to changeset 18455.
* Thu Oct 16 2008 olh@suse.de
- add ExclusiveArch x86 x86_64
* Wed Oct 15 2008 jfehlig@novell.com
- bnc#433722 - Fix handling of default bridge in qemu-ifup.
* Mon Oct 13 2008 carnold@novell.com
- bnc#431324 - Cannot boot from XEN kernel
* Mon Oct 13 2008 kwolf@suse.de
- blktapctrl: Close connection to tapdisk-ioemu only if there are
  no more attached disks
  blktap-ioemu-close-fix.patch
- blktapctrl: If tapdisk-ioemu has been shut down and a new
  instance is needed, fix saving the PID of the new instance
* Thu Oct  2 2008 jfehlig@novell.com
- bnc#431737 - Fix use of deprecated python constructs in xend
* Mon Sep 29 2008 carnold@novell.com
- Update to c/s 18430, remove our versions of upstream patches.
- fate#303867 - minimum HVM domain limits.  Pulled upstream
  patches for supporting up to 255 cpus.
* Fri Sep 26 2008 kwolf@suse.de
- bnc#430222 - Fixed block-attach for tap:aio images
* Thu Sep 25 2008 kwolf@suse.de
- bnc#429801 - Fixed xm start -c / --vncviewer
  xm-start-fix.patch
* Wed Sep 24 2008 carnold@novell.com
- bnc#382401 - xm man page missing information for commands.
* Wed Sep 17 2008 carnold@novell.com
- Pulled some upstream patches for Intel and AMD microcode fixes.
* Tue Sep 16 2008 carnold@novell.com
- Update to changeset 18412.  Contains several bug fixes including
  a crash fix in qemu-dm and also various memory leaks fixes.
* Mon Sep 15 2008 carnold@novell.com
- Fix parameters in call to kill_proc_info (pv drivers).
- Add conditional for use of smp_call_function so the pv drivers
  can be built on older kernel versions.
* Thu Sep 11 2008 brogers@novell.com
- Added gdbserver-xen to the set of tools we build.
  fate#302942
* Thu Sep 11 2008 jfehlig@novell.com
- Added ocfs2 to Should-Start in xendomains init script
* Wed Sep 10 2008 plc@novell.com
- Added pv cdrom support to blktap
  fate#300964
* Wed Sep 10 2008 jfehlig@novell.com
- Removed invocation of network-bridge script from xend-config.sxp.
  Networks are now created through yast2-network package.
- Added sysconfig hook script for Xen to cope with ifup/ifdown
  events on network devices (e.g. bridges) in use by virtual
  machines.
  fate#303386
* Mon Sep  8 2008 carnold@novell.com
- Updated to xen version 3.3.1 RC changeset 18390.
* Wed Sep  3 2008 kwolf@suse.de
- Snapshots: Fix xend API functions for libvirt usage
* Mon Sep  1 2008 carnold@novell.com
- Fix problems building KMPs against the 2.6.27 kernel.
* Fri Aug 29 2008 plc@novell.com
- Added 'tap' to the type of devices for HalDaemon.py to
  scan for change of xenstore attribute media-present.
* Wed Aug 27 2008 jfehlig@novell.com
- Don't create pv vif device if emulated network device is
  explicitly specified in guest config.
* Fri Aug 22 2008 carnold@novell.com
- Updated to xen-unstable changeset 18358 Xen 3.3.0 FCS.
* Wed Aug 20 2008 carnold@novell.com
- Updated to xen-unstable changeset 18353 RC7.
* Wed Aug 20 2008 kwolf@suse.de
- Implementation of xm snapshot-delete
  snapshot-ioemu-delete.patch, snapshot-xend.patch
- Add snapshot options to qemu-img-xen
  qemu-img-snapshot.patch
* Tue Aug 19 2008 carnold@novell.com
- Enable kboot and kexec patches.
* Mon Aug 18 2008 carnold@novell.com
- Updated to xen-unstable changeset 18335 RC5.
* Mon Aug 18 2008 carnold@suse.de
- Removed git dependency.  Instead use a static version of
  ioemu-remote.
* Thu Aug 14 2008 jfehlig@novell.com
- Added patch to prevent starting same domU from multiple hosts.
  Feature is disabled by default - see /etc/xen/xend-config.sxp.
  fate#305062
* Mon Aug 11 2008 jfehlig@novell.com
- Added python-openssl to Requires list for xen-tools.  This
  package is required if SSL relocation is enabled by user.
* Mon Aug 11 2008 carnold@novell.com
- Updated to xen-unstable changeset 18309. Pre 3.3.0-rc4.
* Sat Aug  9 2008 jfehlig@novell.com
- Disabled xend-relocation-ssl-server for now.  Certificates must
  be created and feature needs testing.
* Fri Aug  8 2008 carnold@novell.com
- Update to xen-unstable changeset 18269 post RC3.  Reverse
  version back to 3.3.0 from 4.0.0.
* Wed Aug  6 2008 carnold@novell.com
- Updated to xen-unstable changeset 18242.  Version changes from
  3.3.0 to 4.0.0
* Mon Aug  4 2008 carnold@novell.com
- Updated to xen-unstable changeset 18210. Post 3.3.0-rc2.
* Tue Jul  8 2008 carnold@novell.com
- Updated to xen-unstable changeset 17990.
* Tue Jul  8 2008 kwolf@suse.de
- ioemu: Write barriers for blktap devices
  ioemu-blktap-barriers.patch
* Thu Jul  3 2008 kwolf@suse.de
- blktapctrl defaults to using ioemu instead of tapdisk now
  blktapctrl-default-to-ioemu.patch
- Now that ioemu is default, it can be called with image paths
  starting e.g. with tap:qcow2. If the image format is specified,
  it has to be respected and no guessing on the image file must
  happen.
  ioemu-blktap-image-format.patch
- qcow2: Read/Write multiple sectors at once if possible to
  improve performance.
  ioemu-qcow2-multiblock-aio.patch
* Thu Jun 12 2008 kwolf@novell.com
- Add snapshot support to ioemu and blktapctrl
  snapshot-ioemu-save.patch
  snapshot-ioemu-restore.patch
* Fri Jun  6 2008 jfehlig@novell.com
- bnc#397890 - Create and own /var/lib/xen/dump
* Thu Jun  5 2008 kwolf@novell.com
- Fix tapdisk for qcow2 images > 2 GB
  1xxxx-qcow2-2gb-bug.patch
* Thu Jun  5 2008 jfehlig@novell.com
- Updated to xen-unstable changeset 17772.
* Tue May 27 2008 plc@novell.com
- bnc#381368 - boot qcow image fix.
* Fri May 23 2008 jfehlig@novell.com
- bnc#378595 - Revert patch that disables use of ifup/ifdown.
  ifup-bridge in sysconfig has been fixed so patch is no longer
  needed.  Calling ifdown on bridge now removes ports and deletes
  bridge, so network-bridge no longer needs to do these tasks.
* Fri May 16 2008 carnold@novell.com
- bnc#390985 - xm man page needs FIXME sections to be fixed
  xen-fixme-doc.diff
* Wed May 14 2008 carnold@novell.com
- bnc#375322 - L3:timer went backwards
  x86-domain-shutdown-latency.patch
* Sat May 10 2008 plc@novell.com
- bnc#388969 - Shift tab traversal does not work
  xen-shift-key.patch
- bnc#384277 - PVFB security hole
  xen-pvfb-security.patch
- bnc#385586 - VNC windows size too small
  xen-vnc-resize.patch
* Fri Apr 25 2008 carnold@novell.com
- bnc#383513 - Unknown unit 'K' in Xen's logrotate config file.
* Fri Apr 25 2008 carnold@novell.com
- Update to Xen 3.2.1 FCS changeset 16881.
* Fri Apr 11 2008 carnold@novell.com
- Update to Xen 3.2.1 RC5 changeset 16864.
* Thu Apr 10 2008 jfehlig@novell.com
- bnc#378595 - Do not use ifup/ifdown in network-bridge for now.
* Mon Mar 24 2008 carnold@novell.com
- bnc#373194 - The xen module and the kernel for Dom0 don't match.
- Add ncurses-devel build dependency
* Mon Mar 24 2008 carnold@novell.com
- Update to Xen 3.2.1 RC1 changeset 16820.
* Thu Mar 20 2008 coolo@suse.de
- 3.1.0 is unfortunately not enough to obsolete 3.1.0_<something>
  in rpm terms
* Fri Mar 14 2008 carnold@novell.com
- Update to Xen 3.2.1 changeset 16805.
* Fri Mar 14 2008 coolo@suse.de
- ipcalc does not exist - and breaks pattern
* Wed Mar 12 2008 jfehlig@novell.com
- Increased dom0-min-mem value to 512Mb in xend-config.sxp
  bnc#370007
* Mon Mar 10 2008 jfehlig@novell.com
- Fixed initialization of default VM config values when creating
  VMs through Xen API.  bnc#368273
* Mon Mar 10 2008 jfehlig@novell.com
- Removed unused/untested xend-relocation script.
* Fri Mar  7 2008 jfehlig@novell.com
- Set device model when creating pvfb consoles via XenAPI.
  bnc#367851
* Fri Mar  7 2008 jfehlig@novell.com
- Ensure dhcpcd is activated, if appropriate, on bridges created
  by network-multinet.  bnc#364633
* Fri Feb 29 2008 carnold@novell.com
- bnc#357966 - VT-D dosen't work for HVM guest.
* Fri Feb 29 2008 plc@novell.com
- Send UNIT_ATTENTION when CD drive has newly inserted media and
  becomes ready.  bnc#365386
* Thu Feb 28 2008 jfehlig@novell.com
- Updated block-iscsi script and xen-domUloader patch, bnc #365385
* Thu Feb 28 2008 carnold@novell.com
- Add support for Intel EPT / VPID.
* Tue Feb 26 2008 carnold@novell.com
- bnc#362415 - SLE-based installs 32-bit fully-virtualized have
  network problems during installs.
- bnc#358244 - Time remaining does not change properly for FV SLES10
  SP2 guest.
- bnc#363053 - Install remaining time always shows 2:00:00
* Tue Feb 26 2008 carnold@novell.com
- bnc#359457 - Xen full virt has data integrity issue.
* Tue Feb 26 2008 plc@novell.com
- Tranlate colors from 32 bit to 16 bit when viewing a 32 bit PV
  VM from a 16 bit client.  bnc#351470
  Also includes upstream mouse queue patch.
* Fri Feb 22 2008 jfehlig@novell.com
- Added PAM configuration files for remote authentication via
  Xen API.  bnc #353464
* Tue Feb 19 2008 carnold@novell.com
- Fix PV drivers for HVM guests.
* Fri Feb 15 2008 carnold@novell.com
- Support for pxe booting fully virtualized guests in vm-install is
  complete.
* Thu Feb 14 2008 carnold@novell.com
- Added upstream changesets that fix various bugs.
  16859 16929 16930 16945 16947 16962 16976 16980 16995 16998 17036
* Wed Feb 13 2008 jfehlig@novell.com
- Updated network-multinet
  - Simplify bridge creation
  - Create traditional bridge and hostonly networks by default
* Fri Feb  8 2008 jfehlig@novell.com
- Added upstream changesets 16932, 16965, 16977, and 16988 to fix
  various bugs in tool stack
- Also added upstream changeset 16989 to complete fate #302941.
* Mon Feb  4 2008 plc@novell.com
- Replaced xen-blktab-subtype-strip.patch with official upstream
  changeset for bnc#353065.
* Fri Feb  1 2008 carnold@novell.com
- Update to xen 3.2 FCS.  Changeset 16718
- Merge xen-tools and xen-tools-ioemu into xen-tools.
* Wed Dec 19 2007 carnold@novell.com
- Update to xen 3.2 RC2.  Changeset 16646
* Thu Dec 13 2007 carnold@novell.com
- Added agent support for HP Proliant hardware.
* Wed Dec  5 2007 carnold@novell.com
- #338108 - VUL-0: Xen security issues in SLE10
- #279062 - Timer ISR/1: Time went backwards
* Thu Nov 29 2007 carnold@novell.com
- Added part of upstream c/s 15211.  Fixed open call with O_CREAT
  because it had no mode flags (15211-fix-open-mode.patch).
* Mon Nov  5 2007 jfehlig@novell.com
- Added upstream c/s 15434 to allow access to serial devices.
  Bug #338486.
* Thu Nov  1 2007 carnold@novell.com
- #334445: xenbaked: Fix security vulnerability CVE-2007-3919.
* Thu Nov  1 2007 carnold@novell.com
- #310279: Kernel Panic while booting Xen
* Tue Oct  2 2007 ccoffing@novell.com
- #286859: Fix booting from SAN
* Thu Sep 13 2007 ccoffing@novell.com
- #310338: Fix "No such file or directory" in network-multinet
* Wed Sep 12 2007 jfehlig@novell.com
- #309940: Fix 'xm reboot'
- Moved hvm_vnc.diff and xend_mem_leak.diff to 'Upstream patches'
  section of spec file since both have been accepted upstream now.
* Mon Sep 10 2007 jfehlig@novell.com
- #289283: Fix memory leak in xend
* Fri Sep  7 2007 jfehlig@novell.com
- #297125: Expose 'type vnc' in vfb device sexp for HVM guests.
* Thu Sep  6 2007 ccoffing@novell.com
- #302106: Update network-multinet
* Wed Sep  5 2007 carnold@novell.com
- #307458: AMD-V CR8 intercept reduction for HVM windows 64b guests
* Wed Aug 29 2007 ccoffing@novell.com
- Update block-iscsi to match changes to open-iscsi.
* Mon Aug 27 2007 carnold@novell.com
- #289275 - domu will not reboot if pci= is passed in at boot time.
* Fri Aug 24 2007 carnold@novell.com
- #297345: Added several upstream patches for hvm migration.
* Fri Aug 17 2007 jfehlig@novell.com
- Added upstream c/s 15128, 15153, 15477, and 15716.  These patches
  provide foundation for bug #238986
- Renamed xend_dev_destroy_cleanup.patch to reflect the upstream
  c/s number and moved it to "upstream patches" section of spec
  file.
* Mon Aug 13 2007 carnold@novell.com
- hvm svm: Log into 'xm dmesg' that SVM NPT is enabled.
* Fri Aug 10 2007 ccoffing@novell.com
- Honor RPM_OPT_FLAGS better
* Thu Aug  9 2007 ccoffing@novell.com
- #298176: Do not enable NX if CPU/BIOS does not support it
- #289569: Modify network-bridge to handle vlan
- #297295: Fix bridge setup: stop using getcfg
* Mon Aug  6 2007 olh@suse.de
- remove inclusion of linux/compiler.h and linux/string.h
  remove ExclusiveArch and fix prep section for quilt setup *.spec
* Thu Aug  2 2007 jfehlig@novell.com
- Added patch to fix/cleanup destoryDevice code path in xend.
  Patch was submitted upstream.  Aids in fixing several bugs, e.g.
  [#217211] and #242953.
* Tue Jul 31 2007 ccoffing@novell.com
- Update Ron Terry's network-multi script
- Fix insserv
* Tue Jul 31 2007 jfehlig@novell.com
- Added following upstream patches:
  + 15642 - Fixes bug 289421 found in SLES10 SP1 but applies to
    Xen 3.1.0 as well.
  + 15649, 15650, 15651 - Fixes/enhancements to Xen API required
    by Xen CIM providers
* Fri Jul 27 2007 ccoffing@novell.com
- #242953: Allow HVM to use blktap
- #239173: block-attach as RW for domUloader to avoid failures with
  reiserfs (since blktap does not yet correctly communicate RO to
  the kernel)
* Mon Jul 23 2007 ccoffing@novell.com
- Drop xen-bootloader-dryrun.diff; not needed for xen 3.1
- rpmlint: Actually apply patch for #280637
- rpmlint: Rename logrotate config from xend to xen
- Don't package xenperf twice
- xen-detect is a domU tool
* Mon Jul 23 2007 jfehlig@novell.com
- Added upstream patches that fix various bugs
  + 15168 fixes check for duplicate domains
  + 15587 resets domain ID and fixes problems with domain state
    via Xen API
  + 15609 stores memory values changed via Xen API
* Thu Jul 19 2007 ccoffing@novell.com
- BuildRequires LibVNCServer-devel
- Rotate all logs.
- Fix network data corruption on Win2003 with rtl8139. (#254646)
- Xen fails to create VM due to "out of memory" errors. (#280637)
* Tue Jul 17 2007 plc@novell.com
- Added CDROM removable media patch from 3.0.4
* Fri Jul  6 2007 ccoffing@novell.com
- xensource bug #858: Disable strict aliasing for xenstore, to
  avoid domU hangs.
* Tue Jul  3 2007 ccoffing@novell.com
- #285929: Bad "xendomains status" output w/ empty XENDOMAINS_SAVE
* Tue Jul  3 2007 carnold@novell.com
- Changes necessary to support EDD and EDID from Jan.
* Wed Jun 20 2007 jfehlig@novell.com
- Added upstream changesets 15273, 15274, and 15275.
- Removed the modified 15157 patch.  This patch was actually a
  consolidation of changesets 15157 and 15250.  These changesets
  are now discrete patches to ease subsequent updates of Xen.
* Wed Jun 20 2007 ccoffing@novell.com
- Split vm-install off as a separate package.
- Update man page.
- Update Ron Terry's network-multi script.
* Mon Jun 18 2007 ccoffing@novell.com
- Fix compiler warnings.
- Update block-npiv.
* Mon Jun 11 2007 ccoffing@novell.com
- Fix more warn_unused_value compiler warnings.
* Fri Jun  8 2007 ccoffing@novell.com
- Update to official rc10 (changeset 15042).
- Updated vm-install:
  + easier to exit with Ctrl-C
  + drop "TERM=xterm" for Linux (breaks PVFB text install)
  + use "TERM=vt100" when calling "xm" to suppress terminal codes
  + command-line support for VNC password
  + fixed disk groups (e.g., 2 disks on command line w/o PDEV)
  + fixed regression:  Don't let user close progress window
  + failure to open a device should not completely fail search for
  bootsector (consider: no media in /dev/cdrom)
  + always remove PV kernel and initrd from /tmp
  + #279153: Support disks on iscsi/qcow/vmdk/nbd/file/phy/...
* Fri Jun  8 2007 jfehlig@novell.com
- Added a modified version of upstream c/s 15157.  Original version
  of c/s 15157 fixed bug #262805 but also broke
  'xm block-detach dom dev_name'.  Modified version fixes bug 262805
  without introducing regression.  Patch fixing c/s 15157 has been
  submitted upstream.
* Wed May 23 2007 ccoffing@novell.com
- Drop xen-messages.diff; Xen now supports HVM save/restore.
* Tue May 22 2007 ccoffing@novell.com
- Update Ron Terry's network-multi script.
- Drop xen-doc-ps.  (#267948)
- Update init scripts.
- Tidy spec file to fix rpmlint errors.
- Updated patches from Jan.
* Mon May 21 2007 ccoffing@novell.com
- vm-install bug fixes:
  + #211342: better progress bar
  + #259994: disk size would reset when editing path
  + #247073: handle autoyast URLs
  + #254311: physical disks were showing as 0.0 GB
* Wed May 16 2007 ccoffing@novell.com
- Properly quote pathnames in domUloader to fix EVMS.  (#274484)
- Allow user to specify a default 'keymap' in xend's configuration
  file. (#258818 and 241149)
* Mon May 14 2007 plc@novell.com
- Added upstream python patches for keymap specification in
  PV config file. Added upstream ALTGR fix, sign extension fix
  and modified patch 323 so that upstream patches applied cleanly.
  (#258818)
* Fri May 11 2007 ccoffing@novell.com
- Update to xen-3.1-testing rc10 (changeset 15040).
- Update .desktop with proper group.  (#258600)
- Include Kurt's updated block-iscsi.  (#251368)
- Jim's updated patch to honor localtime setting.  (#273430)
- Fix vm-install to work correctly when doing multiple simultaneous
  installs via virt-manager.  (#259917)
- Network connectivity fails in FV SLES 10 SP1; MAC address was
  being read incorrectly from xenstore by PV driver.  (#272351)
- For FV SLES 9, default apic=1 to allow x86_64 SLES 9 to boot.
  (#264183)
* Fri May  4 2007 carnold@novell.com
- Added security fixes for problems found Travis Orandy (#270621)
  CVE-2007-1320, CVE-2007-1321, CVE-2007-1322, CVE-2007-1323,
  CVE-2007-1366
* Thu May  3 2007 ccoffing@novell.com
- Update to xen-3.1-testing rc7 (changeset 15020).
- Fix identification of virt-manager windows.  (#264162)
* Tue May  1 2007 jfehlig@novell.com
- Integrated domUloader with 3.0.5.  Updated xen-domUloader.diff.
* Mon Apr 30 2007 ccoffing@novell.com
- Update to xen-3.0.5-testing rc4 (changeset 14993).
* Thu Apr 26 2007 jfehlig@novell.com
- Fixed autobuild error in function that returns random data.
  File tools/ioemu/hw/piix4acpi.c line 72.  Fix added to
  xen-warnings.diff.
* Thu Apr 26 2007 ccoffing@novell.com
- Fix build on SLES 10 SP1.
* Wed Apr 25 2007 ccoffing@novell.com
- Update to xen-3.0.5-testing rc3 (changeset 14934).
- Switch BuildRequires to texlive.
* Fri Apr 20 2007 ccoffing@novell.com
- Updated README. (#250705)
- Fix vm-install's detection of PV RHEL4/5 kernels. (#260983)
* Thu Apr 19 2007 ccoffing@novell.com
- Place xenstore-* tools in new xen-tools-domU package, to be used
  by suse_register.  (#249157)
* Tue Apr 17 2007 ccoffing@novell.com
- Update translations.
* Thu Apr 12 2007 ccoffing@novell.com
- Combine two xenstore reads into one transaction, which causes
  xenstored to not thrash so badly, and makes virt-manager more
  responsive and less likely to time out or lock up.  Partial fix
  for #237406.
- If disk is read-only, pass -r to losetup.  (#264158)
* Thu Apr  5 2007 ccoffing@novell.com
- Update vm-install:
  + #260510: do not delete xml settings file
  + #260579: write correct vif line for PV NIC in FV VM
  + #261288: re-enable add disk buttons after deleting a disk
  + #192272, #222765, #250618:  Update OS list and their defaults
* Tue Apr  3 2007 ccoffing@novell.com
- Could not do simultaneous installs via virt-manager. (#259917)
* Mon Apr  2 2007 jfehlig@novell.com
- Fix improper handling of guest kernel arguments in domUloader.
  Bug #259810
* Mon Apr  2 2007 ccoffing@novell.com
- Update vm-install:
  + #259420: refresh available memory more often
  + #259972: cannot enter autoyast url
* Mon Apr  2 2007 ccoffing@novell.com
- Update translations for RC2.
* Fri Mar 30 2007 ccoffing@novell.com
- Fix "cannot allocate memory" when starting VMs. (#229849, 258743)
* Thu Mar 29 2007 ccoffing@novell.com
- Fix quoting of args for child processes during VM install.
  (#258376)
- Fix retry logic in block hotplug script. (#257925)
* Wed Mar 28 2007 ccoffing@novell.com
- Updated vm-install's icon name.
- Updated translations.
* Fri Mar 23 2007 ccoffing@novell.com
- Disable aspects of qemu's console that can affect domain 0.
  (#256135)
- Fix xmclone.sh to work with managed domains. (#253988)
- Update to xen-unstable changeset 14535.
* Mon Mar 19 2007 ccoffing@novell.com
- Update to xen-unstable changeset 14444.
- Include Ron Terry's network-multi_bridge
* Fri Mar  9 2007 jfehlig@novell.com
- Added lame patch to handle showing suspended state via Xen API.
  The patch only affects Xen API and is thus low risk.
  Bug #237859
* Fri Mar  9 2007 carnold@novell.com
- Added AMD support for Vista 64 installation and boot.
* Fri Mar  9 2007 ccoffing@novell.com
- Make vm-install support NFS for SUSE (#241251).
* Fri Mar  9 2007 jfehlig@novell.com
- Fixed bug #250522
  + Upstream c/s 13557 stores model attribute of vif in xenstore.
* Thu Mar  8 2007 ccoffing@novell.com
- Update vm-install:
  + Better description on "Virtual Disk" drop-down (not "xvda")
  + Proper separation of recording options versus calculating
  defaults; fixes corner cases
  + #247849, #253013, 253009: Multiple fixes related to how disks
  are defined, centered around bug #247849 (handle partitioned
  PV installation disk)
  + #252437: Allow virtual CDROM to be added (via ISO) even if
  physical CDROM doesn't exist
* Wed Mar  7 2007 jfehlig@novell.com
- Fixed bug #252396
  + Added upstream c/s 14021.  Applies to Xen API c-bindings -
    low risk.
  + Added local patch to correctly set Xen API Console.protocol
    property
* Wed Mar  7 2007 jfehlig@novell.com
- Added upstream patch that fixes save/restore on 32pae guests.
  Upstream c/s 14150.  Bug #237859
* Tue Mar  6 2007 carnold@novell.com
- Remove a debug message which is spamming the logs during live
  migration.
* Mon Mar  5 2007 jfehlig@novell.com
- Fixed handling of vbd type in Xen API <-> sexpr integration.
  Bug #250351
  + Updated an existing patch (xend_disk_decorate_rm.patch) and
    then renamed patch to xend_vbd_type.patch to better reflect
    purpose of patch.
* Mon Mar  5 2007 ccoffing@novell.com
- Default apic=0 for SLES 8 and 9, for performance.  (#228133)
* Fri Mar  2 2007 carnold@novell.com
- Xen kernel crashes at domain creation time. Bug #248183.
  Fix mouse for win2k hvm guest.
* Fri Mar  2 2007 jfehlig@novell.com
- Incorrect values returned for actions_after_* in Xen API.  Added
  patch xend-actions-after.patch for fix.  Patch submitted upstream
  as well.  Bug #250870.
* Fri Mar  2 2007 ccoffing@novell.com
- Update vm-install:
  + Fixed possible "tree path exception" when editing disk
  + Fixed failure to properly refresh fields when editing disk
  + #248356: allow specifying bridge
* Fri Mar  2 2007 jfehlig@novell.com
- Add check for HVM domain in domain_save.  The check is
  performed in domain_suspend and should be included here as well.
* Thu Mar  1 2007 ccoffing@novell.com
- Update vm-install:
  + #250201: for linux PVFB, pass xencons=tty if graphics=none
  + #250016: honor non-sparse flag
* Thu Mar  1 2007 jfehlig@novell.com
- Fix exception caused by incorrect method name in xen-messages.diff.
  This is one of perhaps several problems with save/restore,
  bug #237859
* Thu Mar  1 2007 dpmerrill@novell.com
- Add xen-ioemu-hvm-pv-support.diff
  This patch allows for shutting down the IDE drive.
* Thu Mar  1 2007 jfehlig@novell.com
- Fix bug #243667
  + Updated domUloader to accept '--args' parameter.  The args
    provided as an option to --args are simply added to the sexpr
    returned by domUloader.  pygrub has similar behavior.
* Wed Feb 28 2007 ccoffing@novell.com
- Update vm-install:
  + #249013, #228113: default to realtek instead of pcnet
  + #249124: write os-type to config files
  + Updated translations
  + Setting os_type should implicitly set full_virt; fixes NIC
    model exceptions
  + Add "Add" button to Operating System Installation page, based
    on usability feedback
* Wed Feb 28 2007 jfehlig@novell.com
- Added changeset 13786 and 14022 from xen-unstable.  These
  changesets affect the Xen API C bindings only and are low risk.
  This is a continuation of support for FATE feature 110320.  ECO
  has been approved for late arrival of this feature.
* Mon Feb 26 2007 ccoffing@novell.com
- Update vm-install:
  + #244772: display error message in GUI if xen isn't running
  + #246049: better error message when OS==SUSE but ISO looks wrong
  + Fix printing of jobid when run with --background
* Wed Feb 21 2007 ccoffing@novell.com
- Don't allow "xm create" of running VM.  (#245253)
- Update vm-install:
  + Fix inability to use already-extracted SUSE kernel/initrds
  + Fix accumulation of 0-byte tmp files
  + #237063: close fds before running vncviewer
  + default apic=0 for Windows, due to performance
* Tue Feb 20 2007 carnold@novell.com
- Domain0 reboots after 2-6 hours of running guests. (#246160)
* Tue Feb 20 2007 ccoffing@novell.com
- Fix typo in xendomains.  (#246107)
- Fix order in which vm-install processes command-line arguments.
* Fri Feb 16 2007 jfehlig@novell.com
- Added changeset 13775 from xen-unstable.  This patch fixes
  the last known issue with the Xen API patchset backported
  from xen-unstable.
* Fri Feb 16 2007 jfehlig@novell.com
- Added c/s 13226 from xen-unstable.  It affects Xen API only.
- Added patch to remove ':disk' and 'tap:qcow' from stored domain
  config.  Fixes bug #237414 and helps with bug #242953.
* Thu Feb 15 2007 jfehlig@novell.com
- Backported Xen API functionality from xen-unstable to support
  hosting CIM providers.  This functionality is required for
  FATE feature 110320.  ECO has been approved.
  + Includes 19 changesets from xen-unstable.  Most are
    specific to Xen API.
  + Includes 1 patch that relaxes parsing of xml response
    in Xen API c-bindings.
* Thu Feb 15 2007 carnold@novell.com
- Added x86-nmi-inject.patch for NW debuging. (#245942)
* Thu Feb 15 2007 carnold@novell.com
- kernel panic in DomU while installing 32bit DomU on 64bit
  Dom0. (#244055) Patches 13630-domctl.patch,
  13903-domctl.patch and 13908-domctl.patch
- Updated patch pae-guest-linear-pgtable.patch
* Mon Feb 12 2007 ccoffing@novell.com
- Load xenblk at dom0 start to support bootstrapping from
  non-loopback devices.  (#242963, #186696)
- Update vm-install:
  + Update translations
  + Clean up exception error codes and sync man pages
  + Honor ordering of arguments (as claimed in man page)
  + #240984: properly detach vncviewer
  + #240387: default to absolute coordinate mouse for Windows
- Drop logging patch.  (#245150)
* Sun Feb 11 2007 ro@suse.de
- remove -fstack-protector from RPM_OPT_FLAGS for now
* Thu Feb  8 2007 ccoffing@novell.com
- Update vm-install:
  + Allow specifing disk (and disk size) vs. cdrom from CLI
  + Add missing -M/--max-memory parameter to CLI to match GUI
  + #241528: Display error if user selects FV OS but hw lacks VT
  + Move all consistency checks out of Options class, since CLI
    options may be processed in a "bad" order
  + Fix infinite loops when info is missing from background jobs
  + --background implies --no-auto-console
  + Don't let user close progress window
  + Fix bug in qemu slowness work-around, reported by Jan Albrecht
  + Do disk.validate() when clicking "OK" on disks page
  + #238959: Probe for removable media via /sys/block
  + Output VNC info for backgrounded job
  + Fix method of waiting for VM to exit when --no-autoconsole
  + #239582: Use extracted kernel-xen/initrd-xen if present
* Tue Feb  6 2007 ro@suse.de
- disable commented out buildreq for kernel for the moment
  to workaround endless rebuild
* Tue Feb  6 2007 ccoffing@novell.com
- xm-test should clean up xenstore better (#180138)
* Thu Feb  1 2007 ccoffing@novell.com
- Implement better job support for CIM (#241197)
- Temporary fix to allow PV VMs to reboot (#237414)
- Delete PYTHONOPTIMIZE for good; callers don't set it.
* Wed Jan 31 2007 ccoffing@novell.com
- Update xen-3.0.4 (changeset 13138); includes migration bugfix.
* Tue Jan 30 2007 ccoffing@novell.com
- Enable building KMP.
- Fix xendomains to work with managed domains. (#238781)
* Thu Jan 25 2007 ccoffing@novell.com
- Various bug fixes of 32on64, from Jan and Keir.
- Gerd's fix for domain builder with > 4 GB RAM (#233761)
- Update xen-vm-install:
  [#234331], #239007: CD/DVDs should always be marked read-only
  [#238458]: Work-around qemu slowness bug
  [#239196]: Support SLED
  [#239275]: Fix .desktop file
  [#240064]: Clean up VMs better after failed install
* Tue Jan 23 2007 ccoffing@novell.com
- Update xen-vm-install:
  [#237370]: Can now install 32pae SLES 10 on x86_64 hypervisor
  [#237396]: Be able to use an existing disk, bypass OS installation
  Fix handling of user's extra_args
- Patch from Jan to enable building PV drivers KMP for FV SUSE.
  Currently conditionalized.
- Drop unused patches xen-io-register-context.diff and
  xen-console.diff
* Sat Jan 20 2007 brogers@novell.com
- Fix handling of localtime config file parameter for PV guests
  (#234376)
* Fri Jan 19 2007 ccoffing@novell.com
- Update xen-vm-install (NIC UI work; do not require tcp port bz
  [#236517]; integrate with virt-manager)
* Wed Jan 17 2007 ccoffing@novell.com
- Update xen-vm-install (more disk UI work; support NetWare
  response files and licenses)
* Tue Jan 16 2007 ccoffing@novell.com
- Major fixes to xen-vm-install (adding disks in the UI now works,
  and fixed several CLI exceptions)
- Microcode does not need to be exactly 2048 bytes (changeset
  13079; Kurt)
* Fri Jan 12 2007 ccoffing@novell.com
- Include script to clone SLES 10 domU, from coolsolutions (fate
  [#301742])
- Updated patches from Gerd and Jan, including PAE > 4 gig fix,
  updated VGA console patch.
- Updated xen-vm-install with finalized strings and desktop file.
* Thu Jan 11 2007 ccoffing@novell.com
- Include xen-unstable patches for HVM save/restore and 32-on-64
  HVM.
- Update to xen-3.0.4-1 (changeset 13132).
* Wed Jan 10 2007 ccoffing@novell.com
- Update xen-vm-install and domUloader to support NetWare.
- Include AMD's nested page table patches.
* Mon Jan  8 2007 ccoffing@novell.com
- Update to xen-3.0.4 (changeset 13129).
- Fix from upstream for mis-emulation of x86-64 pop.
* Fri Jan  5 2007 carnold@novell.com
- Many patches from Jan Beulich and Gerd Hoffmann in support of
  32 on 64 pv guests.  These patches apply to both the hypervisor
  and the tools.
* Fri Dec 22 2006 ccoffing@novell.com
- Do not require authentication on XenAPI socket, since CIMOM does
  not support authentication.  Socket is only accessible to root.
* Wed Dec 20 2006 ccoffing@novell.com
- Update to xen-3.0.4 (changeset 13100).
- Update xen-vm-install tools.
- Include Jim's 2 xen-tools patches for CIM provider issues.
* Mon Dec 18 2006 ccoffing@novell.com
- Update to xen-3.0.4-rc3 (changeset 13087).
- Fix line terminators in block-iscsi (#228864)
- Make domUloader work with blktap support in xend.
* Fri Dec 15 2006 ccoffing@novell.com
- Update to xen-3.0.4-rc2 (changeset 13067).
* Thu Dec 14 2006 ccoffing@novell.com
- Update to xen-3.0.4-rc1 (changeset 12901).
* Wed Dec 13 2006 brogers@novell.com
- Patch for loading bimodal PAE kernel to suuport NetWare
* Thu Dec  7 2006 ccoffing@novell.com
- Update to xen-unstable (changeset 12757).
- Enable LIBXENAPI_BINDINGS and XENFB_TOOLS.
- Enable unix domain socket for xend; needed by tools.
* Tue Dec  5 2006 ccoffing@novell.com
- Update to xen-unstable (changeset 12734; feature freeze for
  3.0.4)
- Make /etc/xen mode 0700 to protect vnc passwords.
* Mon Nov 27 2006 ccoffing@novell.com
- Fix how bootloader is called by the xend during restarts.
  (#223850)
* Wed Nov 22 2006 ccoffing@novell.com
- Series of patches from Jan to address selectors with non-zero-
  bases and other related issues in HVM. (#214568)
- Default pae=1, otherwise 64 bit HVM does not work at all.
  (#217160)
* Fri Nov 17 2006 ccoffing@novell.com
- Backport several HVM fixes. (#176171?)
* Thu Nov 16 2006 ccoffing@novell.com
- Fix some problems in the xen-hvm-default-bridge patch. (#219092)
- xmlrpc isn't 64-bit clean, causing xend to get exceptions when
  PFN is > 2 GB. (#220418)
* Mon Nov 13 2006 kallan@novell.com
- Backport changesets 11847, 11888, 1189[6-9], 119[00-18], 11974,
  1203[0-2], and 12205 from xen-unstable so that the PV drivers
  can compile on older kernels such as sles9 and rhel4
- Fix netfront.c to fail the probe if it is called for an ioemu
  type device.  This allows both PV and FV drivers to exist at
  same time in the FV guest.
* Thu Nov  9 2006 ccoffing@novell.com
- Add xen-vm-install.
- Default bridge correctly for HVM guests. (#219092)
* Wed Nov  8 2006 aj@suse.de
- Set correct permissions on man files.
* Tue Nov  7 2006 ccoffing@novell.com
- Update name of blktap.ko in xend init script. (#215384)
- Remove some extraneous bad chars in xm manpage. (#218440)
- Update logrotate.conf.
- Update spec file.
* Wed Nov  1 2006 kallan@novell.com
- Backport xen-unstable changesets 12040 to address spurious
  interrupts with PV drivers in HVM guests.
* Tue Oct 31 2006 ccoffing@novell.com
- Backport xen-unstable changesets 1184[1-3] to address SVM
  interrupt injection issues.  Replaces earlier (broken) patches.
* Mon Oct 30 2006 ccoffing@novell.com
- /var/lib/xen/images should not be world readable. (#214638)
- Update to xen-3.0.3-0 (changeset 11774; no code changes).
* Mon Oct 16 2006 ccoffing@novell.com
- Update to xen-3.0.3-testing changeset 11772 (rc5).
- Fix several possible type errors when running domUloader.
- Remove pygrub.  Was broken on reiserfs and never had ext2
  support, so it is useless. (#173384)
- First attempt at moving domUloader to blktap.  Still disabled
  due to block-detach failing.
* Fri Oct 13 2006 ccoffing@novell.com
- Update to xen-3.0.3-testing changeset 11760 (rc4).
* Tue Oct 10 2006 ccoffing@novell.com
- Update to xen-3.0.3-testing changeset 11740 (rc3).
- Fix crash on PAE when specifying dom0_mem=4096M. (#211399)
- Make xend.balloon aware of kernel's memory floor, to fix
  "Privileged domain did not balloon" errors. (#184727)
* Mon Oct  9 2006 ccoffing@novell.com
- Include AMD's interrupt injection fix.
* Wed Oct  4 2006 ccoffing@novell.com
- Imported keymap patch. (#203758)
- Account for minimum memory required by dom0 kernel. (#184727)
- Package /usr/include/xen/hvm/*.h
* Tue Oct  3 2006 ccoffing@novell.com
- Update to xen-3.0.3-testing changeset 11686.
* Tue Oct  3 2006 kallan@novell.com
- Updated README.SuSE to reflect the current method of handling
  Xen network-bridging when using SuSEfirewall2.  (#205092)
* Sat Sep 30 2006 aj@suse.de
- Cleanup BuildRequires.
* Thu Sep 28 2006 ccoffing@novell.com
- Only "eval" disks once in domUloader, to match current Xen.
* Wed Sep 27 2006 ccoffing@novell.com
- Switch to xen-3.0.3-testing tree; changeset 11633.
- Update (but disable) paravirtualized framebuffer patches.
* Tue Sep 26 2006 ccoffing@novell.com
- Update to xen-unstable changeset 11623.
- Fix domUloader typo introduced in last update.
- Build debug version of xen-pae.
* Mon Sep 25 2006 ccoffing@novell.com
- Update to xen-unstable changeset 11616.
* Tue Sep 12 2006 ccoffing@novell.com
- Update check_python script to identify Python 2.5 RCs as valid.
* Mon Sep 11 2006 ccoffing@novell.com
- Update to xen-unstable changeset 11440.
- xen-tools conflicts with qemu.  Do not package qemu.1 manpage.
  (#204758)
- Include Jan's updated patch for #192150 (to preserve register
  context when doing IO).
* Tue Sep  5 2006 ccoffing@novell.com
- Update block-nbd and xmexample.nbd, and add block-iscsi and
  xmexample.iscsi (from Kurt).
* Thu Aug 31 2006 ccoffing@novell.com
- Automatically create/destroy virtual frame buffer viewer.  Add
  "sdl=1" to config file of a paravirtualized VM to get the viewer.
- Log files have moved to /var/log/xen.
* Tue Aug 29 2006 ccoffing@novell.com
- xendomains does not actually save domains.  (#201349)
- Update to xen-unstable changeset 11299.
* Mon Aug 28 2006 ccoffing@novell.com
- Fix incorrect path on x86_64 for vncfb and sdlfb.
* Thu Aug 17 2006 ccoffing@novell.com
- Improve xendomains init script, to handle unset sysconfig vars.
- Import virtual framebuffer patches.
- Drop reboot patch; resync patches.
* Wed Aug 16 2006 ccoffing@novell.com
- Update to xen-unstable changeset 11134.
- Drop xen-reverse-10064.diff now that kernel is updated.
* Tue Aug  8 2006 ccoffing@novell.com
- Re-enabled patch for #184175.
- Update to xen-unstable changeset 10986.
- Include Jan's patch to preserve register context when doing
  IO.  (#192150)
* Fri Jul 28 2006 ccoffing@novell.com
- Add support to domUloader for "xm create --dry-run".  Based on
  patch from HP.
* Thu Jul 27 2006 ccoffing@novell.com
- Add link for qemu-dm that is invariant across architectures, so
  that VM config files can be simple key/value pairs parsable by
  yast, and still be movable to another arch.  (#193854)
- Add loop.ko to rescue image created by mk-xen-rescue-img, and
  remove usbfs from image's /etc/fstab since USB isn't yet
  supported, to avoid errors during boot.  (#191627)
* Mon Jul 17 2006 ccoffing@novell.com
- Update to xen-unstable changeset 10712.
- Update domUloader and rcxend to work with blktap.
* Fri Jul 14 2006 ccoffing@novell.com
- When waiting for domains to shut down, must also wait for
  loopback devices to be torn down, otherwise higher-level tools
  may migrate a VM before the disk image is flushed.  (#185557)
- More updates to the README.
* Thu Jul 13 2006 kallan@novell.com
- Added for loop to retry the losetup -d in /etc/xen/scripts/block.
  It is possible for the losetup -d to fail if another process is
  examining the loopback devices e.g. losetup -a.  (#151105)
* Wed Jul 12 2006 ccoffing@novell.com
- Corrected and updated README.
* Mon Jul 10 2006 ccoffing@novell.com
- Add Jeff Mahoney's block-sync.diff, to give control of
  "losetup -y" to the user (and potentially yast).  Defaults to
  old async behavior.  (#190869)
* Thu Jul  6 2006 ccoffing@novell.com
- Update to xen-unstable tree.  Revert changeset 10064, to maintain
  backwards compatibility with SLES 10.
* Wed Jul  5 2006 ccoffing@novell.com
- Do not open migration port by default.  (#190170)
- Update patch for migration oops, to latest version in bug
  [#162865].
* Mon Jul  3 2006 okir@suse.de
- xen-losetup-sync.diff: use the new "losetup -y" option to force
  the loop device to use synchronous I/O (#189051)
* Fri Jun 30 2006 ccoffing@novell.com
- Increase balloon timeout value.  (#189815)
- Update to xen-3.0-testing tree, changeset 9762.
* Thu Jun 29 2006 ccoffing@novell.com
- Fix some loopback races in domUloader.  (#151105)
* Tue Jun 27 2006 ccoffing@novell.com
- Add "max_para_memory" and "max_hvm_memory" to output of "xm info"
  for bug #184727.
- Include Jan's patches for bug #184175.  Improves PAE guest
  support on HVM.
* Mon Jun 26 2006 ccoffing@novell.com
- Include patch from HP to fix a domU migration failure ("Kernel
  BUG at mm/mmap.c:1961").  Force L1/L2 page tables to be updated
  at the end, to avoid them from being dirtied and not transferred.
  (#162865)
* Fri Jun 23 2006 kallan@novell.com
- Updated xen-bonding.diff to enable bonding again after the latest
  patches to network-bridge etc. (#161888)
* Wed Jun 21 2006 ccoffing@novell.com
- Clean up the useless "Nothing to flush" messages, from 'ip addr
  flush', in /var/log/xen-hotplug.log
- Fix race condition in domUloader.py, when another process did
  losetup -d while domUloader was running.  This would result in
  the mount failing, and so the VM would fail to start.
* Tue Jun 20 2006 ccoffing@novell.com
- Revamp balloon.py to account for pages currently being
  scrubbed.  (#185135)
* Mon Jun 19 2006 ccoffing@novell.com
- Update to xen-3.0-testing tree, changeset 9749.
- DomUs are getting starved for CPU (up to 40 seconds was seen)
  when dom0 has a load.  This can cause pathological behavior, and
  can cause OCFS2 to fence (panic) the domain.  (#179368, #178884)
- Import Gerd's fix to network-bridge script for bug #161888.
* Wed Jun 14 2006 ccoffing@novell.com
- Pull out accidentally-included debugging code.
- Drop xenvers patch; this was for backwards compatibility for
  some early internal builds.
- Update from Jan on the console patch.  Not all graphics cards /
  drivers properly reflect the state in the register being tested.
  Improved the check, to prevent screen corruption.  (#161541)
* Tue Jun 13 2006 ccoffing@novell.com
- Resync with new tarball from xen-3.0-testing; changeset 9738.
* Mon Jun 12 2006 ccoffing@novell.com
- Drop BUILD_BUG_ON and pirq-shared patches.  Last week's pirq
  sharing patch from upstream (for bug #152892) makes these patches
  redundant.  Dropping these makes our shared_info structure match
  upstream again, which is needed for compatibility with other
  paravirtualized guests.
- Import changeset 9734 from xen-3.0-testing.  This fixes a hyper-
  call (used by the pcifront driver) to work on MP guests.  Without
  this, the pciback driver can hang on MP.  (#181467)
- Import changeset 9733 from xen-3.0-testing.  This patch is
  required to match the Linux kernel, since Linux always calls
  this operation from VCPU0 during secondary VCPU bringup.
  Without this, process run-time accounting on secondary CPUs is
  completely wrong.
- Updated README:  Documented work-around for bug #180058.
* Fri Jun  9 2006 ccoffing@novell.com
- Include Jan's patch: "IOPL is ignored for VM86 mode port
  accesses.  Fix Xen emulation to match native behaivour."  Fixes
  some X lockup issues.  (#179045)
- Include Keir's patch to allow reading from port 0x61, to avoid
  an X server lockup.  (#171087)
- Include xen-3.0-testing changeset 9726, which is needed to
  support the latest kernel-xen.  With this support, Linux will
  only trigger unhandled IRQ path if IRQ is not shared across
  multiple guests (another guest may have handled the interrupt).
  This is more upstream work that goes with bug #152892.
- Add versioning to the Requires lines, to guard against mixing
  binary incompatible versions.  (#183292)
- I accidentially dropped part of Clyde's fix for bug #162244.
  SMP support in HVM is working in xen-unstable, so upstream
  dropped the HT CPUID masking code, which we then inheirited.
  Re-add HT CPUID masking.  (#162244)
- Updated README:  VNC installations, known issues.
* Thu Jun  8 2006 ccoffing@novell.com
- Drop our XCHG patch for the equivalent upstream patch, to fix
  patch application order.  No code change.
* Wed Jun  7 2006 ccoffing@novell.com
- Updated README:  HVM issues/tips, CDROM tips, known issues.
- Add patch from Intel to decode LODS/STOS instructions to fix
  Windows installation.  Only affects HVM.  Xen changeset #9725
  consolidates this patch and xen-hvm-decode.diff; drop our 2 in
  favor of the consolidated upstream patch.  (#176717)
* Tue Jun  6 2006 ccoffing@novell.com
- Drop xen-8-way-bios patch, because it breaks Windows HVM
  installation.  The patch was only necessary when running SMP HVM
  with "acpi=0" on the kernel command line.  (#181974)
- Include two patches from xen-3.0-testing that change the
  interface between Xen and guests.  Including these now to help
  forward-compatibility:
  + 9709: Changes interface for accessing %%cr3 so that extra bits
    (>4GB) for PAE pgdirs are placed in low-order bits of %%cr3.
    Kernels without support for this will still run fine.
  + 9721: Use explicitly-sized types in the dom0_ops and privcmd
    structures.
- Fix ability to change ISOs images for HVM guest.  (#181895)
- Removed pointless whitespace changes from xen-removable.diff, for
  better maintainability.  Cut the patch size in half; no code
  changes.
* Mon Jun  5 2006 ccoffing@novell.com
- Include select patches from xen-3.0-testing:
  + 9698: Official fix for bug #159001.  Dropped our patch.
  + 9702: Fix MMU_NORMAL_PT_UPDATE when passed a page that is no
    longer of type page-table.
  + 9703: Modification to fix for bug #159001; ignore empty PTEs.
  + 9704: Fix for obvious typo in map_pages_to_xen: When replacing
    a pte, free the page table pointed to by the old entry, not the
    new entry.
  + 9705: Jan's previous signed-ness patch (c/s 9695) was changed
    when accepted upstream, which broke it; this changeset
    attempts to fix the breakage.
  + 9708: HVM: Fix a hang when doing an "xm destroy" of Windows VM.
  + 9717: HVM: Interrupts must be kept disabled when entering Xen
    for external interrupt processing.
* Fri Jun  2 2006 ccoffing@novell.com
- Include xen-3.0-testing changeset 9693.  This scales the
  ballooning timeout with the amount of memory being requested
  (necessary for large memory machines).  This is a more proper fix
  for Novell bug #175805, and addresses XenSource bug #650.
* Thu Jun  1 2006 ccoffing@novell.com
- Update the README, regarding how to make the mouse work properly
  with VNC in HVM.
- Update help text in mk-xen-rescue-img.
* Wed May 31 2006 ccoffing@novell.com
- Jan's backport of xen-unstable changesets 9517, 9518, and 9529.
  This allows Xen to boot on 4-node configurations without
  crashing.  (#150114)
- Include patch from Jun Nakajima at Intel to fix inability to
  start XWindows after creating HVM guest.  (#159001)
- Include select patches from xen-3.0-testing:
  + 9697: Fix infinite recursion loop in get_page_type() error path
- Include xen-unstable changeset 9967, to improve Summagraphics
  tablet emulation, to help mouse tracking in HVM.  (#167187)
- Include 3 patches from AMD to fix SMP support in HVM.  (#176171)
- Add CPUID masking patches from AMD and Intel for HVM.  This
  prevents the OS from seeing (and trying to use) various hardware
  features that are not supported within the VM.  (#180879)
* Fri May 26 2006 ccoffing@novell.com
- Fix deadlock between xm and qemu.  Qemu should not call xm;
  issue xc commands directly.  This deadlock was exposed when
  making qemu exit nicely and clean up.  (#176400)
- Include Gerd's update to his previous REP MOVS fix.  Calculating
  high_addr and low_addr is more complicated than previously
  thought, and the count was wrong.  (#165448).
- Drop previous patch that forcefully turns off Xen's console
  logging to avoid video corruption; instead use Jan's patch which
  only turns logging off when in graphical mode.  (#161541)
- Include Jan's patch to call machine_halt rather than inline
  assembly "hlt" when Xen crashes to sync display, disable watchdog
  timers, etc.
- Tweak the auto-ballooning patch to limit the VM itself to the
  requested amount of memory, don't include the overhead, as
  suggested by Intel.  Separate calls exist elsewhere to increase
  the max as needed.  (#149179)
- Include select patches from xen-3.0-testing:
  + 9688, 9696:  These remove some broken assembly string
    functions.  This is prep work from Jan for bug #160066.
  + 9695: Updates in the hypervisor to EDI and ESI could be
    incorrect, due to sign not being handled correctly.
* Fri May 19 2006 ccoffing@novell.com
- Update from Intel to previous patch to fix installation of HVM
  W2k.  Adds decoding for two more instructions.  (#176717)
- Updated the README.
- Included updated version of KY's patch to reserve some lowmem
  for PAE, to avoid kernel BUG() during boot.  The amounts of
  memory reserved at various physical memory sizes have been
  adjusted.  (#175124)
- Include Intel's patch for unchecked allocations in shadow*.c.
  (#149179)
* Thu May 18 2006 ccoffing@novell.com
- Include Intel's patch to fix installation of HVM W2k.  This patch
  adds decoding for 'xor' and 'and' instructions.  Without this,
  the VM crashes when W2k attempts to install network components.
  (#176717)
- While tidying xen-hvm-memory-check.diff for submission upstream,
  I noticed an error in the patch (such that low-memory while
  starting the HVM domain could still crash the physical machine.)
  Now all uses of iopm are protected by the check.  (#149179)
- Xen must always relinquish control of the VGA console once dom0
  has started.  Otherwise, it could be over-writing dom0's memory,
  causing screen or other memory corruption.  Admin can use
  "xm dmesg" to view Xen's log instead.  (#161541)
- First send a SIGTERM, rather than SIGKILL, to qemu to give it a
  chance to clean up.  This fixes both mouse and CD-ROM issues
  for fully virtualized VMs.  This is a work-around; Ross is
  still working on the proper fix.  (#176400, #171258, #176157)
- Include select patches from xen-3.0-testing:
  + 9682,9683: These patches only affect full virtualization on
    AMD.  Fixes register corruption, cleans up event injection,
    cleans up IO handling.
  + 9685,9686: This patch only affects full virtualization on
    Intel.  Fixes VM's segment base address, to avoid vmentry
    failure.  Also remove 32/64 differences in vmx reg store/load.
* Wed May 17 2006 ccoffing@novell.com
- When auto-ballooning domain 0's memory for a new HVM domain,
  all memory (including memory intended for overhead) was given
  to the VM itself.  So increasing the memory size calculations
  did not actually free up any more memory.  Now, treat the amount
  to balloon and the amount to give to the VM as separate values.
  (#149179)
* Tue May 16 2006 ccoffing@novell.com
- Include Gerd's fix for HVM emulation of REP MOVS when the copy
  spans a page.  If the direction flag was set, the emulation code
  broke.  This caused the VM to freeze when configuring firewall
  (#165448).
- Include KY's fix to default to reserving 16M of lowmem for PAE,
  to avoid hitting kernel BUG() during boot (#175124).
- Don Dugger's (Intel) fix for HVM screen corruption (#164573).
- Increase maximum time auto-ballooning will wait for domain 0 to
  respond, otherwise large VMs will fail to start from yast
  (#175805).
* Mon May 15 2006 ccoffing@novell.com
- Update memory size calculations when auto-ballooning for HVM
  to make more stable (#149179).
* Fri May 12 2006 ccoffing@novell.com
- Include select patches from xen-3.0-testing:
  + 9674: xc_ptrace: Fix reversed conditional, which broke single-
    stepping.
  + 9675: xc_ptrace: Fix out-of-bounds memory-access for FPU state.
  + 9678: Fix the performance issues of 2-level paging HVM guests
    on the PAE Xen.
- Update man pages.
* Wed May 10 2006 brogers@novell.com
- Fix loading of binary images which either require PAE or
  dynamically support running on both PAE hypervisor and non-PAE
  hypervisors. (#174080)
* Wed May 10 2006 carnold@novell.com
- Handle memory failure when staring fully virtualized
  guests to prevent reboot of the box (AMD) or
  hanging the box (VT) (#149179).
* Tue May  9 2006 ccoffing@novell.com
- Include select patches from xen-3.0-testing:
  + 9665: Fix pciif parsing for compatibility variable.
  + 9666: Fix HVM hang; was broken due to previous "hda lost
    interrupt" patch. (#169146)
  + 9667: Do not set GP fault in VMCS for VMX (no bug#; from Intel)
* Thu May  4 2006 cgriffin@novell.com
- Update xen-3.0-testing tree, changeset 9664:
  + Changesets 9663 and 9664 fix AMD fully virtualized
    guests causing the system to reboot when
    first starting up.  (#169855)
* Thu May  4 2006 cgriffin@novell.com
- With a Xen domain set up with a loop-mountable file as rootfs,
  the "xm start " invocation fails. The cause is a bug
  domUloader.py (#172586)
* Thu May  4 2006 rmaxfiel@novell.com
- Added the ability to 'attach' and 'detach' removable media
  devices to hvm guests.  Also made cdrom eject when the eject
  request comes from the hvm guest. (#159907)
- Fixed the loss of mouse when a SDL session ends with 'grab'
  in effect.  (#159001)
* Thu May  4 2006 cgriffin@novell.com
- Update xen-3.0-testing tree, changeset 9661:
  + Drop patches merged upstream
  + Took Kier's official patches for dropped patches most
    notably spurious interrupts (#152892)
- Took Intel's patch to fix screen corruption when
    resizing the screen of windows hvm guests (#164573)
* Wed May  3 2006 kallan@novell.com
- Added configuring network interfaces when using Xen bridging instructions
  to the README.SuSE file as requested by bug #171533.
* Mon May  1 2006 tthomas@novell.com
- Added message to xm save to indicate that save is not currently
  supported for fully virtualized guests. (#161661)
* Fri Apr 28 2006 ccoffing@novell.com
- Close fds before exec-ing vncviewer, so yast2-vm doesn't hang
  when viewing fully-virtualized console (#168392).
* Thu Apr 27 2006 ccoffing@novell.com
- Update xen-3.0-testing tree, changeset 9656:
  + Drop patches merged upstream.
  + Fix reboot on large SMP machines (IBM, no bug #).
- Integrate Jan's patches:
  + Spurious interrupt roundup (#152892).
* Mon Apr 24 2006 ccoffing@novell.com
- Integrate Jan's patches:
  + FXSR patch (#135677).
  + APIC option patch (work-around #150114).
  + Protect against hypervisor crash (#169143).
- Update xen-3.0-testing tree, changeset 9649:
  + Avoid spurious timer activations in hypervisor.
  + Fix xen command line parsing (lapic / nolapic parsing).
  + Fix inverted BUG_ON w.r.t. SiS APIC bug.
* Fri Apr 21 2006 ccoffing@novell.com
- Update to 3.0.2-2 (xen-3.0-testing tree, changeset 9640):
  + Fix for "hda lost interrupt" for PAE VMX.
  + Increase L2 PDE to 1 GB; allows x86_64 to boot larger dom0.
  + Fix for SVM booting 32pae-on-32pae.
- Drop upstream patches (SiS APIC bug, HTT, HVM interrupt race)
- Add Jan's port of spurious interrupt patch (#152892).
- Add /etc/xen/images link for convenience (#168070).
- Updated README.
* Thu Apr 20 2006 ccoffing@novell.com
- SiS APIC bug patch (Jan Beulich, #116485).
* Wed Apr 19 2006 ccoffing@novell.com
- Don't kill xenstored and xenconsoled when stopping xend.
  (#158562, #156261)
* Wed Apr 19 2006 ccoffing@novell.com
- Update to 3.0.2-2 (xen-3.0-testing tree, changeset 9629):
  + Fix for SMP IA32 VMX guest booting.
  + KY's SETMAXMEM fix.
* Wed Apr 19 2006 cgriffin@novell.com
- Removed HTT bit from cpuid and set logical processor count to 1.
  Also fixed logic problem in svm code where apic=0 was not
  handled (#162244).
* Wed Apr 19 2006 agruen@suse.de
- Create /boot symlinks in the %%install section instead of in
  %%post so that they will end up in the package file list.
* Tue Apr 18 2006 ccoffing@novell.com
- Add /etc/xen/vm to vm config file search path (#167208).
* Fri Apr 14 2006 kallan@novell.com
- Add support for bonding in network-bridge. (#161678).
* Fri Apr 14 2006 ccoffing@novell.com
- Update to 3.0.2-2 (xen-3.0-testing tree, changeset 9620):
  + Fixes stack corruption in libxs (XenSource #411).
* Thu Apr 13 2006 rmaxfiel@novell.com
- Fixed a problem in ioemu which exited when the cdrom line was
  found in the guest def file but the cd device contained no media.
  (#161210)
* Wed Apr 12 2006 ccoffing@novell.com
- Auto-balloon domain 0 for HVM domains (#149179).
- Update to 3.0.2-1 (xen-3.0-testing tree, changeset 9612):
  + Fixes xmlrpc issues.
  + Fixes several emulated instructions for HVM.
  + Fixes for x86_64 inline assembly.
* Tue Apr 11 2006 ccoffing@novell.com
- Fix "jitter" and race in dom0's memory target calculation, which
  could cause auto-ballooning to fail (#164714).
* Tue Apr 11 2006 brogers@novell.com
- Fix problem where localtime=1 results in zombie domains after
  they shutdown (#164960)
* Mon Apr 10 2006 ccoffing@novell.com
- Update to hg 9598 (xen-3.0-testing tree; 3.0.2-rc).  Discounting
  Linux changes and patches we already carry, this update contains:
  + Saner error handling in iret hypercall (x86/64).
  + Make root page table sanity check on restore more generic.
  + Additional sanity / compatability checks during guest build.
  + IO-APIC update hypercall fixes.
* Fri Apr  7 2006 ccoffing@novell.com
- Don't throw an exception if 'xm top' is run by non-root; print
  error message instead (#164224).
- Change localtime patch to account for daylight savings time
  (Bruce Rogers).
- Re-add patch to make tightvnc work.  It was accidentally dropped
  recently (#149556).
* Thu Apr  6 2006 ccoffing@novell.com
- Update to hg 9590 (xen-3.0-testing tree; 3.0.2-rc).
- Fix type error in localtime patch for para (Bruce Rogers).
- Fix default localtime for full (Bruce Rogers).
- Fix path in mk-xen-resue-img.sh (#163622).
- Update README (pathnames, yast2-vm descriptions, terminology).
* Mon Apr  3 2006 garloff@suse.de
- init script: Test for control_d in capabilities to determine dom0
  rather than privcmd.
- init script: Try loading netloop and backend modules.
- mk-xen-rescue-img.sh: Copy frontend drivers, remove stale files.
- example config files: provide commented out domUloader exmaples.
* Mon Apr  3 2006 ccoffing@novell.com
- Update to hg 9514 (xen-unstable tree; 3.0.2-rc).
- Fix for rebooting (Jan Beulich; #160064).
* Fri Mar 31 2006 ccoffing@novell.com
- Update to hg 9502 (xen-unstable tree; 3.0.2-rc).
- Update man page (#162402).
- xen-tools requires python-xml (#161712).
- Include localtime patch to support NetWare (Bruce Rogers).
* Thu Mar 30 2006 ccoffing@novell.com
- Update to hg 9481 (xen-unstable tree; 3.0.2-rc).
- Correctly default XAUTHORITY if it is not set.  This allows the
  GUI to come up for fully virtualized guests (was especially
  problematic when VM was started from YaST).  (#142472)
* Wed Mar 29 2006 ccoffing@novell.com
- Fixed reversed "Do I have enough memory?" test when creating
  new VMs (#156448).
* Tue Mar 28 2006 ccoffing@novell.com
- Pick up two critical fixes for AMD to fix full virtualization:
  c/s 9453 & c/s 9456.
* Thu Mar 23 2006 ccoffing@novell.com
- Update to hg 9434 (xen-unstable tree; 3.0.2-rc).
- Fix /etc/xen/scripts/block to properly check if devices can be
  shared.
- Default XENDOMAINS_AUTO_ONLY to true; previous setting
  contradicts yast2-vm's claim that only VM's marked auto will be
  auto-started.
* Mon Mar 20 2006 ccoffing@novell.com
- Update to hg 9329 (xen-unstable tree).
* Wed Mar 15 2006 ccoffing@novell.com
- Update to hg 9251 (xen-unstable tree).
- Update to latest versions of Intel's VNC patches:
  patch-vga-sse2-0314.l, patch-vnc_loop-0314.l,
  patch-vncmouse-0315.l
- Gather example files in /etc/xen/examples.
* Tue Mar 14 2006 rmaxfiel@novell.com
- Removed the intermediate sym-link between xen.gz and
  xen-<version>-<release>.gz.  Grub 0.97 XFS can not handle a
  double indirect to a file.  (#151792)
* Mon Mar 13 2006 garloff@suse.de
- Update README.SuSE: Document limits (mem, cpu hotplug, max_loop),
  more network troubleshooting, update security info.
- Be more tolerant against errors in ifdown/ifup to better coexist
  with non-std network setups (e.g. ifplugd/NetworkManager).
* Tue Mar  7 2006 ccoffing@novell.com
- Update to hg 9172 (xen-unstable tree).
- Create new xen-libs package, split from xen-tools (#154473).
- Update mk-xen-rescume-img and xmexample.rescue to work with
  current rescue image on CD (#152971).
- Include Kurt's patch to domUloader, to pass command line args.
- xendomains shouldn't try to migrate or save HVM domains, as this
  isn't supported and will stall the shutdown (#155265).
- Create empty /etc/xen/vm directory for YaST to place config files
  in, to avoid name collisions (#156322).
- Update and re-enable vga patch from Intel (Don Dugger).  VGA
  emul is faster and not corrupted.
- ifup is run to ensure IPs are assigned before rearranging for
  xen, but this can fail with ifplugd; this should not kill the
  whole script (Kirk Allan) (#154115).
- Make network-bridge script more robust, by checking /sys instead
  of grep-ing.
* Mon Mar  6 2006 ccoffing@novell.com
- Update to hg 9148 (xen-unstable tree).  Drop patches merged
  upstream.
- More README improvements (#154134).
- Fix "vncviewer=1" to bring up vncviewer (#149556).
* Mon Mar  6 2006 ccoffing@novell.com
- Fix build of hvmloader and vmxassist by removing external
  CFLAGS (XS changeset #9110).
- Fix build by forcing --prefix during installation of *.py.
* Wed Mar  1 2006 ccoffing@novell.com
- Update to hg 9029 (xen-unstable tree).  Adds support for HVM on
  64 bit hardware.
- Update vncmouse diff to 20060301 from Intel; compensates for lack
  of eager events in our LibVNCServer.
- Fix many bugs in lomount.
- Cap maximum value of "xm mem-set" for domain 0, based on size of
  dom0's page tables (#152667).
* Mon Feb 27 2006 ccoffing@novell.com
- Update to hg 9015 (xen-unstable tree).  More bug fixes.
- Update patch to better honor RPM_OPT_FLAGS.
- Updated README (#154134).
- Disable xen-vga-0213 patch; it speeds VGA updates but was
  corrupting the display.
- Change max mouse polling time from 1ms to 10ms to reduce CPU
  load (from Intel).
* Thu Feb 23 2006 ccoffing@novell.com
- Update to hg 8954 (xen-unstable tree).  More bug fixes.
- Don't use a dummy IP of 1.2.3.4 for NFS server when booting domU
  with DHCP.  Seems to hang x86_64 Linux.
- Remove unnecessary x86_64 patch.
- Fix auto-ballooning of dom0 memory for HVM domUs (XenSource bug
  521).
* Tue Feb 21 2006 ccoffing@novell.com
- Update to hg 8920 (xen-unstable tree).  Fixes instruction decode
  for fully virtualized guests, fixing booting from CDs.
- Integrate 3 patches from Intel, to improve VNC performance.
* Tue Feb 21 2006 ccoffing@novell.com
- Update to hg 8910 (xen-unstable tree).
  fixes 32 on 32, 32 pae on 32pae, 64 on 64, 32 on 64.
  critical HVM fixes, for fully virtualized guests.
* Fri Feb 17 2006 ccoffing@novell.com
- Update to hg 8870 (xen-unstable tree).  More HVM fixes.
- Remove duplicate balloon.free call.
- Add patch from Intel to fix dom0 crash on 64 bit SMP HVM.
* Thu Feb 16 2006 carnold@novell.com
- Update to hg 8858 (xen-unstable tree).
* Wed Feb 15 2006 ccoffing@novell.com
- Update to hg 8857 (xen-unstable tree).  Syncs hypervisor core
  with Linux 2.6.16, which may fix some ACPI issues.  Fixes HVM.
- Fix uninitialized variable in xc_load_bin (from Bruce Rogers).
- Auto-balloon dom0 for fully virtualized domains (#149179).
- xen-doc-html was missing image files.
* Mon Feb 13 2006 ccoffing@novell.com
- Update to hg 8830 (xen-unstable tree).
- Restore cs 8783/8792 to match kernel.
* Wed Feb  8 2006 ccoffing@novell.com
- Update to hg 8800 (xen-unstable tree).
- Update BuildRequires.
- Add "max-free-memory" to "xm info", to support yast2-vm (#147612)
- Insserv xendomains, to support yast2-vm.
- Fix exit code of "xend stop".
- Revert cs 8783/8792 to allow xenstore to start (until kernel
  catches up).
- Ensure eth0 aka veth0 really comes up in network-bridge.
* Sat Feb  4 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Fri Jan 27 2006 ccoffing@novell.com
- Update to hg 8728 (xen-unstable tree).
- Improve network-bridge:
  + Ensure netdev really is up, to fix STARTMODE="manual".
  + Stop ifplugd when doing ifdown, to fix STARTMODE="ifplugd".
  + Improve check for whether bridge already exists.
  + Improve defaults for netdev.
- Fix log rotate so xend moves to new log.
- xen-tools "Requires" python, et.al.; xen proper doesn't.
- Revamp mk-xen-rescue-img.sh (#118566).
- Revamp rcxendomains:  improved output, error checking, return
  values (#143754, #105677).
* Tue Jan 24 2006 ccoffing@novell.com
- Update to hg 8659 (xen-unstable tree).
* Mon Jan 23 2006 ccoffing@novell.com
- Correct return values and improve messages of init scripts.
* Fri Jan 20 2006 ccoffing@novell.com
- Use domUloader instead of pygrub.
* Thu Jan 19 2006 carnold@novell.com
- Build based on the xen-unstable.hg 8628
* Wed Jan 18 2006 carnold@novell.com
- Update to hg 8646 xen-unstable-hvm.hg tree.
* Fri Jan 13 2006 ccoffing@novell.com
- Allow version string "XEN_VER=3.0" instead of just
  "XEN_VER=xen-3.0" for backwards compatibility.
- Correctly set changeset in compile.h.
* Thu Jan 12 2006 carnold@novell.com
- Added two patches from AMD that apply to the 8513 changeset.
* Thu Jan 12 2006 kukuk@suse.de
- Add libreiserfs-devel to nfb.
* Wed Jan 11 2006 carnold@novell.com
- Update to hg 8513 xen-unstable-hvm.hg tree.
* Tue Jan 10 2006 ccoffing@novell.com
- Update to hg 8269 (xen-3.0-testing).
- Support try-restart in init scripts.
- Clean up installation of udev rules.
* Wed Dec 14 2005 ccoffing@novell.com
- Update to hg 8257 (xen-3.0-testing).
- Update documentation.
- Fix gcc 4.1 warnings.
* Wed Dec  7 2005 ccoffing@novell.com
- Update to hg 8241 (xen-3.0-testing).
* Mon Nov 28 2005 ccoffing@novell.com
- Update to hg 8073.
- Rationalize command names (eg, setsize -> xentrace-setsize).
- Fix gcc 4.1 warnings.
* Wed Nov 16 2005 ccoffing@novell.com
- Update to hg 7782.
- Honor RPM_OPT_FLAGS better.
- Include a few simple, obvious fixes from upstream.
- Build xm-test package.
- Update udev scripts.
* Mon Nov 14 2005 ccoffing@novell.com
- Includes upstream fixes to fix i586 save/restore.
* Thu Nov 10 2005 ccoffing@novell.com
- Include a few simple, obvious fixes: 7609, 7618, 7636, 7689,
  7690, 7692, 7696
* Thu Nov  3 2005 ccoffing@novell.com
- Update to hg 7608.
- Fix warn_unused_result warnings.
- Drop some patches (merged upstream)
- Tidy README.SuSE.
* Tue Nov  1 2005 ccoffing@novell.com
- Update to hg 7583.
* Thu Oct 20 2005 ccoffing@novell.com
- Don't mention unwritten man pages.
- Update xmexample* to match SUSE paths.
- Update xs-include patch.
* Wed Oct 19 2005 garloff@suse.de
- Avoid race in watchdog functionality.
- Improve network-bridge script.
* Tue Oct 18 2005 garloff@suse.de
- Ignore zombies in the xendomains shutdown procedure and have a
  configurable timeout for the commands. Make xendomains status
  report something useful.
- Make xendomains script comaptible to non-SUSE distros.
* Mon Oct 17 2005 garloff@suse.de
- Update to hg 7398.
* Mon Oct 17 2005 garloff@suse.de
- Create useful xendomains init script and sysconfig file.
* Mon Oct 17 2005 garloff@suse.de
- Create symlinks also for -pae and -dbg hypervisor.
- Build doxygen documentation.
- Include block-nbd script and xen-nbd example config.
- Include patchset info.
* Wed Oct 12 2005 garloff@suse.de
- Update docu.
- Enable xen-dbg hypervisor for gdbserver domU debugging.
* Tue Oct 11 2005 garloff@suse.de
- Update docu.
- Update to hg 7313.
- Move libxenstore.so to xen-tools.
* Tue Oct 11 2005 garloff@suse.de
- Fix buglet in /sbin/xen-vbd.
* Mon Oct 10 2005 garloff@suse.de
- Downgrade to hg 7267.
- Add troubleshooting section to README.SUSE.
* Mon Oct 10 2005 garloff@suse.de
- Fix typo in SrvDomain for mem-set operation.
- Workaround: write directly to balloon in dom0 setMemoryTarget.
- Kill xenconsoled and xenstored in rcxend stop.
* Sun Oct  9 2005 garloff@suse.de
- Update to hg 7278.
- Provide udev rules to setup vifs and vbds in dom0 when domUs
  boot (kraxel).
- Change default FS size for rescue images to 80MB.
* Sat Sep 10 2005 garloff@suse.de
- Update to hg 6715.
- Fix network-bridge down.
* Wed Sep  7 2005 garloff@suse.de
- Build PAE version along non-PAE version of Hypervisor.
* Tue Sep  6 2005 garloff@suse.de
- Try to fix network bridge down issue.
- Document netowrking and firewalling caveats in README.SUSE.
- Enable PAE.
* Tue Sep  6 2005 garloff@suse.de
- Update to hg 6644.
* Sun Sep  4 2005 garloff@suse.de
- Update to hg 6610.
- Rename default name of xen-br0 to xenbr0.
- Fix pygrub installation.
- Use libreiserfs to support pygrub on reiser.
* Mon Aug 29 2005 ccoffing@novell.com
- xen-bridge-net.diff: do not destroy domain 0's network setup
  when starting xend.
* Mon Aug 29 2005 garloff@suse.de
- Update to hg 6458.
- Drop privileged port check -- we use Unix dom sockets anyway
  (#105178).
- init.xend: Fix linebreaks in PID list.
- Correctly assign insserv to xen-tools subpackage.
* Thu Aug 25 2005 garloff@suse.de
- Add dirs /var/run/xenstored and /var/lib/xenstored.
* Thu Aug 25 2005 garloff@suse.de
- Update to hg 6393.
* Mon Aug 22 2005 garloff@suse.de
- Update to hg 6315.
- Include linux-public headers in xen-devel package.
* Sun Aug 21 2005 garloff@suse.de
- Update to hg 6305.
* Sat Aug 20 2005 garloff@suse.de
- Update to hg 6299.
- Enable VNC support (depending on LibVNCServer).
* Sat Aug 20 2005 garloff@suse.de
- Split off xen-tools-ioemu for supporting unmodified guests.
* Fri Aug 19 2005 garloff@suse.de
- Enable pygrub (at the cost of depending on e2fsprogs-devel)
- Enable VMX ioemu SDL support (at the cost of many dependencies)
* Fri Aug 19 2005 garloff@suse.de
- Update to mercurial changeset 6223.
- Move /usr/libexec/xen/ to /usr/lib[64]/xen/bin/.
- Split off -tools package.
* Mon Aug 15 2005 garloff@suse.de
- Create symlinks in %%post.
- Update README.SUSE.
- Mark /etc/xen/ as %%config(noreplace).
- Fix x86-64 build (movl -> mov, lib vs. lib64 inst dirs).
- Remove PYTHONOPTIMIZE.
* Tue Aug  2 2005 ccoffing@novell.com
- Fix warn_unused_result warnings
* Thu Jul 28 2005 ccoffing@novell.com
- Update to latest 3.0-unstable snapshot.
* Wed Jul 13 2005 ccoffing@novell.com
- Fixed bug in glibc24 patch that caused erroneous "out of memory"
  errors
* Fri Jun 24 2005 ccoffing@novell.com
- Fix gcc4 patch that caused a panic in Xen at boot.
* Fri Jun 24 2005 ccoffing@novell.com
- Fix xen-syms link.
* Fri Jun 17 2005 ccoffing@novell.com
- Fix version-check in NetWare loader (0x336ec577 -> 0x326ec578).
* Fri Jun 17 2005 ccoffing@novell.com
- Backport NetWare-friendly loader from Xen 3.0.
* Thu Jun 16 2005 ccoffing@novell.com
- Destroy domains that failed to be fully created.
* Fri Jun 10 2005 garloff@suse.de
- Update to latest 2.0-testing snapshot.
- Use RPM version and release no as xen version.
* Tue Jun  7 2005 garloff@suse.de
- Update mk-xen-rescue-img.sh script: Handle SLES9 better.
- Export PYTHONOPTIMIZE in xend start script.
* Mon Jun  6 2005 garloff@suse.de
- Merge _perform_err fixes.
* Mon May 23 2005 ccoffing@novell.com
- update to 2.0.6
* Wed Apr 13 2005 garloff@suse.de
- More gcc4 and binutils related fixes.
* Wed Apr 13 2005 garloff@suse.de
- Build fixes for gcc4.
* Sun Apr  3 2005 garloff@suse.de
- Update xen: Various fixes (scheduling, memset, domain crash
  handling) and enhancements (bg page scrubbing).
* Thu Mar 24 2005 garloff@suse.de
- xen-bridge-net.diff: Make sure bridge netdev is up after adding
  addresses to it.
* Wed Mar 23 2005 garloff@suse.de
- xen-secure.diff: Check for privileged port before allowing
  certain control operations.
- README.SUSE: Document this change.
* Wed Mar 23 2005 garloff@suse.de
- Require ports < 1024 to allow controlling VMs.
* Mon Mar 21 2005 garloff@suse.de
- Update xen.
* Wed Mar 16 2005 garloff@suse.de
- Update xen.
- Add /var/lib/xen/xen-db/ subdirs.
* Sun Mar 13 2005 garloff@suse.de
- Update to post-2.0.5
- Make /usr/sbin/xm root:trusted 0750
- Drop some patches (merged upstream)
* Tue Mar  8 2005 garloff@suse.de
- Update README with security notes.
- Update mk-xen-rescue-image.sh script allowing to specify the
  kernel version to be used.
- Rather than busy-looping, exit console on a domain that has
  shutdown.
* Mon Mar  7 2005 garloff@suse.de
- Update xen to latest snapshot.
- tgif not needed any more.
* Tue Mar  1 2005 garloff@suse.de
- Include serial-split from Charles Coffing.
* Mon Feb 28 2005 garloff@suse.de
- Update xen to latest snapshot.
* Mon Feb 21 2005 garloff@suse.de
- Update README.SuSE.
- Update xen to latest snapshot.
* Sun Feb 13 2005 garloff@suse.de
- Add init header to xendomains init script.
- Add bridge-utils dependency.
- Update config file and README.
- Activate xend init script on installation.
* Wed Feb  9 2005 ro@suse.de
- remove te_etex and te_pdf from neededforbuild.
* Wed Feb  9 2005 garloff@suse.de
- Update README about IDE dma.
- Default to dhcp.
* Wed Feb  9 2005 garloff@suse.de
- Update to xen post-2.0.4.
- Little bugfix for xen rescue install script.
- Update README.SUSE: Better explanation of root FS creation.
* Sun Jan 23 2005 garloff@suse.de
- Change some defaults to be more secure (xend only binds to
  localhost, ip spoof protection on).
- Avoid ipv6 issue with xend network script.
- Extensive docu in README.SUSE now.
- mk-xen-rescue-img.sh creates a xen root fs image from the std
  SUSE rescue image.
- Put boot.local script in root img to parse ip boot par.
* Thu Jan 20 2005 garloff@suse.de
- Update to newer snapshot.
* Wed Jan 19 2005 garloff@suse.de
- Update to xen-2.0-unstable (post 2.0.3).
* Thu Dec  9 2004 garloff@suse.de
- Initial creation of package xen, xen-doc-*.
- i686 only for now.
