/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import jcifs.smb.SmbFile;

public class TestLocking
implements Runnable {
    int numThreads = 1;
    int numIter = 1;
    long delay = 100L;
    String url = null;
    int numComplete = 0;
    long ltime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                SmbFile f = new SmbFile(this.url);
                SmbFile d = new SmbFile(f.getParent());
                byte[] buf = new byte[1024];
                int ii = 0;
                while (ii < this.numIter) {
                    TestLocking testLocking = this;
                    synchronized (testLocking) {
                        this.ltime = System.currentTimeMillis();
                        this.wait();
                    }
                    try {
                        double r = Math.random();
                        if (r < 0.333) {
                            f.exists();
                        } else if (r < 0.667) {
                            d.listFiles();
                        } else if (r < 1.0) {
                            InputStream in = f.getInputStream();
                            while (in.read(buf) > 0) {
                            }
                            in.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.err.println(ioe.getMessage());
                    }
                    ++ii;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ++this.numComplete;
            }
        }
        finally {
            ++this.numComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("usage: TestLocking [-t <numThreads>] [-i <numIter>] [-d <delay>] url");
            System.exit(1);
        }
        TestLocking t = new TestLocking();
        t.ltime = System.currentTimeMillis();
        int ai = 0;
        while (ai < args.length) {
            if (args[ai].equals("-t")) {
                t.numThreads = Integer.parseInt(args[++ai]);
            } else if (args[ai].equals("-i")) {
                t.numIter = Integer.parseInt(args[++ai]);
            } else if (args[ai].equals("-d")) {
                t.delay = Long.parseLong(args[++ai]);
            } else {
                t.url = args[ai];
            }
            ++ai;
        }
        Thread[] threads = new Thread[t.numThreads];
        int ti = 0;
        while (ti < t.numThreads) {
            threads[ti] = new Thread(t);
            System.out.print(threads[ti].getName());
            threads[ti].start();
            ++ti;
        }
        while (t.numComplete < t.numThreads) {
            TestLocking testLocking;
            long delay;
            do {
                delay = 2L;
                testLocking = t;
                synchronized (testLocking) {
                    long expire = t.ltime + t.delay;
                    long ctime = System.currentTimeMillis();
                    if (expire > ctime) {
                        delay = expire - ctime;
                    }
                }
                if (delay > 2L) {
                    System.out.println("delay=" + delay);
                }
                Thread.sleep(delay);
            } while (delay > 2L);
            testLocking = t;
            synchronized (testLocking) {
                t.notifyAll();
            }
        }
        ti = 0;
        while (ti < t.numThreads) {
            threads[ti].join();
            System.out.print(threads[ti].getName());
            ++ti;
        }
        System.out.println();
    }
}

