/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;

public class BufferCache {
    private static final int MAX_BUFFERS = Config.getInt("jcifs.smb.maxBuffers", 16);
    static Object[] cache = new Object[MAX_BUFFERS];
    private static int freeBuffers = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBuffer() {
        Object[] objectArray = cache;
        synchronized (cache) {
            if (freeBuffers > 0) {
                int i = 0;
                while (i < MAX_BUFFERS) {
                    if (cache[i] != null) {
                        byte[] buf = (byte[])cache[i];
                        BufferCache.cache[i] = null;
                        --freeBuffers;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return buf;
                    }
                    ++i;
                }
            }
            byte[] buf = new byte[65535];
            // ** MonitorExit[var0] (shouldn't be in output)
            return buf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getBuffers(SmbComTransaction req, SmbComTransactionResponse rsp) {
        Object[] objectArray = cache;
        synchronized (cache) {
            req.txn_buf = BufferCache.getBuffer();
            rsp.txn_buf = BufferCache.getBuffer();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseBuffer(byte[] buf) {
        Object[] objectArray = cache;
        synchronized (cache) {
            if (freeBuffers < MAX_BUFFERS) {
                int i = 0;
                while (i < MAX_BUFFERS) {
                    if (cache[i] == null) {
                        BufferCache.cache[i] = buf;
                        ++freeBuffers;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    ++i;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

