/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import jcifs.Config;
import jcifs.netbios.Name;
import jcifs.netbios.NameServiceClient;
import jcifs.util.Hexdump;

public final class NbtAddress {
    static final String ANY_HOSTS_NAME = "*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    public static final String MASTER_BROWSER_NAME = "\u0001\u0002__MSBROWSE__\u0002";
    public static final String SMBSERVER_NAME = "*SMBSERVER     ";
    public static final int B_NODE = 0;
    public static final int P_NODE = 1;
    public static final int M_NODE = 2;
    public static final int H_NODE = 3;
    static final InetAddress[] NBNS;
    private static final NameServiceClient CLIENT;
    private static final int DEFAULT_CACHE_POLICY = 30;
    private static final int CACHE_POLICY;
    private static final int FOREVER = -1;
    private static int nbnsIndex;
    private static final HashMap ADDRESS_CACHE;
    private static final HashMap LOOKUP_TABLE;
    static final Name UNKNOWN_NAME;
    static final NbtAddress UNKNOWN_ADDRESS;
    static final byte[] UNKNOWN_MAC_ADDRESS;
    static NbtAddress localhost;
    Name hostName;
    int address;
    int nodeType;
    boolean groupName;
    boolean isBeingDeleted;
    boolean isInConflict;
    boolean isActive;
    boolean isPermanent;
    boolean isDataFromNodeStatus;
    byte[] macAddress;
    String calledName;

    static {
        String localHostname;
        NBNS = Config.getInetAddressArray("jcifs.netbios.wins", ",", new InetAddress[0]);
        CLIENT = new NameServiceClient();
        CACHE_POLICY = Config.getInt("jcifs.netbios.cachePolicy", 30);
        nbnsIndex = 0;
        ADDRESS_CACHE = new HashMap();
        LOOKUP_TABLE = new HashMap();
        UNKNOWN_NAME = new Name("0.0.0.0", 0, null);
        UNKNOWN_ADDRESS = new NbtAddress(UNKNOWN_NAME, 0, false, 0);
        UNKNOWN_MAC_ADDRESS = new byte[6];
        ADDRESS_CACHE.put(UNKNOWN_NAME, new CacheEntry(UNKNOWN_NAME, UNKNOWN_ADDRESS, -1L));
        InetAddress localInetAddress = NbtAddress.CLIENT.laddr;
        if (localInetAddress == null) {
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                try {
                    localInetAddress = InetAddress.getByName("127.0.0.1");
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        if ((localHostname = Config.getProperty("jcifs.netbios.hostname", null)) == null || localHostname.length() == 0) {
            byte[] addr = localInetAddress.getAddress();
            localHostname = "JCIFS" + (addr[2] & 0xFF) + "_" + (addr[3] & 0xFF) + "_" + Hexdump.toHexString((int)(Math.random() * 255.0), 2);
        }
        Name localName = new Name(localHostname, 0, Config.getProperty("jcifs.netbios.scope", null));
        localhost = new NbtAddress(localName, localInetAddress.hashCode(), false, 0, false, false, true, false, UNKNOWN_MAC_ADDRESS);
        NbtAddress.cacheAddress(localName, localhost, -1L);
    }

    static void cacheAddress(Name hostName, NbtAddress addr) {
        if (CACHE_POLICY == 0) {
            return;
        }
        long expiration = -1L;
        if (CACHE_POLICY != -1) {
            expiration = System.currentTimeMillis() + (long)(CACHE_POLICY * 1000);
        }
        NbtAddress.cacheAddress(hostName, addr, expiration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheAddress(Name hostName, NbtAddress addr, long expiration) {
        if (CACHE_POLICY == 0) {
            return;
        }
        HashMap hashMap = ADDRESS_CACHE;
        synchronized (hashMap) {
            CacheEntry entry = (CacheEntry)ADDRESS_CACHE.get(hostName);
            if (entry == null) {
                entry = new CacheEntry(hostName, addr, expiration);
                ADDRESS_CACHE.put(hostName, entry);
            } else {
                entry.address = addr;
                entry.expiration = expiration;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheAddressArray(NbtAddress[] addrs) {
        if (CACHE_POLICY == 0) {
            return;
        }
        long expiration = -1L;
        if (CACHE_POLICY != -1) {
            expiration = System.currentTimeMillis() + (long)(CACHE_POLICY * 1000);
        }
        HashMap hashMap = ADDRESS_CACHE;
        synchronized (hashMap) {
            int i = 0;
            while (i < addrs.length) {
                CacheEntry entry = (CacheEntry)ADDRESS_CACHE.get(addrs[i].hostName);
                if (entry == null) {
                    entry = new CacheEntry(addrs[i].hostName, addrs[i], expiration);
                    ADDRESS_CACHE.put(addrs[i].hostName, entry);
                } else {
                    entry.address = addrs[i];
                    entry.expiration = expiration;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NbtAddress getCachedAddress(Name hostName) {
        if (CACHE_POLICY == 0) {
            return null;
        }
        HashMap hashMap = ADDRESS_CACHE;
        synchronized (hashMap) {
            CacheEntry entry = (CacheEntry)ADDRESS_CACHE.get(hostName);
            if (entry != null && entry.expiration < System.currentTimeMillis() && entry.expiration >= 0L) {
                entry = null;
            }
            return entry != null ? entry.address : null;
        }
    }

    static NbtAddress doNameQuery(Name name, InetAddress svr) throws UnknownHostException {
        NbtAddress addr;
        block8: {
            if (name.hexCode == 29 && svr == null) {
                svr = NbtAddress.CLIENT.baddr;
            }
            name.srcHashCode = svr != null ? svr.hashCode() : 0;
            addr = NbtAddress.getCachedAddress(name);
            if (addr == null && (addr = (NbtAddress)NbtAddress.checkLookupTable(name)) == null) {
                try {
                    try {
                        addr = CLIENT.getByName(name, svr);
                    }
                    catch (UnknownHostException uhe) {
                        addr = UNKNOWN_ADDRESS;
                        NbtAddress.cacheAddress(name, addr);
                        NbtAddress.updateLookupTable(name);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    NbtAddress.cacheAddress(name, addr);
                    NbtAddress.updateLookupTable(name);
                    throw throwable;
                }
                NbtAddress.cacheAddress(name, addr);
                NbtAddress.updateLookupTable(name);
            }
        }
        if (addr == UNKNOWN_ADDRESS) {
            throw new UnknownHostException(name.toString());
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object checkLookupTable(Name name) {
        HashMap hashMap = LOOKUP_TABLE;
        synchronized (hashMap) {
            if (!LOOKUP_TABLE.containsKey(name)) {
                LOOKUP_TABLE.put(name, name);
                return null;
            }
            while (LOOKUP_TABLE.containsKey(name)) {
                try {
                    LOOKUP_TABLE.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        NbtAddress obj = NbtAddress.getCachedAddress(name);
        if (obj != null) return obj;
        hashMap = LOOKUP_TABLE;
        synchronized (hashMap) {
            LOOKUP_TABLE.put(name, name);
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLookupTable(Name name) {
        HashMap hashMap = LOOKUP_TABLE;
        synchronized (hashMap) {
            LOOKUP_TABLE.remove(name);
            LOOKUP_TABLE.notifyAll();
        }
    }

    public static NbtAddress getLocalHost() throws UnknownHostException {
        return localhost;
    }

    public static Name getLocalName() {
        return NbtAddress.localhost.hostName;
    }

    public static NbtAddress getByName(String host) throws UnknownHostException {
        return NbtAddress.getByName(host, 0, null);
    }

    public static NbtAddress getByName(String host, int type, String scope) throws UnknownHostException {
        return NbtAddress.getByName(host, type, scope, null);
    }

    public static NbtAddress getByName(String host, int type, String scope, InetAddress svr) throws UnknownHostException {
        if (host == null || host.length() == 0) {
            return NbtAddress.getLocalHost();
        }
        if (!Character.isDigit(host.charAt(0))) {
            return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
        }
        int IP = 0;
        int hitDots = 0;
        char[] data = host.toCharArray();
        int i = 0;
        while (i < data.length) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
            }
            IP = (IP << 8) + b;
            ++hitDots;
            ++i;
        }
        if (hitDots != 4 || host.endsWith(".")) {
            return NbtAddress.doNameQuery(new Name(host, type, scope), svr);
        }
        return new NbtAddress(UNKNOWN_NAME, IP, false, 0);
    }

    public static NbtAddress[] getAllByName(String host, int type, String scope, InetAddress svr) throws UnknownHostException {
        return CLIENT.getAllByName(new Name(host, type, scope), svr);
    }

    public static NbtAddress[] getAllByAddress(String host) throws UnknownHostException {
        return NbtAddress.getAllByAddress(NbtAddress.getByName(host, 0, null));
    }

    public static NbtAddress[] getAllByAddress(String host, int type, String scope) throws UnknownHostException {
        return NbtAddress.getAllByAddress(NbtAddress.getByName(host, type, scope));
    }

    public static NbtAddress[] getAllByAddress(NbtAddress addr) throws UnknownHostException {
        try {
            NbtAddress[] addrs = CLIENT.getNodeStatus(addr);
            NbtAddress.cacheAddressArray(addrs);
            return addrs;
        }
        catch (UnknownHostException uhe) {
            throw new UnknownHostException("no name with type 0x" + Hexdump.toHexString(addr.hostName.hexCode, 2) + (addr.hostName.scope == null || addr.hostName.scope.length() == 0 ? " with no scope" : " with scope " + addr.hostName.scope) + " for host " + addr.getHostAddress());
        }
    }

    public static InetAddress getWINSAddress() {
        return NBNS.length == 0 ? null : NBNS[nbnsIndex];
    }

    public static boolean isWINS(InetAddress svr) {
        int i = 0;
        while (svr != null && i < NBNS.length) {
            if (svr.hashCode() == NBNS[i].hashCode()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static InetAddress switchWINS() {
        nbnsIndex = nbnsIndex + 1 < NBNS.length ? nbnsIndex + 1 : 0;
        return NBNS.length == 0 ? null : NBNS[nbnsIndex];
    }

    NbtAddress(Name hostName, int address, boolean groupName, int nodeType) {
        this.hostName = hostName;
        this.address = address;
        this.groupName = groupName;
        this.nodeType = nodeType;
    }

    NbtAddress(Name hostName, int address, boolean groupName, int nodeType, boolean isBeingDeleted, boolean isInConflict, boolean isActive, boolean isPermanent, byte[] macAddress) {
        this.hostName = hostName;
        this.address = address;
        this.groupName = groupName;
        this.nodeType = nodeType;
        this.isBeingDeleted = isBeingDeleted;
        this.isInConflict = isInConflict;
        this.isActive = isActive;
        this.isPermanent = isPermanent;
        this.macAddress = macAddress;
        this.isDataFromNodeStatus = true;
    }

    public String firstCalledName() {
        this.calledName = this.hostName.name;
        if (Character.isDigit(this.calledName.charAt(0))) {
            int dots = 0;
            int i = 0;
            int len = this.calledName.length();
            char[] data = this.calledName.toCharArray();
            while (i < len && Character.isDigit(data[i++])) {
                if (i == len && dots == 3) {
                    this.calledName = SMBSERVER_NAME;
                    break;
                }
                if (i >= len || data[i] != '.') continue;
                ++dots;
                ++i;
            }
        } else {
            switch (this.hostName.hexCode) {
                case 27: 
                case 28: 
                case 29: {
                    this.calledName = SMBSERVER_NAME;
                }
            }
        }
        return this.calledName;
    }

    public String nextCalledName() {
        if (this.calledName == this.hostName.name) {
            this.calledName = SMBSERVER_NAME;
        } else if (this.calledName == SMBSERVER_NAME) {
            block10: {
                NbtAddress[] addrs = CLIENT.getNodeStatus(this);
                if (this.hostName.hexCode != 29) break block10;
                int i = 0;
                while (i < addrs.length) {
                    if (addrs[i].hostName.hexCode == 32) {
                        return addrs[i].hostName.name;
                    }
                    ++i;
                }
                return null;
            }
            try {
                if (this.isDataFromNodeStatus) {
                    this.calledName = null;
                    return this.hostName.name;
                }
            }
            catch (UnknownHostException uhe) {
                this.calledName = null;
            }
        } else {
            this.calledName = null;
        }
        return this.calledName;
    }

    void checkData() throws UnknownHostException {
        if (this.hostName == UNKNOWN_NAME) {
            NbtAddress.getAllByAddress(this);
        }
    }

    void checkNodeStatusData() throws UnknownHostException {
        if (!this.isDataFromNodeStatus) {
            NbtAddress.getAllByAddress(this);
        }
    }

    public boolean isGroupAddress() throws UnknownHostException {
        this.checkData();
        return this.groupName;
    }

    public int getNodeType() throws UnknownHostException {
        this.checkData();
        return this.nodeType;
    }

    public boolean isBeingDeleted() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isBeingDeleted;
    }

    public boolean isInConflict() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isInConflict;
    }

    public boolean isActive() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isActive;
    }

    public boolean isPermanent() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.isPermanent;
    }

    public byte[] getMacAddress() throws UnknownHostException {
        this.checkNodeStatusData();
        return this.macAddress;
    }

    public String getHostName() {
        if (this.hostName == UNKNOWN_NAME) {
            return this.getHostAddress();
        }
        return this.hostName.name;
    }

    public byte[] getAddress() {
        byte[] addr = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return addr;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getHostAddress());
    }

    public String getHostAddress() {
        return String.valueOf(this.address >>> 24 & 0xFF) + "." + (this.address >>> 16 & 0xFF) + "." + (this.address >>> 8 & 0xFF) + "." + (this.address >>> 0 & 0xFF);
    }

    public int getNameType() {
        return this.hostName.hexCode;
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof NbtAddress && ((NbtAddress)obj).address == this.address;
    }

    public String toString() {
        return String.valueOf(this.hostName.toString()) + "/" + this.getHostAddress();
    }

    static final class CacheEntry {
        Name hostName;
        NbtAddress address;
        long expiration;

        CacheEntry(Name hostName, NbtAddress address, long expiration) {
            this.hostName = hostName;
            this.address = address;
            this.expiration = expiration;
        }
    }
}

