#
# spec file for package mozilla-nss
#
# Copyright (c) 2014 SUSE LINUX Products GmbH, Nuernberg, Germany.
# Copyright (c) 2006-2014 Wolfgang Rosenauer
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%global nss_softokn_fips_version 3.12.4

Name:           mozilla-nss
BuildRequires:  gcc-c++
BuildRequires:  mozilla-nspr-devel >= 4.10.7
BuildRequires:  pkg-config
BuildRequires:  sqlite-devel
BuildRequires:  zlib-devel
Version:        3.17.3
Release:        1.1
# bug437293
%ifarch ppc64
Obsoletes:      mozilla-nss-64bit
%endif
#
Summary:        Network Security Services
License:        MPL-2.0
Group:          System/Libraries
Url:            http://www.mozilla.org/projects/security/pki/nss/
Source:         https://ftp.mozilla.org/pub/mozilla.org/security/nss/releases/NSS_3_17_3_RTM/src/nss-%{version}.tar.gz
# hg clone https://hg.mozilla.org/projects/nss nss-3.17.3/nss ; cd nss-3.17.3/nss ; hg up NSS_3_17_3_RTM
#Source:         nss-%{version}.tar.gz
Source1:        nss.pc.in
Source3:        nss-config.in
Source4:        %{name}-rpmlintrc
Source5:        baselibs.conf
Source6:        setup-nsssysinit.sh
Source7:        cert9.db
Source8:        key4.db
Source9:        pkcs11.txt
#Source10:       PayPalEE.cert
Patch1:         nss-opt.patch
Patch2:         system-nspr.patch
Patch4:         nss-no-rpath.patch
Patch5:         renegotiate-transitional.patch
Patch6:         malloc.patch
Patch7:         nss-disable-ocsp-test.patch
Patch8:         nss-sqlitename.patch
%define nspr_ver %(rpm -q --queryformat '%{VERSION}' mozilla-nspr)
PreReq:         mozilla-nspr >= %nspr_ver
PreReq:         libfreebl3 >= %{nss_softokn_fips_version}
PreReq:         libsoftokn3 >= %{nss_softokn_fips_version}
%if %{_lib} == lib64
Requires:       libnssckbi.so()(64bit)
%else
Requires:       libnssckbi.so
%endif
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
%define nssdbdir %{_sysconfdir}/pki/nssdb
%ifnarch %sparc
%if ! 0%{?qemu_user_space_build}
%define run_testsuite 1
%endif
%endif

%description
Network Security Services (NSS) is a set of libraries designed to
support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v3,
TLS v1.0, v1.1, v1.2, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3
certificates, and other security standards.


%package devel
Summary:        Network (Netscape) Security Services development files
Group:          Development/Libraries/Other
Requires:       libfreebl3
Requires:       libsoftokn3
Requires:       mozilla-nspr-devel >= 4.9
Requires:       mozilla-nss = %{version}-%{release}
# bug437293
%ifarch ppc64
Obsoletes:      mozilla-nss-devel-64bit
%endif

%description devel
Network Security Services (NSS) is a set of libraries designed to
support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v3,
TLS v1.0, v1.1, v1.2, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3
certificates, and other security standards.

%package tools
Summary:        Tools for developing, debugging, and managing applications that use NSS
Group:          System/Management
PreReq:         mozilla-nss >= %{version}

%description tools
The NSS Security Tools allow developers to test, debug, and manage
applications that use NSS.


%package sysinit
Summary:        System NSS Initialization
Group:          System/Management
Requires:       mozilla-nss >= %{version}
Requires(post): coreutils

%description sysinit
Default Operation System module that manages applications loading
NSS globally on the system. This module loads the system defined
PKCS #11 modules for NSS and chains with other NSS modules to load
any system or user configured modules.


%package -n libfreebl3
Summary:        Freebl library for the Network Security Services
Group:          System/Libraries

%description -n libfreebl3
Network Security Services (NSS) is a set of libraries designed to
support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v3,
TLS v1.0, v1.1, v1.2, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3
certificates, and other security standards.

This package installs the freebl library from NSS.


%package -n libsoftokn3
Summary:        Network Security Services Softoken Module
Group:          System/Libraries
Requires:       libfreebl3 = %{version}-%{release}

%description -n libsoftokn3
Network Security Services (NSS) is a set of libraries designed to
support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v3,
TLS v1.0, v1.1, v1.2, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3
certificates, and other security standards.

Network Security Services Softoken Cryptographic Module


%package certs
Summary:        CA certificates for NSS
Group:          Productivity/Networking/Security

%description certs
This package contains the integrated CA root certificates from the
Mozilla project.


%prep
%setup -n nss-%{version} -q
cd nss
%patch1 -p1
%patch2 -p1
%patch4 -p1
%patch5 -p1
%if %suse_version > 1110
%patch6 -p1
%endif
%patch7 -p1
%patch8 -p1
# additional CA certificates
#cd security/nss/lib/ckfw/builtins
#cat %{SOURCE2} >> certdata.txt
#make generate

%build
cd nss
modified="$(sed -n '/^----/n;s/ - .*$//;p;q' "%{_sourcedir}/%{name}.changes")"
DATE="\"$(date -d "${modified}" "+%%b %%e %%Y")\""
TIME="\"$(date -d "${modified}" "+%%R")\""
find . -name '*.[ch]' -print -exec sed -i "s/__DATE__/${DATE}/g;s/__TIME__/${TIME}/g" {} +

export FREEBL_NO_DEPEND=1
export FREEBL_LOWHASH=1
export NSPR_INCLUDE_DIR=`nspr-config --includedir`
export NSPR_LIB_DIR=`nspr-config --libdir`
export OPT_FLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing"
export LIBDIR=%{_libdir}
%ifarch x86_64 s390x ppc64 ppc64le ia64 aarch64
export USE_64=1
%endif
export NSS_USE_SYSTEM_SQLITE=1
#export SQLITE_LIB_NAME=nsssqlite3
MAKE_FLAGS="BUILD_OPT=1"
make nss_build_all $MAKE_FLAGS
# run testsuite
%if 0%{?run_testsuite}
export BUILD_OPT=1
export HOST="localhost"
export DOMSUF=" "
export USE_IP=TRUE
export IP_ADDRESS="127.0.0.1"
cd tests
./all.sh
if grep "FAILED" ../../../tests_results/security/localhost.1/output.log ; then
  echo "Testsuite FAILED"
  exit 1
fi
%endif

%install
cd nss
mkdir -p $RPM_BUILD_ROOT%{_libdir}
mkdir -p $RPM_BUILD_ROOT%{_libexecdir}/nss
mkdir -p $RPM_BUILD_ROOT%{_includedir}/nss3
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_sbindir}
mkdir -p $RPM_BUILD_ROOT/%{_lib}
mkdir -p $RPM_BUILD_ROOT%{nssdbdir}
pushd ../dist/Linux*
# copy headers
cp -rL ../public/nss/*.h $RPM_BUILD_ROOT%{_includedir}/nss3
# copy dynamic libs
cp -L  lib/libnss3.so \
       lib/libnssdbm3.so \
       lib/libnssdbm3.chk \
       lib/libnssutil3.so \
       lib/libnssckbi.so \
       lib/libnsssysinit.so \
       lib/libsmime3.so \
       lib/libsoftokn3.so \
       lib/libsoftokn3.chk \
       lib/libssl3.so \
       $RPM_BUILD_ROOT%{_libdir}
cp -L  lib/libfreebl3.so \
       lib/libfreebl3.chk \
       $RPM_BUILD_ROOT/%{_lib}
#cp -L  lib/libnsssqlite3.so \
#       $RPM_BUILD_ROOT%{_libdir}
# copy static libs
cp -L  lib/libcrmf.a \
       lib/libnssb.a \
       lib/libnssckfw.a \
       $RPM_BUILD_ROOT%{_libdir}
# copy tools
cp -L  bin/certutil \
       bin/cmsutil \
       bin/crlutil \
       bin/modutil \
       bin/pk12util \
       bin/signtool \
       bin/signver \
       bin/ssltap \
       $RPM_BUILD_ROOT%{_bindir}
# copy unsupported tools
cp -L  bin/atob \
       bin/btoa \
       bin/derdump \
       bin/ocspclnt \
       bin/pp \
       bin/selfserv \
       bin/shlibsign \
       bin/strsclnt \
       bin/symkeyutil \
       bin/tstclnt \
       bin/vfyserv \
       bin/vfychain \
       $RPM_BUILD_ROOT%{_libexecdir}/nss
# prepare pkgconfig file
mkdir -p $RPM_BUILD_ROOT%{_libdir}/pkgconfig/
sed "s:%%LIBDIR%%:%{_libdir}:g
s:%%VERSION%%:%{version}:g
s:%%NSPR_VERSION%%:%{nspr_ver}:g" \
  %{SOURCE1} > $RPM_BUILD_ROOT%{_libdir}/pkgconfig/nss.pc
# prepare nss-config file
popd
NSS_VMAJOR=`cat lib/nss/nss.h | grep "#define.*NSS_VMAJOR" | gawk '{print $3}'`
NSS_VMINOR=`cat lib/nss/nss.h | grep "#define.*NSS_VMINOR" | gawk '{print $3}'`
NSS_VPATCH=`cat lib/nss/nss.h | grep "#define.*NSS_VPATCH" | gawk '{print $3}'`
cat %{SOURCE3} | sed -e "s,@libdir@,%{_libdir},g" \
                     -e "s,@prefix@,%{_prefix},g" \
                     -e "s,@exec_prefix@,%{_prefix},g" \
                     -e "s,@includedir@,%{_includedir}/nss3,g" \
                     -e "s,@MOD_MAJOR_VERSION@,$NSS_VMAJOR,g" \
                     -e "s,@MOD_MINOR_VERSION@,$NSS_VMINOR,g" \
                     -e "s,@MOD_PATCH_VERSION@,$NSS_VPATCH,g" \
                     > $RPM_BUILD_ROOT/%{_bindir}/nss-config
chmod 755 $RPM_BUILD_ROOT/%{_bindir}/nss-config
# setup-nsssysinfo.sh
install -m 744 %{SOURCE6} $RPM_BUILD_ROOT%{_sbindir}/
# create empty NSS database
#LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_lib}:$RPM_BUILD_ROOT%{_libdir} $RPM_BUILD_ROOT%{_bindir}/modutil -force -dbdir "sql:$RPM_BUILD_ROOT%{nssdbdir}" -create
#LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_lib}:$RPM_BUILD_ROOT%{_libdir} $RPM_BUILD_ROOT%{_bindir}/certutil -N -d "sql:$RPM_BUILD_ROOT%{nssdbdir}" -f /dev/null 2>&1 > /dev/null
#chmod 644 "$RPM_BUILD_ROOT%{nssdbdir}"/*
#sed "s:%{buildroot}::g
#s/^library=$/library=libnsssysinit.so/
#/^NSS/s/\(Flags=internal\)\(,[^m]\)/\1,moduleDBOnly\2/" \
#  $RPM_BUILD_ROOT%{nssdbdir}/pkcs11.txt > $RPM_BUILD_ROOT%{nssdbdir}/pkcs11.txt.sed
#  mv $RPM_BUILD_ROOT%{nssdbdir}/pkcs11.txt{.sed,}
# copy empty NSS database
install -m 644 %{SOURCE7} $RPM_BUILD_ROOT%{nssdbdir}
install -m 644 %{SOURCE8} $RPM_BUILD_ROOT%{nssdbdir}
install -m 644 %{SOURCE9} $RPM_BUILD_ROOT%{nssdbdir}
# create shlib sigs after extracting debuginfo
%define __spec_install_post \
  %{?__debug_package:%{__debug_install_post}} \
  %{__arch_install_post} \
  %{__os_install_post} \
  LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_lib}:$RPM_BUILD_ROOT%{_libdir} $RPM_BUILD_ROOT%{_libexecdir}/nss/shlibsign -i $RPM_BUILD_ROOT%{_libdir}/libsoftokn3.so \
  LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_lib}:$RPM_BUILD_ROOT%{_libdir} $RPM_BUILD_ROOT%{_libexecdir}/nss/shlibsign -i $RPM_BUILD_ROOT%{_libdir}/libnssdbm3.so \
  LD_LIBRARY_PATH=$RPM_BUILD_ROOT/%{_lib}:$RPM_BUILD_ROOT%{_libdir} $RPM_BUILD_ROOT%{_libexecdir}/nss/shlibsign -i $RPM_BUILD_ROOT/%{_lib}/libfreebl3.so \
%{nil}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post -n libfreebl3 -p /sbin/ldconfig

%postun -n libfreebl3 -p /sbin/ldconfig

%post -n libsoftokn3 -p /sbin/ldconfig

%postun -n libsoftokn3 -p /sbin/ldconfig

%post sysinit
/sbin/ldconfig
# make sure the current config is enabled
%{_sbindir}/setup-nsssysinit.sh on

%preun sysinit
if [ $1 = 0 ]; then
  %{_sbindir}/setup-nsssysinit.sh off
fi

%postun sysinit -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%{_libdir}/libnss3.so
%{_libdir}/libnssutil3.so
%{_libdir}/libsmime3.so
%{_libdir}/libssl3.so
#%{_libdir}/libnsssqlite3.so

%files devel
%defattr(644, root, root, 755)
%{_includedir}/nss3/
%{_libdir}/*.a
%{_libdir}/pkgconfig/*
%attr(755,root,root) %{_bindir}/nss-config

%files tools
%defattr(-, root, root)
%{_bindir}/*
%exclude %{_sbindir}/setup-nsssysinit.sh
%{_libexecdir}/nss/
%exclude %{_bindir}/nss-config

%files sysinit
%defattr(-, root, root)
%dir %{_sysconfdir}/pki
%dir %{_sysconfdir}/pki/nssdb
%config(noreplace) %{_sysconfdir}/pki/nssdb/*
%{_libdir}/libnsssysinit.so
%{_sbindir}/setup-nsssysinit.sh

%files -n libfreebl3
%defattr(-, root, root)
/%{_lib}/libfreebl3.so
/%{_lib}/libfreebl3.chk

%files -n libsoftokn3
%defattr(-, root, root)
%{_libdir}/libsoftokn3.so
%{_libdir}/libsoftokn3.chk
%{_libdir}/libnssdbm3.so
%{_libdir}/libnssdbm3.chk

%files certs
%defattr(-, root, root)
%{_libdir}/libnssckbi.so

%changelog
* Sat Dec  6 2014 wr@rosenauer.org
- update to 3.17.3
  * Firefox target release 36
  New functionality:
  * Support for TLS_FALLBACK_SCSV has been added to the ssltap and
    tstclnt utilities
  Notable Changes:
  * The QuickDER decoder now decodes lengths robustly
    (CVE-2014-1569)
  * The following 1024-bit CA certificates were removed:
  - GTE CyberTrust Global Root
  - Thawte Server CA
  - Thawte Premium Server CA
  - America Online Root Certification Authority 1
  - America Online Root Certification Authority 2
  * The following CA certificates had the Websites and Code Signing
    trust bits turned off:
  - Class 3 Public Primary Certification Authority - G2
  - Equifax Secure eBusiness CA-1
  * The following CA certificates were added:
  - COMODO RSA Certification Authority
  - USERTrust RSA Certification Authority
  - USERTrust ECC Certification Authority
  - GlobalSign ECC Root CA - R4
  - GlobalSign ECC Root CA - R5
  * the version number of the updated root CA list has been set
    to 2.2
* Thu Oct 16 2014 wr@rosenauer.org
- update to 3.17.2
  Bugfix release
  * bmo#1049435 - Importing an RSA private key fails if p < q
  * bmo#1057161 - NSS hangs with 100%% CPU on invalid EC key
  * bmo#1078669 - certutil crashes when using the --certVersion parameter
* Tue Sep 23 2014 wr@rosenauer.org
- update to 3.17.1 (bnc#897890)
  * MFSA 2014-73/CVE-2014-1568 (bmo#1064636, bmo#1069405)
    RSA Signature Forgery in NSS
  * Change library's signature algorithm default to SHA256
  * Add support for draft-ietf-tls-downgrade-scsv
  * Add clang-cl support to the NSS build system
  * Implement TLS 1.3:
  * Part 1. Negotiate TLS 1.3
  * Part 2. Remove deprecated cipher suites andcompression.
  * Add support for little-endian powerpc64
* Fri Aug 29 2014 wr@rosenauer.org
- update to 3.17
  * required for Firefox 33
  New functionality:
  * When using ECDHE, the TLS server code may be configured to generate
    a fresh ephemeral ECDH key for each handshake, by setting the
    SSL_REUSE_SERVER_ECDHE_KEY socket option to PR_FALSE. The
    SSL_REUSE_SERVER_ECDHE_KEY option defaults to PR_TRUE, which means
    the server's ephemeral ECDH key is reused for multiple handshakes.
    This option does not affect the TLS client code, which always
    generates a fresh ephemeral ECDH key for each handshake.
  New Macros
  * SSL_REUSE_SERVER_ECDHE_KEY
  Notable Changes:
  * The manual pages for the certutil and pp tools have been updated to
    document the new parameters that had been added in NSS 3.16.2.
  * On Windows, the new build variable USE_STATIC_RTL can be used to
    specify the static C runtime library should be used. By default the
    dynamic C runtime library is used.
* Tue Aug 12 2014 wr@rosenauer.org
- update to 3.16.4 (bnc#894201)
  * now required for Firefox 32
  Notable Changes:
  * The following 1024-bit root CA certificate was restored to allow more
    time to develop a better transition strategy for affected sites. It was
    removed in NSS 3.16.3, but discussion in the mozilla.dev.security.policy
    forum led to the decision to keep this root included longer in order to
    give website administrators more time to update their web servers.
  - CN = GTE CyberTrust Global Root
  * In NSS 3.16.3, the 1024-bit "Entrust.net Secure Server Certification
    Authority" root CA certificate was removed. In NSS 3.16.4, a 2048-bit
    intermediate CA certificate has been included, without explicit trust.
    The intention is to mitigate the effects of the previous removal of the
    1024-bit Entrust.net root certificate, because many public Internet
    sites still use the "USERTrust Legacy Secure Server CA" intermediate
    certificate that is signed by the 1024-bit Entrust.net root certificate.
    The inclusion of the intermediate certificate is a temporary measure to
    allow those sites to function, by allowing them to find a trust path to
    another 2048-bit root CA certificate. The temporarily included
    intermediate certificate expires November 1, 2015.
* Sat Jul  5 2014 wr@rosenauer.org
- update to 3.16.3
  * required for Firefox 32
  New Functions:
  * CERT_GetGeneralNameTypeFromString (This function was already added
    in NSS 3.16.2, however, it wasn't declared in a public header file.)
  Notable Changes:
  * The following 1024-bit CA certificates were removed
  - Entrust.net Secure Server Certification Authority
  - GTE CyberTrust Global Root
  - ValiCert Class 1 Policy Validation Authority
  - ValiCert Class 2 Policy Validation Authority
  - ValiCert Class 3 Policy Validation Authority
  * Additionally, the following CA certificate was removed as
    requested by the CA:
  - TDC Internet Root CA
  * The following CA certificates were added:
  - Certification Authority of WoSign
  - CA 沃通根证书
  - DigiCert Assured ID Root G2
  - DigiCert Assured ID Root G3
  - DigiCert Global Root G2
  - DigiCert Global Root G3
  - DigiCert Trusted Root G4
  - QuoVadis Root CA 1 G3
  - QuoVadis Root CA 2 G3
  - QuoVadis Root CA 3 G3
  * The Trust Bits were changed for the following CA certificates
  - Class 3 Public Primary Certification Authority
  - Class 3 Public Primary Certification Authority
  - Class 2 Public Primary Certification Authority - G2
  - VeriSign Class 2 Public Primary Certification Authority - G3
  - AC Raíz Certicámara S.A.
  - NetLock Uzleti (Class B) Tanusitvanykiado
  - NetLock Expressz (Class C) Tanusitvanykiado
- changes in 3.16.2
  New functionality:
  * DTLS 1.2 is supported.
  * The TLS application layer protocol negotiation (ALPN) extension
    is also supported on the server side.
  * RSA-OEAP is supported. Use the new PK11_PrivDecrypt and
    PK11_PubEncrypt functions with the CKM_RSA_PKCS_OAEP mechanism.
  * New Intel AES assembly code for 32-bit and 64-bit Windows,
    contributed by Shay Gueron and Vlad Krasnov of Intel.
  New Functions:
  * CERT_AddExtensionByOID
  * PK11_PrivDecrypt
  * PK11_PubEncrypt
  New Macros
  * SSL_ERROR_NEXT_PROTOCOL_NO_CALLBACK
  * SSL_ERROR_NEXT_PROTOCOL_NO_PROTOCOL
  Notable Changes:
  * The btoa command has a new command-line option -w suffix, which
    causes the output to be wrapped in BEGIN/END lines with the
    given suffix
  * The certutil commands supports additionals types of subject
    alt name extensions.
  * The certutil command supports generic certificate extensions,
    by loading binary data from files, which have been prepared using
    external tools, or which have been extracted from other existing
    certificates and dumped to file.
  * The certutil command supports three new certificate usage specifiers.
  * The pp command supports printing UTF-8 (-u).
  * On Linux, NSS is built with the -ffunction-sections -fdata-sections
    compiler flags and the --gc-sections linker flag to allow unused
    functions to be discarded.
* Thu May  8 2014 wr@rosenauer.org
- update to 3.16.1
  * required for Firefox 31
  New functionality:
  * Added the "ECC" flag for modutil to select the module used for
    elliptic curve cryptography (ECC) operations.
  New Functions:
  * PK11_ExportDERPrivateKeyInfo/PK11_ExportPrivKeyInfo
    exports a private key in a DER-encoded ASN.1 PrivateKeyInfo type
    or a SECKEYPrivateKeyInfo structure. Only RSA private keys are
    supported now.
  * SECMOD_InternalToPubMechFlags
    converts from NSS-internal to public representation of mechanism
    flags
  New Types:
  * ssl_padding_xtn
    the value of this enum constant changed from the experimental
    value 35655 to the IANA-assigned value 21
  New Macros
  * PUBLIC_MECH_ECC_FLAG
    a public mechanism flag for elliptic curve cryptography (ECC)
    operations
  * SECMOD_ECC_FLAG
    an NSS-internal mechanism flag for elliptic curve cryptography
    (ECC) operations. This macro has the same numeric value as
    PUBLIC_MECH_ECC_FLAG.
  Notable Changes:
  * Imposed name constraints on the French government root CA ANSSI
    (DCISS).
* Fri Mar 21 2014 wr@rosenauer.org
- update to 3.16
  * required for Firefox 29
  * bmo#903885 - (CVE-2014-1492) In a wildcard certificate, the wildcard
    character should not be embedded within the U-label of an
    internationalized domain name. See the last bullet point in RFC 6125,
    Section 7.2.
  * Supports the Linux x32 ABI. To build for the Linux x32 target, set
    the environment variable USE_X32=1 when building NSS.
  New Functions:
  * NSS_CMSSignerInfo_Verify
  New Macros
  * TLS_RSA_WITH_RC4_128_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA, etc.,
    cipher suites that were first defined in SSL 3.0 can now be referred
    to with their official IANA names in TLS, with the TLS_ prefix.
    Previously, they had to be referred to with their names in SSL 3.0,
    with the SSL_ prefix.
  Notable Changes:
  * ECC is enabled by default. It is no longer necessary to set the
    environment variable NSS_ENABLE_ECC=1 when building NSS. To disable
    ECC, set the environment variable NSS_DISABLE_ECC=1 when building NSS.
  * libpkix should not include the common name of CA as DNS names when
    evaluating name constraints.
  * AESKeyWrap_Decrypt should not return SECSuccess for invalid keys.
  * Fix a memory corruption in sec_pkcs12_new_asafe.
  * If the NSS_SDB_USE_CACHE environment variable is set, skip the runtime
    test sdb_measureAccess.
  * The built-in roots module has been updated to version 1.97, which
    adds, removes, and distrusts several certificates.
  * The atob utility has been improved to automatically ignore lines of
    text that aren't in base64 format.
  * The certutil utility has been improved to support creation of
    version 1 and version 2 certificates, in addition to the existing
    version 3 support.
* Tue Feb 25 2014 wr@rosenauer.org
- update to 3.15.5
  * required for Firefox 28
  * export FREEBL_LOWHASH to get the correct default headers
    (bnc#865539)
  New functionality
  * Added support for the TLS application layer protocol negotiation
    (ALPN) extension. Two SSL socket options, SSL_ENABLE_NPN and
    SSL_ENABLE_ALPN, can be used to control whether NPN or ALPN (or both)
    should be used for application layer protocol negotiation.
  * Added the TLS padding extension. The extension type value is 35655,
    which may change when an official extension type value is assigned
    by IANA. NSS automatically adds the padding extension to ClientHello
    when necessary.
  * Added a new macro CERT_LIST_TAIL, defined in certt.h, for getting
    the tail of a CERTCertList.
  Notable Changes
  * bmo#950129: Improve the OCSP fetching policy when verifying OCSP
    responses
  * bmo#949060: Validate the iov input argument (an array of PRIOVec
    structures) of ssl_WriteV (called via PR_Writev). Applications should
    still take care when converting struct iov to PRIOVec because the
    iov_len members of the two structures have different types
    (size_t vs. int). size_t is unsigned and may be larger than int.
* Thu Feb 20 2014 aj@ajaissle.de
- BuildRequire mozilla-nspr >= 4.9
* Tue Jan  7 2014 wr@rosenauer.org
- update to 3.15.4
  * required for Firefox 27
  * regular CA root store update (1.96)
  * Reordered the cipher suites offered in SSL/TLS client hello
    messages to match modern best practices.
  * Improved SSL/TLS false start. In addition to enabling the
    SSL_ENABLE_FALSE_START option, an application must now register
    a callback using the SSL_SetCanFalseStartCallback function.
  * When false start is enabled, libssl will sometimes return
    unencrypted, unauthenticated data from PR_Recv
    (CVE-2013-1740, bmo#919877)
  * MFSA 2014-12/CVE-2014-1490/CVE-2014-1491
    NSS ticket handling issues
  New functionality
  * Implemented OCSP querying using the HTTP GET method, which is
    the new default, and will fall back to the HTTP POST method.
  * Implemented OCSP server functionality for testing purposes
    (httpserv utility).
  * Support SHA-1 signatures with TLS 1.2 client authentication.
  * Added the --empty-password command-line option to certutil,
    to be used with -N: use an empty password when creating a new
    database.
  * Added the -w command-line option to pp: don't wrap long output
    lines.
  New functions
  * CERT_ForcePostMethodForOCSP
  * CERT_GetSubjectNameDigest
  * CERT_GetSubjectPublicKeyDigest
  * SSL_PeerCertificateChain
  * SSL_RecommendedCanFalseStart
  * SSL_SetCanFalseStartCallback
  New types
  * CERT_REV_M_FORCE_POST_METHOD_FOR_OCSP: When this flag is used,
    libpkix will never attempt to use the HTTP GET method for OCSP
    requests; it will always use POST.
- removed obsolete char.patch
* Thu Dec  5 2013 wr@rosenauer.org
- update to 3.15.3.1 (bnc#854367)
  * includes certstore update (1.95) (bmo#946351)
    (explicitely distrust AC DG Tresor SSL)
* Wed Dec  4 2013 mls@suse.de
- adapt specfile to ppc64le
* Mon Nov 11 2013 wr@rosenauer.org
- update to 3.15.3 (bnc#850148)
  * CERT_VerifyCert returns SECSuccess (saying certificate is good)
    even for bad certificates, when the CERTVerifyLog log parameter
    is given (bmo#910438)
  * NSS advertises TLS 1.2 ciphersuites in a TLS 1.1 ClientHello
    (bmo#919677)
  * fix CVE-2013-5605
* Sat Sep 28 2013 crrodriguez@opensuse.org
- update to 3.15.2 (bnc#842979)
  * Support for AES-GCM ciphersuites that use the SHA-256 PRF
  * MD2, MD4, and MD5 signatures are no longer accepted for OCSP
    or CRLs
  * Add PK11_CipherFinal macro
  * sizeof() used incorrectly
  * nssutil_ReadSecmodDB() leaks memory
  * Allow SSL_HandshakeNegotiatedExtension to be called before
    the handshake is finished.
  * Deprecate the SSL cipher policy code
  * Avoid uninitialized data read in the event of a decryption
    failure. (CVE-2013-1739)
* Fri Jul  5 2013 lnussel@suse.de
- fix 32bit requirement, it's without () actually
* Wed Jul  3 2013 wr@rosenauer.org
- update to 3.15.1
  * TLS 1.2 (RFC 5246) is supported. HMAC-SHA256 cipher suites
    (RFC 5246 and RFC 5289) are supported, allowing TLS to be used
    without MD5 and SHA-1.
    Note the following limitations:
    The hash function used in the signature for TLS 1.2 client
    authentication must be the hash function of the TLS 1.2 PRF,
    which is always SHA-256 in NSS 3.15.1.
    AES GCM cipher suites are not yet supported.
  * some bugfixes and improvements
* Fri Jun 28 2013 lnussel@suse.de
- require libnssckbi instead of mozilla-nss-certs so p11-kit can
  conflict with the latter (fate#314991)
* Tue Jun 11 2013 wr@rosenauer.org
- update to 3.15
  * Packaging
    + removed obsolete patches
  * nss-disable-expired-testcerts.patch
  * bug-834091.patch
  * New Functionality
    + Support for OCSP Stapling (RFC 6066, Certificate Status
    Request) has been added for both client and server sockets.
    TLS client applications may enable this via a call to
    SSL_OptionSetDefault(SSL_ENABLE_OCSP_STAPLING, PR_TRUE);
    + Added function SECITEM_ReallocItemV2. It replaces function
    SECITEM_ReallocItem, which is now declared as obsolete.
    + Support for single-operation (eg: not multi-part) symmetric
    key encryption and decryption, via PK11_Encrypt and PK11_Decrypt.
    + certutil has been updated to support creating name constraints
    extensions.
  * New Functions
    in ssl.h
    SSL_PeerStapledOCSPResponse - Returns the server's stapled
    OCSP response, when used with a TLS client socket that
    negotiated the status_request extension.
    SSL_SetStapledOCSPResponses - Set's a stapled OCSP response
    for a TLS server socket to return when clients send the
    status_request extension.
    in ocsp.h
    CERT_PostOCSPRequest - Primarily intended for testing, permits
    the sending and receiving of raw OCSP request/responses.
    in secpkcs7.h
    SEC_PKCS7VerifyDetachedSignatureAtTime - Verifies a PKCS#7
    signature at a specific time other than the present time.
    in xconst.h
    CERT_EncodeNameConstraintsExtension - Matching function for
    CERT_DecodeNameConstraintsExtension, added in NSS 3.10.
    in secitem.h
    SECITEM_AllocArray
    SECITEM_DupArray
    SECITEM_FreeArray
    SECITEM_ZfreeArray - Utility functions to handle the
    allocation and deallocation of SECItemArrays
    SECITEM_ReallocItemV2 - Replaces SECITEM_ReallocItem, which is
    now obsolete. SECITEM_ReallocItemV2 better matches caller
    expectations, in that it updates item->len on allocation.
    For more details of the issues with SECITEM_ReallocItem,
    see Bug 298649 and Bug 298938.
    in pk11pub.h
    PK11_Decrypt - Performs decryption as a single PKCS#11
    operation (eg: not multi-part). This is necessary for AES-GCM.
    PK11_Encrypt - Performs encryption as a single PKCS#11
    operation (eg: not multi-part). This is necessary for AES-GCM.
  * New Types
    in secitem.h
    SECItemArray - Represents a variable-length array of SECItems.
  * New Macros
    in ssl.h
    SSL_ENABLE_OCSP_STAPLING - Used with SSL_OptionSet to configure
    TLS client sockets to request the certificate_status extension
    (eg: OCSP stapling) when set to PR_TRUE
  * Notable changes
    + SECITEM_ReallocItem is now deprecated. Please consider using
    SECITEM_ReallocItemV2 in all future code.
    + The list of root CA certificates in the nssckbi module has
    been updated.
    + The default implementation of SSL_AuthCertificate has been
    updated to add certificate status responses stapled by the TLS
    server to the OCSP cache.
  * a lot of bugfixes
* Tue Apr 16 2013 idonmez@suse.com
- Add Source URL, see https://en.opensuse.org/SourceUrls
* Sun Mar 24 2013 wr@rosenauer.org
- disable tests with expired certificates
  (nss-disable-expired-testcerts.patch)
- add SEC_PKCS7VerifyDetachedSignatureAtTime using patch from
  mozilla tree to fulfill Firefox 21 requirements
  (bug-834091.patch; bmo#834091)
* Thu Feb 28 2013 wr@rosenauer.org
- update to 3.14.3
  * No new major functionality is introduced in this release. This
    release is a patch release to address CVE-2013-1620 (bmo#822365)
  * "certutil -a" was not correctly producing ASCII output as
    requested. (bmo#840714)
  * NSS 3.14.2 broke compilation with older versions of sqlite that
    lacked the SQLITE_FCNTL_TEMPFILENAME file control. NSS 3.14.3 now
    properly compiles when used with older versions of sqlite
    (bmo#837799) - remove system-sqlite.patch
- add aarch64 support
* Tue Feb  5 2013 wr@rosenauer.org
- added system-sqlite.patch (bmo#837799)
  * do not depend on latest sqlite just for a #define
- enable system sqlite usage again
* Sat Feb  2 2013 wr@rosenauer.org
- update to 3.14.2
  * required for Firefox >= 20
  * removed obsolete nssckbi update patch
  * MFSA 2013-40/CVE-2013-0791 (bmo#629816)
    Out-of-bounds array read in CERT_DecodeCertPackage
- disable system sqlite usage since we depend on 3.7.15 which is
  not provided in any openSUSE distribution
  * add nss-sqlitename.patch to avoid any name clash
* Sun Dec 30 2012 wr@rosenauer.org
- updated CA database (nssckbi-1.93.patch)
  * MFSA 2013-20/CVE-2013-0743 (bmo#825022, bnc#796628)
    revoke mis-issued intermediate certificates from TURKTRUST
* Tue Dec 18 2012 wr@rosenauer.org
- update to 3.14.1 RTM
  * minimal requirement for Gecko 20
  * several bugfixes
* Thu Oct 25 2012 wr@rosenauer.org
- update to 3.14 RTM
  * Support for TLS 1.1 (RFC 4346)
  * Experimental support for DTLS 1.0 (RFC 4347) and DTLS-SRTP (RFC 5764)
  * Support for AES-CTR, AES-CTS, and AES-GCM
  * Support for Keying Material Exporters for TLS (RFC 5705)
  * Support for certificate signatures using the MD5 hash algorithm
    is now disabled by default
  * The NSS license has changed to MPL 2.0. Previous releases were
    released under a MPL 1.1/GPL 2.0/LGPL  2.1 tri-license. For more
    information about MPL 2.0, please see
    http://www.mozilla.org/MPL/2.0/FAQ.html. For an additional
    explanation on GPL/LGPL compatibility, see security/nss/COPYING
    in the source code.
  * Export and DES cipher suites are disabled by default. Non-ECC
    AES and Triple DES cipher suites are enabled by default
- disabled OCSP testcases since they need external network
  (nss-disable-ocsp-test.patch)
* Wed Aug 15 2012 wr@rosenauer.org
- update to 3.13.6 RTM
  * root CA update
  * other bugfixes
* Fri Jun  1 2012 wr@rosenauer.org
- update to 3.13.5 RTM
* Fri Apr 13 2012 wr@rosenauer.org
- update to 3.13.4 RTM
  * fixed some bugs
  * fixed cert verification regression in PKIX mode (bmo#737802)
    introduced in 3.13.2
* Thu Feb 23 2012 wr@rosenauer.org
- update to 3.13.3 RTM
  - distrust Trustwave's MITM certificates (bmo#724929)
  - fix generic blacklisting mechanism (bmo#727204)
* Thu Feb 16 2012 wr@rosenauer.org
- update to 3.13.2 RTM
  * requirement with Gecko >= 11
- removed obsolete patches
  * ckbi-1.88
  * pkcs11n-header-fix.patch
* Sun Dec 18 2011 adrian@suse.de
- fix spec file syntax for qemu-workaround
* Mon Nov 14 2011 john@redux.org.uk
- Added a patch to fix errors in the pkcs11n.h header file.
  (bmo#702090)
* Sat Nov  5 2011 wolfgang@rosenauer.org
- update to 3.13.1 RTM
  * better SHA-224 support (bmo#647706)
  * fixed a regression (causing hangs in some situations)
    introduced in 3.13 (bmo#693228)
- update to 3.13.0 RTM
  * SSL 2.0 is disabled by default
  * A defense against the SSL 3.0 and TLS 1.0 CBC chosen plaintext
    attack demonstrated by Rizzo and Duong (CVE-2011-3389) is
    enabled by default. Set the SSL_CBC_RANDOM_IV SSL option to
    PR_FALSE to disable it.
  * SHA-224 is supported
  * Ported to iOS. (Requires NSPR 4.9.)
  * Added PORT_ErrorToString and PORT_ErrorToName to return the
    error message and symbolic name of an NSS error code
  * Added NSS_GetVersion to return the NSS version string
  * Added experimental support of RSA-PSS to the softoken only
  * NSS_NoDB_Init does not try to open /pkcs11.txt and /secmod.db
    anymore (bmo#641052, bnc#726096)
* Sat Nov  5 2011 wr@rosenauer.org
- explicitely distrust DigiCert Sdn. Bhd (bnc#728520, bmo#698753)
- make sure NSS_NoDB_Init does not try to use wrong certificate
  databases (CVE-2011-3640, bnc#726096, bmo#641052)
* Fri Sep 30 2011 crrodriguez@opensuse.org
- Workaround qemu-arm bugs.
* Fri Sep  9 2011 wr@rosenauer.org
- explicitely distrust/override DigiNotar certs (bmo#683261)
  (trustdb version 1.87)
* Fri Sep  2 2011 pcerny@suse.com
- removed DigiNotar root certificate from trusted db
  (bmo#682927, bnc#714931)
* Wed Aug 24 2011 andrea.turrini@gmail.com
- fixed typo in summary of mozilla-nss (libsoftokn3)
* Fri Aug 12 2011 wr@rosenauer.org
- update to 3.12.11 RTM
  * no upstream release notes available
* Wed Jul 13 2011 meissner@suse.de
- Linux3.0 is the new Linux2.6 (make it build)
* Mon May 23 2011 crrodriguez@opensuse.org
- Do not include build dates in binaries, messes up
  build compare
* Thu May 19 2011 wr@rosenauer.org
- update to 3.12.10 RTM
  * no changes except internal release information
* Thu Apr 28 2011 wr@rosenauer.org
- update to 3.12.10beta1
  * root CA changes
  * filter certain bogus certs (bmo#642815)
  * fix minor memory leaks
  * other bugfixes
* Sun Jan  9 2011 wr@rosenauer.org
- update to 3.12.9rc0
  * fix minor memory leaks (bmo#619268)
  * fix crash in nss_cms_decoder_work_data (bmo#607058)
  * fix crash in certutil (bmo#620908)
  * handle invalid argument in JPAKE (bmo#609068)
* Thu Dec  9 2010 wr@rosenauer.org
- update to 3.12.9beta2
  * J-PAKE support (API requirement for Firefox >= 4.0b8)
* Tue Nov  9 2010 wr@rosenauer.org
- replaced expired PayPal test certificate (fixing testsuite)
* Sat Sep 25 2010 wr@rosenauer.org
- update to 3.12.8 RTM release
  * support TLS false start (needed for Firefox4) (bmo#525092)
  * fix wildcard matching for IP addresses (bnc#637290, bmo#578697)
    (CVE-2010-3170)
  * bugfixes
* Fri Jul 23 2010 wr@rosenauer.org
- update to 3.12.7 RTM release
  * bugfix release
  * updated root CA list
- removed obsolete patches
* Fri Jul  9 2010 jengelh@medozas.de
- Disable testsuite on SPARC. Some tests fails, probably due to
  just bad timing/luck.
* Thu Jun  3 2010 wr@rosenauer.org
- Use preloaded empty system database since creating with
  modutil leaves database in nonusable state
* Sat Apr 24 2010 coolo@novell.com
- buildrequire pkg-config to fix provides
* Sun Apr  4 2010 wr@rosenauer.org
- disabled a test using an expired cert (bmo#557071)
* Sat Mar 20 2010 wr@rosenauer.org
- fixed builds for older dists where internal sqlite3 is used
  (nss-sqlitename.patch was not refreshed correctly)
- fixed baselibs.conf as <release> is not a valid identifier
* Tue Mar  9 2010 wr@rosenauer.org
- update to 3.12.6 RTM release
  * added mozilla-nss-sysinit subpackage
- change renegotiation behaviour to the old default for a
  transition phase
* Tue Mar  9 2010 wr@rosenauer.org
- split off libsoftokn3 subpackage to allow mixed NSS installation
* Sat Dec 26 2009 wr@rosenauer.org
- added mozilla-nss-certs baselibs (bnc#567322)
* Fri Dec 18 2009 wr@rosenauer.org
- split mozilla-nss-certs from main package
- added rpmlintrc to ignore expected warnings
- added baselibs.conf as source
* Mon Dec 14 2009 wr@rosenauer.org
- updated builtin certs (version 1.77)
* Mon Nov 23 2009 wr@rosenauer.org
- rebased patches to apply w/o fuzz
* Fri Aug 14 2009 wr@rosenauer.org
- update to 3.12.4 RTM release
* Fri Aug  7 2009 wr@rosenauer.org
- update to recent snapshot (20090806)
- libnssdbm3.so has to be signed starting with 3.12.4
* Mon Aug  3 2009 wr@rosenauer.org
- update to NSS 3.12.4pre snapshot
- rebased existing patches
- enable testsuite again (was disabled accidentally before)
* Wed Jul 29 2009 wr@rosenauer.org
- update to NSS 3.12.3.1 (upstream use in FF 3.5.1) (bmo#504611)
  * RNG_SystemInfoForRNG called twice by nsc_CommonInitialize
    (bmo#489811; other changes are unrelated to Linux)
- moved shlibsign to tools package again (as it's not needed at
  library install time anymore)
- use %%{_libexecdir} for the tools
* Sat Jun  6 2009 wr@rosenauer.org
- Temporary testsuite fix for Factory (bnc#509308) (malloc.patch)
- remove the post scriptlet which created the *.chk files and
  use a RPM feature to create them after debuginfo stuff
* Tue Jun  2 2009 wr@rosenauer.org
- updated builtin root certs by updating to
  NSS_3_12_3_WITH_CKBI_1_75_RTM tag which is supposed to be the
  base for Firefox 3.5.0
- PreReq coreutils in the main package already as "rm" is used
  in its %%post script
- disable testsuite for this moment as it crashes on Factory
  currently for an unknown reason
* Thu May 21 2009 wr@rosenauer.org
- renew Paypal certs to fix testsuite errors (bmo#491163)
* Mon Apr 20 2009 wr@rosenauer.org
- update to version 3.12.3 RTM
  * default behaviour changed slightly but can be set up
    backward compatible using environment variables
    https://developer.mozilla.org/En/NSS_reference/NSS_environment_variables
  * New Korean SEED cipher
  * Some new functions in the nss library:
    CERT_RFC1485_EscapeAndQuote (see cert.h)
    CERT_CompareCerts (see cert.h)
    CERT_RegisterAlternateOCSPAIAInfoCallBack (see ocsp.h)
    PK11_GetSymKeyHandle (see pk11pqg.h)
    UTIL_SetForkState (see secoid.h)
    NSS_GetAlgorithmPolicy (see secoid.h)
    NSS_SetAlgorithmPolicy (see secoid.h)
- created libfreebl3 subpackage and build it w/o nspr and nss deps
- added patch to make all ASM noexecstack
- create the softokn3 and freebl3 checksums at installation time
  (moved shlibsign to the main package to achieve that)
- applied upstream patch to avoid OSCP test failures (bmo#488646)
- applied upstream patch to fix libjar crashes (bmo#485145)
* Wed Feb  4 2009 wr@rosenauer.org
- update to version 3.12.2 RTM (with CKBI 1.73) as in FF 3.0.6
* Tue Jan 13 2009 wr@rosenauer.org
- update to version 3.12.2rc1 (as used by FF 3.0.5)
  * NSS is now using system zlib (bmo#302670)
- create a system wide, sql based NSS database in /etc/pki/nssdb
  (let previously created /etc/ssl/nssdb untouched)
* Wed Jan  7 2009 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Thu Oct 23 2008 maw@suse.de
- Review and approve changes.
* Thu Aug 21 2008 wr@rosenauer.org
- run testsuite (bnc#418233)
* Tue Jun 17 2008 maw@suse.de
- Merge changes from the build service (thanks, Wolfgang)
  (bnc#400001 and SWAMP#18164).
* Wed May 28 2008 wr@rosenauer.org
- update to 3.12.0rc4 (20080528) (featuring FF3.0)
* Tue Apr 29 2008 maw@suse.de
- Prerequire coretools in the -tools subpackage (bnc#379540)
- Require sqlite3-devel to build.
* Mon Apr 14 2008 maw@suse.de
- Merge some fixes from the build service's version.
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Mon Mar 31 2008 maw@suse.de
- Undo the shared library package split, per discussion in
  opensuse-packaging.
* Mon Mar 31 2008 wr@rosenauer.org
- new snapshot still based on 3.12.0 Beta 3 (20080330)
* Tue Mar 25 2008 maw@suse.de
- Merge changes from the build service (thanks, Wolfgang)
- Update to a new snapshot of nss based on 3.12.0 Beta 2:
  + Update build requirements accordingly
  + Add nss-sqlitename.patch and nss-no-rpath.patch
- Split out a shared library subpackage.
* Mon Dec 10 2007 rguenther@suse.de
- disable use of freebl/mpi/mp_comba.c.  [#346256]
* Sun Sep 16 2007 coolo@suse.de
- fixing errors in %%post during installation
* Thu Sep 13 2007 jberkman@novell.com
- merge -tools package into main package
- create system-wide nssdb for system configuration of smart cards,
  as used by pam_pkcs11, krb5 pkinit, and others
* Thu Jul 26 2007 maw@suse.de
- Update to version 3.11.7 (from the build service)
- Bug fixes.
* Mon Jun 11 2007 ro@suse.de
- use string[0] instead of string in char.patch
* Mon Jun 11 2007 ro@suse.de
- update to NSS 3.11.6 (pull in from wr from opensuse BS)
* Wed Feb 21 2007 maw@suse.de
- Update to NSS 3.11.5 (thanks, Wolfgang)
* Sun Oct  1 2006 wr@rosenauer.org
- update to NSS 3.11.3
- requires NSPR 4.6.3 (pkgconfig)
* Wed Sep  6 2006 stark@suse.de
- update to NSS_3_11_20060905_TAG to be in sync with
  Gecko 1.8.1
* Mon Aug  7 2006 stark@suse.de
- enabled usage of ECC
* Sat Aug  5 2006 stark@suse.de
- update to NSS_3_11_20060731_TAG to be in sync with
  Gecko 1.8.1
* Fri Jul 28 2006 stark@suse.de
- fixed usage of uninitialized pointers (uninit.patch)
- requires NSPR 4.6.2
* Sat Jul  1 2006 stark@suse.de
- update to 3.11.2 RTM version
  * ECC not enabled but defines needed symbols
* Thu Jun  8 2006 stark@suse.de
- update to 3.11.2 beta
  * enabled ECC (needed since MOZILLA_1_8_BRANCH)
* Mon May 15 2006 stark@suse.de
- update to 3.11.1 RTM version
  including:
  * TLS server name indication extension support
  * implement RFC 3546 (TLS v1.0 extensions)
  * fixed bugs found by Coverity
* Mon Jan 30 2006 stark@suse.de
- removed additional CA certs
- removed zip from BuildRequires
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Wed Jan 11 2006 stark@suse.de
- install nss-config executable
* Fri Dec 16 2005 stark@suse.de
- marked libfreebl3.so noexec stack
* Fri Dec 16 2005 stark@suse.de
- update to 3.11 RTM version
- provide nss-config file
- added static libs
- moved include files to /usr/include/nss3
- only ship a subset of the tools
* Sat Nov 26 2005 stark@suse.de
- update to 3.11rc1
- fixed PC file for 64bit archs
* Tue Nov 15 2005 stark@suse.de
- update to current 3.10.2 snapshot (20051114)
* Wed Nov  2 2005 stark@suse.de
- added tools subpackage which provides all NSS related
  tools for managing and debugging NSS stuff
* Tue Oct 11 2005 stark@suse.de
- update to current 3.10.2 snapshot
* Mon Sep 26 2005 stark@suse.de
- prerequire the correct NSPR version
* Thu Sep 22 2005 stark@suse.de
- update to NSS_3_10_2_BETA1
* Tue Jul  5 2005 stark@suse.de
- use RPM_OPT_FLAGS
- fixed requirements for devel package
* Wed Jun  8 2005 stark@suse.de
- added pkgconfig file
- fixed permission for include directory
- fixed compiler/abuild warning
- included correct header files
* Mon May  9 2005 stark@suse.de
- update to 3.10 RTM version
* Wed Apr 27 2005 stark@suse.de
- don't package static libs
- copy NSPR static libs from new location
* Thu Apr  7 2005 stark@suse.de
- update to 3.10beta3
* Fri Apr  1 2005 stark@suse.de
- don't parallelize build
* Thu Mar 31 2005 stark@suse.de
- fixed build on other archs
- update to 3.10beta2
* Sat Mar 19 2005 stark@suse.de
- update to 3.10beta1
* Tue Mar  8 2005 stark@suse.de
- initial standalone package
