#
# spec file for package openssl
#
# Copyright (c) 2015 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


Name:           openssl
BuildRequires:  bc
BuildRequires:  ed
BuildRequires:  pkg-config
BuildRequires:  zlib-devel
%define ssletcdir %{_sysconfdir}/ssl
#%define num_version %(echo "%{version}" | sed -e "s+[a-zA-Z]++g; s+_.*++g")
%define num_version 1.0.0
Provides:       ssl
# bug437293
%ifarch ppc64
Obsoletes:      openssl-64bit
%endif
Version:        1.0.1k
Release:        11.64.2
Summary:        Secure Sockets and Transport Layer Security
License:        OpenSSL
Group:          Productivity/Networking/Security
Url:            http://www.openssl.org/
Source:         http://www.%{name}.org/source/%{name}-%{version}.tar.gz
Source42:       http://www.%{name}.org/source/%{name}-%{version}.tar.gz.asc
# to get mtime of file:
Source1:        openssl.changes
Source2:        baselibs.conf
Source10:       README.SuSE
Patch0:         merge_from_0.9.8k.patch
Patch1:         openssl-1.0.0-c_rehash-compat.diff
Patch2:         bug610223.patch
Patch3:         openssl-ocloexec.patch
Patch4:         VIA_padlock_support_on_64systems.patch
# PATCH-FIX-UPSTREAM http://rt.openssl.org/Ticket/Attachment/WithHeaders/20049
Patch5:         openssl-fix-pod-syntax.diff
Patch6:         openssl-1.0.1e-truststore.diff
Patch7:         compression_methods_switch.patch
Patch8:         0005-libssl-Hide-library-private-symbols.patch
Patch9:         openssl-1.0.1c-default-paths.patch
Patch10:        openssl-pkgconfig.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

%description
The OpenSSL Project is a collaborative effort to develop a robust,
commercial-grade, full-featured, and open source toolkit implementing
the Secure Sockets Layer (SSL v2/v3) and Transport Layer Security (TLS
v1) protocols with full-strength cryptography. The project is managed
by a worldwide community of volunteers that use the Internet to
communicate, plan, and develop the OpenSSL toolkit and its related
documentation.

Derivation and License

OpenSSL is based on the excellent SSLeay library developed by Eric A.
Young and Tim J. Hudson. The OpenSSL toolkit is licensed under an
Apache-style license, which basically means that you are free to get it
and to use it for commercial and noncommercial purposes.

%package -n libopenssl1_0_0
Summary:        Secure Sockets and Transport Layer Security
Group:          Productivity/Networking/Security
Recommends:     openssl-certs
# bug437293
%ifarch ppc64
Obsoletes:      openssl-64bit
%endif
#

%description -n libopenssl1_0_0
The OpenSSL Project is a collaborative effort to develop a robust,
commercial-grade, full-featured, and open source toolkit implementing
the Secure Sockets Layer (SSL v2/v3) and Transport Layer Security (TLS
v1) protocols with full-strength cryptography. The project is managed
by a worldwide community of volunteers that use the Internet to
communicate, plan, and develop the OpenSSL toolkit and its related
documentation.

Derivation and License

OpenSSL is based on the excellent SSLeay library developed by Eric A.
Young and Tim J. Hudson. The OpenSSL toolkit is licensed under an
Apache-style license, which basically means that you are free to get it
and to use it for commercial and noncommercial purposes.

%package -n libopenssl-devel
Summary:        Include Files and Libraries mandatory for Development
Group:          Development/Libraries/C and C++
Obsoletes:      openssl-devel < %{version}
Requires:       %name = %version
Requires:       libopenssl1_0_0 = %{version}
Requires:       zlib-devel
Provides:       openssl-devel = %{version}
# bug437293
%ifarch ppc64
Obsoletes:      openssl-devel-64bit
%endif
#

%description -n libopenssl-devel
This package contains all necessary include files and libraries needed
to develop applications that require these.

%package doc
Summary:        Additional Package Documentation
Group:          Productivity/Networking/Security
%if 0%{?suse_version} >= 1140
BuildArch:      noarch
%endif

%description doc
This package contains optional documentation provided in addition to
this package's base documentation.

%prep
%setup -q 
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1

cp -p %{S:10} .
echo "adding/overwriting some entries in the 'table' hash in Configure"
# $dso_scheme:$shared_target:$shared_cflag:$shared_ldflag:$shared_extension:$ranlib:$arflags
export DSO_SCHEME='dlfcn:linux-shared:-fPIC::.so.\$(SHLIB_MAJOR).\$(SHLIB_MINOR)::'
cat <<EOF_ED | ed -s Configure 
/^);
-
i
#
# local configuration added from specfile
# ... MOST of those are now correct in openssl's Configure already, 
# so only add them for new ports!
#
#config-string,  $cc:$cflags:$unistd:$thread_cflag:$sys_id:$lflags:$bn_ops:$cpuid_obj:$bn_obj:$des_obj:$aes_obj:$bf_obj:$md5_obj:$sha1_obj:$cast_obj:$rc4_obj:$rmd160_obj:$rc5_obj:$wp_obj:$cmll_obj:$dso_scheme:$shared_target:$shared_cflag:$shared_ldflag:$shared_extension:$ranlib:$arflags:$multilib
#"linux-elf",    "gcc:-DL_ENDIAN			::-D_REENTRANT::-ldl:BN_LLONG \${x86_gcc_des} \${x86_gcc_opts}:\${x86_elf_asm}:$DSO_SCHEME:",
#"linux-ia64",   "gcc:-DL_ENDIAN	-DMD32_REG_T=int::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG RC4_CHUNK RC4_CHAR:\${ia64_asm}:		$DSO_SCHEME:",
#"linux-ppc",    "gcc:-DB_ENDIAN			::-D_REENTRANT::-ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_RISC1 DES_UNROLL:\${no_asm}:		$DSO_SCHEME:",
#"linux-ppc64",  "gcc:-DB_ENDIAN -DMD32_REG_T=int::-D_REENTRANT::-ldl:RC4_CHAR RC4_CHUNK DES_RISC1 DES_UNROLL SIXTY_FOUR_BIT_LONG:\${no_asm}:	$DSO_SCHEME:64",
"linux-elf-arm","gcc:-DL_ENDIAN			::-D_REENTRANT::-ldl:BN_LLONG:\${no_asm}:							$DSO_SCHEME:",
"linux-mips",   "gcc:-DB_ENDIAN			::-D_REENTRANT::-ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_RISC1 DES_UNROLL:\${no_asm}:		$DSO_SCHEME:",
"linux-sparcv7","gcc:-DB_ENDIAN			::-D_REENTRANT::-ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR:\${no_asm}:			$DSO_SCHEME:",
#"linux-sparcv8","gcc:-DB_ENDIAN -DBN_DIV2W -mv8	::-D_REENTRANT::-ldl:BN_LLONG RC4_CHAR RC4_CHUNK DES_UNROLL BF_PTR::asm/sparcv8.o:::::::::::::	$DSO_SCHEME:",
#"linux-x86_64", "gcc:-DL_ENDIAN -DNO_ASM -DMD32_REG_T=int::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG:\${no_asm}:						$DSO_SCHEME:64",
#"linux-s390",   "gcc:-DB_ENDIAN			::(unknown):   :-ldl:BN_LLONG:\${no_asm}:							$DSO_SCHEME:",
#"linux-s390x",  "gcc:-DB_ENDIAN -DNO_ASM -DMD32_REG_T=int::-D_REENTRANT::-ldl:SIXTY_FOUR_BIT_LONG:\${no_asm}:					$DSO_SCHEME:64",
"linux-parisc",	"gcc:-DB_ENDIAN 		::-D_REENTRANT::-ldl:BN_LLONG RC4_CHAR DES_PTR DES_UNROLL DES_RISC1:\${no_asm}:			$DSO_SCHEME:",
.
wq
EOF_ED
# fix ENGINESDIR path
sed -i 's,/lib/engines,/%_lib/engines,' Configure
# Record mtime of changes file instead of build time
CHANGES=`stat --format="%y" %SOURCE1`
sed -i -e "s|#define DATE \(.*\).LC_ALL.*date.|#define DATE \1$CHANGES|" crypto/Makefile

%build
%ifarch armv5el armv5tel
export MACHINE=armv5el
%endif
%ifarch armv6l armv6hl
export MACHINE=armv6l
%endif
./config --test-sanity 
#
config_flags="threads shared no-rc5 no-idea \
%ifarch x86_64 
enable-ec_nistp_64_gcc_128 \
%endif
enable-camellia \
zlib \
--prefix=%{_prefix} \
--libdir=%{_lib} \
--openssldir=%{ssletcdir} \
$RPM_OPT_FLAGS -std=gnu99 \
-Wa,--noexecstack \
-fomit-frame-pointer \
-DTERMIO \
-DPURIFY \
-DSSL_FORBID_ENULL \
-D_GNU_SOURCE \
$(getconf LFS_CFLAGS) \
%ifnarch hppa aarch64
-Wall \
-fstack-protector "
%else
-Wall "
%endif
#
#%{!?do_profiling:%define do_profiling 0}
#%if %do_profiling
#	# generate feedback
#	./config $config_flags
#	make depend CC="gcc %cflags_profile_generate"
#	make CC="gcc %cflags_profile_generate"
#	LD_LIBRARY_PATH=`pwd` make rehash CC="gcc %cflags_profile_generate"
#	LD_LIBRARY_PATH=`pwd` make test CC="gcc %cflags_profile_generate"
#	LD_LIBRARY_PATH=`pwd` apps/openssl speed
#	make clean
#	# compile with feedback
#	# but not if it makes a cipher slower:
#	#find crypto/aes -name '*.da' | xargs -r rm
#	./config $config_flags %cflags_profile_feedback
#	make depend
#	make
#	LD_LIBRARY_PATH=`pwd` make rehash
#	LD_LIBRARY_PATH=`pwd` make test
#%else
# OpenSSL relies on uname -m (not good). Thus that little sparc line.
	./config \
%ifarch sparc64
		linux64-sparcv9 \
%endif
		$config_flags
	make depend
	make
	LD_LIBRARY_PATH=`pwd` make rehash
	%ifnarch armv4l
	LD_LIBRARY_PATH=`pwd` make test
	%endif
#%endif
# show settings
make TABLE
echo $RPM_OPT_FLAGS
eval $(egrep PLATFORM='[[:alnum:]]' Makefile)
grep -B1 -A22 "^\*\*\* $PLATFORM$" TABLE 

%install
rm -rf $RPM_BUILD_ROOT
make MANDIR=%{_mandir} INSTALL_PREFIX=$RPM_BUILD_ROOT install
install -d -m755 $RPM_BUILD_ROOT%{ssletcdir}/certs
ln -sf ./%{name} $RPM_BUILD_ROOT/%{_includedir}/ssl
mkdir $RPM_BUILD_ROOT/%{_datadir}/ssl
mv $RPM_BUILD_ROOT/%{ssletcdir}/misc $RPM_BUILD_ROOT/%{_datadir}/ssl/
# ln -s %{ssletcdir}/certs 	$RPM_BUILD_ROOT/%{_datadir}/ssl/certs
# ln -s %{ssletcdir}/private 	$RPM_BUILD_ROOT/%{_datadir}/ssl/private
# ln -s %{ssletcdir}/openssl.cnf 	$RPM_BUILD_ROOT/%{_datadir}/ssl/openssl.cnf
#

# avoid file conflicts with man pages from other packages
#
pushd $RPM_BUILD_ROOT/%{_mandir}
# some man pages now contain spaces. This makes several scripts go havoc, among them /usr/sbin/Check.
# replace spaces by underscores
#for i in man?/*\ *; do mv -v "$i" "${i// /_}"; done
which readlink &>/dev/null || function readlink { ( set +x; target=$(file $1 2>/dev/null); target=${target//* }; test -f $target && echo $target; ) }
for i in man?/*; do 
	if test -L $i ; then
	    LDEST=`readlink $i`
	    rm -f $i ${i}ssl
	    ln -sf ${LDEST}ssl ${i}ssl
	else
	    mv $i ${i}ssl
        fi
	case `basename ${i%.*}` in 
	    asn1parse|ca|config|crl|crl2pkcs7|crypto|dgst|dhparam|dsa|dsaparam|enc|gendsa|genrsa|nseq|openssl|passwd|pkcs12|pkcs7|pkcs8|rand|req|rsa|rsautl|s_client|s_server|smime|spkac|ssl|verify|version|x509)
		# these are the pages mentioned in openssl(1). They go into the main package.
		echo %doc %{_mandir}/${i}ssl.gz >> $OLDPWD/filelist;;
	    *)	
		# the rest goes into the openssl-doc package.
		echo %doc %{_mandir}/${i}ssl.gz >> $OLDPWD/filelist.doc;;
	esac
done
popd
#
# check wether some shared library has been installed
#
ls -l $RPM_BUILD_ROOT%{_libdir}
test -f $RPM_BUILD_ROOT%{_libdir}/libssl.so.%{num_version}
test -f $RPM_BUILD_ROOT%{_libdir}/libcrypto.so.%{num_version}
test -L $RPM_BUILD_ROOT%{_libdir}/libssl.so
test -L $RPM_BUILD_ROOT%{_libdir}/libcrypto.so
#
# see what we've got
#
cat > showciphers.c <<EOF
#include <openssl/err.h>
#include <openssl/ssl.h>
int main(){
unsigned int i;
SSL_CTX *ctx;
SSL *ssl;
SSL_METHOD *meth;
  meth = SSLv23_client_method();
  SSLeay_add_ssl_algorithms();
  ctx = SSL_CTX_new(meth);
  if (ctx == NULL) return 0;
  ssl = SSL_new(ctx);
  if (!ssl) return 0;
  for (i=0; ; i++) {
    int j, k;
    SSL_CIPHER *sc;
    sc = (meth->get_cipher)(i);
    if (!sc) break;
    k = SSL_CIPHER_get_bits(sc, &j);
    printf("%s\n", sc->name);
  }
  return 0;
};
EOF
gcc $RPM_OPT_FLAGS -I${RPM_BUILD_ROOT}%{_includedir} -c showciphers.c
gcc -o showciphers showciphers.o -L${RPM_BUILD_ROOT}%{_libdir} -lssl -lcrypto
LD_LIBRARY_PATH=${RPM_BUILD_ROOT}%{_libdir} ./showciphers > AVAILABLE_CIPHERS || true
cat AVAILABLE_CIPHERS
# Do not install demo scripts executable under /usr/share/doc
find demos -type f -perm /111 -exec chmod 644 {} \;

#process openssllib
mkdir $RPM_BUILD_ROOT/%{_lib}
mv $RPM_BUILD_ROOT%{_libdir}/libssl.so.%{num_version} $RPM_BUILD_ROOT/%{_lib}/
mv $RPM_BUILD_ROOT%{_libdir}/libcrypto.so.%{num_version} $RPM_BUILD_ROOT/%{_lib}/
mv $RPM_BUILD_ROOT%{_libdir}/engines $RPM_BUILD_ROOT/%{_lib}/
cd $RPM_BUILD_ROOT%{_libdir}/
ln -sf /%{_lib}/libssl.so.%{num_version} ./libssl.so
ln -sf /%{_lib}/libcrypto.so.%{num_version} ./libcrypto.so

for engine in 4758cca atalla nuron sureware ubsec cswift chil aep; do
rm %{buildroot}/%{_lib}/engines/lib$engine.so
done

%ifnarch %{ix86} x86_64
rm %{buildroot}/%{_lib}/engines/libpadlock.so
%endif

%clean
if ! test -f /.buildenv; then rm -rf $RPM_BUILD_ROOT; fi

%post -n libopenssl1_0_0 -p /sbin/ldconfig

%postun -n libopenssl1_0_0 -p /sbin/ldconfig

%files -n libopenssl1_0_0
%defattr(-, root, root)
/%{_lib}/libssl.so.%{num_version}
/%{_lib}/libcrypto.so.%{num_version}
/%{_lib}/engines

%files -n libopenssl-devel
%defattr(-, root, root)
%{_includedir}/%{name}/
%{_includedir}/ssl
%exclude %{_libdir}/libcrypto.a
%exclude %{_libdir}/libssl.a
%{_libdir}/libssl.so
%{_libdir}/libcrypto.so
%_libdir/pkgconfig/libcrypto.pc
%_libdir/pkgconfig/libssl.pc
%_libdir/pkgconfig/openssl.pc

%files doc -f filelist.doc
%defattr(-, root, root)
%doc doc/* demos
%doc showciphers.c 

%files -f filelist
%defattr(-, root, root)
%doc CHANGE* INSTAL* AVAILABLE_CIPHERS
%doc LICENSE NEWS README README.SuSE
%dir %{ssletcdir}
%dir %{ssletcdir}/certs
%config (noreplace) %{ssletcdir}/openssl.cnf
%attr(700,root,root) %{ssletcdir}/private
%dir %{_datadir}/ssl
%{_datadir}/ssl/misc
%{_bindir}/c_rehash
%{_bindir}/%{name}

%changelog
* Thu Jan  8 2015 crrodriguez@opensuse.org
- Upgrade to 1.0.1k
  bsc#912294 CVE-2014-3571: Fix DTLS segmentation fault in dtls1_get_record.
  bsc#912292 CVE-2015-0206: Fix DTLS memory leak in dtls1_buffer_record.
  bsc#911399 CVE-2014-3569: Fix issue where no-ssl3 configuration sets method to NULL.
  bsc#912015 CVE-2014-3572: Abort handshake if server key exchange
    message is omitted for ephemeral ECDH ciphersuites.
  bsc#912014 CVE-2015-0204: Remove non-export ephemeral RSA code on client and server.
  bsc#912293 CVE-2015-0205: Fixed issue where DH client certificates are accepted without verification.
  bsc#912018 CVE-2014-8275: Fix various certificate fingerprint issues.
  bsc#912296 CVE-2014-3570: Correct Bignum squaring.
  and other bugfixes.
- refresh patches
* Thu Oct 16 2014 vcizek@suse.com
- upgrade to 1.0.1j
  * fixes bnc#901277 and bnc#901223
  * ) SRTP Memory Leak.
    A flaw in the DTLS SRTP extension parsing code allows an attacker, who
    sends a carefully crafted handshake message, to cause OpenSSL to fail
    to free up to 64k of memory causing a memory leak. This could be
    exploited in a Denial Of Service attack. This issue affects OpenSSL
    1.0.1 server implementations for both SSL/TLS and DTLS regardless of
    whether SRTP is used or configured. Implementations of OpenSSL that
    have been compiled with OPENSSL_NO_SRTP defined are not affected.
    (CVE-2014-3513)
  * ) Session Ticket Memory Leak.
    When an OpenSSL SSL/TLS/DTLS server receives a session ticket the
    integrity of that ticket is first verified. In the event of a session
    ticket integrity check failing, OpenSSL will fail to free memory
    causing a memory leak. By sending a large number of invalid session
    tickets an attacker could exploit this issue in a Denial Of Service
    attack.
    (CVE-2014-3567)
  * ) Build option no-ssl3 is incomplete.
    When OpenSSL is configured with "no-ssl3" as a build option, servers
    could accept and complete a SSL 3.0 handshake, and clients could be
    configured to send them.
    (CVE-2014-3568)
  * ) Add support for TLS_FALLBACK_SCSV.
    Client applications doing fallback retries should call
    SSL_set_mode(s, SSL_MODE_SEND_FALLBACK_SCSV).
    (CVE-2014-3566)
    [Adam Langley, Bodo Moeller]
  * ) Add additional DigestInfo checks.
    Reencode DigestInto in DER and check against the original when
    verifying RSA signature: this will reject any improperly encoded
    DigestInfo structures.
    Note: this is a precautionary measure and no attacks are currently known.
* Tue Aug 12 2014 crrodriguez@opensuse.org
- openssl 1.0.1i
  * Information leak in pretty printing functions (CVE-2014-3508)
  * Crash with SRP ciphersuite in Server Hello message (CVE-2014-5139)
  * Race condition in ssl_parse_serverhello_tlsext (CVE-2014-3509)
  * Double Free when processing DTLS packets (CVE-2014-3505)
  * DTLS memory exhaustion (CVE-2014-3506)
  * DTLS memory leak from zero-length fragments (CVE-2014-3507)
  * OpenSSL DTLS anonymous EC(DH) denial of service (CVE-2014-3510)
  * OpenSSL TLS protocol downgrade attack (CVE-2014-3511)
  * SRP buffer overrun (CVE-2014-3512)
- 0005-libssl-Hide-library-private-symbols.patch Re-enable heartbleed
  test and correctly refresh patch (issue fixed upstream)
* Thu Jun  5 2014 meissner@suse.com
- Upgrade to 1.0.1h (bnc#880891):
  - CVE-2014-0224: Fix for SSL/TLS MITM flaw. An attacker using a carefully crafted
    handshake can force the use of weak keying material in OpenSSL
    SSL/TLS clients and servers.
  - CVE-2014-0221: Fix DTLS recursion flaw. By sending an invalid DTLS handshake to an
    OpenSSL DTLS client the code can be made to recurse eventually crashing
    in a DoS attack.
  - CVE-2014-0195: Fix DTLS invalid fragment vulnerability. A buffer
    overrun attack can be triggered by sending invalid DTLS fragments to
    an OpenSSL DTLS client or server. This is potentially exploitable to
    run arbitrary code on a vulnerable client or server.
  - CVE-2014-3470: Fix bug in TLS code where clients enable anonymous
    ECDH ciphersuites are subject to a denial of service attack.
  - Harmonize version and its documentation. -f flag is used to display compilation flags.
  - Fix eckey_priv_encode so it immediately returns an error upon a failure
    in i2d_ECPrivateKey.
  - Fix some double frees. These are not thought to be exploitable.
- CVE-2014-0198.patch: upstreamed
- CVE-2010-5298.patch: upstreamed
- openssl-fix-pod-syntax.diff: refreshed as various fixes were done upstream
- 0005-libssl-Hide-library-private-symbols.patch: This breaks compilation
  of heartbleed testcase, disabled the test for now.
* Mon May  5 2014 citypw@gmail.com
- Fixed bug[ bnc#876282], CVE-2014-0198 openssl: OpenSSL NULL pointer dereference in do_ssl3_write
  Add file: CVE-2014-0198.patch
* Wed Apr 23 2014 citypw@gmail.com
- Fixed bug[ bnc#873351] CVE-2010-5298: openssl: Use-after-free race condition,in OpenSSL's read buffer
  Add file: CVE-2010-5298.patch
* Thu Apr 10 2014 shchang@suse.com
- Upgrade to 1.0.1g:
  * TLS heartbeat read overrun (CVE-2014-0160)
  * Fixed: CVE-2013-4353, CVE-2013-6449, CVE-2013-6450, CVE-2014-0076, CVE-2014-0160
  Add files: openssl-1.0.1g.tar.gz, openssl-1.0.1g.tar.gz.asc
  Delete files: openssl-1.0.1e.tar.gz, openssl-1.0.1e.tar.gz.asc, CVE-2013-4353.patch,
  CVE-2013-6449.patch, CVE-2013-6450.patch, CVE-2014-0076.patch, bug-861384-crash_webrtc.patch,
  CVE-2014-0160.patch, SSL_get_certificate-broken.patch, openssl-1.0.1e-bnc822642.patch
* Tue Apr  8 2014 shchang@suse.com
- Fixed bug[ bnc#872299] CVE-2014-0160: openssl: missing bounds checks for heartbeat messages
  Add file: CVE-2014-0160.patch
* Tue Mar 25 2014 shchang@suse.com
- Fix bug[ bnc#869945] CVE-2014-0076: openssl: Recovering OpenSSL ECDSA Nonces Using the FLUSH+RELOAD Cache Side-channel Attack
  Add file: CVE-2014-0076.patch
* Sun Jan 26 2014 shchang@suse.com
- Fixed bnc#861384, update to openssl-1.0.1e-11.14.1 broke WebRTC functionality in FreeSWITCH
  Add file: bug-861384-crash_webrtc.patch
* Wed Jan  8 2014 shchang@suse.com
- Fixed bnc#857640, openssl: TLS record tampering issue can lead to OpenSSL crash
  Add file: CVE-2013-4353.patch
* Thu Jan  2 2014 shchang@suse.com
- Fixed bnc#857203, openssl: crash in DTLS renegotiation after packet loss
  Add file: CVE-2013-6450.patch
* Sun Dec 22 2013 shchang@suse.com
- Fixed bnc#856687, openssl: crash when using TLS 1.2
  Add file: CVE-2013-6449.patch
* Tue Dec 17 2013 meissner@suse.com
- compression_methods_switch.patch: setenv might not be successful
  if a surrounding library or application filters it, like e.g. sudo.
  As setenv() does not seem to be useful anyway, remove it.
  bnc#849377
* Fri Sep 27 2013 dmacvicar@suse.de
- VPN openconnect problem (DTLS handshake failed)
  (git 9fe4603b8, bnc#822642, openssl ticket#2984)
* Wed Sep  4 2013 guillaume@opensuse.org
- Fix armv6l arch (armv7 was previously used to build armv6 which
  lead to illegal instruction when used)
* Mon Aug 12 2013 shchang@suse.com
- Fix bug[ bnc#832833] openssl ssl_set_cert_masks() is broken
  modify patch file: SSL_get_certificate-broken.patch
* Fri Aug  9 2013 crrodriguez@opensuse.org
- Via padlock is only found in x86 and x86_64 CPUs, remove
  the shared module for other archs.
* Wed Aug  7 2013 crrodriguez@opensuse.org
- Cleanup engines that are of no use in a modern linux distro
- The following engines stay:
  * libcapi.so --> usable in case you have third party /dev/crypto
  * libgmp.so --> may help to doing some maths using GMP
  * libgost.so --> implements the GOST block cipher
  * libpadlock.so --> VIA padlock support
- Al other are removed because they require third party propietary
  shared libraries nowhere to be found or that we can test.
* Wed Aug  7 2013 crrodriguez@opensuse.org
- openssl-pkgconfig.patch: Here we go.. For applications
  to benefit fully of features provided by openSSL engines
  (rdrand, aes-ni..etc) either builtin or in DSO form applications
  have to call ENGINE_load_builtin_engines() or OPENSSL_config()
  unfortunately from a total of 68 apps/libraries linked to libcrypto
  in a desktop system, only 4 do so, and there is a sea of buggy
  code that I dont feel like fixing.
  Instead we can pass -DOPENSSL_LOAD_CONF in the pkgconfig files
  so the needed operation becomes implicit the next time such apps
  are recompiled, see OPENSSL_config(3)
  Unfortunately this does not fix everything, because there are apps
  not using pkgconfig or using it incorrectly, but it is a good start.
* Wed Aug  7 2013 dmueller@suse.com
- add openssl-1.0.1c-default-paths.patch:
  Fix from Fedora for openssl s_client not setting
  CApath by default
* Sat Aug  3 2013 crrodriguez@opensuse.org
- 0005-libssl-Hide-library-private-symbols.patch: hide
  private symbols, this *only* applies to libssl where
  it is straightforward to do so as applications should
  not be using any of the symbols declared/defined in headers
  that the library does not install.
  A separate patch MAY be provided in the future for libcrypto
  where things are much more complicated and threfore requires
  careful testing.
* Mon Jul 29 2013 meissner@suse.com
- compression_methods_switch.patch: Disable compression by default to
  avoid the CRIME attack (CVE-2012-4929 bnc#793420)
  Can be override by setting environment variable
    OPENSSL_NO_DEFAULT_ZLIB=no
* Tue Jul  2 2013 lnussel@suse.de
- Don't use the legacy /etc/ssl/certs directory anymore but rather
  the p11-kit generated /var/lib/ca-certificates/openssl one
  (fate#314991, openssl-1.0.1e-truststore.diff)
* Sat Jun 29 2013 crrodriguez@opensuse.org
- Build enable-ec_nistp_64_gcc_128, ecdh is many times faster
  but only works in x86_64.
  According to the openSSL team
  "it is superior to the default in multiple regards (speed, and also
  security as the new implementations are secure against timing
  attacks)"
  It is not enabled by default due to the build system being unable
  to detect if the compiler supports __uint128_t.
* Thu Jun 20 2013 coolo@suse.com
- pick openssl-fix-pod-syntax.diff out of the upstream RT to fix
  build with perl 5.18
* Sat May 25 2013 i@marguerite.su
- add %%if tag for BuildArch. sles may also need latest openssl.
* Fri Feb 22 2013 dmueller@suse.com
- disable fstack-protector on aarch64
* Tue Feb 12 2013 hrvoje.senjan@gmail.com
- Update to 1.0.1e
  o Bugfix release (bnc#803004)
- Drop openssl-1.0.1d-s3-packet.patch, included upstream
* Sun Feb 10 2013 hrvoje.senjan@gmail.com
- Added openssl-1.0.1d-s3-packet.patch from upstream, fixes
  bnc#803004, openssl ticket#2975
* Tue Feb  5 2013 meissner@suse.com
- update to version 1.0.1d, fixing security issues
  o Fix renegotiation in TLS 1.1, 1.2 by using the correct TLS version.
  o Include the fips configuration module.
  o Fix OCSP bad key DoS attack CVE-2013-0166
  o Fix for SSL/TLS/DTLS CBC plaintext recovery attack CVE-2013-0169
    bnc#802184
  o Fix for TLS AESNI record handling flaw CVE-2012-2686
* Mon Nov 12 2012 gjhe@suse.com
- fix bug[bnc#784994] - VIA padlock support on 64 systems
  e_padlock: add support for x86_64 gcc
* Sun Aug 19 2012 crrodriguez@opensuse.org
- Open Internal file descriptors with O_CLOEXEC, leaving
  those open across fork()..execve() makes a perfect
  vector for a side-channel attack...
* Tue Aug  7 2012 dmueller@suse.com
- fix build on armv5 (bnc#774710)
* Thu May 10 2012 crrodriguez@opensuse.org
- Update to version 1.0.1c for the complete list of changes see
  NEWS, this only list packaging changes.
- Drop aes-ni patch, no longer needed as it is builtin in openssl
  now.
- Define GNU_SOURCE and use -std=gnu99 to build the package.
- Use LFS_CFLAGS in platforms where it matters.
* Fri May  4 2012 lnussel@suse.de
- don't install any demo or expired certs at all
* Mon Apr 23 2012 gjhe@suse.com
- update to latest stable verison 1.0.0i
  including the following patches:
  CVE-2012-2110.path
  Bug748738_Tolerate_bad_MIME_headers.patch
  bug749213-Free-headers-after-use.patch
  bug749210-Symmetric-crypto-errors-in-PKCS7_decrypt.patch
  CVE-2012-1165.patch
  CVE-2012-0884.patch
  bug749735.patch
* Tue Mar 27 2012 gjhe@suse.com
- fix bug[bnc#749735] - Memory leak when creating public keys.
  fix bug[bnc#751977] - CMS and S/MIME Bleichenbacher attack
  CVE-2012-0884
* Thu Mar 22 2012 gjhe@suse.com
- fix bug[bnc#751946] - S/MIME verification may erroneously fail
  CVE-2012-1165
* Wed Mar 21 2012 gjhe@suse.com
- fix bug[bnc#749213]-Free headers after use in error message
  and bug[bnc#749210]-Symmetric crypto errors in PKCS7_decrypt
* Tue Mar 20 2012 cfarrell@suse.com
- license update: OpenSSL
* Fri Feb 24 2012 gjhe@suse.com
- fix bug[bnc#748738] - Tolerate bad MIME headers in openssl's
  asn1 parser.
  CVE-2006-7250
* Thu Feb  2 2012 gjhe@suse.com
- Update to version 1.0.0g fix the following:
  DTLS DoS attack (CVE-2012-0050)
* Wed Jan 11 2012 gjhe@suse.com
- Update to version 1.0.0f fix the following:
  DTLS Plaintext Recovery Attack (CVE-2011-4108)
  Uninitialized SSL 3.0 Padding (CVE-2011-4576)
  Malformed RFC 3779 Data Can Cause Assertion Failures (CVE-2011-4577)
  SGC Restart DoS Attack (CVE-2011-4619)
  Invalid GOST parameters DoS Attack (CVE-2012-0027)
* Tue Oct 18 2011 crrodriguez@opensuse.org
- AES-NI: Check the return value of Engine_add()
  if the ENGINE_add() call fails: it ends up adding a reference
  to a freed up ENGINE which is likely to subsequently contain garbage
  This will happen if an ENGINE with the same name is added multiple
  times,for example different libraries. [bnc#720601]
* Sat Oct  8 2011 crrodriguez@opensuse.org
- Build with -DSSL_FORBID_ENULL so servers are not
  able to use the NULL encryption ciphers (Those offering no
  encryption whatsoever).
* Wed Sep  7 2011 crrodriguez@opensuse.org
- Update to openssl 1.0.0e fixes CVE-2011-3207 and CVE-2011-3210
  see http://openssl.org/news/secadv_20110906.txt for details.
* Sat Aug  6 2011 crrodriguez@opensuse.org
- Add upstream patch that calls ENGINE_register_all_complete()
  in ENGINE_load_builtin_engines() saving us from adding dozens
  of calls to such function to calling applications.
* Fri Aug  5 2011 crrodriguez@opensuse.org
- remove -fno-strict-aliasing from CFLAGS no longer needed
  and is likely to slow down stuff.
* Mon Jul 25 2011 jengelh@medozas.de
- Edit baselibs.conf to provide libopenssl-devel-32bit too
* Fri Jun 24 2011 gjhe@novell.com
- update to latest stable version 1.0.0d.
  patch removed(already in the new package):
  CVE-2011-0014
  patch added:
  ECDSA_signatures_timing_attack.patch
* Tue May 31 2011 gjhe@novell.com
- fix bug[bnc#693027].
  Add protection against ECDSA timing attacks as mentioned in the paper
  by Billy Bob Brumley and Nicola Tuveri, see:
  http://eprint.iacr.org/2011/232.pdf
  [Billy Bob Brumley and Nicola Tuveri]
* Mon May 16 2011 andrea@opensuse.org
- added openssl as dependency in the devel package
* Thu Feb 10 2011 gjhe@novell.com
- fix bug [bnc#670526]
  CVE-2011-0014,OCSP stapling vulnerability
* Sat Jan 15 2011 cristian.rodriguez@opensuse.org
- Add patch from upstream in order to support AES-NI instruction
  set present on current Intel and AMD processors
* Mon Jan 10 2011 meissner@suse.de
- enable -DPURIFY to avoid valgrind errors.
* Thu Dec  9 2010 gjhe@novell.com
- update to stable version 1.0.0c.
  patch included:
  CVE-2010-1633_and_CVE-2010-0742.patch
  patchset-19727.diff
  CVE-2010-2939.patch
  CVE-2010-3864.patch
* Thu Nov 18 2010 gjhe@novell.com
- fix bug [bnc#651003]
  CVE-2010-3864
* Sat Sep 25 2010 gjhe@novell.com
- fix bug [bnc#629905]
  CVE-2010-2939
* Wed Jul 28 2010 cristian.rodriguez@opensuse.org
- Exclude static libraries, see what breaks and fix that
  instead
* Wed Jun 30 2010 jengelh@medozas.de
- fix two compile errors on SPARC
* Tue Jun 15 2010 bg@novell.com
- -fstack-protector is not supported on hppa
* Fri Jun  4 2010 gjhe@novell.com
- fix bnc #610642
  CVE-2010-0742
  CVE-2010-1633
* Mon May 31 2010 gjhe@novell.com
- fix bnc #610223,change Configure to tell openssl to load engines
  from /%%{_lib} instead of %%{_libdir}
* Mon May 10 2010 aj@suse.de
- Do not compile in build time but use mtime of changes file instead.
  This allows build-compare to identify that no changes have happened.
* Tue May  4 2010 gjhe@novell.com
- build libopenssl to /%%{_lib} dir,and keep only one
  libopenssl-devel for new developping programs.
* Tue Apr 27 2010 gjhe@novell.com
- build libopenssl and libopenssl-devel to a version directory
* Sat Apr 24 2010 coolo@novell.com
- buildrequire pkg-config to fix provides
* Wed Apr 21 2010 lnussel@suse.de
- also create old certificate hash in /etc/ssl/certs for
  compatibility with applications that still link against 0.9.8
* Mon Apr 12 2010 meissner@suse.de
- Disable our own build targets, instead use the openSSL provided ones
  as they are now good (or should be good at least).
- add -Wa,--noexecstack to the Configure call, this is the upstream
  approved way to avoid exec-stack marking
* Mon Apr 12 2010 gjhe@novell.com
- update to 1.0.0
  Merge the following patches from 0.9.8k:
  openssl-0.9.6g-alpha.diff
  openssl-0.9.7f-ppc64.diff
  openssl-0.9.8-flags-priority.dif
  openssl-0.9.8-sparc.dif
  openssl-allow-arch.diff
  openssl-hppa-config.diff
* Fri Apr  9 2010 meissner@suse.de
- fixed "exectuable stack" for libcrypto.so issue on i586 by
  adjusting the assembler output during MMX builds.
* Wed Apr  7 2010 meissner@suse.de
- Openssl is now partially converted to libdir usage upstream,
  merge that in to fix lib64 builds.
* Thu Mar 25 2010 gjhe@novell.com
- fix security bug [bnc#590833]
  CVE-2010-0740
* Mon Mar 22 2010 gjhe@novell.com
- update to version 0.9.8m
  Merge the following patches from 0.9.8k:
  bswap.diff
  non-exec-stack.diff
  openssl-0.9.6g-alpha.diff
  openssl-0.9.7f-ppc64.diff
  openssl-0.9.8-flags-priority.dif
  openssl-0.9.8-sparc.dif
  openssl-allow-arch.diff
  openssl-hppa-config.diff
* Fri Feb  5 2010 jengelh@medozas.de
- build openssl for sparc64
* Mon Dec 14 2009 jengelh@medozas.de
- add baselibs.conf as a source
- package documentation as noarch
* Tue Nov  3 2009 coolo@novell.com
- updated patches to apply with fuzz=0
* Tue Sep  1 2009 gjhe@novell.com
- fix Bug [bnc#526319]
* Wed Aug 26 2009 coolo@novell.com
- use %%patch0 for Patch0
* Fri Jul  3 2009 gjhe@novell.com
- update to version 0.9.8k
- patches merged upstream:
  openssl-CVE-2008-5077.patch
  openssl-CVE-2009-0590.patch
  openssl-CVE-2009-0591.patch
  openssl-CVE-2009-0789.patch
  openssl-CVE-2009-1377.patch
  openssl-CVE-2009-1378.patch
  openssl-CVE-2009-1379.patch
  openssl-CVE-2009-1386.patch
  openssl-CVE-2009-1387.patch
* Tue Jun 30 2009 gjhe@novell.com
- fix security bug [bnc#509031]
  CVE-2009-1386
  CVE-2009-1387
* Tue Jun 30 2009 gjhe@novell.com
- fix security bug [bnc#504687]
  CVE-2009-1377
  CVE-2009-1378
  CVE-2009-1379
* Wed Apr 15 2009 gjhe@suse.de
- fix security bug [bnc#489641]
  CVE-2009-0590
  CVE-2009-0591
  CVE-2009-0789
* Wed Jan  7 2009 olh@suse.de
- obsolete old -XXbit packages (bnc#437293)
* Thu Dec 18 2008 jshi@suse.de
- fix security bug [bnc#459468]
  CVE-2008-5077
* Tue Dec  9 2008 xwhu@suse.de
- Disable optimization for s390x
* Mon Dec  8 2008 xwhu@suse.de
- Disable optimization of md4
* Mon Nov 10 2008 xwhu@suse.de
- Disable optimization of ripemd [bnc#442740]
* Tue Oct 14 2008 xwhu@suse.de
- Passing string as struct cause openssl segment-fault [bnc#430141]
* Wed Jul 16 2008 mkoenig@suse.de
- do not require openssl-certs, but rather recommend it
  to avoid dependency cycle [bnc#408865]
* Wed Jul  9 2008 mkoenig@suse.de
- remove the certs subpackage from the openssl package
  and move the CA root certificates into a package of its own
* Tue Jun 24 2008 mkoenig@suse.de
- update to version 0.9.8h
- openssl does not ship CA root certificates anymore
  keep certificates that SuSE is already shipping
- resolves bad array index (function has been removed) [bnc#356549]
- removed patches
  openssl-0.9.8g-fix_dh_for_certain_moduli.patch
  openssl-CVE-2008-0891.patch
  openssl-CVE-2008-1672.patch
* Wed May 28 2008 mkoenig@suse.de
- fix OpenSSL Server Name extension crash (CVE-2008-0891)
  and OpenSSL Omit Server Key Exchange message crash (CVE-2008-1672)
  [bnc#394317]
* Wed May 21 2008 cthiel@suse.de
- fix baselibs.conf
* Tue Apr 22 2008 mkoenig@suse.de
- add -DMD32_REG_T=int for x86_64 and ia64 [bnc#381844]
* Thu Apr 10 2008 ro@suse.de
- added baselibs.conf file to build xxbit packages
  for multilib support
* Mon Nov  5 2007 mkoenig@suse.de
- fix Diffie-Hellman failure with certain prime lengths
* Mon Oct 22 2007 mkoenig@suse.de
- update to version 0.9.8g:
  * fix some bugs introduced with 0.9.8f
* Mon Oct 15 2007 mkoenig@suse.de
- update to version 0.9.8f:
  * fixes CVE-2007-3108, CVE-2007-5135, CVE-2007-4995
- patches merged upstream:
  openssl-0.9.8-key_length.patch
  openssl-CVE-2007-3108-bug296511
  openssl-CVE-2007-5135.patch
  openssl-gcc42.patch
  openssl-gcc42_b.patch
  openssl-s390-config.diff
* Mon Oct  1 2007 mkoenig@suse.de
- fix buffer overflow CVE-2007-5135 [#329208]
* Wed Sep  5 2007 mkoenig@suse.de
- fix another gcc 4.2 build problem [#307669]
* Fri Aug  3 2007 coolo@suse.de
- provide the version obsoleted (#293401)
* Wed Aug  1 2007 werner@suse.de
- Add patch from CVS for RSA key reconstruction vulnerability
  (CVE-2007-3108, VU#724968, bug #296511)
* Thu May 24 2007 mkoenig@suse.de
- fix build with gcc-4.2
  openssl-gcc42.patch
- do not install example scripts with executable permissions
* Sun Apr 29 2007 ro@suse.de
- adapt requires
* Fri Apr 27 2007 mkoenig@suse.de
- Do not use dots in package name
- explicitly build with gcc-4.1 because of currently unresolved
  failures with gcc-4.2
* Wed Apr 25 2007 mkoenig@suse.de
- Split/rename package to follow library packaging policy [#260219]
  New package libopenssl0.9.8 containing shared libs
  openssl-devel package renamed to libopenssl-devel
  New package openssl-certs containing certificates
- add zlib-devel to Requires of devel package
- remove old Obsoletes and Conflicts
  openssls (Last used Nov 2000)
  ssleay (Last used 6.2)
* Mon Apr 23 2007 mkoenig@suse.de
- Fix key length [#254905,#262477]
* Tue Mar  6 2007 mkoenig@suse.de
- update to version 0.9.8e:
  * patches merged upstream:
    openssl-CVE-2006-2940-fixup.patch
    openssl-0.9.8d-padlock-static.patch
* Tue Jan  9 2007 mkoenig@suse.de
- fix PadLock support [#230823]
* Thu Nov 30 2006 mkoenig@suse.de
- enable fix for CVE-2006-2940 [#223040], SWAMP-ID 7198
* Mon Nov  6 2006 poeml@suse.de
- configure with 'zlib' instead of 'zlib-dynamic'. Build with the
  latter, there are problems opening the libz when running on the
  Via Epia or vmware platforms. [#213305]
* Wed Oct  4 2006 poeml@suse.de
- add patch for the CVE-2006-2940 fix: the newly introduced limit
  on DH modulus size could lead to a crash when exerted. [#208971]
  Discovered and fixed after the 0.9.8d release.
* Fri Sep 29 2006 poeml@suse.de
- update to 0.9.8d
  * ) Introduce limits to prevent malicious keys being able to
    cause a denial of service.  (CVE-2006-2940)
  * ) Fix ASN.1 parsing of certain invalid structures that can result
    in a denial of service.  (CVE-2006-2937)
  * ) Fix buffer overflow in SSL_get_shared_ciphers() function.
    (CVE-2006-3738)
  * ) Fix SSL client code which could crash if connecting to a
    malicious SSLv2 server.  (CVE-2006-4343)
  * ) Since 0.9.8b, ciphersuite strings naming explicit ciphersuites
    match only those.  Before that, "AES256-SHA" would be interpreted
    as a pattern and match "AES128-SHA" too (since AES128-SHA got
    the same strength classification in 0.9.7h) as we currently only
    have a single AES bit in the ciphersuite description bitmap.
    That change, however, also applied to ciphersuite strings such as
    "RC4-MD5" that intentionally matched multiple ciphersuites --
    namely, SSL 2.0 ciphersuites in addition to the more common ones
    from SSL 3.0/TLS 1.0.
    So we change the selection algorithm again: Naming an explicit
    ciphersuite selects this one ciphersuite, and any other similar
    ciphersuite (same bitmap) from *other* protocol versions.
    Thus, "RC4-MD5" again will properly select both the SSL 2.0
    ciphersuite and the SSL 3.0/TLS 1.0 ciphersuite.
    Since SSL 2.0 does not have any ciphersuites for which the
    128/256 bit distinction would be relevant, this works for now.
    The proper fix will be to use different bits for AES128 and
    AES256, which would have avoided the problems from the beginning;
    however, bits are scarce, so we can only do this in a new release
    (not just a patchlevel) when we can change the SSL_CIPHER
    definition to split the single 'unsigned long mask' bitmap into
    multiple values to extend the available space.
- not in mentioned in CHANGES: patch for CVE-2006-4339 corrected
  [openssl.org #1397]
* Fri Sep  8 2006 schwab@suse.de
- Fix inverted logic.
* Wed Sep  6 2006 poeml@suse.de
- update to 0.9.8c
  Changes between 0.9.8b and 0.9.8c  [05 Sep 2006]
  * ) Avoid PKCS #1 v1.5 signature attack discovered by Daniel Bleichenbacher
    (CVE-2006-4339)  [Ben Laurie and Google Security Team]
  * ) Add AES IGE and biIGE modes.  [Ben Laurie]
  * ) Change the Unix randomness entropy gathering to use poll() when
    possible instead of select(), since the latter has some
    undesirable limitations.  [Darryl Miles via Richard Levitte and Bodo Moeller]
  * ) Disable "ECCdraft" ciphersuites more thoroughly.  Now special
    treatment in ssl/ssl_ciph.s makes sure that these ciphersuites
    cannot be implicitly activated as part of, e.g., the "AES" alias.
    However, please upgrade to OpenSSL 0.9.9[-dev] for
    non-experimental use of the ECC ciphersuites to get TLS extension
    support, which is required for curve and point format negotiation
    to avoid potential handshake problems.  [Bodo Moeller]
  * ) Disable rogue ciphersuites:
  - SSLv2 0x08 0x00 0x80 ("RC4-64-MD5")
  - SSLv3/TLSv1 0x00 0x61 ("EXP1024-RC2-CBC-MD5")
  - SSLv3/TLSv1 0x00 0x60 ("EXP1024-RC4-MD5")
    The latter two were purportedly from
    draft-ietf-tls-56-bit-ciphersuites-0[01].txt, but do not really
    appear there.
    Also deactive the remaining ciphersuites from
    draft-ietf-tls-56-bit-ciphersuites-01.txt.  These are just as
    unofficial, and the ID has long expired.  [Bodo Moeller]
  * ) Fix RSA blinding Heisenbug (problems sometimes occured on
    dual-core machines) and other potential thread-safety issues.
    [Bodo Moeller]
  * ) Add the symmetric cipher Camellia (128-bit, 192-bit, 256-bit key
    versions), which is now available for royalty-free use
    (see http://info.isl.ntt.co.jp/crypt/eng/info/chiteki.html).
    Also, add Camellia TLS ciphersuites from RFC 4132.
    To minimize changes between patchlevels in the OpenSSL 0.9.8
    series, Camellia remains excluded from compilation unless OpenSSL
    is configured with 'enable-camellia'.  [NTT]
  * ) Disable the padding bug check when compression is in use. The padding
    bug check assumes the first packet is of even length, this is not
    necessarily true if compresssion is enabled and can result in false
    positives causing handshake failure. The actual bug test is ancient
    code so it is hoped that implementations will either have fixed it by
    now or any which still have the bug do not support compression.
    [Steve Henson]
  Changes between 0.9.8a and 0.9.8b  [04 May 2006]
  * ) When applying a cipher rule check to see if string match is an explicit
    cipher suite and only match that one cipher suite if it is.  [Steve Henson]
  * ) Link in manifests for VC++ if needed.  [Austin Ziegler <halostatue@gmail.com>]
  * ) Update support for ECC-based TLS ciphersuites according to
    draft-ietf-tls-ecc-12.txt with proposed changes (but without
    TLS extensions, which are supported starting with the 0.9.9
    branch, not in the OpenSSL 0.9.8 branch).  [Douglas Stebila]
  * ) New functions EVP_CIPHER_CTX_new() and EVP_CIPHER_CTX_free() to support
    opaque EVP_CIPHER_CTX handling.  [Steve Henson]
  * ) Fixes and enhancements to zlib compression code. We now only use
    "zlib1.dll" and use the default __cdecl calling convention on Win32
    to conform with the standards mentioned here:
    http://www.zlib.net/DLL_FAQ.txt
    Static zlib linking now works on Windows and the new --with-zlib-include
  - -with-zlib-lib options to Configure can be used to supply the location
    of the headers and library. Gracefully handle case where zlib library
    can't be loaded.  [Steve Henson]
  * ) Several fixes and enhancements to the OID generation code. The old code
    sometimes allowed invalid OIDs (1.X for X >= 40 for example), couldn't
    handle numbers larger than ULONG_MAX, truncated printing and had a
    non standard OBJ_obj2txt() behaviour.  [Steve Henson]
  * ) Add support for building of engines under engine/ as shared libraries
    under VC++ build system.  [Steve Henson]
  * ) Corrected the numerous bugs in the Win32 path splitter in DSO.
    Hopefully, we will not see any false combination of paths any more.
    [Richard Levitte]
- enable Camellia cipher. There is a royalty free license to the
  patents, see http://info.isl.ntt.co.jp/crypt/eng/info/chiteki.html.
  NOTE: the license forbids patches to the cipher.
- build with zlib-dynamic and add zlib-devel to BuildRequires.
  Allows compression of data in TLS, although few application would
  actually use it since there is no standard for negotiating the
  compression method. The only one I know if is stunnel.
* Fri Jun  2 2006 poeml@suse.de
- fix built-in ENGINESDIR for 64 bit architectures. We change only
  the builtin search path for engines, not the path where engines
  are packaged. Path can be overridden with the OPENSSL_ENGINES
  environment variable. [#179094]
* Wed Jan 25 2006 mls@suse.de
- converted neededforbuild to BuildRequires
* Mon Jan 16 2006 mc@suse.de
- fix build problems on s390x (openssl-s390-config.diff)
- build with -fstack-protector
* Mon Nov  7 2005 dmueller@suse.de
- build with non-executable stack
* Thu Oct 20 2005 poeml@suse.de
- fix unguarded free() which can cause a segfault in the ca
  commandline app [#128655]
* Thu Oct 13 2005 poeml@suse.de
- add Geotrusts Equifax Root1 CA certificate, which needed to
  verify the authenticity of you.novell.com [#121966]
* Tue Oct 11 2005 poeml@suse.de
- update to 0.9.8a
  * ) Remove the functionality of SSL_OP_MSIE_SSLV2_RSA_PADDING
    (part of SSL_OP_ALL).  This option used to disable the
    countermeasure against man-in-the-middle protocol-version
    rollback in the SSL 2.0 server implementation, which is a bad
    idea.  (CAN-2005-2969)
  * ) Add two function to clear and return the verify parameter flags.
  * ) Keep cipherlists sorted in the source instead of sorting them at
    runtime, thus removing the need for a lock.
  * ) Avoid some small subgroup attacks in Diffie-Hellman.
  * ) Add functions for well-known primes.
  * ) Extended Windows CE support.
  * ) Initialize SSL_METHOD structures at compile time instead of during
    runtime, thus removing the need for a lock.
  * ) Make PKCS7_decrypt() work even if no certificate is supplied by
    attempting to decrypt each encrypted key in turn. Add support to
    smime utility.
* Thu Sep 29 2005 poeml@suse.de
- update to 0.9.8
  see CHANGES file or http://www.openssl.org/news/changelog.html
- adjust patches
- drop obsolete openssl-no-libc.diff
- disable libica patch until it has been ported
* Fri May 20 2005 poeml@suse.de
- update to 0.9.7g. The significant changes are:
  * ) Fixes for newer kerberos headers. NB: the casts are needed because
    the 'length' field is signed on one version and unsigned on another
    with no (?) obvious way to tell the difference, without these VC++
    complains. Also the "definition" of FAR (blank) is no longer included
    nor is the error ENOMEM. KRB5_PRIVATE has to be set to 1 to pick up
    some needed definitions.
  * ) Added support for proxy certificates according to RFC 3820.
    Because they may be a security thread to unaware applications,
    they must be explicitely allowed in run-time.  See
    docs/HOWTO/proxy_certificates.txt for further information.
* Tue May 17 2005 schwab@suse.de
- Include %%cflags_profile_generate in ${CC} since it is required for
  linking as well.
- Remove explicit reference to libc.
* Fri Apr  8 2005 poeml@suse.de
- update to 0.9.7f. The most significant changes are:
    o Several compilation issues fixed.
    o Many memory allocation failure checks added.
    o Improved comparison of X509 Name type.
    o Mandatory basic checks on certificates.
    o Performance improvements.
  (for a complete list see http://www.openssl.org/source/exp/CHANGES)
- adjust openssl-0.9.7f-ppc64.diff
- drop obsolete openssl-0.9.7d-crl-default_md.dif [#55435]
* Tue Jan  4 2005 poeml@suse.de
- update to 0.9.7e
  * ) Avoid a race condition when CRLs are checked in a multi
    threaded environment. This would happen due to the reordering
    of the revoked entries during signature checking and serial
    number lookup. Now the encoding is cached and the serial
    number sort performed under a lock.  Add new STACK function
    sk_is_sorted().
  * ) Add Delta CRL to the extension code.
  * ) Various fixes to s3_pkt.c so alerts are sent properly.
  * ) Reduce the chances of duplicate issuer name and serial numbers
    (in violation of RFC3280) using the OpenSSL certificate
    creation utilities.  This is done by creating a random 64 bit
    value for the initial serial number when a serial number file
    is created or when a self signed certificate is created using
    'openssl req -x509'. The initial serial number file is created
    using 'openssl x509 -next_serial' in CA.pl rather than being
    initialized to 1.
- remove obsolete patches
- fix openssl-0.9.7d-padlock-glue.diff and ICA patch to patch
  Makefile, not Makefile.ssl
- fixup for spaces in names of man pages not needed now
- pack /usr/bin/openssl_fips_fingerprint
- in rpm post/postun script, run /sbin/ldconfig directly (the macro
  is deprecated)
* Mon Oct 18 2004 poeml@suse.de
- don't install openssl.doxy file [#45210]
* Thu Jul 29 2004 poeml@suse.de
- apply patch from CVS to fix segfault in S/MIME encryption
  (http://cvs.openssl.org/chngview?cn=12081, regression in
  openssl-0.9.7d) [#43386]
* Mon Jul 12 2004 mludvig@suse.cz
- Updated VIA PadLock engine.
* Wed Jun 30 2004 mludvig@suse.cz
- Updated openssl-0.9.7d-padlock-engine.diff with support for
  AES192, AES256 and RNG.
* Tue Jun 15 2004 poeml@suse.de
- update IBM ICA patch to last night's version. Fixes ibmca_init()
  to reset ibmca_dso=NULL after calling DSO_free(), if the device
  driver could not be loaded. The bug lead to a segfault triggered
  by stunnel, which does autoload available engines [#41874]
- patch from CVS: make stack API more robust (return NULL for
  out-of-range indexes). Fixes another possible segfault during
  engine detection (could also triggered by stunnel)
- add patch from Michal Ludvig for VIA PadLock support
* Wed Jun  2 2004 poeml@suse.de
- add root certificate for the ICP-Brasil CA [#41546]
* Thu May 13 2004 poeml@suse.de
- add patch to use default_md for CRLs too [#40435]
* Tue May  4 2004 poeml@suse.de
- update ICA patch to apr292004 release [#39695]
* Thu Mar 18 2004 poeml@suse.de
- update to 0.9.7d
  o Security: Fix Kerberos ciphersuite SSL/TLS handshaking bug
    (CAN-2004-0112)
  o Security: Fix null-pointer assignment in do_change_cipher_spec()
    (CAN-2004-0079)
  o Allow multiple active certificates with same subject in CA index
  o Multiple X590 verification fixes
  o Speed up HMAC and other operations
- remove the hunk from openssl-0.9.6d.dif that added NO_IDEA around
  IDEA_128_CBC_WITH_MD5 in the global cipher list. Upstream now has
  OPENSSL_NO_IDEA around it
- [#36386] fixed (broken generation of EVP_BytesToKey.3ssl from the
  pod file)
- permissions of lib/pkgconfig fixed
* Wed Feb 25 2004 poeml@suse.de
- update to 0.9.7c
  * ) Fix various bugs revealed by running the NISCC test suite:
    Stop out of bounds reads in the ASN1 code when presented with
    invalid tags (CAN-2003-0543 and CAN-2003-0544).
    Free up ASN1_TYPE correctly if ANY type is invalid (CAN-2003-0545).
    If verify callback ignores invalid public key errors don't try to check
    certificate signature with the NULL public key.
  * ) New -ignore_err option in ocsp application to stop the server
    exiting on the first error in a request.
  * ) In ssl3_accept() (ssl/s3_srvr.c) only accept a client certificate
    if the server requested one: as stated in TLS 1.0 and SSL 3.0
    specifications.
  * ) In ssl3_get_client_hello() (ssl/s3_srvr.c), tolerate additional
    extra data after the compression methods not only for TLS 1.0
    but also for SSL 3.0 (as required by the specification).
  * ) Change X509_certificate_type() to mark the key as exported/exportable
    when it's 512 *bits* long, not 512 bytes.
  * ) Change AES_cbc_encrypt() so it outputs exact multiple of
    blocks during encryption.
  * ) Various fixes to base64 BIO and non blocking I/O. On write
    flushes were not handled properly if the BIO retried. On read
    data was not being buffered properly and had various logic bugs.
    This also affects blocking I/O when the data being decoded is a
    certain size.
  * ) Various S/MIME bugfixes and compatibility changes:
    output correct application/pkcs7 MIME type if
    PKCS7_NOOLDMIMETYPE is set. Tolerate some broken signatures.
    Output CR+LF for EOL if PKCS7_CRLFEOL is set (this makes opening
    of files as .eml work). Correctly handle very long lines in MIME
    parser.
- update ICA patch
  quote: This version of the engine patch has updated error handling in
  the DES/SHA code, and turns RSA blinding off for hardware
  accelerated RSA ops.
- filenames of some man pages contain spaces now. Replace them with
  underscores
- fix compiler warnings in showciphers.c
- fix permissions of /usr/%%_lib/pkgconfig
* Sat Jan 10 2004 adrian@suse.de
- add %%run_ldconfig
- remove unneeded PreRequires
* Tue Nov 18 2003 poeml@suse.de
- ditch annoying mail to root about moved locations [#31969]
* Wed Aug 13 2003 poeml@suse.de
- enable profile feedback based optimizations (except AES which
  becomes slower)
- add -fno-strict-aliasing, due to warnings about code where
  dereferencing type-punned pointers will break strict aliasing
- make a readlink function if readlink is not available
* Mon Aug  4 2003 ro@suse.de
- fixed manpages symlinks
* Wed Jul 30 2003 meissner@suse.de
- Fix Makefile to create pkgconfig file with lib64 on lib64 systems.
* Sun Jul 27 2003 poeml@suse.de
- don't explicitely strip binaries since RPM handles it, and may
  keep the stripped information somewhere
* Tue Jul 15 2003 meissner@suse.de
- -DMD32_REG_T=int for ppc64 and s390x.
* Thu Jul 10 2003 poeml@suse.de
- update ibm ICA patch to 20030708 release (libica-1.3)
* Mon May 12 2003 poeml@suse.de
- package the openssl.pc file for pkgconfig
* Wed Apr 16 2003 poeml@suse.de
- update to 0.9.7b. The most significant changes are:
  o New library section OCSP.
  o Complete rewrite of ASN1 code.
  o CRL checking in verify code and openssl utility.
  o Extension copying in 'ca' utility.
  o Flexible display options in 'ca' utility.
  o Provisional support for international characters with UTF8.
  o Support for external crypto devices ('engine') is no longer
    a separate distribution.
  o New elliptic curve library section.
  o New AES (Rijndael) library section.
  o Support for new platforms: Windows CE, Tandem OSS, A/UX, AIX 64-bit,
    Linux x86_64, Linux 64-bit on Sparc v9
  o Extended support for some platforms: VxWorks
  o Enhanced support for shared libraries.
  o Now only builds PIC code when shared library support is requested.
  o Support for pkg-config.
  o Lots of new manuals.
  o Makes symbolic links to or copies of manuals to cover all described
    functions.
  o Change DES API to clean up the namespace (some applications link also
    against libdes providing similar functions having the same name).
    Provide macros for backward compatibility (will be removed in the
    future).
  o Unify handling of cryptographic algorithms (software and engine)
    to be available via EVP routines for asymmetric and symmetric ciphers.
  o NCONF: new configuration handling routines.
  o Change API to use more 'const' modifiers to improve error checking
    and help optimizers.
  o Finally remove references to RSAref.
  o Reworked parts of the BIGNUM code.
  o Support for new engines: Broadcom ubsec, Accelerated Encryption
    Processing, IBM 4758.
  o A few new engines added in the demos area.
  o Extended and corrected OID (object identifier) table.
  o PRNG: query at more locations for a random device, automatic query for
    EGD style random sources at several locations.
  o SSL/TLS: allow optional cipher choice according to server's preference.
  o SSL/TLS: allow server to explicitly set new session ids.
  o SSL/TLS: support Kerberos cipher suites (RFC2712).
    Only supports MIT Kerberos for now.
  o SSL/TLS: allow more precise control of renegotiations and sessions.
  o SSL/TLS: add callback to retrieve SSL/TLS messages.
  o SSL/TLS: support AES cipher suites (RFC3268).
- adapt the ibmca patch
- remove openssl-nocrypt.diff, openssl's crypt() vanished
- configuration syntax has changed ($sys_id added before $lflags)
* Thu Feb 20 2003 poeml@suse.de
- update to bugfix release 0.9.6i:
  - security fix: In ssl3_get_record (ssl/s3_pkt.c), minimize
    information leaked via timing by performing a MAC computation
    even if incorrrect block cipher padding has been found.  This
    is a countermeasure against active attacks where the attacker
    has to distinguish between bad padding and a MAC verification
    error.  (CAN-2003-0078)
  - a few more small bugfixes (mainly missing assertions)
* Fri Dec  6 2002 poeml@suse.de
- update to 0.9.6h (last release in the 0.9.6 series)
  o New configuration targets for Tandem OSS and A/UX.
  o New OIDs for Microsoft attributes.
  o Better handling of SSL session caching.
  o Better comparison of distinguished names.
  o Better handling of shared libraries in a mixed GNU/non-GNU environment.
  o Support assembler code with Borland C.
  o Fixes for length problems.
  o Fixes for uninitialised variables.
  o Fixes for memory leaks, some unusual crashes and some race conditions.
  o Fixes for smaller building problems.
  o Updates of manuals, FAQ and other instructive documents.
- add a call to make depend
- fix sed expression (lib -> lib64) to replace multiple occurences
  on one line
* Mon Nov  4 2002 stepan@suse.de
- fix openssl for alpha ev56 cpus
* Thu Oct 24 2002 poeml@suse.de
- own the /usr/share/ssl directory [#20849]
- openssl-hppa-config.diff can be applied on all architectures
* Mon Sep 30 2002 bg@suse.de
- enable hppa distribution; use only pa1.1 architecture.
* Tue Sep 17 2002 froh@suse.de
- update ibm-hardware-crypto-patch to ibmca.patch-0.96e-2 (#18953)
* Mon Aug 12 2002 poeml@suse.de
- update to 0.9.6g and drop the now included ASN1 check patch.
  Other change:
  - Use proper error handling instead of 'assertions' in buffer
    overflow checks added in 0.9.6e.  This prevents DoS (the
    assertions could call abort()).
* Fri Aug  9 2002 kukuk@suse.de
- Fix requires of openssl-devel subpackage
* Tue Aug  6 2002 draht@suse.de
- Correction for changes in the ASN1 code, assembled in
  openssl-0.9.6e-cvs-20020802-asn1_lib.diff
* Wed Jul 31 2002 poeml@suse.de
- update to 0.9.6e. Major changes:
  o Various security fixes (sanity checks to asn1_get_length(),
    various remote buffer overflows)
  o new option SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS, disabling the
    countermeasure against a vulnerability in the CBC ciphersuites
    in SSL 3.0/TLS 1.0 that was added in 0.9.6d which turned out to
    be incompatible with buggy SSL implementations
- update ibmca crypto hardware patch (security issues fixed)
- gcc 3.1 version detection is fixed, we can drop the patch
- move the most used man pages from the -doc to the main package
  [#9913] and resolve man page conflicts by putting them into ssl
  sections [#17239]
- spec file: use PreReq for %%post script
* Fri Jul 12 2002 poeml@suse.de
- update to 0.9.6d. Major changes:
  o Various SSL/TLS library bugfixes.
  o Fix DH parameter generation for 'non-standard' generators.
  Complete Changelog: http://www.openssl.org/news/changelog.html
- supposed to fix a session caching failure occuring with postfix
- simplify local configuration for the architectures
- there's a new config variable: $shared_ldflag
- use RPM_OPT_FLAGS in favor of predifined cflags by appending them
  at the end
- validate config data (config --check-sanity)
- resolve file conflict of /usr/share/man/man1/openssl.1.gz [#15982]
- move configuration to /etc/ssl [#14387]
- mark openssl.cnf %%config (noreplace)
* Sat Jul  6 2002 schwab@suse.de
- Include <crypt.h> to get crypt prototype.
* Fri Jul  5 2002 kukuk@suse.de
- Remove crypt prototype from des.h header file, too.
* Mon Jun 10 2002 meissner@suse.de
- enhanced ppc64 support (needs seperate config), reenabled make check
* Fri May 31 2002 olh@suse.de
- add ppc64 support, temporary disable make check
* Thu Apr 18 2002 meissner@suse.de
- fixed x86_64 build, added bc to needed_for_build (used by tests)
* Wed Apr 17 2002 ro@suse.de
- fixed gcc version determination
- drop sun4c support/always use sparcv8
- ignore return code from showciphers
* Fri Mar 15 2002 poeml@suse.de
- add settings for sparc to build shared objects. Note that all
  sparcs (sun4[mdu]) are recognized as linux-sparcv7
* Wed Feb  6 2002 kukuk@suse.de
- Remove crypt function from libcrypto.so.0 [Bug #13056]
* Sun Feb  3 2002 poeml@suse.de
- add settings for mips to build shared objects
- print out all settings to the build log
* Tue Jan 29 2002 poeml@suse.de
- update to 0.9.6c:
  o bug fixes
  o support for hardware crypto devices (Cryptographic Appliances,
  Broadcom, and Accelerated Encryption Processing)
- add IBMCA patch for IBM eServer Cryptographic Accelerator Device
  Driver (#12565) (forward ported from 0.9.6b)
  (http://www-124.ibm.com/developerworks/projects/libica/)
- tell Configure how to build shared libs for s390 and s390x
- tweak Makefile.org to use %%_libdir
- clean up spec file
- add README.SuSE as source file instead of in a patch
* Wed Dec  5 2001 uli@suse.de
- disabled "make test" for ARM (destest segfaults, the other tests
  seem to succeed)
* Wed Dec  5 2001 ro@suse.de
- removed subpackage src
* Wed Nov 28 2001 uli@suse.de
- needs -ldl on ARM, too
* Mon Nov 19 2001 mls@suse.de
- made mips big endian, fixed shared library creation for mips
* Fri Aug 31 2001 rolf@suse.de
- added root certificates [BUG#9913]
- move from /usr/ssh to /usr/share/ssl
* Wed Jul 18 2001 rolf@suse.de
- update to 0.9.6b
- switch to engine version of openssl, which supports hardware
  encryption for a few popular devices
- check wether shared libraries have been generated
* Thu Jul  5 2001 rolf@suse.de
- appliy PRNG security patch
* Tue Jun 12 2001 bk@suse.de
- added support for s390x
* Mon May  7 2001 kukuk@suse.de
- Fix building of shared libraries on SPARC, too.
* Mon May  7 2001 rolf@suse.de
- Fix ppc and s390 shared library builds
- resolved conflict in manpage naming:
  rand.3 is now sslrand.3 [BUG#7643]
* Tue May  1 2001 schwab@suse.de
- Fix ia64 configuration.
- Fix link command.
* Thu Apr 26 2001 bjacke@suse.de
- updated to 0.96a
* Wed Apr 18 2001 kkaempf@suse.de
- provide .so files in -devel package only
* Tue Apr 17 2001 bjacke@suse.de
- resolve file name conflict (#6966)
* Wed Mar 21 2001 rolf@suse.de
- new subpackage openssl-src [BUG#6383]
- added README.SuSE which explains where to find the man pages [BUG#6717]
* Fri Dec 15 2000 sf@suse.de
- changed CFLAG to -O1 to make the tests run successfully
* Mon Dec 11 2000 rolf@suse.de
- build openssl with no-idea and no-rc5 to meet US & RSA regulations
- build with -fPIC on all platforms (especially IA64)
* Wed Nov 22 2000 rolf@suse.de
- rename openssls to openssl-devel and add shared libs and header files
- new subpackge openssl-doc for manpages and documentation
- use BuildRoot
* Fri Oct 27 2000 schwab@suse.de
- Add link-time links for libcrypto and libssl.
- Make sure that LD_LIBRARY_PATH is passed down to sub-makes.
* Mon Oct  2 2000 rolf@suse.de
- update to 0.9.6
* Mon Apr 10 2000 bk@suse.de
- fix support for s390-linux
* Mon Apr 10 2000 rolf@suse.de
- new version 0.9.5a
* Sun Apr  9 2000 bk@suse.de
- add support for s390-linux
* Mon Mar 27 2000 kukuk@suse.de
- Use sparcv7 for SPARC
* Wed Mar  1 2000 rolf@suse.de
- move manpages back, as too many conflict with system manuals
* Wed Mar  1 2000 rolf@suse.de
- move manpages to %%{_mandir}
- include static libraries
* Wed Mar  1 2000 bk@suse.de
- added subpackage source openssls, needed for ppp_ssl
* Tue Feb 29 2000 rolf@suse.de
- new version 0.9.5
* Thu Feb 24 2000 schwab@suse.de
- add support for ia64-linux
* Mon Jan 31 2000 kukuk@suse.de
- Create and add libcrypto.so.0 and libssl.so.0
* Mon Sep 13 1999 bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Wed Sep  1 1999 rolf@suse.de
- new version 0.9.4
* Wed May 26 1999 rolf@suse.de
- new version 0.9.3 with new layout
- alpha asm disabled by default now, no patch needed
* Thu May 20 1999 ro@suse.de
- disable asm for alpha: seems incomplete
* Mon May 17 1999 rolf@suse.de
- don't use -DNO_IDEA
* Wed May 12 1999 rolf@suse.de
- first version 0.9.2b
