#!/bin/bash

CUR_DIR=$(pwd)

CC=${CC:=gcc}

BUILD_MODE=${BUILD_MODE:=install}

if [ ! -d "${GSOAP_PATH}" ]; then
echo "Please set GSOAP_PATH"
exit 1
fi

BUILD_DEBUG_DIR=${CUR_DIR}/Build-Debug
INSTALL_DEBUG_DIR=${CUR_DIR}/Install-Debug

BUILD_RELEASE_DIR=${CUR_DIR}/Build-Release
INSTALL_RELEASE_DIR=${CUR_DIR}/Install-Release

BUILD_RELDEBUG_DIR=${CUR_DIR}/Build-RelWithDebInfo
INSTALL_RELDEBUG_DIR=${CUR_DIR}/Install-RelWithDebInfo

BUILD_MINSIZE_DIR=${CUR_DIR}/Build-MinSizeRel
INSTALL_MINSIZE_DIR=${CUR_DIR}/Install-MinSizeRel

mkdir ${BUILD_DEBUG_DIR}
mkdir ${INSTALL_DEBUG_DIR}

cd ${BUILD_DEBUG_DIR} && CC="${CC}" cmake -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_DEBUG_DIR}" -DPDF_DOCU:BOOL=true -DCOMPILER_WARNINGS:BOOL=true .. && make clean && make ${BUILD_MODE}

mkdir ${BUILD_RELEASE_DIR}
mkdir ${INSTALL_RELEASE_DIR}

cd ${BUILD_RELEASE_DIR} && CC="${CC}" cmake -DCMAKE_BUILD_TYPE:STRING="Release" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_RELEASE_DIR}" -DMAINTAINER_MODE:BOOL=true -DWITH_DOCU:BOOL=false .. && make clean && make ${BUILD_MODE}

mkdir ${BUILD_RELDEBUG_DIR}
mkdir ${INSTALL_RELDEBUG_DIR}

cd ${BUILD_RELDEBUG_DIR} && CC="${CC}" cmake -DCMAKE_BUILD_TYPE:STRING="RelWithDebInfo" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_RELDEBUG_DIR}" -DMAINTAINER_MODE:BOOL=true -DWITH_DOCU:BOOL=false .. && make clean && make ${BUILD_MODE}

mkdir ${BUILD_MINSIZE_DIR}
mkdir ${INSTALL_MINSIZE_DIR}

cd ${BUILD_MINSIZE_DIR} && CC="${CC}" cmake -DCMAKE_BUILD_TYPE:STRING="MinSizeRel" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_MINSIZE_DIR}" -DMAINTAINER_MODE:BOOL=true -DWITH_DOCU:BOOL=false .. && make clean && make ${BUILD_MODE}
