#!/bin/bash

CUR_DIR=$(pwd)

MAKE_TARGET=${MAKE_TARGET:-install}
TOOL_CHAIN_FILE=${TOOL_CHAIN_FILE:-${CUR_DIR}/toolchains/cris-axis-linux-gnu.cmake}
DIR_POSTFIX=${DIR_POSTFIX:-Fox}

BUILD_DEBUG_DIR=${CUR_DIR}/Build-Debug-${DIR_POSTFIX}
INSTALL_DEBUG_DIR=${CUR_DIR}/Install-Debug-${DIR_POSTFIX}
DPWS_DEBUG_HOST_PATH=${CUR_DIR}/Install-Debug

BUILD_RELEASE_DIR=${CUR_DIR}/Build-Release-${DIR_POSTFIX}
INSTALL_RELEASE_DIR=${CUR_DIR}/Install-Release-${DIR_POSTFIX}
DPWS_RELEASE_HOST_PATH=${CUR_DIR}/Install-Release

BUILD_RELDEBUG_DIR=${CUR_DIR}/Build-RelWithDebInfo-${DIR_POSTFIX}
INSTALL_RELDEBUG_DIR=${CUR_DIR}/Install-RelWithDebInfo-${DIR_POSTFIX}
DPWS_RELDEBUG_HOST_PATH=${CUR_DIR}/Install-RelWithDebInfo

BUILD_MINSIZE_DIR=${CUR_DIR}/Build-MinSizeRel-${DIR_POSTFIX}
INSTALL_MINSIZE_DIR=${CUR_DIR}/Install-MinSizeRel-${DIR_POSTFIX}
DPWS_MINSIZE_HOST_PATH=${CUR_DIR}/Install-MinSizeRel

mkdir ${BUILD_DEBUG_DIR}
mkdir ${INSTALL_DEBUG_DIR}

cd ${BUILD_DEBUG_DIR} && CC="${CC}" cmake -DCMAKE_TOOLCHAIN_FILE="${TOOL_CHAIN_FILE}" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_DEBUG_DIR}" -DDPWS_HOSTEXEC_PATH:PATH="${DPWS_DEBUG_HOST_PATH}" .. && make clean && make ${MAKE_TARGET}

mkdir ${BUILD_RELEASE_DIR}
mkdir ${INSTALL_RELEASE_DIR}

cd ${BUILD_RELEASE_DIR} && CC="${CC}" cmake -DCMAKE_TOOLCHAIN_FILE="${TOOL_CHAIN_FILE}" -DCMAKE_BUILD_TYPE:STRING="Release" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_RELEASE_DIR}" -DDPWS_HOSTEXEC_PATH:PATH="${DPWS_RELEASE_HOST_PATH}" .. && make clean && make ${MAKE_TARGET}

mkdir ${BUILD_RELDEBUG_DIR}
mkdir ${INSTALL_RELDEBUG_DIR}

cd ${BUILD_RELDEBUG_DIR} && CC="${CC}" cmake -DCMAKE_TOOLCHAIN_FILE="${TOOL_CHAIN_FILE}" -DCMAKE_BUILD_TYPE:STRING="RelWithDebInfo" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_RELDEBUG_DIR}" -DDPWS_HOSTEXEC_PATH:PATH="${DPWS_RELDEBUG_HOST_PATH}" .. && make clean && make ${MAKE_TARGET}

mkdir ${BUILD_MINSIZE_DIR}
mkdir ${INSTALL_MINSIZE_DIR}

cd ${BUILD_MINSIZE_DIR} && CC="${CC}" cmake -DCMAKE_TOOLCHAIN_FILE="${TOOL_CHAIN_FILE}" -DCMAKE_BUILD_TYPE:STRING="MinSizeRel" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_MINSIZE_DIR}" -DDPWS_HOSTEXEC_PATH:PATH="${DPWS_MINSIZE_HOST_PATH}" .. && make clean && make ${MAKE_TARGET}
