#!/bin/bash

CUR_DIR=$(pwd)
if [ -z "${CC}" ]
then
   CC="ccache gcc"
fi

TEST_SUBMISSION_MODE=Experimental

BUILD_DEBUG_DIR=${CUR_DIR}/Build-Debug
INSTALL_DEBUG_DIR=${CUR_DIR}/Install-Debug

BUILD_RELEASE_DIR=${CUR_DIR}/Build-Release
INSTALL_RELEASE_DIR=${CUR_DIR}/Install-Release

BUILD_RELDEBUG_DIR=${CUR_DIR}/Build-RelWithDebInfo
INSTALL_RELDEBUG_DIR=${CUR_DIR}/Install-RelWithDebInfo

BUILD_MINSIZE_DIR=${CUR_DIR}/Build-MinSizeRel
INSTALL_MINSIZE_DIR=${CUR_DIR}/Install-MinSizeRel

mkdir ${BUILD_DEBUG_DIR}
mkdir ${INSTALL_DEBUG_DIR}

cd ${BUILD_DEBUG_DIR} && CC="${CC}" cmake -DMAINTAINER_MODE:BOOL=true -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_DEBUG_DIR}" -DPDF_DOCU:BOOL=true -DWITH_UNIT_TESTS:BOOL=true .. && make clean && make ${TEST_SUBMISSION_MODE}

mkdir ${BUILD_RELEASE_DIR}
mkdir ${INSTALL_RELEASE_DIR}

cd ${BUILD_RELEASE_DIR} && CC="${CC}" cmake -DMAINTAINER_MODE:BOOL=true -DCMAKE_BUILD_TYPE:STRING="Release" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_RELEASE_DIR}" -DWITH_UNIT_TESTS:BOOL=true .. && make clean && make ${TEST_SUBMISSION_MODE}

mkdir ${BUILD_RELDEBUG_DIR}
mkdir ${INSTALL_RELDEBUG_DIR}

cd ${BUILD_RELDEBUG_DIR} && CC="${CC}" cmake -DMAINTAINER_MODE:BOOL=true -DCMAKE_BUILD_TYPE:STRING="RelWithDebInfo" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_RELDEBUG_DIR}" -DWITH_UNIT_TESTS:BOOL=true .. && make clean && make ${TEST_SUBMISSION_MODE}

mkdir ${BUILD_MINSIZE_DIR}
mkdir ${INSTALL_MINSIZE_DIR}

cd ${BUILD_MINSIZE_DIR} && CC="${CC}" CFLAGS="-ffunction-sections -fdata-sections -Wl,--gc-sections -Wl,--print-gc-sections -Wl,--relax" cmake -DMAINTAINER_MODE:BOOL=true -DCMAKE_BUILD_TYPE:STRING="MinSizeRel" -DGSOAP_PATH:PATH="${GSOAP_PATH}" -DCMAKE_INSTALL_PREFIX:PATH="${INSTALL_MINSIZE_DIR}" -DWITH_UNIT_TESTS:BOOL=true .. && make clean && make ${TEST_SUBMISSION_MODE}
