/* WS4D-gSOAP - Implementation of the Devices Profile for Web Services
 * (DPWS) on top of gSOAP
 * Copyright (C) 2007 University of Rostock
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef WS4D_STRINGLIST_H_
#define WS4D_STRINGLIST_H_

#include "ws4d_misc.h"
#include "ws4d_uri.h"

struct ws4d_stringlist
{
  int status;
  struct ws4d_list_node strings;
  const char *string;

  struct ws4d_abs_allocator alist;
#ifdef WITH_MUTEXES
    WS4D_MUTEX (lock);
#endif
};

int ws4d_stringlist_init (struct ws4d_stringlist *head);

int ws4d_stringlist_init2 (struct ws4d_stringlist *head, const char *items);

int ws4d_stringlist_done (struct ws4d_stringlist *head);

int ws4d_stringlist_isinit (struct ws4d_stringlist *head);

int ws4d_stringlist_isempty (struct ws4d_stringlist *head);

int ws4d_stringlist_len (struct ws4d_stringlist *head);

int ws4d_stringlist_add (struct ws4d_stringlist *head, const char *items);

int ws4d_stringlist_adduri (struct ws4d_stringlist *head,
                            struct ws4d_uri *uri);

int ws4d_stringlist_addlist (struct ws4d_stringlist *head,
                             struct ws4d_stringlist *list);

int ws4d_stringlist_delete (struct ws4d_stringlist *head, const char *sitem);

int
ws4d_stringlist_replace (struct ws4d_stringlist *head, const char *old_item,
                         const char *new_item);

int
ws4d_stringlist_replace2 (struct ws4d_stringlist *head, const char *old_item,
                          struct ws4d_uri *new_item);


int ws4d_stringlist_contains (struct ws4d_stringlist *head, const char *item);

int ws4d_stringlist_compare (struct ws4d_stringlist *head1,
                             struct ws4d_stringlist *head2);

int ws4d_stringlist_copy (struct ws4d_stringlist *src,
                          struct ws4d_stringlist *dst);

int ws4d_stringlist_clear (struct ws4d_stringlist *head);

#ifdef WITH_MUTEXES
void ws4d_stringlist_lock (struct ws4d_stringlist *head);
#else
#define ws4d_stringlist_lock(head)
#endif

#ifdef WITH_MUTEXES
void ws4d_stringlist_unlock (struct ws4d_stringlist *head);
#else
#define ws4d_stringlist_unlock(head)
#endif

const char *ws4d_stringlist_iterate (const struct ws4d_stringlist *head,
                                     void **iterator);

const char *ws4d_stringlist_tostring (struct ws4d_stringlist *head);

#define ws4d_stringlist_foreach(elem_s, iterator, head) \
  for(iterator=NULL, elem_s = ws4d_stringlist_iterate(head, &(iterator)); elem_s != NULL; elem_s = ws4d_stringlist_iterate(head, &(iterator)))

int ws4d_isstringlist (const char *s);

#endif /*WS4D_STRINGLIST_H_ */
