/* WS4D-gSOAP - Implementation of the Devices Profile for Web Services
 * (DPWS) on top of gSOAP
 * Copyright (C) 2007 University of Rostock
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef WS4D_QNAME_H_
#define WS4D_QNAME_H_

/**
 * QName
 *
 * @addtogroup APIQName QName
 * @ingroup WS4D_UTILS
 *
 * @{
 */

struct ws4d_qname
{
  struct ws4d_list_node list;
  const char *prefix;
  const char *name;
  const char *ns;
};

#define ws4d_qname_getName(qname) (qname)->name
#define ws4d_qname_getPrefix(qname) (qname)->prefix
#define ws4d_qname_getNS(qname) (qname)->ns

int ws4d_qname_init (struct ws4d_qname *qname);

int ws4d_qname_done (struct ws4d_qname *qname);

/**
 * TODO: add documentation
 */
struct ws4d_qname *ws4d_qname_alloc (int count,
                                     struct ws4d_abs_allocator *alist);

/**
 * TODO: add documentation
 */
void ws4d_qname_free (struct ws4d_qname *qname);

/**
 * TODO: add documentation
 */
size_t ws4d_qname_strlen (struct ws4d_qname *qname);

int ws4d_qname_match (struct ws4d_qname *q1, struct ws4d_qname *q2);

/**
 * TODO: add documentation
 */
char *ws4d_qname_tostring2 (struct ws4d_qname *qname, char *buffer,
                            size_t size);

/**
 * TODO: add documentation
 */
struct ws4d_qname *ws4d_qname_dup (const struct ws4d_qname *src,
                                   struct ws4d_abs_allocator *alist);

int
ws4d_qname_parse (const char *string, struct ws4d_qname *qname,
                  struct ws4d_abs_allocator *alist);

/**
 * QName list
 *
 * @addtogroup APIQNameList QName list
 * @ingroup APIQName
 *
 * @{
 */

typedef struct ws4d_qnamelist
{
  int status;
  struct ws4d_list_node qnames;
  const char *string;

  struct ws4d_abs_allocator alist;
#ifdef WITH_MUTEXES
    WS4D_MUTEX (lock);
#endif
} ws4d_qnamelist;


/**
 * Function to initialize a QNameList head
 *
 * @param head list head to initialize
 * @return SOAP_OK on success SOAP_ERR otherwise
 */
int ws4d_qnamelist_init (ws4d_qnamelist * head);

int ws4d_qnamelist_init2 (ws4d_qnamelist * head, const char *string);

/**
 * Function to reset QNameList head
 *
 * @param head head of list to reset
 * @return SOAP_OK on success SOAP_ERR otherwise
 */
int ws4d_qnamelist_done (ws4d_qnamelist * head);

/**
 * TODO: add documentation
 */
int ws4d_qnamelist_add (ws4d_qnamelist * head,
                        const struct ws4d_qname *qname);

#ifdef WITH_MUTEXES
void ws4d_qnamelist_lock (struct ws4d_qnamelist *head);
#else
#define ws4d_qnamelist_lock(head)
#endif

#ifdef WITH_MUTEXES
void ws4d_qnamelist_unlock (struct ws4d_qnamelist *head);
#else
#define ws4d_qnamelist_unlock(head)
#endif


/**
 * TODO: add documentation
 */
int ws4d_qnamelist_addstring (ws4d_qnamelist * head, const char *string);

/**
 * TODO: add documentation
 */
int
ws4d_qnamelist_addlist (ws4d_qnamelist * head, const ws4d_qnamelist * list);

/**
 * TODO: add documentation
 */
int ws4d_qnamelist_copy (const ws4d_qnamelist * src, ws4d_qnamelist * dst);

/**
 * TODO: add documentation
 */
int ws4d_qnamelist_remove (ws4d_qnamelist * head, struct ws4d_qname *qname);

/**
 * TODO: add documentation
 */
int ws4d_qnamelist_clear (ws4d_qnamelist * head);

/**
 * TODO: add documentation
 */
int ws4d_qnamelist_isempty (const ws4d_qnamelist * head);

/**
 * TODO: add documentation
 */
const char *ws4d_qnamelist_tostring (ws4d_qnamelist * head);

/**
 * TODO: add documentation
 */
#define ws4d_qnamelist_foreach(pos, iter, head) ws4d_list_foreach (pos, iter, &(head)->qnames, struct ws4d_qname, list)


/** @} */

/** @} */

#endif /*WS4D_QNAME_H_ */
