# Copyright (C) 2007  University of Rostock
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301 USA.

INCLUDE(FindPackageHandleStandardArgs)

FIND_PROGRAM(DTRACE_EXECUTABLE
  NAMES dtrace
  DOC "dtrace tool. See http://sourceware.org/systemtap/ for details."
  PATHS ${CMAKE_SOURCE_DIR}/bin
)

MACRO(GEN_PROBES provider headerfile)
  IF(DTRACE_EXECUTABLE)

    GET_FILENAME_COMPONENT(name ${headerfile} NAME_WE)

    SET_SOURCE_FILES_PROPERTIES(${headerfile}
      PROPERTIES GENERATED TRUE)

    ADD_CUSTOM_COMMAND(
      OUTPUT ${headerfile}
      COMMAND ${DTRACE_EXECUTABLE} -h -s ${provider} -o ${headerfile}
      DEPENDS ${provider})

    ADD_CUSTOM_TARGET(${name}_gen
      DEPENDS ${headerfile})

  ENDIF(DTRACE_EXECUTABLE)
ENDMACRO(GEN_PROBES provider headerfile)

MACRO(GEN_PROBES_STUB provider headerfile stubfile)
  IF(DTRACE_EXECUTABLE)

    GET_FILENAME_COMPONENT(name ${stubfile} NAME_WE)
    SET(${name}_STUB ${CMAKE_CURRENT_BINARY_DIR}/${name}.o)

    SET_SOURCE_FILES_PROPERTIES(${name}_STUB
      PROPERTIES GENERATED TRUE)

    ADD_CUSTOM_COMMAND(
      OUTPUT ${${name}_STUB}
      COMMAND ${DTRACE_EXECUTABLE} -G -s ${provider} -o ${${name}_STUB}
      DEPENDS ${provider})

    ADD_CUSTOM_TARGET(gen_${name}_STUB DEPENDS ${${name}_STUB})

    ADD_DEPENDENCIES(gen_${name}_STUB ${name}_gen)

  ENDIF(DTRACE_EXECUTABLE)
ENDMACRO(GEN_PROBES_STUB provider stubfile)

MACRO(ADD_PROBES target stubfile)
  IF(DTRACE_EXECUTABLE)

    GET_FILENAME_COMPONENT(name ${stubfile} NAME_WE)
    SET(${name}_STUB ${CMAKE_CURRENT_BINARY_DIR}/${name}.o)

    ADD_DEPENDENCIES(${target} gen_${name}_STUB)

    TARGET_LINK_LIBRARIES(${target} ${${name}_STUB})

  ENDIF(DTRACE_EXECUTABLE)
ENDMACRO(ADD_PROBES target stubfile)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(SystemTap "Could NOT find SystemTap Development Tools! See http://sourceware.org/systemtap/ for details." DTRACE_EXECUTABLE)
